/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.module.modules;

import fr.maxlego08.essentials.ZEssentialsPlugin;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.economy.EconomyManager;
import fr.maxlego08.essentials.api.event.events.user.UserFirstJoinEvent;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.modules.joinquit.JoinQuitMessageType;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.module.ZModule;
import fr.maxlego08.essentials.module.modules.TeleportationModule;
import fr.maxlego08.essentials.zutils.utils.paper.PaperComponent;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.permissions.Permissible;

public class JoinQuitModule
extends ZModule {
    private boolean allowSilentJoinQuit;
    private JoinQuitMessageType customJoinMessage = JoinQuitMessageType.DEFAULT;
    private JoinQuitMessageType customQuitMessage = JoinQuitMessageType.DEFAULT;
    private boolean allowFirstJoinBroadcast;
    private boolean allowFirstJoinMotd;
    private int firstJoinMotdTicks;

    public JoinQuitModule(ZEssentialsPlugin plugin) {
        super(plugin, "join_quit");
    }

    @EventHandler
    public void onFirstJoin(UserFirstJoinEvent event) {
        if (!this.isEnable()) {
            return;
        }
        User user = event.getUser();
        Player player = user.getPlayer();
        TeleportationModule teleportModule = this.plugin.getModuleManager().getModule(TeleportationModule.class);
        if (teleportModule != null && teleportModule.isEnable() && teleportModule.isEnableFirstJoinRtp()) {
            this.plugin.getScheduler().runAtLocationLater(player.getLocation(), () -> teleportModule.performFirstJoinRtp(player), 20L);
        }
        if (!this.allowFirstJoinBroadcast) {
            return;
        }
        long totalUsers = this.plugin.getStorageManager().getStorage().totalUsers();
        EconomyManager economyManager = this.plugin.getEconomyManager();
        Bukkit.getOnlinePlayers().forEach(onlinePlayer -> this.message((CommandSender)onlinePlayer, Message.FIRST_JOIN_MESSAGE, "%player%", user.getName(), "%totalUser%", totalUsers, "%totalUserFormat%", economyManager.format(totalUsers)));
        this.message((CommandSender)Bukkit.getConsoleSender(), Message.FIRST_JOIN_MESSAGE, "%player%", user.getName(), "%totalUser%", totalUsers, "%totalUserFormat%", economyManager.format(totalUsers));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onJoin(PlayerJoinEvent event) {
        if (!this.isEnable()) {
            return;
        }
        Player player = event.getPlayer();
        User user = this.getUser((Entity)player);
        if (this.allowSilentJoinQuit && this.hasPermission((Permissible)player, Permission.ESSENTIALS_SILENT_JOIN)) {
            event.joinMessage((Component)Component.empty());
        } else if (this.customJoinMessage == JoinQuitMessageType.DISABLE) {
            event.joinMessage((Component)Component.empty());
        } else if (this.customJoinMessage == JoinQuitMessageType.CUSTOM) {
            PaperComponent paperComponent = (PaperComponent)this.componentMessage;
            String papiMessage = this.papi(this.getMessage(Message.JOIN_MESSAGE, "%player%", player.getName(), "%displayName%", player.getDisplayName()), player);
            event.joinMessage(paperComponent.getComponent(papiMessage));
        }
        if (user != null && user.isFirstJoin() && this.allowFirstJoinMotd) {
            this.plugin.getScheduler().runAtLocationLater(player.getLocation(), () -> this.message((CommandSender)player, Message.FIRST_JOIN_MOTD, "%player%", player.getName(), "%displayName%", player.getDisplayName()), (long)this.firstJoinMotdTicks);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onQuit(PlayerQuitEvent event) {
        if (!this.isEnable()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.allowSilentJoinQuit && this.hasPermission((Permissible)player, Permission.ESSENTIALS_SILENT_QUIT)) {
            event.quitMessage((Component)Component.empty());
        } else if (this.customQuitMessage == JoinQuitMessageType.DISABLE) {
            event.quitMessage((Component)Component.empty());
        } else if (this.customQuitMessage == JoinQuitMessageType.CUSTOM) {
            PaperComponent paperComponent = (PaperComponent)this.componentMessage;
            String papiMessage = this.papi(this.getMessage(Message.QUIT_MESSAGE, "%player%", player.getName(), "%displayName%", player.getDisplayName()), player);
            event.quitMessage(paperComponent.getComponent(papiMessage));
        }
    }
}

