/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.module.modules;

import fr.maxlego08.essentials.ZEssentialsPlugin;
import fr.maxlego08.essentials.api.dto.MailBoxDTO;
import fr.maxlego08.essentials.api.mailbox.MailBoxItem;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.storage.IStorage;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.module.ZModule;
import fr.maxlego08.essentials.module.modules.ItemModule;
import fr.maxlego08.essentials.user.ZUser;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class MailBoxModule
extends ZModule {
    private long expiration;

    public MailBoxModule(ZEssentialsPlugin plugin) {
        super(plugin, "mailbox");
    }

    @Override
    public void loadConfiguration() {
        super.loadConfiguration();
        this.loadInventory("mailbox");
        this.loadInventory("mailbox_admin");
    }

    public void addItemAndFix(UUID uuid, ItemStack itemStack) {
        int amount = itemStack.getAmount();
        if (amount > itemStack.getMaxStackSize()) {
            while (amount > 0) {
                int currentAmount = Math.min(itemStack.getMaxStackSize(), amount);
                amount -= currentAmount;
                ItemStack clonedItemStacks = itemStack.clone();
                clonedItemStacks.setAmount(currentAmount);
                this.addItem(uuid, clonedItemStacks);
            }
        } else {
            this.addItem(uuid, itemStack);
        }
    }

    public void addItem(UUID uuid, ItemStack itemStack) {
        MailBoxItem mailBoxItem = new MailBoxItem(uuid, itemStack, new Date(System.currentTimeMillis() + this.expiration * 1000L));
        User user = this.plugin.getUser(uuid);
        if (user != null) {
            user.addMailBoxItem(mailBoxItem);
            this.message(user, Message.MAILBOX_ADD, new Object[0]);
        } else {
            IStorage iStorage = this.plugin.getStorageManager().getStorage();
            iStorage.addMailBoxItem(mailBoxItem);
        }
    }

    public void openMailBox(Player player) {
        this.plugin.getInventoryManager().openInventory(player, (Plugin)this.plugin, "mailbox");
    }

    public void openMailBoxAdmin(Player player) {
        this.plugin.getInventoryManager().openInventory(player, (Plugin)this.plugin, "mailbox_admin");
    }

    public void removeItem(User user, Player player, MailBoxItem mailBoxItem) {
        IStorage iStorage = this.plugin.getStorageManager().getStorage();
        PlayerInventory inventory = player.getInventory();
        int firstEmptySlot = inventory.firstEmpty();
        if (firstEmptySlot == -1) {
            this.message((CommandSender)player, Message.MAILBOX_REMOVE_FULL, new Object[0]);
            return;
        }
        List<MailBoxItem> mailBoxItems = user.getMailBoxItems();
        if (mailBoxItem.isExpired()) {
            this.message((CommandSender)player, Message.MAILBOX_REMOVE_EXPIRE, new Object[0]);
            this.openMailBox(player);
            mailBoxItems.remove(mailBoxItem);
            iStorage.removeMailBoxItem(mailBoxItem.getId());
            return;
        }
        if (mailBoxItems.contains(mailBoxItem)) {
            inventory.addItem(new ItemStack[]{mailBoxItem.getItemStack()});
            mailBoxItems.remove(mailBoxItem);
            iStorage.removeMailBoxItem(mailBoxItem.getId());
        }
        if (user.getUniqueId().equals(player.getUniqueId())) {
            this.openMailBox(player);
        } else {
            this.openMailBoxAdmin(player);
        }
    }

    public void openMailBox(User user, UUID uuid, String username) {
        IStorage iStorage = this.plugin.getStorageManager().getStorage();
        List<MailBoxDTO> mailBoxDTOS = iStorage.getMailBox(uuid);
        User fakeUser = ZUser.fakeUser(this.plugin, uuid, username);
        fakeUser.setMailBoxItems(mailBoxDTOS);
        user.setTargetUser(fakeUser);
        this.openMailBoxAdmin(user.getPlayer());
    }

    public void giveItem(CommandSender sender, UUID uuid, String username, String itemName, int amount) {
        ItemModule itemModule = this.plugin.getModuleManager().getModule(ItemModule.class);
        ItemStack itemStack = itemModule.getItemStack(itemName, (OfflinePlayer)Bukkit.getPlayer((UUID)uuid));
        if (itemStack == null) {
            this.message(sender, Message.MAILBOX_GIVE_ERROR, "%item%", itemName);
            return;
        }
        int realAmount = 0;
        if (amount > itemStack.getMaxStackSize()) {
            while (amount > 0) {
                ItemStack newItemStack = itemStack.clone();
                int currentAmount = Math.min(amount, itemStack.getMaxStackSize());
                if (currentAmount > 0) {
                    amount -= currentAmount;
                    realAmount += currentAmount;
                    newItemStack.setAmount(currentAmount);
                    this.addItem(uuid, newItemStack);
                    continue;
                }
                break;
            }
        } else {
            int currentAmount;
            realAmount = currentAmount = Math.max(1, amount);
            itemStack.setAmount(currentAmount);
            this.addItem(uuid, itemStack);
        }
        this.message(sender, Message.MAILBOX_GIVE, "%item%", itemName, "%player%", username, "%amount%", realAmount);
    }

    public void giveAllItem(CommandSender sender, String itemName, int amount) {
        Player player;
        ItemStack itemStack;
        ItemModule itemModule = this.plugin.getModuleManager().getModule(ItemModule.class);
        if (!itemModule.isItem(itemName)) {
            this.message(sender, Message.MAILBOX_GIVE_ERROR, "%item%", itemName);
            return;
        }
        Iterator iterator = Bukkit.getOnlinePlayers().iterator();
        block0: while (iterator.hasNext() && (itemStack = itemModule.getItemStack(itemName, (OfflinePlayer)(player = (Player)iterator.next()))) != null) {
            if (amount > itemStack.getMaxStackSize()) {
                int currentAmount;
                for (int playerAmount = amount; playerAmount > 0; playerAmount -= currentAmount) {
                    ItemStack newItemStack = itemStack.clone();
                    currentAmount = Math.min(playerAmount, itemStack.getMaxStackSize());
                    if (currentAmount <= 0) continue block0;
                    newItemStack.setAmount(currentAmount);
                    this.addItem(player.getUniqueId(), newItemStack);
                }
                continue;
            }
            itemStack.setAmount(Math.max(1, amount));
            this.addItem(player.getUniqueId(), itemStack);
        }
        this.message(sender, Message.MAILBOX_GIVE_ALL, "%item%", itemName, "%amount%", amount);
    }

    public void giveItemFromHand(CommandSender sender, UUID uuid, String username, ItemStack itemStack) {
        if (itemStack == null || itemStack.getType().isAir()) {
            this.message(sender, Message.COMMAND_ITEM_EMPTY, new Object[0]);
            return;
        }
        ItemStack clonedItemStack = itemStack.clone();
        this.addItemAndFix(uuid, clonedItemStack);
        this.message(sender, Message.MAILBOX_GIVE_HAND, "%item%", this.getItemName(clonedItemStack), "%player%", username, "%amount%", clonedItemStack.getAmount());
    }

    public void giveAllItemFromHand(CommandSender sender, ItemStack itemStack) {
        if (itemStack == null || itemStack.getType().isAir()) {
            this.message(sender, Message.COMMAND_ITEM_EMPTY, new Object[0]);
            return;
        }
        String itemName = this.getItemName(itemStack);
        int amount = itemStack.getAmount();
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.addItemAndFix(player.getUniqueId(), itemStack.clone());
        }
        this.message(sender, Message.MAILBOX_GIVE_ALL_HAND, "%item%", itemName, "%amount%", amount);
    }

    private String getItemName(ItemStack itemStack) {
        ItemMeta itemMeta;
        if (itemStack.hasItemMeta() && (itemMeta = itemStack.getItemMeta()) != null && itemMeta.hasDisplayName()) {
            return itemMeta.getDisplayName();
        }
        return this.name(itemStack.getType().name());
    }

    public void clear(CommandSender sender, UUID uuid, String username) {
        this.getStorage().clearMailBox(uuid);
        User user = this.getUser(uuid);
        if (user != null) {
            user.setMailBoxItems(List.of());
        }
        this.message(sender, Message.MAILBOX_CLEAR, "%player%", username);
    }
}

