/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.module.modules;

import fr.maxlego08.essentials.ZEssentialsPlugin;
import fr.maxlego08.essentials.api.configuration.NonLoadable;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.teleportation.RandomTeleportWorld;
import fr.maxlego08.essentials.api.teleportation.TeleportPermission;
import fr.maxlego08.essentials.api.teleportation.WorldOverride;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.module.ZModule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TeleportationModule
extends ZModule {
    private final Random random = new Random();
    private final List<TeleportPermission> teleportDelayPermissions = new ArrayList<TeleportPermission>();
    private final List<TeleportPermission> teleportProtections = new ArrayList<TeleportPermission>();
    private final List<String> blacklistBiomes = new ArrayList<String>();
    private final List<RandomTeleportWorld> rtpWorlds = new ArrayList<RandomTeleportWorld>();
    private final List<WorldOverride> rtpWorldOverrides = new ArrayList<WorldOverride>();
    @NonLoadable
    private final Queue<UUID> rtpQueue = new LinkedList<UUID>();
    private boolean teleportSafety;
    private boolean teleportToCenter;
    private int teleportDelay;
    private int teleportProtection;
    private int teleportTpaExpire;
    private boolean teleportDelayBypass;
    private boolean openConfirmInventoryForTpa;
    private boolean openConfirmInventoryForTpaHere;
    private int maxRtpAttempts;
    private boolean enableRandomTeleportSearchLogMessage;
    private boolean enableRtpQueue;
    private long rtpQueueDelay;
    private boolean enableFirstJoinRtp;
    private String firstJoinRtpWorld;
    @NonLoadable
    private Map<String, String> worldOverrides = new HashMap<String, String>();
    @NonLoadable
    private Map<String, RandomTeleportWorld> rtpWorldMap = new HashMap<String, RandomTeleportWorld>();
    @NonLoadable
    private boolean isProcessingQueue = false;

    public TeleportationModule(ZEssentialsPlugin plugin) {
        super(plugin, "teleportation");
    }

    @Override
    public void loadConfiguration() {
        super.loadConfiguration();
        this.loadInventory("confirm_request_inventory");
        this.loadInventory("confirm_request_here_inventory");
        this.rtpWorldMap = this.rtpWorlds.stream().collect(Collectors.toMap(RandomTeleportWorld::world, r -> r));
        this.worldOverrides = this.rtpWorldOverrides.stream().filter(e -> e.to() != null && e.from() != null).collect(Collectors.toMap(WorldOverride::from, WorldOverride::to));
    }

    public boolean isTeleportSafety() {
        return this.teleportSafety;
    }

    public boolean isTeleportToCenter() {
        return this.teleportToCenter;
    }

    public int getTeleportDelay() {
        return this.teleportDelay;
    }

    public boolean isTeleportDelayBypass() {
        return this.teleportDelayBypass;
    }

    public List<TeleportPermission> getTeleportDelayPermissions() {
        return this.teleportDelayPermissions;
    }

    public int getTeleportTpaExpire() {
        return this.teleportTpaExpire;
    }

    public boolean isOpenConfirmInventoryForTpa() {
        return this.openConfirmInventoryForTpa;
    }

    public boolean isOpenConfirmInventoryForTpaHere() {
        return this.openConfirmInventoryForTpaHere;
    }

    public int getTeleportDelay(Player player) {
        return this.teleportDelayPermissions.stream().filter(teleportPermission -> player.hasPermission(teleportPermission.permission())).mapToInt(TeleportPermission::delay).min().orElse(this.teleportDelay);
    }

    public int getTeleportProtectionDelay(Player player) {
        return this.teleportProtections.stream().filter(teleportPermission -> player.hasPermission(teleportPermission.permission())).mapToInt(TeleportPermission::delay).min().orElse(this.teleportProtection);
    }

    public void openConfirmInventory(Player player) {
        this.plugin.getInventoryManager().openInventory(player, (Plugin)this.plugin, "confirm_request_inventory");
    }

    public void openConfirmHereInventory(Player player) {
        this.plugin.getInventoryManager().openInventory(player, (Plugin)this.plugin, "confirm_request_here_inventory");
    }

    public void randomTeleport(Player player, World world) {
        RandomTeleportWorld configuration;
        String worldName = world.getName();
        if (this.worldOverrides.containsKey(worldName)) {
            String overrideWorld = this.worldOverrides.get(worldName);
            World targetWorld = this.plugin.getServer().getWorld(overrideWorld);
            if (targetWorld != null) {
                world = targetWorld;
                worldName = overrideWorld;
            }
        }
        if ((configuration = this.rtpWorldMap.get(worldName)) == null) {
            this.message((CommandSender)player, Message.COMMAND_RANDOM_TP_CONFIGURATION_NOT_FOUND, "%world%", worldName);
            return;
        }
        if (this.enableRtpQueue) {
            this.addToRtpQueue(player, world, configuration);
        } else {
            this.randomTeleport(player, world, configuration.centerX(), configuration.centerZ(), configuration.radiusX(), configuration.radiusZ());
        }
    }

    public void randomTeleport(Player player, World world, int centerX, int centerZ, int rangeX, int rangeZ) {
        this.performRandomTeleport(player, world, centerX, centerZ, rangeX, rangeZ);
    }

    private void performRandomTeleport(Player player, World world, int centerX, int centerZ, int rangeX, int rangeZ) {
        this.debug("Starting random teleport for player " + player.getName());
        this.message((CommandSender)player, Message.TELEPORT_RANDOM_START, new Object[0]);
        this.getRandomSurfaceLocation(world, centerX, centerZ, rangeX, rangeZ, this.maxRtpAttempts).thenAccept(randomLocation -> {
            this.debug("Random location found: " + String.valueOf(randomLocation));
            if (randomLocation != null) {
                User user = this.getUser((Entity)player);
                user.teleport((Location)randomLocation, Message.TELEPORT_MESSAGE_RANDOM, Message.TELEPORT_SUCCESS_RANDOM, new Object[0]);
            } else {
                this.debug("Failed to find random location");
                this.message((CommandSender)player, Message.COMMAND_RANDOM_TP_ERROR, new Object[0]);
            }
        });
    }

    private CompletableFuture<Location> getRandomSurfaceLocation(World world, int centerX, int centerZ, int rangeX, int rangeZ, int attempts) {
        this.debug("Starting random surface location search for world " + world.getName());
        CompletableFuture<Location> future = new CompletableFuture<Location>();
        if (attempts > 0) {
            this.randomLocation(world, centerX, centerZ, rangeX, rangeZ).thenAccept(location -> {
                this.debug("Random location generated: " + String.valueOf(location));
                if (this.isValidLocation((Location)location)) {
                    future.complete((Location)location);
                } else {
                    this.debug("Random location not valid");
                    this.getRandomSurfaceLocation(world, centerX, centerZ, rangeX, rangeZ, attempts - 1).thenAccept(future::complete);
                }
            });
        } else {
            this.debug("Failed to find random surface location, using default location");
            future.complete(null);
        }
        return future;
    }

    private CompletableFuture<Location> randomLocation(World world, int centerX, int centerZ, int rangeX, int rangeZ) {
        this.debug("Generating random location for world " + world.getName());
        CompletableFuture<Location> future = new CompletableFuture<Location>();
        int x = centerX + (int)(Math.random() * (double)(2 * rangeX + 1)) - rangeX;
        int z = centerZ + (int)(Math.random() * (double)(2 * rangeZ + 1)) - rangeZ;
        world.getChunkAtAsync(x >> 4, z >> 4).thenAccept(chunk -> this.plugin.getScheduler().runAtLocation(new Location(world, (double)x, 0.0, (double)z), wrappedTask -> {
            int y = this.findSafeY(world, x, z);
            Location location = new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5, 360.0f * this.random.nextFloat() - 180.0f, 0.0f);
            this.debug("Final location determined: " + String.valueOf(location));
            future.complete(location);
        }));
        return future;
    }

    private int findSafeY(World world, int x, int z) {
        if (World.Environment.NETHER == world.getEnvironment()) {
            return this.getNetherYAt(new Location(world, (double)x, 0.0, (double)z));
        }
        int maxY = world.getMaxHeight() - 1;
        int minY = world.getMinHeight();
        for (int y = maxY; y >= minY; --y) {
            Material blockType = world.getBlockAt(x, y, z).getType();
            if (blockType == Material.WATER || blockType == Material.LAVA || !blockType.isSolid()) continue;
            return y + 1;
        }
        return world.getSeaLevel();
    }

    private boolean isValidLocation(Location location) {
        Location checkLoc = location.clone();
        if (this.blacklistBiomes.stream().anyMatch(b -> b.equalsIgnoreCase(checkLoc.getBlock().getBiome().name()))) {
            return false;
        }
        Location below = checkLoc.clone().subtract(0.0, 1.0, 0.0);
        Location at = checkLoc.clone();
        Location above = checkLoc.clone().add(0.0, 1.0, 0.0);
        Material belowType = below.getBlock().getType();
        Material atType = at.getBlock().getType();
        Material aboveType = above.getBlock().getType();
        boolean isValid = belowType.isSolid() && belowType != Material.WATER && belowType != Material.LAVA && !atType.isSolid() && atType.isAir() && aboveType.isAir();
        this.debug("Location validation: " + String.valueOf(location) + " -> " + isValid);
        this.debug("  Below: " + String.valueOf(below.getBlock().getType()) + " (solid: " + below.getBlock().getType().isSolid() + ")");
        this.debug("  At: " + String.valueOf(at.getBlock().getType()) + " (air: " + at.getBlock().getType().isAir() + ")");
        this.debug("  Above: " + String.valueOf(above.getBlock().getType()) + " (air: " + above.getBlock().getType().isAir() + ")");
        return isValid;
    }

    private int getNetherYAt(Location location) {
        for (int y = 32; y < location.getWorld().getMaxHeight(); ++y) {
            if (this.isBlockUnsafe(location.getWorld(), location.getBlockX(), y, location.getBlockZ())) continue;
            return y;
        }
        return -1;
    }

    private boolean isBlockUnsafe(World world, int x, int y, int z) {
        Material blockType = world.getBlockAt(x, y, z).getType();
        return !blockType.isSolid() || blockType == Material.LAVA || blockType == Material.FIRE;
    }

    private void debug(String message) {
        if (this.enableRandomTeleportSearchLogMessage) {
            this.plugin.getLogger().info(message);
        }
    }

    private void addToRtpQueue(Player player, World world, RandomTeleportWorld configuration) {
        UUID playerUuid = player.getUniqueId();
        if (this.rtpQueue.contains(playerUuid)) {
            this.message((CommandSender)player, Message.TELEPORT_ALREADY_IN_QUEUE, new Object[0]);
            return;
        }
        this.rtpQueue.offer(playerUuid);
        int position = this.rtpQueue.size();
        this.message((CommandSender)player, Message.TELEPORT_ADDED_TO_QUEUE, "%position%", position);
        if (!this.isProcessingQueue) {
            this.processRtpQueue(world, configuration);
        }
    }

    private void processRtpQueue(World defaultWorld, RandomTeleportWorld defaultConfig) {
        if (this.rtpQueue.isEmpty()) {
            this.isProcessingQueue = false;
            return;
        }
        this.isProcessingQueue = true;
        UUID playerUuid = this.rtpQueue.poll();
        if (playerUuid != null) {
            Player player = this.plugin.getServer().getPlayer(playerUuid);
            if (player != null && player.isOnline()) {
                RandomTeleportWorld configuration;
                World world = player.getWorld();
                String worldName = world.getName();
                if (this.worldOverrides.containsKey(worldName)) {
                    String overrideWorld = this.worldOverrides.get(worldName);
                    World targetWorld = this.plugin.getServer().getWorld(overrideWorld);
                    if (targetWorld != null) {
                        world = targetWorld;
                        worldName = overrideWorld;
                    }
                }
                if ((configuration = this.rtpWorldMap.get(worldName)) == null) {
                    configuration = defaultConfig;
                    world = defaultWorld;
                }
                World finalWorld = world;
                RandomTeleportWorld finalConfig = configuration;
                this.performRandomTeleport(player, world, configuration.centerX(), configuration.centerZ(), configuration.radiusX(), configuration.radiusZ());
                this.plugin.getScheduler().runLater(() -> this.processRtpQueue(finalWorld, finalConfig), this.rtpQueueDelay, TimeUnit.MILLISECONDS);
            } else {
                this.processRtpQueue(defaultWorld, defaultConfig);
            }
        }
    }

    public void performFirstJoinRtp(Player player) {
        if (!this.enableFirstJoinRtp) {
            return;
        }
        World world = this.plugin.getServer().getWorld(this.firstJoinRtpWorld);
        if (world == null) {
            world = player.getWorld();
        }
        this.randomTeleport(player, world);
    }

    public boolean isEnableFirstJoinRtp() {
        return this.enableFirstJoinRtp;
    }
}

