/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.module.modules.kit;

import fr.maxlego08.essentials.ZEssentialsPlugin;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.kit.Kit;
import fr.maxlego08.essentials.api.kit.KitDisplay;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.module.ZModule;
import fr.maxlego08.essentials.module.modules.kit.KitInventoryHolder;
import fr.maxlego08.essentials.module.modules.kit.ZKit;
import fr.maxlego08.essentials.zutils.utils.TimerBuilder;
import fr.maxlego08.menu.api.InventoryManager;
import fr.maxlego08.menu.api.MenuItemStack;
import fr.maxlego08.menu.api.requirement.Action;
import fr.maxlego08.menu.api.utils.Loader;
import fr.maxlego08.menu.api.utils.TypedMapAccessor;
import fr.maxlego08.menu.loader.MenuItemStackLoader;
import fr.maxlego08.menu.zcore.utils.itemstack.MenuItemStackFromItemStack;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.util.Strings;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;

public class KitModule
extends ZModule {
    private final List<Kit> kits = new ArrayList<Kit>();
    private final List<String> kitsOnFirstJoin = new ArrayList<String>();
    private KitDisplay display;

    public KitModule(ZEssentialsPlugin plugin) {
        super(plugin, "kits");
        this.copyAndUpdate = false;
    }

    @Override
    public void loadConfiguration() {
        super.loadConfiguration();
        this.loadKits();
        this.loadInventory("kits");
        this.loadInventory("kit_preview");
    }

    public boolean exist(String name) {
        return this.getKit(name).isPresent();
    }

    public Optional<Kit> getKit(String name) {
        return this.kits.stream().filter(e -> e.getName().equalsIgnoreCase(name)).findFirst();
    }

    private void loadKits() {
        this.kits.clear();
        File folder = new File(this.getFolder(), "kits");
        if (!folder.exists()) {
            this.plugin.saveResource("modules/kits/kits/food.yml", true);
            this.plugin.saveResource("modules/kits/kits/tools.yml", true);
            this.plugin.saveResource("modules/kits/kits/fight.yml", true);
            this.plugin.saveResource("modules/kits/kits/basic_tools.yml", true);
            this.plugin.saveResource("modules/kits/kits/iron_tools_advanced.yml", true);
            this.plugin.saveResource("modules/kits/kits/pvp.yml", true);
            this.plugin.saveResource("modules/kits/kits/starter_food.yml", true);
        }
        this.files(folder, this::loadKit);
    }

    private void loadKit(File file) {
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
        String name = configuration.getString("name");
        String displayName = configuration.getString("display-name", name);
        String permission = configuration.getString("permission", Permission.ESSENTIALS_KIT_.asPermission(name));
        String category = configuration.getString("category", null);
        String subCategory = configuration.getString("sub-category", null);
        if (this.exist(name)) {
            this.plugin.getLogger().severe("Kit " + name + " already exist !");
            return;
        }
        long cooldown = configuration.getLong("cooldown", 0L);
        HashMap<String, Long> permissionCooldowns = new HashMap<String, Long>();
        for (Map map : configuration.getMapList("permission-cooldowns")) {
            TypedMapAccessor accessor = new TypedMapAccessor(map);
            permissionCooldowns.put(accessor.getString("permission"), accessor.getLong("cooldown"));
        }
        ConfigurationSection configurationSectionItems = configuration.getConfigurationSection("items");
        if (configurationSectionItems == null) {
            this.plugin.getLogger().severe("Impossible to find items section for " + String.valueOf(file.getAbsoluteFile()));
            return;
        }
        ArrayList<MenuItemStack> items = new ArrayList<MenuItemStack>();
        for (String itemName : configurationSectionItems.getKeys(false)) {
            items.add(this.plugin.getInventoryManager().loadItemStack(configuration, "items." + itemName + ".", file));
        }
        List actions = this.plugin.getButtonManager().loadActions(configuration.getList("actions", new ArrayList()), "actions", file);
        ZKit kit = new ZKit(this.plugin, displayName, name, category, subCategory, cooldown, permissionCooldowns, items, actions, permission, file);
        this.loadKitEquipment(kit, configuration, this.plugin.getInventoryManager(), "helmet.", EquipmentSlot.HEAD);
        this.loadKitEquipment(kit, configuration, this.plugin.getInventoryManager(), "chestplate.", EquipmentSlot.CHEST);
        this.loadKitEquipment(kit, configuration, this.plugin.getInventoryManager(), "leggings.", EquipmentSlot.LEGS);
        this.loadKitEquipment(kit, configuration, this.plugin.getInventoryManager(), "boots.", EquipmentSlot.FEET);
        this.kits.add(kit);
        this.plugin.getLogger().info("Register kit: " + name);
    }

    private void loadKitEquipment(ZKit kit, YamlConfiguration configuration, InventoryManager inventoryManager, String path, EquipmentSlot equipmentSlot) {
        if (configuration.getConfigurationSection(path) == null) {
            return;
        }
        MenuItemStack itemStack = inventoryManager.loadItemStack(configuration, path, kit.getFile());
        switch (equipmentSlot) {
            case HEAD: {
                kit.setHelmet(itemStack);
                break;
            }
            case CHEST: {
                kit.setChestplate(itemStack);
                break;
            }
            case LEGS: {
                kit.setLeggings(itemStack);
                break;
            }
            case FEET: {
                kit.setBoots(itemStack);
            }
        }
    }

    public List<Kit> getKits(Permissible permissible) {
        return this.kits.stream().filter(kit -> kit.hasPermission(permissible)).toList();
    }

    public List<Kit> getKitsByCategory(Player player, String categoryName) {
        return this.getKits((Permissible)player).stream().filter(e -> e.hasCategory() && e.getCategory().equalsIgnoreCase(categoryName)).toList();
    }

    public List<Kit> getKitsBySubCategory(Player player, String categoryName, String subCategoryName) {
        return this.getKits((Permissible)player).stream().filter(e -> e.getCategory().equalsIgnoreCase(categoryName) && e.getSubCategory().equalsIgnoreCase(subCategoryName)).toList();
    }

    public boolean giveKit(User user, Kit kit, boolean bypassCooldown) {
        long cooldown = kit.getCooldown((Permissible)user.getPlayer());
        if (cooldown != 0L && !bypassCooldown && !user.hasPermission(Permission.ESSENTIALS_KIT_BYPASS_COOLDOWN) && user.isKitCooldown(kit)) {
            long milliSeconds = user.getKitCooldown(kit) - System.currentTimeMillis();
            this.message(user, Message.COOLDOWN, "%cooldown%", TimerBuilder.getStringTime(milliSeconds));
            return false;
        }
        kit.give(user.getPlayer());
        if (cooldown != 0L && !bypassCooldown && !user.hasPermission(Permission.ESSENTIALS_KIT_BYPASS_COOLDOWN)) {
            user.addKitCooldown(kit, cooldown);
        }
        return true;
    }

    public void sendInLine(CommandSender sender) {
        List<String> homesAsString = this.kits.stream().map(kit -> this.getMessage(Message.COMMAND_KIT_INFORMATION_IN_LINE_INFO_AVAILABLE, "%name%", kit.getName())).toList();
        this.message(sender, Message.COMMAND_KIT_INFORMATION_IN_LINE, "%kits%", Strings.join(homesAsString, (char)','));
    }

    public void showKits(User user) {
        if (this.display != KitDisplay.INVENTORY) {
            List<Kit> kits = this.getKits((Permissible)user.getPlayer());
            if (this.display == KitDisplay.IN_LINE) {
                List<String> homesAsString = kits.stream().map(kit -> {
                    long cooldown = kit.getCooldown((Permissible)user.getPlayer());
                    long milliSeconds = 0L;
                    if (cooldown != 0L && !user.hasPermission(Permission.ESSENTIALS_KIT_BYPASS_COOLDOWN) && user.isKitCooldown((Kit)kit)) {
                        milliSeconds = user.getKitCooldown((Kit)kit) - System.currentTimeMillis();
                    }
                    return this.getMessage(milliSeconds != 0L ? Message.COMMAND_KIT_INFORMATION_IN_LINE_INFO_UNAVAILABLE : Message.COMMAND_KIT_INFORMATION_IN_LINE_INFO_AVAILABLE, "%name%", kit.getName(), "%time%", TimerBuilder.getStringTime(milliSeconds));
                }).toList();
                this.message(user, Message.COMMAND_KIT_INFORMATION_IN_LINE, "%kits%", Strings.join(homesAsString, (char)','));
            } else {
                this.message(user, Message.COMMAND_KIT_INFORMATION_MULTI_LINE_HEADER, new Object[0]);
                kits.forEach(kit -> {
                    long cooldown = kit.getCooldown((Permissible)user.getPlayer());
                    long milliSeconds = 0L;
                    if (cooldown != 0L && !user.hasPermission(Permission.ESSENTIALS_KIT_BYPASS_COOLDOWN) && user.isKitCooldown((Kit)kit)) {
                        milliSeconds = user.getKitCooldown((Kit)kit) - System.currentTimeMillis();
                    }
                    this.message(user, milliSeconds != 0L ? Message.COMMAND_KIT_INFORMATION_MULTI_LINE_CONTENT_UNAVAILABLE : Message.COMMAND_KIT_INFORMATION_MULTI_LINE_CONTENT_AVAILABLE, "%name%", kit.getName(), "%time%", TimerBuilder.getStringTime(milliSeconds));
                });
                this.message(user, Message.COMMAND_KIT_INFORMATION_MULTI_LINE_FOOTER, new Object[0]);
            }
        } else {
            this.plugin.openInventory(user.getPlayer(), "kits");
        }
    }

    public void openKitEditor(Player player, Kit kit) {
        KitInventoryHolder inventoryHolder = new KitInventoryHolder(player, kit);
        player.openInventory(inventoryHolder.getInventory());
    }

    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (inventoryHolder instanceof KitInventoryHolder) {
            KitInventoryHolder inventoryHolder2 = (KitInventoryHolder)inventoryHolder;
            Kit kit = inventoryHolder2.getKit();
            ArrayList<MenuItemStack> menuItemStacks = new ArrayList<MenuItemStack>();
            for (ItemStack itemStack : event.getInventory().getContents()) {
                if (itemStack == null) continue;
                menuItemStacks.add((MenuItemStack)MenuItemStackFromItemStack.fromItemStack((InventoryManager)this.plugin.getInventoryManager(), (ItemStack)itemStack));
            }
            kit.setItems(menuItemStacks);
            this.saveKit(kit);
            this.message((CommandSender)event.getPlayer(), Message.COMMAND_KIT_EDITOR_SAVE, "%kit%", kit.getName());
        }
    }

    public void createKit(Player player, String kitName, long cooldown) {
        File file = new File(this.getFolder(), "kits/" + kitName + ".yml");
        try {
            file.createNewFile();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        ZKit kit = new ZKit(this.plugin, kitName, kitName, null, null, cooldown, new HashMap<String, Long>(), new ArrayList<MenuItemStack>(), new ArrayList<Action>(), Permission.ESSENTIALS_KIT_.asPermission(kitName), file);
        this.kits.add(kit);
        this.saveKit(kit);
        this.message((CommandSender)player, Message.COMMAND_KIT_CREATE, "%kit%", kit.getName());
    }

    public void deleteKit(Player player, Kit kit) {
        if (kit.getFile().delete()) {
            this.kits.remove(kit);
            this.message((CommandSender)player, Message.COMMAND_KIT_DELETE, "%kit%", kit.getName());
        } else {
            this.message((CommandSender)player, Message.COMMAND_KIT_DELETE, "%kit%", kit.getName());
        }
    }

    public List<String> getKitNames() {
        List<String> kitNames = Arrays.asList("warrior", "archer", "mage", "healer", "miner", "builder", "scout", "assassin", "knight", "ranger", "alchemist", "blacksmith", "explorer", "thief", "fisherman", "farmer", "necromancer", "paladin", "berserker", "enchanter");
        return kitNames.stream().filter(name -> this.kits.stream().noneMatch(kit -> kit.getName().equalsIgnoreCase((String)name))).toList();
    }

    private void saveKit(Kit kit) {
        File file = kit.getFile();
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
        ConfigurationSection configurationSection = configuration.getConfigurationSection("items.");
        if (configurationSection != null) {
            configurationSection.getKeys(true).forEach(key -> configurationSection.set(key, null));
        }
        configuration.set("name", (Object)kit.getName());
        configuration.set("display-name", (Object)kit.getDisplayName());
        configuration.set("permission", (Object)kit.getPermission());
        configuration.set("cooldown", (Object)kit.getCooldown());
        MenuItemStackLoader loader = new MenuItemStackLoader(this.plugin.getInventoryManager());
        AtomicInteger atomicInteger = new AtomicInteger(1);
        kit.getMenuItemStacks().forEach(arg_0 -> KitModule.lambda$saveKit$10((Loader)loader, configuration, atomicInteger, file, arg_0));
        try {
            configuration.save(file);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        User user = this.getUser((Entity)event.getPlayer());
        if (this.kitsOnFirstJoin.isEmpty() || !user.isFirstJoin()) {
            return;
        }
        for (String kitName : this.kitsOnFirstJoin) {
            Optional<Kit> optional = this.getKit(kitName);
            if (optional.isPresent()) {
                Kit kit = optional.get();
                kit.give(user.getPlayer());
                continue;
            }
            this.plugin.getLogger().severe("Cannot find the kit " + kitName);
        }
    }

    private static /* synthetic */ void lambda$saveKit$10(Loader loader, YamlConfiguration configuration, AtomicInteger atomicInteger, File file, MenuItemStack menuItemStack) {
        loader.save((Object)menuItemStack, configuration, "items.item-" + atomicInteger.getAndIncrement() + ".", file, new Object[0]);
    }
}

