/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.module.modules.vault;

import fr.maxlego08.essentials.api.dto.VaultItemDTO;
import fr.maxlego08.essentials.api.vault.Vault;
import fr.maxlego08.essentials.api.vault.VaultItem;
import fr.maxlego08.essentials.module.modules.vault.ZVaultItem;
import fr.maxlego08.essentials.zutils.utils.ZUtils;
import fr.maxlego08.menu.zcore.utils.nms.ItemStackUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ZVault
extends ZUtils
implements Vault {
    private final UUID uniqueId;
    private final int vaultId;
    private final Map<Integer, VaultItem> vaultItems = new HashMap<Integer, VaultItem>();
    private String name;
    private ItemStack iconItemStack;

    public ZVault(UUID uniqueId, int vaultId, String name, ItemStack iconItemStack) {
        this.uniqueId = uniqueId;
        this.vaultId = vaultId;
        this.name = name;
        this.iconItemStack = iconItemStack;
    }

    public ZVault(UUID uuid, int vaultId, String name) {
        this(uuid, vaultId, name.replace("%vault-id%", String.valueOf(vaultId)), null);
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public Map<Integer, VaultItem> getVaultItems() {
        return this.vaultItems;
    }

    @Override
    public int getVaultId() {
        return this.vaultId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public ItemStack getIconItemStack() {
        return this.iconItemStack;
    }

    @Override
    public void setIconItemStack(ItemStack iconItemStack) {
        this.iconItemStack = iconItemStack;
    }

    @Override
    public void createItem(VaultItemDTO vaultItemDTO) {
        this.vaultItems.put(vaultItemDTO.slot(), new ZVaultItem(vaultItemDTO.slot(), ItemStackUtils.deserializeItemStack((String)vaultItemDTO.item()), vaultItemDTO.quantity()));
    }

    @Override
    public boolean contains(int slot) {
        return this.vaultItems.containsKey(slot);
    }

    @Override
    public boolean contains(ItemStack itemStack) {
        return this.vaultItems.values().stream().anyMatch(vaultItem -> vaultItem.getItemStack().isSimilar(itemStack));
    }

    @Override
    public Optional<VaultItem> find(ItemStack itemStack) {
        return this.vaultItems.values().stream().filter(vaultItem -> vaultItem.getItemStack().isSimilar(itemStack)).findFirst();
    }

    @Override
    public int getNextSlot() {
        return IntStream.range(0, 45).filter(i -> !this.vaultItems.containsKey(i)).findFirst().orElse(-1);
    }

    @Override
    public boolean hasFreeSlot() {
        return this.getNextSlot() != -1;
    }

    @Override
    public long getMaterialAmount(Material material) {
        Optional<VaultItem> optional = this.find(new ItemStack(material));
        return optional.map(VaultItem::getQuantity).orElse(0L);
    }
}

