/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.storage.database.repositeries;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.dto.PrivateMessageDTO;
import fr.maxlego08.essentials.libs.sarah.DatabaseConnection;
import fr.maxlego08.essentials.storage.database.Repository;
import java.util.List;
import java.util.UUID;

public class PrivateMessagesRepository
extends Repository {
    public PrivateMessagesRepository(EssentialsPlugin plugin, DatabaseConnection connection) {
        super(plugin, connection, "private_messages");
    }

    public List<PrivateMessageDTO> getMessages(UUID uuid) {
        return this.select(PrivateMessageDTO.class, table -> {
            table.uuid("sender_unique_id", uuid);
            table.orderByDesc("created_at");
        });
    }

    public void insertMessages(List<PrivateMessageDTO> privateMessages) {
        this.insert(privateMessages.stream().map(dto -> this.schema(table -> {
            table.uuid("sender_unique_id", dto.sender_unique_id());
            table.uuid("receiver_unique_id", dto.receiver_unique_id());
            table.string("content", dto.content());
        })).toList());
    }
}

