/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.storage.database.repositeries;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.dto.CooldownDTO;
import fr.maxlego08.essentials.libs.sarah.DatabaseConnection;
import fr.maxlego08.essentials.libs.sarah.database.Schema;
import fr.maxlego08.essentials.storage.database.Repository;
import java.util.List;
import java.util.UUID;

public class UserCooldownsRepository
extends Repository {
    public UserCooldownsRepository(EssentialsPlugin plugin, DatabaseConnection connection) {
        super(plugin, connection, "user_cooldowns");
    }

    public void upsert(UUID uuid, String cooldownName, long cooldownValue) {
        this.upsert((Schema table) -> {
            table.uuid("unique_id", uuid).primary();
            table.string("cooldown_name", cooldownName).primary();
            table.bigInt("cooldown_value", cooldownValue);
        });
    }

    public List<CooldownDTO> select(UUID uuid) {
        return this.select(CooldownDTO.class, schema -> schema.where("unique_id", uuid));
    }

    public void deleteExpiredCooldowns() {
        this.delete(table -> table.where("cooldown_value", "<", System.currentTimeMillis()));
    }

    public void delete(UUID uniqueId, String key) {
        this.delete(table -> table.where("cooldown_name", key).where("unique_id", uniqueId.toString()));
    }
}

