/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.storage.database.repositeries;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.dto.HomeDTO;
import fr.maxlego08.essentials.api.home.Home;
import fr.maxlego08.essentials.libs.sarah.DatabaseConnection;
import fr.maxlego08.essentials.libs.sarah.database.Schema;
import fr.maxlego08.essentials.storage.database.Repository;
import fr.maxlego08.essentials.user.ZHome;
import java.util.List;
import java.util.UUID;

public class UserHomeRepository
extends Repository {
    public UserHomeRepository(EssentialsPlugin plugin, DatabaseConnection connection) {
        super(plugin, connection, "user_homes");
    }

    public void upsert(UUID uuid, Home home) {
        this.upsert((Schema table) -> {
            table.uuid("unique_id", uuid).primary();
            table.string("name", home.getName()).primary();
            table.string("location", this.locationAsString(home.getLocation()));
            table.string("material", home.getMaterial() != null ? home.getMaterial().name() : null);
        });
    }

    public List<HomeDTO> select(UUID uuid) {
        return this.select(HomeDTO.class, schema -> schema.where("unique_id", uuid));
    }

    public void deleteHome(UUID uuid, String name) {
        this.delete(table -> table.where("unique_id", uuid).where("name", name));
    }

    public List<Home> getHomes(UUID uuid, String homeName) {
        return this.select(HomeDTO.class, schema -> schema.where("unique_id", uuid).where("name", homeName)).stream().map(homeDTO -> new ZHome(this.stringAsLocation(homeDTO.location()), homeDTO.name(), null)).toList();
    }

    public List<Home> getHomes(UUID uuid) {
        return this.select(HomeDTO.class, schema -> schema.where("unique_id", uuid)).stream().map(homeDTO -> new ZHome(this.stringAsLocation(homeDTO.location()), homeDTO.name(), null)).toList();
    }

    public void deleteWorldData(String worldName) {
        this.delete(table -> table.where("location", "LIKE", "%" + worldName + "%"));
    }
}

