/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.storage.database.repositeries;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.dto.VaultItemDTO;
import fr.maxlego08.essentials.libs.sarah.DatabaseConnection;
import fr.maxlego08.essentials.libs.sarah.database.Schema;
import fr.maxlego08.essentials.storage.database.Repository;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class VaultItemRepository
extends Repository {
    private final ConcurrentHashMap<CacheKey, CacheValue> caches = new ConcurrentHashMap();

    public VaultItemRepository(EssentialsPlugin plugin, DatabaseConnection connection) {
        super(plugin, connection, "vault_items");
    }

    public List<VaultItemDTO> select() {
        return this.select(VaultItemDTO.class, table -> {});
    }

    public Optional<VaultItemDTO> select(UUID uniqueId, int vaultId, int slot) {
        return this.select(VaultItemDTO.class, table -> {
            table.where("unique_id", uniqueId);
            table.where("vault_id", vaultId);
            table.where("slot", slot);
        }).stream().findFirst();
    }

    public void updateQuantity(UUID uniqueId, int vaultId, int slot, long quantity) {
        CacheKey key = new CacheKey(uniqueId, vaultId, slot);
        this.caches.compute(key, (k, value) -> {
            if (value != null) {
                value.add(quantity);
                return value;
            }
            this.startTask((CacheKey)k);
            return new CacheValue(System.currentTimeMillis(), quantity);
        });
    }

    private void startTask(CacheKey key) {
        this.plugin.getScheduler().runLaterAsync(() -> {
            long currentTime = System.currentTimeMillis();
            CacheValue value = this.caches.get(key);
            if (value == null) {
                return;
            }
            if (currentTime - value.getCreatedAt() >= 200L) {
                this.caches.remove(key);
                this.update(table -> {
                    table.bigInt("quantity", value.quantity);
                    table.where("unique_id", key.uniqueId);
                    table.where("vault_id", key.vaultId);
                    table.where("slot", key.slot);
                });
            } else {
                this.startTask(key);
            }
        }, 4L);
    }

    public void createNewItem(UUID uniqueId, int vaultId, int slot, long quantity, String item) {
        this.insert((Schema table) -> {
            table.uuid("unique_id", uniqueId);
            table.bigInt("vault_id", vaultId);
            table.bigInt("slot", slot);
            table.string("item", item);
            table.bigInt("quantity", quantity);
        });
    }

    public void removeItem(UUID uniqueId, int vaultId, int slot) {
        this.caches.remove(new CacheKey(uniqueId, vaultId, slot));
        this.delete(table -> {
            table.where("unique_id", uniqueId);
            table.where("vault_id", vaultId);
            table.where("slot", slot);
        });
    }

    public boolean forceRemove(UUID uniqueId, int vaultId, int slot) {
        this.caches.remove(new CacheKey(uniqueId, vaultId, slot));
        int result = this.delete(table -> {
            table.where("unique_id", uniqueId);
            table.where("vault_id", vaultId);
            table.where("slot", slot);
        });
        return result > 0;
    }

    public record CacheKey(UUID uniqueId, int vaultId, int slot) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.vaultId == cacheKey.vaultId && this.slot == cacheKey.slot && Objects.equals(this.uniqueId, cacheKey.uniqueId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.uniqueId, this.vaultId, this.slot);
        }
    }

    public static class CacheValue {
        private long createdAt;
        private long quantity;

        public CacheValue(long createdAt, long quantity) {
            this.createdAt = createdAt;
            this.quantity = quantity;
        }

        public long getCreatedAt() {
            return this.createdAt;
        }

        public long getQuantity() {
            return this.quantity;
        }

        public void add(long quantity) {
            this.createdAt = System.currentTimeMillis();
            this.quantity = quantity;
        }
    }
}

