/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.user;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.user.TeleportRequest;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.libs.folialib.impl.PlatformScheduler;
import fr.maxlego08.essentials.module.modules.TeleportationModule;
import fr.maxlego08.essentials.zutils.utils.ZUtils;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Location;

public class ZTeleportRequest
extends ZUtils
implements TeleportRequest {
    private final EssentialsPlugin plugin;
    private final User toUser;
    private final User fromUser;
    private final long expiredAt;
    private boolean isTeleport = false;

    public ZTeleportRequest(EssentialsPlugin plugin, User toUser, User fromUser, long expiredAt) {
        this.plugin = plugin;
        this.toUser = toUser;
        this.fromUser = fromUser;
        this.expiredAt = expiredAt;
    }

    @Override
    public User getToUser() {
        return this.toUser;
    }

    @Override
    public User getFromUser() {
        return this.fromUser;
    }

    @Override
    public long getExpiredAt() {
        return this.expiredAt;
    }

    @Override
    public boolean isValid() {
        return this.expiredAt > System.currentTimeMillis() && this.toUser.isOnline() && this.fromUser.isOnline() && !this.isTeleport;
    }

    @Override
    public void accept() {
        this.message(this.fromUser, Message.COMMAND_TPA_ACCEPT_SENDER, this.toUser);
        this.message(this.toUser, Message.COMMAND_TPA_ACCEPT_RECEIVER, this.fromUser);
        TeleportationModule teleportationModule = this.plugin.getModuleManager().getModule(TeleportationModule.class);
        AtomicInteger atomicInteger = new AtomicInteger(teleportationModule.getTeleportDelay(this.fromUser.getPlayer()));
        if (teleportationModule.isTeleportDelayBypass() && this.fromUser.hasPermission(Permission.ESSENTIALS_TELEPORT_BYPASS) || atomicInteger.get() <= 0) {
            this.teleport(teleportationModule);
            return;
        }
        Location playerLocation = this.fromUser.getPlayer().getLocation();
        PlatformScheduler serverImplementation = this.plugin.getScheduler();
        serverImplementation.runAtLocationTimer(this.toUser.getPlayer().getLocation(), wrappedTask -> {
            if (!this.fromUser.isOnline() || !this.same(playerLocation, this.fromUser.getPlayer().getLocation())) {
                this.message(this.fromUser, Message.TELEPORT_MOVE, new Object[0]);
                wrappedTask.cancel();
                this.fromUser.removeTeleportRequest(this.toUser);
                return;
            }
            int currentSecond = atomicInteger.getAndDecrement();
            if (!this.toUser.isOnline() || !this.fromUser.isOnline()) {
                wrappedTask.cancel();
                return;
            }
            if (currentSecond <= 0) {
                wrappedTask.cancel();
                this.teleport(teleportationModule);
            } else {
                this.message(this.fromUser, Message.TELEPORT_MESSAGE, "%seconds%", currentSecond);
            }
        }, 1L, 20L);
    }

    private void teleport(TeleportationModule teleportationModule) {
        Location location;
        Location playerLocation = this.toUser.getPlayer().getLocation();
        Location location2 = this.fromUser.getPlayer().isFlying() ? playerLocation : (location = teleportationModule.isTeleportSafety() ? this.toSafeLocation(playerLocation) : playerLocation);
        if (teleportationModule.isTeleportToCenter()) {
            location = location.getBlock().getLocation().add(0.5, 0.0, 0.5);
            location.setYaw(playerLocation.getYaw());
            location.setPitch(playerLocation.getPitch());
        }
        this.fromUser.teleportNow(location);
        this.fromUser.removeTeleportRequest(this.toUser);
        this.message(this.fromUser, Message.TELEPORT_SUCCESS, new Object[0]);
        this.isTeleport = true;
    }

    @Override
    public void deny() {
        this.message(this.fromUser, Message.COMMAND_TP_DENY_RECEIVER, this.toUser);
        this.message(this.toUser, Message.COMMAND_TP_DENY_SENDER, this.fromUser);
        this.isTeleport = true;
    }
}

