/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.zutils.utils.component.adapters;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonWriter;
import fr.maxlego08.essentials.zutils.utils.component.AbstractComponent;
import java.io.IOException;
import java.util.List;

public abstract class ComponentAdapter<T extends AbstractComponent>
extends TypeAdapter<T> {
    protected void writeExtras(JsonWriter out, T component) throws IOException {
        this.writeComponents(out, "extra", ((AbstractComponent)component).getExtra());
    }

    protected void writeComponents(JsonWriter out, String name, List<AbstractComponent> abstractComponents) throws IOException {
        if (!abstractComponents.isEmpty()) {
            out.name(name);
            out.beginArray();
            for (AbstractComponent extraComponent : abstractComponents) {
                AbstractComponent.GSON.toJson((Object)extraComponent, AbstractComponent.class, out);
            }
            out.endArray();
        }
    }

    protected void readExtras(JsonObject jsonObject, T component) {
        this.readComponents(jsonObject, "extra", ((AbstractComponent)component).getExtra());
    }

    protected void readComponents(JsonObject jsonObject, String name, List<AbstractComponent> abstractComponents) {
        if (jsonObject.has(name)) {
            JsonArray extraArray = jsonObject.getAsJsonArray(name);
            for (JsonElement element : extraArray) {
                AbstractComponent extraComponent = AbstractComponent.parse(element);
                if (extraComponent == null) continue;
                abstractComponents.add(extraComponent);
            }
        }
    }
}

