/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.zutils.utils.component.adapters;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import fr.maxlego08.essentials.zutils.utils.component.AbstractComponent;
import fr.maxlego08.essentials.zutils.utils.component.components.HoverEvent;
import fr.maxlego08.essentials.zutils.utils.component.components.TextComponent;
import java.io.IOException;
import java.util.UUID;
import net.kyori.adventure.text.event.HoverEvent;

public class HoverAdapter
extends TypeAdapter<HoverEvent> {
    public void write(JsonWriter out, HoverEvent event) throws IOException {
        out.beginObject();
        out.name("action").value(event.getAction());
        Object value = event.getValue();
        if (value != null) {
            out.name("value");
            if (value instanceof String) {
                out.value((String)value);
            } else if (value instanceof TextComponent) {
                TextComponent textComponent = (TextComponent)value;
                AbstractComponent.GSON.toJson(textComponent.toJsonElement(), out);
            } else if (value instanceof ShowItem || value instanceof ShowEntity) {
                AbstractComponent.GSON.toJson(value, value.getClass(), out);
            }
        }
        out.endObject();
    }

    public HoverEvent read(JsonReader in) throws IOException {
        Object value;
        String action;
        block16: {
            JsonObject jsonObject;
            block15: {
                action = null;
                value = null;
                jsonObject = (JsonObject)AbstractComponent.GSON.fromJson(in, JsonObject.class);
                if (jsonObject.has("action")) {
                    action = jsonObject.get("action").getAsString();
                }
                if (!jsonObject.has("value") || action == null) break block15;
                JsonElement element = jsonObject.get("value");
                switch (action) {
                    default: {
                        if (element.isJsonPrimitive()) {
                            value = new TextComponent(element.getAsString());
                            break;
                        }
                        if (element.isJsonArray()) {
                            value = AbstractComponent.parse((JsonElement)element.getAsJsonArray());
                            break;
                        }
                        if (element.isJsonObject()) {
                            value = AbstractComponent.GSON.fromJson(element, TextComponent.class);
                            break;
                        }
                        break block16;
                    }
                    case "show_achievement": {
                        value = element.getAsString();
                        break;
                    }
                    case "show_item": {
                        value = AbstractComponent.GSON.fromJson(element, ShowItem.class);
                        break;
                    }
                    case "show_entity": {
                        value = AbstractComponent.GSON.fromJson(element, ShowEntity.class);
                        break;
                    }
                }
                break block16;
            }
            if (jsonObject.has("contents")) {
                JsonElement element = jsonObject.get("contents");
                value = AbstractComponent.GSON.fromJson(element, TextComponent.class);
            }
        }
        return new HoverEvent(action, value);
    }

    public static final class ShowItem {
        private String item;
        private int count;

        public ShowItem() {
        }

        public ShowItem(HoverEvent.ShowItem value) {
            this.item = value.item().value();
            this.count = value.count();
        }

        public String toMiniMessage() {
            return this.item + ":" + this.count;
        }
    }

    public static final class ShowEntity {
        private String type;
        private UUID id;
        private AbstractComponent name;

        public ShowEntity() {
        }

        public ShowEntity(HoverEvent.ShowEntity value) {
            this.type = value.type().value();
            this.id = value.id();
            if (value.name() != null) {
                this.name = AbstractComponent.parse(value.name());
            }
        }

        public String toMiniMessage() {
            return this.type + ":" + String.valueOf(this.id) + ":\"" + this.name.toMiniMessage() + "\"";
        }
    }
}

