/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.api.cache;

import java.util.concurrent.ConcurrentHashMap;

public class SimpleCache<K, V> {
    private final ConcurrentHashMap<K, V> cache = new ConcurrentHashMap();

    public V get(K key, Loader<V> loader) {
        return (V)this.cache.computeIfAbsent(key, k -> {
            Object value = loader.load();
            if (value == null) {
                throw new IllegalStateException("Cache loader returned null for key: " + String.valueOf(key));
            }
            return value;
        });
    }

    @FunctionalInterface
    public static interface Loader<V> {
        public V load();
    }
}

