/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.api.discord;

import fr.maxlego08.essentials.api.discord.DiscordWebhook;
import fr.maxlego08.essentials.api.functionnals.ReturnConsumer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public record DiscordEmbedConfiguration(String title, String description, String url, Color color, Footer footer, Thumbnail thumbnail, Image image, Author author, List<Field> fields) {
    public static List<DiscordEmbedConfiguration> convertToEmbedObjects(List<Map<?, ?>> data) {
        ArrayList<DiscordEmbedConfiguration> embedObjects = new ArrayList<DiscordEmbedConfiguration>();
        for (Map<?, ?> map : data) {
            String title = DiscordEmbedConfiguration.getString(map, "title");
            String description = DiscordEmbedConfiguration.getString(map, "description");
            String url = DiscordEmbedConfiguration.getString(map, "url");
            Color color = DiscordEmbedConfiguration.hexToColor(DiscordEmbedConfiguration.getString(map, "color"));
            Footer footer = null;
            Map<?, ?> footerMap = DiscordEmbedConfiguration.getMap(map, "footer");
            if (footerMap != null) {
                String footerText = DiscordEmbedConfiguration.getString(footerMap, "text");
                String footerIconUrl = DiscordEmbedConfiguration.getString(footerMap, "icon-url");
                footer = new Footer(footerText, footerIconUrl);
            }
            Thumbnail thumbnail = null;
            Map<?, ?> thumbnailMap = DiscordEmbedConfiguration.getMap(map, "thumbnail");
            if (thumbnailMap != null) {
                String thumbnailUrl = DiscordEmbedConfiguration.getString(thumbnailMap, "url");
                thumbnail = new Thumbnail(thumbnailUrl);
            }
            Image image = null;
            Map<?, ?> imageMap = DiscordEmbedConfiguration.getMap(map, "image");
            if (imageMap != null) {
                String imageUrl = DiscordEmbedConfiguration.getString(imageMap, "url");
                image = new Image(imageUrl);
            }
            Author author = null;
            Map<?, ?> authorMap = DiscordEmbedConfiguration.getMap(map, "author");
            if (authorMap != null) {
                String authorName = DiscordEmbedConfiguration.getString(authorMap, "name");
                String authorUrl = DiscordEmbedConfiguration.getString(authorMap, "url");
                String authorIconUrl = DiscordEmbedConfiguration.getString(authorMap, "icon-url");
                author = new Author(authorName, authorUrl, authorIconUrl);
            }
            ArrayList<Field> fields = new ArrayList<Field>();
            List<Map<String, Object>> fieldsList = DiscordEmbedConfiguration.getList(map, "fields");
            if (fieldsList != null) {
                for (Map map2 : fieldsList) {
                    String fieldName = DiscordEmbedConfiguration.getString(map2, "name");
                    String fieldValue = DiscordEmbedConfiguration.getString(map2, "value");
                    Boolean inline = DiscordEmbedConfiguration.getBoolean(map2, "inline");
                    fields.add(new Field(fieldName, fieldValue, inline != null ? inline : false));
                }
            }
            DiscordEmbedConfiguration embedObject = new DiscordEmbedConfiguration(title, description, url, color, footer, thumbnail, image, author, fields);
            embedObjects.add(embedObject);
        }
        return embedObjects;
    }

    private static String getString(Map<?, ?> map, String key) {
        Object value = map.get(key);
        return value instanceof String ? (String)value : null;
    }

    private static Map<?, ?> getMap(Map<?, ?> map, String key) {
        Object value = map.get(key);
        return value instanceof Map ? (Map)value : null;
    }

    private static List<Map<String, Object>> getList(Map<?, ?> map, String key) {
        Object value = map.get(key);
        return value instanceof List ? (List)value : null;
    }

    private static Boolean getBoolean(Map<?, ?> map, String key) {
        Object value = map.get(key);
        return value instanceof Boolean ? (Boolean)value : null;
    }

    private static Color hexToColor(String hex) {
        if (hex == null) {
            return null;
        }
        if (hex.startsWith("#")) {
            hex = hex.substring(1);
        }
        if (hex.length() != 6 && hex.length() != 8) {
            throw new IllegalArgumentException("Invalid hex color string");
        }
        int r = Integer.parseInt(hex.substring(0, 2), 16);
        int g = Integer.parseInt(hex.substring(2, 4), 16);
        int b = Integer.parseInt(hex.substring(4, 6), 16);
        int a = 255;
        if (hex.length() == 8) {
            a = Integer.parseInt(hex.substring(6, 8), 16);
        }
        return new Color(r, g, b, a);
    }

    public void apply(ReturnConsumer<String, String> consumer, DiscordWebhook discordWebhook, String ... args) {
        DiscordWebhook.EmbedObject embedObject = new DiscordWebhook.EmbedObject();
        if (this.author != null) {
            embedObject.setAuthor(this.replace(consumer.accept(this.author.name()), args), this.replace(consumer.accept(this.author.url()), args), this.replace(consumer.accept(this.author.iconUrl()), args));
        }
        if (this.description != null) {
            embedObject.setDescription(this.replace(consumer.accept(this.description), args));
        }
        if (this.color != null) {
            embedObject.setColor(this.color);
        }
        if (this.title != null) {
            embedObject.setTitle(this.replace(consumer.accept(this.title), args));
        }
        if (this.thumbnail != null) {
            embedObject.setThumbnail(this.replace(consumer.accept(this.thumbnail.url()), args));
        }
        if (this.image != null) {
            embedObject.setImage(this.replace(consumer.accept(this.image.url()), args));
        }
        if (this.footer != null) {
            embedObject.setFooter(this.replace(consumer.accept(this.footer.text()), args), this.replace(consumer.accept(this.footer.iconUrl()), args));
        }
        if (!this.fields.isEmpty()) {
            for (Field field : this.fields) {
                embedObject.addField(this.replace(consumer.accept(field.name()), args), this.replace(consumer.accept(field.value()), args), field.inline());
            }
        }
        discordWebhook.addEmbed(embedObject);
    }

    private String replace(String message, Object[] newArgs) {
        if (message == null) {
            return null;
        }
        if (newArgs.length % 2 != 0) {
            throw new IllegalArgumentException("Number of invalid arguments. Arguments must be in pairs.");
        }
        for (int i = 0; i < newArgs.length; i += 2) {
            if (newArgs[i] == null || newArgs[i + 1] == null) {
                throw new IllegalArgumentException("Keys and replacement values must not be null.");
            }
            message = message.replace(newArgs[i].toString(), newArgs[i + 1].toString());
        }
        return message;
    }

    public record Footer(String text, String iconUrl) {
    }

    public record Thumbnail(String url) {
    }

    public record Image(String url) {
    }

    public record Author(String name, String url, String iconUrl) {
    }

    public record Field(String name, String value, boolean inline) {
    }
}

