/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.api.steps;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class PlayerStep {
    private final Map<String, Integer> statistics;
    private final Map<String, Map<String, Integer>> blocksStatistics;
    private final Map<String, Map<String, Integer>> itemsStatistics;
    private final Map<String, Map<String, Integer>> entitiesStatistics;
    private final Map<String, Object> additionalDatas;

    public PlayerStep(Player player, Map<String, Object> additionalData) {
        this.additionalDatas = additionalData;
        this.statistics = new HashMap<String, Integer>();
        this.blocksStatistics = new HashMap<String, Map<String, Integer>>();
        this.itemsStatistics = new HashMap<String, Map<String, Integer>>();
        this.entitiesStatistics = new HashMap<String, Map<String, Integer>>();
        for (Statistic statistic : Statistic.values()) {
            if (statistic.getType() != Statistic.Type.UNTYPED) continue;
            int value = player.getStatistic(statistic);
            this.statistics.put(statistic.name(), value);
        }
        for (Statistic statistic : Material.values()) {
            int mined;
            if (!statistic.isBlock() || (mined = player.getStatistic(Statistic.MINE_BLOCK, (Material)statistic)) <= 0) continue;
            this.blocksStatistics.computeIfAbsent("MINE_BLOCK", k -> new HashMap()).put(statistic.name(), mined);
        }
        for (Statistic statistic : Material.values()) {
            if (!statistic.isItem()) continue;
            int used = player.getStatistic(Statistic.USE_ITEM, (Material)statistic);
            int crafted = player.getStatistic(Statistic.CRAFT_ITEM, (Material)statistic);
            int broken = player.getStatistic(Statistic.BREAK_ITEM, (Material)statistic);
            if (used > 0) {
                this.itemsStatistics.computeIfAbsent("USE_ITEM", k -> new HashMap()).put(statistic.name(), used);
            }
            if (crafted > 0) {
                this.itemsStatistics.computeIfAbsent("CRAFT_ITEM", k -> new HashMap()).put(statistic.name(), crafted);
            }
            if (broken <= 0) continue;
            this.itemsStatistics.computeIfAbsent("BREAK_ITEM", k -> new HashMap()).put(statistic.name(), broken);
        }
        for (Statistic statistic : EntityType.values()) {
            if (!statistic.isAlive()) continue;
            int killed = player.getStatistic(Statistic.KILL_ENTITY, (EntityType)statistic);
            int killedBy = player.getStatistic(Statistic.ENTITY_KILLED_BY, (EntityType)statistic);
            if (killed > 0) {
                this.entitiesStatistics.computeIfAbsent("KILL_ENTITY", k -> new HashMap()).put(statistic.name(), killed);
            }
            if (killedBy <= 0) continue;
            this.entitiesStatistics.computeIfAbsent("ENTITY_KILLED_BY", k -> new HashMap()).put(statistic.name(), killedBy);
        }
    }

    public Map<String, Integer> getStatistics() {
        return this.statistics;
    }

    public Map<String, Map<String, Integer>> getBlocksStatistics() {
        return this.blocksStatistics;
    }

    public Map<String, Map<String, Integer>> getItemsStatistics() {
        return this.itemsStatistics;
    }

    public Map<String, Map<String, Integer>> getEntitiesStatistics() {
        return this.entitiesStatistics;
    }

    public Map<String, Object> getAdditionalDatas() {
        return this.additionalDatas;
    }
}

