/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.commands.commands.spawn;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.CommandResultType;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.module.modules.SpawnModule;
import fr.maxlego08.essentials.storage.ConfigStorage;
import fr.maxlego08.essentials.zutils.utils.commands.VCommand;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class CommandSpawn
extends VCommand {
    public CommandSpawn(EssentialsPlugin plugin) {
        super(plugin);
        this.setModule(SpawnModule.class);
        this.setPermission(Permission.ESSENTIALS_SPAWN);
        this.setDescription(Message.DESCRIPTION_SPAWN);
        this.addOptionalArg("player");
    }

    @Override
    protected CommandResultType perform(EssentialsPlugin plugin) {
        boolean teleportingSelf;
        User user;
        Player player = this.argAsPlayer(0, this.player);
        if (player == null) {
            return CommandResultType.SYNTAX_ERROR;
        }
        if (this.player != null && !this.hasPermission((Permissible)this.player, Permission.ESSENTIALS_SPAWN_OTHER)) {
            player = this.player;
        }
        if ((user = this.plugin.getUser(player.getUniqueId())) == null) {
            return CommandResultType.SYNTAX_ERROR;
        }
        if (ConfigStorage.spawnLocation == null || !ConfigStorage.spawnLocation.isValid()) {
            this.message(this.sender, Message.COMMAND_SPAWN_NOT_DEFINE, new Object[0]);
            return CommandResultType.DEFAULT;
        }
        Location location = ConfigStorage.spawnLocation.getLocation();
        if (location == null) {
            this.message(this.sender, Message.COMMAND_SPAWN_NOT_DEFINE, new Object[0]);
            return CommandResultType.DEFAULT;
        }
        boolean bl = teleportingSelf = this.user != null && user == this.user;
        if (teleportingSelf) {
            user.teleport(location, Message.TELEPORT_MESSAGE_SPAWN, Message.TELEPORT_SUCCESS_SPAWN, new Object[0]);
        } else {
            user.teleportNow(location);
            this.message(user, Message.TELEPORT_SUCCESS_SPAWN, new Object[0]);
        }
        if (this.user == null || user != this.user) {
            this.message(this.sender, Message.TELEPORT_MESSAGE_SPAWN_CONSOLE, player);
        }
        return CommandResultType.SUCCESS;
    }
}

