/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.commands.commands.utils;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.CommandResultType;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.utils.TransformMaterial;
import fr.maxlego08.essentials.zutils.utils.commands.VCommand;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class CommandFurnace
extends VCommand {
    public CommandFurnace(EssentialsPlugin plugin) {
        super(plugin);
        this.setPermission(Permission.ESSENTIALS_FURNACE);
        this.setDescription(Message.DESCRIPTION_FURNACE);
        this.onlyPlayers();
    }

    @Override
    protected CommandResultType perform(EssentialsPlugin plugin) {
        ItemStack itemStack = this.player.getInventory().getItemInMainHand();
        Material material = itemStack.getType();
        Optional<TransformMaterial> optional = this.configuration.getSmeltableMaterials().stream().filter(e -> e.from().equals((Object)material)).findFirst();
        if (optional.isEmpty()) {
            this.message(this.sender, Message.COMMAND_FURNACE_TYPE, "%material%", this.name(material.name()));
            return CommandResultType.DEFAULT;
        }
        TransformMaterial compactMaterial = optional.get();
        Material newMaterial = compactMaterial.to();
        PlayerInventory inventory = this.player.getInventory();
        int realAmount = this.count((Inventory)inventory, material);
        if (realAmount < 0) {
            this.message((CommandSender)this.getPlayer(), Message.COMMAND_FURNACE_ERROR, "%item%", this.name(material.name()));
            return CommandResultType.DEFAULT;
        }
        this.removeItems((Inventory)inventory, new ItemStack(material), realAmount);
        this.plugin.give(this.player, new ItemStack(newMaterial, realAmount));
        this.message((CommandSender)this.player, Message.COMMAND_FURNACE_SUCCESS, "%amount%", realAmount, "%item%", this.name(material.name()), "%toAmount%", realAmount, "%toItem%", this.name(newMaterial.name()));
        return CommandResultType.SUCCESS;
    }
}

