/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.commands.commands.weather;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.CommandResultType;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.zutils.utils.commands.VCommand;
import java.util.Arrays;
import org.bukkit.command.CommandSender;

public class CommandPlayerTime
extends VCommand {
    public CommandPlayerTime(EssentialsPlugin plugin) {
        super(plugin);
        this.setPermission(Permission.ESSENTIALS_PLAYER_TIME);
        this.setDescription(Message.DESCRIPTION_PLAYER_TIME);
        this.addOptionalArg("time", (a, b) -> Arrays.asList("0", "500", "1000", "1500", "2000"));
        this.onlyPlayers();
    }

    @Override
    protected CommandResultType perform(EssentialsPlugin plugin) {
        long ticks = this.argAsLong(0, 0L);
        if (ticks == 0L) {
            this.player.resetPlayerTime();
            this.message((CommandSender)this.player, Message.COMMAND_PLAYER_TIME_RESET, new Object[0]);
        } else {
            long time = this.player.getPlayerTime();
            time -= time % 24000L;
            this.player.setPlayerTime(time += 24000L + ticks, true);
            this.message((CommandSender)this.player, Message.COMMAND_PLAYER_TIME_CHANGE, new Object[0]);
        }
        return CommandResultType.SUCCESS;
    }
}

