/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.convert.cmi;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.convert.Convert;
import fr.maxlego08.essentials.api.economy.Economy;
import fr.maxlego08.essentials.api.home.Home;
import fr.maxlego08.essentials.api.storage.IStorage;
import fr.maxlego08.essentials.api.utils.SafeLocation;
import fr.maxlego08.essentials.convert.cmi.CMIUser;
import fr.maxlego08.essentials.libs.sarah.DatabaseConfiguration;
import fr.maxlego08.essentials.libs.sarah.RequestHelper;
import fr.maxlego08.essentials.libs.sarah.SqliteConnection;
import fr.maxlego08.essentials.storage.database.repositeries.UserEconomyRepository;
import fr.maxlego08.essentials.storage.database.repositeries.UserHomeRepository;
import fr.maxlego08.essentials.storage.database.repositeries.UserRepository;
import fr.maxlego08.essentials.storage.storages.SqlStorage;
import fr.maxlego08.essentials.user.ZHome;
import fr.maxlego08.essentials.zutils.utils.ZUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;

public class CMIConvert
extends ZUtils
implements Convert {
    private final EssentialsPlugin plugin;

    public CMIConvert(EssentialsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void convert(CommandSender sender) {
        this.message(sender, "&fStart convert &7CMI");
        File file = new File(this.plugin.getDataFolder(), "cmi.sqlite.db");
        if (!file.exists()) {
            this.message(sender, "&cUnable to find &bcmi.sqlite.db &cfile in &fplugins/zEssentials&c.");
            return;
        }
        IStorage iStorage = this.plugin.getStorageManager().getStorage();
        if (iStorage instanceof SqlStorage) {
            SqlStorage sqlStorage = (SqlStorage)iStorage;
            this.plugin.getScheduler().runAsync(wrappedTask -> this.startConvertDatabase(sender, sqlStorage));
        } else {
            this.message(sender, "&cYou must have the storage in a database to be able to convert. Never use the storage in JSON !");
        }
    }

    private void startConvertDatabase(CommandSender sender, SqlStorage sqlStorage) {
        SqliteConnection databaseConnection = new SqliteConnection(DatabaseConfiguration.sqlite(sqlStorage.getConnection().getDatabaseConfiguration().isDebug()), this.plugin.getDataFolder());
        databaseConnection.setFileName("cmi.sqlite.db");
        if (!databaseConnection.isValid()) {
            this.message(sender, "&cUnable to connect to database.");
        }
        RequestHelper requestHelper = new RequestHelper(databaseConnection, message -> this.plugin.getLogger().info(message));
        List<CMIUser> cmiUsers = requestHelper.select("users", CMIUser.class, table -> {});
        this.message(sender, "&aFound &f" + cmiUsers.size() + " &ausers.");
        UserRepository userRepository = sqlStorage.with(UserRepository.class);
        UserEconomyRepository userEconomyRepository = sqlStorage.with(UserEconomyRepository.class);
        UserHomeRepository userHomeRepository = sqlStorage.with(UserHomeRepository.class);
        cmiUsers.forEach(cmiUser -> {
            String homes;
            if (cmiUser.username() == null || cmiUser.player_uuid() == null) {
                return;
            }
            userRepository.upsert((CMIUser)cmiUser);
            if (this.plugin.getEconomyManager().isEnable() && cmiUser.Balance() != null) {
                Economy defaultEconomy = this.plugin.getEconomyManager().getDefaultEconomy();
                userEconomyRepository.upsert(cmiUser.player_uuid(), defaultEconomy, cmiUser.Balance());
            }
            if ((homes = cmiUser.Homes()) != null) {
                this.storeHomes(userHomeRepository, (CMIUser)cmiUser);
            }
        });
        this.message(sender, "&aYou have just converted your CMI data to zEssentials !");
    }

    private void storeHomes(UserHomeRepository userHomeRepository, CMIUser cmiUser) {
        try {
            List<Home> homes = this.parseHomes(cmiUser.Homes());
            homes.forEach(home -> userHomeRepository.upsert(cmiUser.player_uuid(), (Home)home));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private List<Home> parseHomes(String data) {
        String[] homeEntries;
        ArrayList<Home> homes = new ArrayList<Home>();
        for (String entry : homeEntries = data.split(";")) {
            try {
                String[] parts = entry.split("[$]|%%|:");
                String name = parts[0];
                int index = parts.length == 10 ? 4 : (parts.length == 9 ? 3 : 2);
                Material material = null;
                if (parts.length == 9) {
                    try {
                        material = Material.valueOf((String)parts[2].replace("-", ""));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                String world = parts[index];
                double x = Double.parseDouble(parts[index + 1]);
                double y = Double.parseDouble(parts[index + 2]);
                double z = Double.parseDouble(parts[index + 3]);
                double yaw = Double.parseDouble(parts[index + 4]);
                double pitch = Double.parseDouble(parts[index + 5]);
                homes.add(new ZHome(new SafeLocation(world, x, y, z, (float)pitch, (float)yaw), name, material));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.plugin.getLogger().severe("Unable to convert the home " + entry);
            }
        }
        return homes;
    }
}

