/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.module.modules;

import fr.maxlego08.essentials.ZEssentialsPlugin;
import fr.maxlego08.essentials.api.configuration.NonLoadable;
import fr.maxlego08.essentials.api.dto.UserVoteDTO;
import fr.maxlego08.essentials.api.event.events.user.UserVoteEvent;
import fr.maxlego08.essentials.api.event.events.vote.VotePartyEvent;
import fr.maxlego08.essentials.api.event.events.vote.VotePartyStartEvent;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.storage.IStorage;
import fr.maxlego08.essentials.api.storage.Key;
import fr.maxlego08.essentials.api.storage.StorageKey;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.api.vote.VoteCache;
import fr.maxlego08.essentials.api.vote.VoteManager;
import fr.maxlego08.essentials.api.vote.VotePartyReward;
import fr.maxlego08.essentials.api.vote.VoteResetConfiguration;
import fr.maxlego08.essentials.api.vote.VoteReward;
import fr.maxlego08.essentials.api.vote.VoteSiteConfiguration;
import fr.maxlego08.essentials.libs.folialib.impl.PlatformScheduler;
import fr.maxlego08.essentials.libs.folialib.wrapper.task.WrappedTask;
import fr.maxlego08.essentials.module.ZModule;
import fr.maxlego08.menu.api.ButtonManager;
import fr.maxlego08.menu.api.engine.InventoryEngine;
import fr.maxlego08.menu.api.utils.Placeholders;
import fr.maxlego08.menu.api.utils.TypedMapAccessor;
import java.io.File;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;

public class VoteModule
extends ZModule
implements VoteManager {
    @NonLoadable
    private final Key votePartyKey;
    @NonLoadable
    private final VoteCache voteCache = new VoteCache();
    @NonLoadable
    private long newVotePartyAmount;
    @NonLoadable
    private long newVotePartyUpdate;
    @NonLoadable
    private WrappedTask newVotePartyTask;
    @NonLoadable
    private long currentVoteAmount;
    private boolean enableVoteParty;
    private boolean enableVotePartyOpenVoteInventory;
    private boolean enableOfflineVoteMessage;
    private long votePartyObjective;
    @NonLoadable
    private VotePartyReward votePartyRewards;
    @NonLoadable
    private List<VoteReward> rewardsOnVote = new ArrayList<VoteReward>();
    private List<VoteSiteConfiguration> sites;
    private String placeholderAvailable;
    private String placeholderCooldown;
    private VoteResetConfiguration resetConfiguration;

    public VoteModule(ZEssentialsPlugin plugin) {
        super(plugin, "vote");
        this.votePartyKey = new StorageKey(plugin, "vote-party-amount");
    }

    @Override
    public void loadConfiguration() {
        super.loadConfiguration();
        this.currentVoteAmount = this.plugin.getServerStorage().getLong(this.votePartyKey);
        this.loadInventory("vote");
        ButtonManager buttonManager = this.plugin.getButtonManager();
        YamlConfiguration configuration = this.getConfiguration();
        File file = new File(this.getFolder(), "config.yml");
        List actions = buttonManager.loadActions(configuration.getList("vote-party-rewards.actions"), "vote-party-rewards.actions", file);
        List permissionActions = buttonManager.loadActions(configuration.getList("vote-party-rewards.permission-actions"), "vote-party-rewards.permission-actions", file);
        String permission = configuration.getString("vote-party-rewards.permission");
        List globalCommands = configuration.getStringList("vote-party-rewards.global-commands");
        this.votePartyRewards = new VotePartyReward(actions, permission, permissionActions, globalCommands);
        this.rewardsOnVote.clear();
        for (Map map : configuration.getMapList("rewards-on-vote")) {
            TypedMapAccessor typedMapAccessor = new TypedMapAccessor(map);
            int min = typedMapAccessor.getInt("min");
            int max = typedMapAccessor.getInt("max", Integer.MAX_VALUE);
            List rewardActions = typedMapAccessor.getStringList("commands");
            this.rewardsOnVote.add(new VoteReward(min, max, rewardActions));
        }
    }

    @Override
    public long getCurrentVotePartyAmount() {
        return this.currentVoteAmount;
    }

    @Override
    public void setCurrentVotePartyAmount(long amount) {
        this.currentVoteAmount = amount;
        this.plugin.getServerStorage().set(this.votePartyKey, this.currentVoteAmount);
    }

    @Override
    public void addCurrentVotePartyAmount(long amount) {
        this.setCurrentVotePartyAmount(this.currentVoteAmount + amount);
    }

    @Override
    public void removeCurrentVotePartyAmount(long amount) {
        this.setCurrentVotePartyAmount(this.currentVoteAmount - amount);
    }

    @Override
    public void onPlayerVote(UUID uniqueId, String site) {
        this.plugin.getScheduler().runNextTick(wrappedTask -> {
            UserVoteEvent event = new UserVoteEvent(uniqueId, site);
            event.callEvent();
            if (event.isCancelled()) {
                return;
            }
            boolean isOnline = Bukkit.getPlayer((UUID)uniqueId) != null;
            this.voteCache.addVote(uniqueId, isOnline);
            if (!this.voteCache.hasTask(uniqueId)) {
                this.scheduleDatabaseUpdateForPlayer(uniqueId);
            }
            IStorage storage = this.plugin.getStorageManager().getStorage();
            User user = this.plugin.getUser(uniqueId);
            if (user != null) {
                user.setVoteSite(site);
            } else {
                storage.setLastVote(uniqueId, site);
            }
            ++this.newVotePartyAmount;
            if (this.newVotePartyTask == null) {
                this.scheduleVotePartyTask();
            }
        });
    }

    private void scheduleVotePartyTask() {
        this.newVotePartyTask = this.plugin.getScheduler().runLater(() -> {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.newVotePartyUpdate >= 500L) {
                this.handleVoteParty(this.newVotePartyAmount);
                this.newVotePartyAmount = 0L;
                this.newVotePartyUpdate = 0L;
                this.newVotePartyTask = null;
            } else {
                this.scheduleVotePartyTask();
            }
        }, 5L);
    }

    private void scheduleDatabaseUpdateForPlayer(UUID uniqueId) {
        WrappedTask task = this.plugin.getScheduler().runLaterAsync(() -> {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.voteCache.getLastUpdateTimestamp(uniqueId) >= 500L) {
                this.updateDatabaseFromCacheForPlayer(uniqueId);
            } else {
                this.scheduleDatabaseUpdateForPlayer(uniqueId);
            }
        }, 5L);
        this.voteCache.addTask(uniqueId, task);
    }

    private void updateDatabaseFromCacheForPlayer(UUID uniqueId) {
        IStorage storage = this.plugin.getStorageManager().getStorage();
        UserVoteDTO voteDTO = this.voteCache.clearVote(uniqueId);
        if (voteDTO != null) {
            this.plugin.getScheduler().runAsync(wrappedTask -> {
                UserVoteDTO dto = storage.getVote(uniqueId);
                long vote = voteDTO.vote() + dto.vote();
                User user = this.plugin.getUser(uniqueId);
                if (user != null) {
                    user.setVote(vote);
                } else {
                    storage.setVote(uniqueId, vote, this.enableOfflineVoteMessage ? voteDTO.vote_offline() + dto.vote_offline() : 0L);
                }
            });
        }
    }

    @Override
    public void addPlayerVote(OfflinePlayer offlinePlayer, String site) {
        if (offlinePlayer == null || offlinePlayer.getName() == null) {
            return;
        }
        this.onPlayerVote(offlinePlayer.getUniqueId(), site);
        PlatformScheduler scheduler = this.plugin.getScheduler();
        scheduler.runAsync(wrappedTask -> {
            long totalVote = this.plugin.getStorageManager().getStorage().getVote(offlinePlayer.getUniqueId()).vote() + 1L;
            List actions = this.rewardsOnVote.stream().filter(e -> totalVote >= (long)e.min() && totalVote <= (long)e.max()).map(VoteReward::actions).flatMap(Collection::stream).toList();
            scheduler.runNextTick(w2 -> actions.forEach(command -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replace("%player%", offlinePlayer.getName()))));
        });
        this.message(offlinePlayer.getUniqueId(), Message.COMMAND_VOTE, new Object[0]);
    }

    @Override
    public void handleVoteParty(long amount) {
        long newAmount = this.getCurrentVotePartyAmount() + amount;
        VotePartyEvent event = new VotePartyEvent(newAmount);
        event.callEvent();
        if (event.isCancelled()) {
            return;
        }
        this.setCurrentVotePartyAmount(event.getVotePartyAmount());
        if (this.getCurrentVotePartyAmount() >= this.votePartyObjective) {
            VotePartyStartEvent startEvent = new VotePartyStartEvent();
            startEvent.callEvent();
            if (event.isCancelled()) {
                return;
            }
            this.setCurrentVotePartyAmount(0L);
            this.giveVotePartyRewards();
        }
    }

    private void giveVotePartyRewards() {
        this.votePartyRewards.globalCommands().forEach(command -> {
            if (command.isEmpty()) {
                return;
            }
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
        });
        InventoryEngine inventoryDefault = this.plugin.getInventoryManager().getFakeInventory();
        Bukkit.getOnlinePlayers().forEach(player -> {
            this.votePartyRewards.actions().forEach(action -> action.preExecute(player, null, inventoryDefault, new Placeholders()));
            if (player.hasPermission(this.votePartyRewards.permissions())) {
                this.votePartyRewards.permissionActions().forEach(action -> action.preExecute(player, null, inventoryDefault, new Placeholders()));
            }
        });
    }

    @Override
    public long getVotePartyObjective() {
        return this.votePartyObjective;
    }

    @Override
    public void openVoteInventory(Player player) {
        this.plugin.openInventory(player, "vote");
    }

    @Override
    public void sendVoteParty(Player player) {
        if (this.enableVotePartyOpenVoteInventory) {
            this.openVoteInventory(player);
        } else {
            this.message((CommandSender)player, Message.COMMAND_VOTEPARTY_INFORMATIONS, "%amount%", this.currentVoteAmount, "%objective%", this.votePartyObjective);
        }
    }

    @Override
    public boolean siteExist(String site) {
        return this.sites.stream().anyMatch(e -> e.name().equals(site));
    }

    @Override
    public List<VoteSiteConfiguration> getSites() {
        return this.sites;
    }

    @Override
    public long getSiteCooldown(String site) {
        return this.sites.stream().filter(voteSiteConfiguration -> voteSiteConfiguration.name().equalsIgnoreCase(site)).mapToLong(VoteSiteConfiguration::seconds).sum();
    }

    @EventHandler
    public void onConnect(PlayerJoinEvent event) {
        if (!this.enableOfflineVoteMessage) {
            return;
        }
        User user = this.getUser((Entity)event.getPlayer());
        if (user == null || user.getOfflineVotes() == 0L) {
            return;
        }
        this.message((CommandSender)event.getPlayer(), Message.VOTE_OFFLINE, "%amount%", user.getOfflineVotes());
        user.resetOfflineVote();
    }

    @Override
    public String getPlaceholderCooldown() {
        return this.placeholderCooldown;
    }

    @Override
    public String getPlaceholderAvailable() {
        return this.placeholderAvailable;
    }

    @Override
    public void startResetTask() {
        LocalDateTime nextRun;
        if (!this.isEnable()) {
            return;
        }
        LocalDateTime now = LocalDateTime.now();
        if (!now.isBefore(nextRun = now.withDayOfMonth(this.range(this.resetConfiguration.day(), 1, 31)).withHour(this.range(this.resetConfiguration.hour(), 0, 23)).withMinute(this.range(this.resetConfiguration.minute(), 0, 59)).withSecond(this.range(this.resetConfiguration.second(), 0, 59)))) {
            nextRun = nextRun.plusMonths(1L);
        }
        long initialDelay = ChronoUnit.MILLIS.between(now, nextRun);
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        scheduler.scheduleAtFixedRate(this::resetVotes, initialDelay, TimeUnit.DAYS.toMillis(30L), TimeUnit.MILLISECONDS);
    }

    @Override
    public void resetVotes() {
        this.plugin.getStorageManager().getStorage().resetVotes();
    }

    private int range(int value, int min, int max) {
        return value < min ? min : Math.min(value, max);
    }
}

