/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.module.modules.afk;

import fr.maxlego08.essentials.ZEssentialsPlugin;
import fr.maxlego08.essentials.api.afk.AfkManager;
import fr.maxlego08.essentials.api.afk.AfkPermission;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.configuration.NonLoadable;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.api.utils.component.ComponentMessage;
import fr.maxlego08.essentials.libs.folialib.wrapper.task.WrappedTask;
import fr.maxlego08.essentials.module.ZModule;
import fr.maxlego08.essentials.zutils.utils.TimerBuilder;
import fr.maxlego08.menu.api.engine.InventoryEngine;
import fr.maxlego08.menu.api.requirement.Action;
import fr.maxlego08.menu.api.utils.Placeholders;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.permissions.Permissible;

public class AFKModule
extends ZModule
implements AfkManager {
    private WrappedTask wrappedTask;
    @NonLoadable
    private List<Action> actions = new ArrayList<Action>();
    private int checkInterval;
    private List<AfkPermission> permissions;
    private boolean softKick;
    private String softKickMessage;
    private String placeholderAfk;
    private String placeholderNotAfk;

    public AFKModule(ZEssentialsPlugin plugin) {
        super(plugin, "afk");
    }

    @Override
    public void loadConfiguration() {
        super.loadConfiguration();
        YamlConfiguration configuration = this.getConfiguration();
        List elements = configuration.getList("kick-actions", new ArrayList());
        this.actions = this.plugin.getButtonManager().loadActions(elements, "kick-actions", this.getConfigurationFile());
        if (this.wrappedTask != null) {
            this.wrappedTask.cancel();
        }
        if (this.checkInterval > 0) {
            this.wrappedTask = this.plugin.getScheduler().runTimer(this::checkPlayers, (long)this.checkInterval, (long)this.checkInterval);
        }
    }

    private void checkPlayers() {
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            User user;
            if (this.hasPermission((Permissible)onlinePlayer, Permission.ESSENTIALS_AFK_BYPASS) || (user = this.getUser((Entity)onlinePlayer)) == null) continue;
            this.checkUser(user);
        }
    }

    @Override
    public void checkUser(User user) {
        Optional<AfkPermission> optional = this.getPermission((Permissible)user.getPlayer());
        if (optional.isEmpty()) {
            return;
        }
        AfkPermission permission = optional.get();
        long difference = (System.currentTimeMillis() - user.getLastActiveTime()) / 1000L;
        ComponentMessage component = this.plugin.getComponentMessage();
        Player player = user.getPlayer();
        if (difference >= (long)permission.maxAfkTime()) {
            InventoryEngine fakeInventory = this.plugin.getInventoryManager().getFakeInventory();
            for (Action action : this.actions) {
                action.preExecute(player, null, fakeInventory, new Placeholders());
            }
            if (this.softKick) {
                component.kick(player, this.papi(this.softKickMessage, player));
            }
        } else if (difference == (long)permission.startAfkTime() && permission.messageOnStartAfk() != null) {
            component.sendMessage((CommandSender)player, this.papi(permission.messageOnStartAfk(), player));
        }
    }

    @Override
    public Optional<AfkPermission> getPermission(Permissible permissible) {
        return this.permissions.stream().filter(permission -> permissible.hasPermission(permission.permission())).max(Comparator.comparingInt(AfkPermission::priority));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onMove(PlayerMoveEvent event) {
        User user = this.getUser((Entity)event.getPlayer());
        if (user == null) {
            return;
        }
        Location from = event.getFrom();
        Location to = event.getTo();
        if (from.getYaw() != to.getYaw() || from.getPitch() != to.getPitch()) {
            this.endAfk(user);
            user.setLastActiveTime();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onCommand(PlayerCommandPreprocessEvent event) {
        User user = this.getUser((Entity)event.getPlayer());
        if (user == null) {
            return;
        }
        String message = event.getMessage().toLowerCase(Locale.ENGLISH);
        if (message.startsWith("/")) {
            message = message.substring(1);
        }
        if (message.equals("afk") || message.startsWith("afk ")) {
            return;
        }
        this.endAfk(user);
        user.setLastActiveTime();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onTalk(AsyncPlayerChatEvent event) {
        User user = this.getUser((Entity)event.getPlayer());
        if (user == null) {
            return;
        }
        this.endAfk(user);
        user.setLastActiveTime();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInventoryClick(InventoryClickEvent event) {
        User user = this.getUser((Entity)event.getWhoClicked());
        if (user == null) {
            return;
        }
        this.endAfk(user);
        user.setLastActiveTime();
    }

    private void endAfk(User user) {
        if (!user.isAfk()) {
            return;
        }
        if (user.isManualAfk()) {
            user.setAfk(false);
        }
        long lastActiveTime = user.getLastActiveTime();
        Optional<AfkPermission> optional = this.getPermission((Permissible)user.getPlayer());
        if (optional.isEmpty()) {
            return;
        }
        AfkPermission permission = optional.get();
        if (permission.messageOnEndAfk() != null) {
            ComponentMessage component = this.plugin.getComponentMessage();
            Placeholders placeholders = new Placeholders();
            placeholders.register("duration", TimerBuilder.getStringTime(System.currentTimeMillis() - lastActiveTime));
            component.sendMessage((CommandSender)user.getPlayer(), this.papi(placeholders.parse(permission.messageOnEndAfk()), user.getPlayer()));
        }
    }

    @Override
    public String getPlaceholderAfk() {
        return this.placeholderAfk == null ? "&aV" : this.placeholderAfk;
    }

    @Override
    public String getPlaceholderNotAfk() {
        return this.placeholderNotAfk == null ? "&cX" : this.placeholderNotAfk;
    }
}

