/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.module.modules.chat;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.chat.ChatDisplay;
import fr.maxlego08.essentials.api.chat.ChatDisplayException;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.utils.component.AdventureComponent;
import fr.maxlego08.essentials.module.modules.chat.ChatModule;
import fr.maxlego08.essentials.zutils.utils.ZUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.translation.Translatable;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;

public class ItemDisplay
extends ZUtils
implements ChatDisplay {
    private static final String DEFAULT_ITEM_NAME_REGEX = "^[a-zA-Z0-9_.?!^\u00a8%\u00f9*&\u00e9\"#'{(\\[-|\u00e8\u00ea\u00eb`\\\\\u00e7\u00e0)\\]=}\u00fb\u00ee+<>:\u00b2\u20ac$/\\-,-\u00e2@;\u00f4 ]+$";
    private final EssentialsPlugin plugin;
    private final Pattern pattern;
    private final Pattern itemNamePattern;
    private final String result;
    private final String permission;

    public ItemDisplay(EssentialsPlugin plugin, String regex, String result, String permission, String itemNameRegex) {
        this.plugin = plugin;
        this.pattern = Pattern.compile(regex);
        this.itemNamePattern = Pattern.compile(itemNameRegex != null && !itemNameRegex.isEmpty() ? itemNameRegex : DEFAULT_ITEM_NAME_REGEX);
        this.result = result;
        this.permission = permission;
    }

    @Override
    public String display(AdventureComponent adventureComponent, TagResolver.Builder builder, Player sender, Player receiver, String message) {
        String plainName;
        ItemStack itemStack = sender.getInventory().getItemInMainHand();
        if (itemStack.isEmpty()) {
            return message;
        }
        TranslatableComponent itemName = Component.translatable((Translatable)itemStack);
        int amount = itemStack.getAmount();
        if (itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName()) {
            itemName = itemStack.getItemMeta().displayName();
        }
        if (!(plainName = PlainTextComponentSerializer.plainText().serialize((Component)itemName)).isEmpty() && !this.itemNamePattern.matcher(plainName).matches()) {
            throw new ChatDisplayException(Message.CHAT_ITEM_FORBIDDEN_CHARACTERS, new Object[0]);
        }
        Matcher matcher = this.pattern.matcher(message);
        StringBuilder formattedMessage = new StringBuilder();
        String name = "item";
        while (matcher.find()) {
            matcher.appendReplacement(formattedMessage, "<" + name + ">");
        }
        Component component = adventureComponent.getComponent(this.result, TagResolver.builder().resolver((TagResolver)Placeholder.component((String)"item", (ComponentLike)itemName)).resolver((TagResolver)Placeholder.component((String)"amount", (ComponentLike)Component.text((int)amount))).build());
        component = component.hoverEvent((HoverEventSource)itemStack.asHoverEvent());
        String code = this.plugin.getModuleManager().getModule(ChatModule.class).createHoverItemStack(sender, itemStack);
        component = component.clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)("/showitem " + code)));
        builder.resolver((TagResolver)Placeholder.component((String)name, (ComponentLike)component));
        matcher.appendTail(formattedMessage);
        return formattedMessage.toString();
    }

    @Override
    public boolean hasPermission(Permissible permissible) {
        return permissible.hasPermission(this.permission);
    }
}

