/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.module.modules.scoreboard.board;

import fr.maxlego08.essentials.api.scoreboard.EssentialsScoreboard;
import fr.maxlego08.essentials.api.scoreboard.PlayerBoard;
import fr.maxlego08.essentials.libs.fastboard.adventure.FastBoard;
import fr.maxlego08.essentials.zutils.utils.paper.PaperComponent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;

public class ComponentBoard
extends FastBoard
implements PlayerBoard {
    private final EssentialsScoreboard essentialsScoreboard;
    private final PaperComponent paperComponent = new PaperComponent();
    private final Map<Integer, Integer> linesModifier = new HashMap<Integer, Integer>();

    public ComponentBoard(Player player, EssentialsScoreboard essentialsScoreboard) {
        super(player);
        this.essentialsScoreboard = essentialsScoreboard;
    }

    @Override
    public void updateTitle(String title) {
        this.updateTitle(this.color(title));
    }

    @Override
    public void updateLine(int line, String text) {
        this.updateLine(line, this.color(text));
    }

    @Override
    public void updateLines(String ... lines) {
        this.updateLines(Arrays.stream(lines).map(this::color).toList());
    }

    @Override
    public void updateLines(List<String> lines) {
        this.updateLines(lines.stream().map(this::color).toList());
    }

    private Component color(String text) {
        return this.paperComponent.getComponent(text);
    }

    @Override
    public EssentialsScoreboard getScoreboard() {
        return this.essentialsScoreboard;
    }

    @Override
    public Map<Integer, Integer> getLinesModifier() {
        return this.linesModifier;
    }

    @Override
    public int getLineModifier(int line) {
        return this.linesModifier.getOrDefault(line, line);
    }
}

