/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.module.modules.vault;

import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.utils.component.AdventureComponent;
import fr.maxlego08.essentials.api.utils.component.ComponentMessage;
import fr.maxlego08.essentials.api.vault.VaultItem;
import fr.maxlego08.essentials.zutils.utils.ZUtils;
import java.util.ArrayList;
import java.util.Iterator;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ZVaultItem
extends ZUtils
implements VaultItem {
    private final int slot;
    private final ItemStack itemStack;
    private long quantity;

    public ZVaultItem(int slot, ItemStack itemStack, long quantity) {
        this.slot = slot;
        this.itemStack = itemStack;
        this.quantity = quantity;
    }

    @Override
    public int getSlot() {
        return this.slot;
    }

    @Override
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @Override
    public long getQuantity() {
        return this.quantity;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ItemStack getDisplayItemStack(Player player, ComponentMessage componentMessage) {
        ItemStack itemStack = this.itemStack.clone();
        itemStack.setAmount(1);
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (componentMessage instanceof AdventureComponent) {
            AdventureComponent adventureComponent = (AdventureComponent)componentMessage;
            if (itemMeta != null) {
                ArrayList<Component> lore;
                ArrayList<Object> arrayList = lore = itemMeta.hasLore() ? itemMeta.lore() : new ArrayList();
                if (lore == null) {
                    lore = new ArrayList<Component>();
                }
                Iterator<String> iterator = Message.VAULT_LORE.getMessageAsStringList().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        itemMeta.lore(lore);
                        itemStack.setItemMeta(itemMeta);
                        return itemStack;
                    }
                    String message = iterator.next();
                    message = message.replace("%quantity%", String.valueOf(this.quantity));
                    lore.add(adventureComponent.getComponent(this.papi(message, player)).decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE));
                }
            }
        }
        if (itemMeta != null) return itemStack;
        Bukkit.getLogger().warning("The itemstack doesnt have ItemMeta ! " + String.valueOf(this.itemStack.getType()) + " - Slot: " + this.slot);
        return itemStack;
    }

    @Override
    public void addQuantity(long amount) {
        this.quantity += amount;
    }

    @Override
    public void removeQuantity(long amount) {
        this.quantity -= amount;
    }
}

