/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.storage;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.event.events.user.UserJoinEvent;
import fr.maxlego08.essentials.api.event.events.user.UserQuitEvent;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.sanction.Sanction;
import fr.maxlego08.essentials.api.storage.IStorage;
import fr.maxlego08.essentials.api.storage.StorageManager;
import fr.maxlego08.essentials.api.storage.StorageType;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.module.modules.SpawnModule;
import fr.maxlego08.essentials.storage.storages.JsonStorage;
import fr.maxlego08.essentials.storage.storages.SqlStorage;
import fr.maxlego08.essentials.zutils.utils.TimerBuilder;
import fr.maxlego08.essentials.zutils.utils.ZUtils;
import java.time.Duration;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class ZStorageManager
extends ZUtils
implements StorageManager {
    private final IStorage iStorage;
    private final EssentialsPlugin plugin;

    public ZStorageManager(EssentialsPlugin plugin) {
        this.plugin = plugin;
        StorageType storageType = plugin.getConfiguration().getStorageType();
        this.iStorage = switch (storageType) {
            case StorageType.HIKARICP, StorageType.SQLITE, StorageType.MYSQL, StorageType.MARIADB -> new SqlStorage(plugin, storageType);
            default -> new JsonStorage(plugin);
        };
    }

    @Override
    public void onEnable() {
        this.iStorage.onEnable();
        Bukkit.getOnlinePlayers().forEach(player -> this.iStorage.createOrLoad(player.getUniqueId(), player.getName()));
    }

    @Override
    public void onDisable() {
        this.iStorage.onDisable();
    }

    @Override
    public IStorage getStorage() {
        return this.iStorage;
    }

    @Override
    public StorageType getType() {
        return this.plugin.getStorageManager().getType();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onLogin(PlayerLoginEvent event) {
        if (this.plugin.getConfiguration().getBlacklistUuids().contains(event.getPlayer().getUniqueId())) {
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, (Component)Component.text((String)"Unable to verify your connection, please try again."));
            this.plugin.getLogger().info("A blacklist player try to connect: " + event.getPlayer().getName() + " (" + String.valueOf(event.getPlayer().getUniqueId()) + ")");
            return;
        }
        PlayerLoginEvent.Result result = event.getResult();
        if (result != PlayerLoginEvent.Result.ALLOWED) {
            return;
        }
        UUID playerUuid = event.getPlayer().getUniqueId();
        String playerName = event.getPlayer().getName();
        if (this.iStorage.isBan(playerUuid)) {
            Sanction sanction = this.iStorage.getBan(playerUuid);
            Duration duration = sanction.getDurationRemaining();
            this.plugin.getUtils().disallow(event, PlayerLoginEvent.Result.KICK_BANNED, Message.MESSAGE_BAN_JOIN, "%reason%", sanction.getReason(), "%remaining%", TimerBuilder.getStringTime(duration.toMillis()));
            return;
        }
        User user = this.iStorage.createOrLoad(playerUuid, playerName);
        user.setAddress(event.getAddress().getHostAddress());
        if (user.isFirstJoin()) {
            this.plugin.getModuleManager().getModule(SpawnModule.class).onPlayerFirstJoin(event.getPlayer());
        }
        UserJoinEvent userEvent = new UserJoinEvent(user);
        this.plugin.getScheduler().runNextTick(wrappedTask -> userEvent.callEvent());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onDisconnect(PlayerQuitEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        User user = this.iStorage.getUser(uuid);
        if (user != null) {
            UserQuitEvent userQuitEvent = new UserQuitEvent(user);
            userQuitEvent.callEvent();
        }
        this.iStorage.onPlayerQuit(uuid);
    }
}

