/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.storage.database.repositeries;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.dto.CommandDTO;
import fr.maxlego08.essentials.libs.sarah.DatabaseConnection;
import fr.maxlego08.essentials.storage.database.Repository;
import java.util.List;
import java.util.UUID;

public class CommandsRepository
extends Repository {
    public CommandsRepository(EssentialsPlugin plugin, DatabaseConnection connection) {
        super(plugin, connection, "commands");
    }

    public List<CommandDTO> getCommands(UUID uuid) {
        return this.select(CommandDTO.class, table -> {
            table.uuid("unique_id", uuid);
            table.orderByDesc("created_at");
        });
    }

    public void insertCommands(List<CommandDTO> commands) {
        this.insert(commands.stream().map(dto -> this.schema(table -> {
            table.uuid("unique_id", dto.unique_id());
            table.string("command", dto.command());
        })).toList());
    }
}

