/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.storage.database.repositeries;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.dto.FlyDTO;
import fr.maxlego08.essentials.api.dto.UserDTO;
import fr.maxlego08.essentials.api.dto.UserEconomyRankingDTO;
import fr.maxlego08.essentials.api.dto.UserVoteDTO;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.convert.cmi.CMIUser;
import fr.maxlego08.essentials.convert.sunlight.SunlightUser;
import fr.maxlego08.essentials.libs.sarah.DatabaseConnection;
import fr.maxlego08.essentials.libs.sarah.conditions.JoinCondition;
import fr.maxlego08.essentials.libs.sarah.database.DatabaseType;
import fr.maxlego08.essentials.libs.sarah.database.Schema;
import fr.maxlego08.essentials.storage.database.Repository;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class UserRepository
extends Repository {
    public UserRepository(EssentialsPlugin plugin, DatabaseConnection connection) {
        super(plugin, connection, "users");
    }

    public void upsert(UUID uuid, String name) {
        this.upsert((Schema table) -> {
            table.uuid("unique_id", uuid).primary();
            table.string("name", name);
        });
    }

    public void upsert(User user) {
        this.upsert((Schema table) -> {
            table.uuid("unique_id", user.getUniqueId()).primary();
            table.string("name", user.getName());
            table.string("last_location", this.locationAsString(user.getLastLocation()));
        });
    }

    public void clearExpiredSanctions() {
        if (this.connection.getDatabaseConfiguration().getDatabaseType() == DatabaseType.SQLITE) {
            this.plugin.getLogger().warning("Attention, SQLITE does not allow to execute all sql queries, the query that allows to delete inactive sanctions is currently not working.");
        } else {
            this.update(table -> {
                table.leftJoin("%prefix%sanctions", "zs", "id", "%prefix%users", "ban_sanction_id");
                table.string("ban_sanction_id", null);
                table.where("zs", "expired_at", "<", new Date());
            });
            this.update(table -> {
                table.leftJoin("%prefix%sanctions", "zs", "id", "%prefix%users", "mute_sanction_id");
                table.string("mute_sanction_id", null);
                table.where("zs", "expired_at", "<", new Date());
            });
        }
    }

    public void updateBanId(UUID uuid, Integer index) {
        this.update(table -> {
            table.decimal("ban_sanction_id", index);
            table.where("unique_id", uuid);
        });
    }

    public void updateMuteId(UUID uuid, Integer index) {
        this.update(table -> {
            table.decimal("mute_sanction_id", index);
            table.where("unique_id", uuid);
        });
    }

    public List<UserDTO> selectUsers(String userName) {
        return this.select(UserDTO.class, table -> table.where("name", userName));
    }

    public List<UserDTO> selectUser(UUID uniqueId) {
        return this.select(UserDTO.class, table -> table.where("unique_id", uniqueId));
    }

    public List<UserVoteDTO> selectVoteUser(UUID uniqueId) {
        return this.select(UserVoteDTO.class, table -> table.where("unique_id", uniqueId));
    }

    public boolean exists(UUID uniqueId) {
        return !this.selectUser(uniqueId).isEmpty();
    }

    public long totalUsers() {
        return this.select(schema -> {});
    }

    public void updatePlayTime(UUID uniqueId, long playTime) {
        this.update(table -> {
            table.decimal("play_time", playTime);
            table.where("unique_id", uniqueId);
        });
    }

    public List<UserDTO> getUsers(String ip) {
        return this.select(UserDTO.class, table -> {
            table.distinct();
            table.leftJoin("%prefix%user_play_times", "pt", "unique_id", "%prefix%users", "unique_id");
            table.where("pt.address", ip);
        });
    }

    public List<UserEconomyRankingDTO> getBalanceRanking(String economyName) {
        return this.select(UserEconomyRankingDTO.class, table -> {
            table.addSelect("%prefix%users", "unique_id");
            table.addSelect("name");
            table.addSelect("ze", "amount", "amount", 0);
            JoinCondition joinCondition = JoinCondition.and("ze", "economy_name", economyName);
            table.leftJoin("%prefix%economies", "ze", "unique_id", "%prefix%users", "unique_id", joinCondition);
            table.orderByDesc("amount");
        });
    }

    public void setVote(UUID uniqueId, long vote, long offline) {
        this.update(table -> {
            if (vote >= 0L) {
                table.object("vote", vote);
            }
            if (offline >= 0L) {
                table.object("vote_offline", offline);
            }
            table.where("unique_id", uniqueId);
        });
    }

    public void resetVotes() {
        this.update(table -> table.object("vote", 0));
    }

    public void upsert(CMIUser cmiUser) {
        this.upsert((Schema table) -> {
            table.uuid("unique_id", cmiUser.player_uuid()).primary();
            table.string("name", cmiUser.username());
            table.bigInt("play_time", cmiUser.TotalPlayTime() / 1000L);
            if (cmiUser.LogOutLocation() != null) {
                table.string("last_location", cmiUser.LogOutLocation().replace(":", ","));
            }
            if (cmiUser.LastLoginTime() > 0L) {
                Date date = new Date(cmiUser.LastLoginTime());
                table.object("created_at", date);
                table.object("updated_at", date);
            }
        });
    }

    public void upsert(SunlightUser sunlightUser) {
        this.upsert((Schema table) -> {
            table.uuid("unique_id", sunlightUser.uuid()).primary();
            table.string("name", sunlightUser.name());
            long createdAt = sunlightUser.dateCreated();
            if (createdAt > 0L) {
                Date date = new Date(createdAt);
                table.object("created_at", date);
                table.object("updated_at", date);
            }
        });
    }

    public void updateFrozen(UUID uuid, boolean frozen) {
        this.update(table -> {
            table.bool("frozen", frozen);
            table.where("unique_id", uuid);
        });
    }

    public void updateFly(UUID uniqueId, long flySeconds) {
        this.update(table -> {
            table.bigInt("fly_seconds", flySeconds);
            table.where("unique_id", uniqueId);
        });
    }

    public long selectFly(UUID uniqueId) {
        List<UserDTO> users = this.selectUser(uniqueId);
        return users.isEmpty() ? 0L : users.getFirst().fly_seconds();
    }

    public void deleteWorldData(String worldName) {
        this.update(table -> {
            table.string("last_location", null);
            table.where("last_location", "LIKE", "%" + worldName + "%");
        });
    }

    public void upsertFly(List<FlyDTO> flights) {
        flights.forEach(e -> this.updateFly(e.unique_id(), e.fly_seconds()));
    }

    public List<String> getPlayerNames() {
        return this.select(UserDTO.class, table -> {}).stream().map(UserDTO::name).toList();
    }

    public Collection<UUID> selectUUIDs() {
        return this.selectAll(UserDTO.class).stream().map(UserDTO::unique_id).toList();
    }
}

