/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.user;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.afk.AfkPermission;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.discord.DiscordAccount;
import fr.maxlego08.essentials.api.dto.CooldownDTO;
import fr.maxlego08.essentials.api.dto.EconomyDTO;
import fr.maxlego08.essentials.api.dto.HomeDTO;
import fr.maxlego08.essentials.api.dto.MailBoxDTO;
import fr.maxlego08.essentials.api.dto.OptionDTO;
import fr.maxlego08.essentials.api.dto.SanctionDTO;
import fr.maxlego08.essentials.api.dto.UserDTO;
import fr.maxlego08.essentials.api.dto.VoteSiteDTO;
import fr.maxlego08.essentials.api.economy.Economy;
import fr.maxlego08.essentials.api.event.events.user.UserEconomyPostUpdateEvent;
import fr.maxlego08.essentials.api.event.events.user.UserEconomyUpdateEvent;
import fr.maxlego08.essentials.api.home.Home;
import fr.maxlego08.essentials.api.kit.Kit;
import fr.maxlego08.essentials.api.mailbox.MailBoxItem;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.sanction.Sanction;
import fr.maxlego08.essentials.api.storage.IStorage;
import fr.maxlego08.essentials.api.user.Option;
import fr.maxlego08.essentials.api.user.PrivateMessage;
import fr.maxlego08.essentials.api.user.TeleportRequest;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.api.utils.DynamicCooldown;
import fr.maxlego08.essentials.api.utils.SafeLocation;
import fr.maxlego08.essentials.api.worldedit.Selection;
import fr.maxlego08.essentials.api.worldedit.WorldEditTask;
import fr.maxlego08.essentials.libs.folialib.impl.PlatformScheduler;
import fr.maxlego08.essentials.module.modules.TeleportationModule;
import fr.maxlego08.essentials.user.ZHome;
import fr.maxlego08.essentials.user.ZSelection;
import fr.maxlego08.essentials.user.ZTeleportHereRequest;
import fr.maxlego08.essentials.user.ZTeleportRequest;
import fr.maxlego08.essentials.zutils.utils.ZUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.Nullable;

public class ZUser
extends ZUtils
implements User {
    private final EssentialsPlugin plugin;
    private final Map<UUID, TeleportRequest> teleports = new HashMap<UUID, TeleportRequest>();
    private final Map<String, Long> cooldowns = new HashMap<String, Long>();
    private final UUID uniqueId;
    private final Map<Option, Boolean> options = new HashMap<Option, Boolean>();
    private final Map<String, BigDecimal> balances = new HashMap<String, BigDecimal>();
    private final List<Home> homes = new ArrayList<Home>();
    private final List<MailBoxItem> mailBoxItems = new ArrayList<MailBoxItem>();
    private final DynamicCooldown dynamicCooldown = new DynamicCooldown();
    private final Selection selection = new ZSelection();
    private WorldEditTask worldEditTask;
    private String name;
    private TeleportRequest teleportRequest;
    private User targetUser;
    private BigDecimal targetAmount;
    private Economy targetEconomy;
    private SafeLocation lastLocation;
    private boolean firstJoin;
    private int banId;
    private int muteId;
    private Sanction muteSanction;
    private Sanction banSanction;
    private List<Sanction> fakeSanctions;
    private String lastMessage;
    private PrivateMessage privateMessage;
    private long playTime;
    private long currentSessionPlayTime;
    private String address;
    private Kit previewKit;
    private Map<Material, String> powerTools = new HashMap<Material, String>();
    private long vote;
    private long offlineVote;
    private Map<String, Long> lastVotes = new HashMap<String, Long>();
    private Home currentDeleteHome;
    private long flySeconds;
    private DiscordAccount discordAccount;
    private long lastActiveTime = System.currentTimeMillis();
    private boolean manualAfk;
    private long protectionDuration;
    private boolean freeze;

    public ZUser(EssentialsPlugin plugin, UUID uniqueId) {
        this.plugin = plugin;
        this.uniqueId = uniqueId;
    }

    public static User fakeUser(EssentialsPlugin plugin, UUID uniqueId, String userName) {
        ZUser user = new ZUser(plugin, uniqueId);
        user.setName(userName);
        return user;
    }

    private IStorage getStorage() {
        return this.plugin.getStorageManager().getStorage();
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.uniqueId);
    }

    @Override
    public boolean isOnline() {
        return Bukkit.getOfflinePlayer((UUID)this.uniqueId).isOnline();
    }

    @Override
    public boolean isIgnore(UUID uniqueId) {
        return false;
    }

    @Override
    public void sendTeleportRequest(User targetUser) {
        if (targetUser == null || !targetUser.isOnline()) {
            this.message(this, Message.COMMAND_TPA_ERROR_SAME, new Object[0]);
            return;
        }
        if (targetUser.getUniqueId().equals(this.uniqueId)) {
            this.message(this, Message.COMMAND_TPA_ERROR_SAME, new Object[0]);
            return;
        }
        if (targetUser.isIgnore(this.uniqueId)) {
            this.message(this, Message.COMMAND_TELEPORT_IGNORE_PLAYER, targetUser);
            return;
        }
        this.teleports.entrySet().removeIf(next -> !((TeleportRequest)next.getValue()).isValid());
        if (this.teleports.containsKey(targetUser.getUniqueId())) {
            this.message(this, Message.COMMAND_TPA_ERROR, targetUser);
            return;
        }
        TeleportationModule teleportationModule = this.plugin.getModuleManager().getModule(TeleportationModule.class);
        long expired = System.currentTimeMillis() + (long)teleportationModule.getTeleportTpaExpire() * 1000L;
        ZTeleportRequest teleportRequest = new ZTeleportRequest(this.plugin, targetUser, this, expired);
        targetUser.setTeleportRequest(teleportRequest);
        this.teleports.put(targetUser.getUniqueId(), teleportRequest);
        this.message(this, Message.COMMAND_TPA_SENDER, targetUser);
        this.message(targetUser, Message.COMMAND_TPA_RECEIVER, this.getPlayer());
    }

    @Override
    public void sendTeleportHereRequest(User targetUser) {
        if (targetUser == null || !targetUser.isOnline()) {
            this.message(this, Message.COMMAND_TPA_HERE_ERROR_SAME, new Object[0]);
            return;
        }
        if (targetUser.getUniqueId().equals(this.uniqueId)) {
            this.message(this, Message.COMMAND_TPA_HERE_ERROR_SAME, new Object[0]);
            return;
        }
        if (targetUser.isIgnore(this.uniqueId)) {
            this.message(this, Message.COMMAND_TELEPORT_IGNORE_PLAYER, targetUser);
            return;
        }
        this.teleports.entrySet().removeIf(next -> !((TeleportRequest)next.getValue()).isValid());
        if (this.teleports.containsKey(targetUser.getUniqueId())) {
            this.message(this, Message.COMMAND_TPA_HERE_ERROR, targetUser);
            return;
        }
        TeleportationModule teleportationModule = this.plugin.getModuleManager().getModule(TeleportationModule.class);
        long expired = System.currentTimeMillis() + (long)teleportationModule.getTeleportTpaExpire() * 1000L;
        ZTeleportHereRequest teleportRequest = new ZTeleportHereRequest(this.plugin, targetUser, this, expired);
        targetUser.setTeleportRequest(teleportRequest);
        this.teleports.put(targetUser.getUniqueId(), teleportRequest);
        this.message(this, Message.COMMAND_TPA_HERE_SENDER, targetUser);
        this.message(targetUser, Message.COMMAND_TPA_HERE_RECEIVER, this.getPlayer());
    }

    @Override
    public void cancelTeleportRequest(User targetUser) {
        if (!this.teleports.containsKey(targetUser.getUniqueId())) {
            this.message(this, Message.COMMAND_TP_CANCEL_ERROR, targetUser);
            return;
        }
        TeleportRequest request = targetUser.getTeleportRequest();
        if (request == null) {
            this.message(this, Message.COMMAND_TP_CANCEL_ERROR, targetUser);
            return;
        }
        if (!request.isValid()) {
            this.message(this, Message.COMMAND_TP_CANCEL_ERROR, targetUser);
            this.teleports.remove(targetUser.getUniqueId());
            return;
        }
        if (request.getFromUser() == this) {
            targetUser.setTeleportRequest(null);
            this.teleports.remove(targetUser.getUniqueId());
            this.message(this, Message.COMMAND_TP_CANCEL_SENDER, targetUser);
            this.message(targetUser, Message.COMMAND_TP_CANCEL_RECEIVER, this);
        } else {
            this.message(this, Message.COMMAND_TP_CANCEL_ERROR, targetUser);
        }
    }

    @Override
    public Collection<TeleportRequest> getTeleportRequests() {
        return this.teleports.values();
    }

    @Override
    public TeleportRequest getTeleportRequest() {
        return this.teleportRequest;
    }

    @Override
    public void setTeleportRequest(TeleportRequest teleportRequest) {
        this.teleportRequest = teleportRequest;
    }

    @Override
    public void removeTeleportRequest(User user) {
        this.teleports.remove(user.getUniqueId());
    }

    @Override
    public void teleportNow(Location location) {
        if (this.plugin.isFolia()) {
            this.setLastLocation();
        }
        this.plugin.getScheduler().teleportAsync((Entity)this.getPlayer(), location);
        int duration = this.plugin.getModuleManager().getModule(TeleportationModule.class).getTeleportProtectionDelay(this.getPlayer());
        if (duration == 0) {
            return;
        }
        this.protectionDuration = System.currentTimeMillis() + (long)duration;
    }

    @Override
    public void teleport(Location location) {
        this.teleport(location, Message.TELEPORT_MESSAGE, Message.TELEPORT_SUCCESS, new Object[0]);
    }

    @Override
    public void teleport(Location location, Message message, Message successMessage, Object ... args) {
        TeleportationModule teleportationModule = this.plugin.getModuleManager().getModule(TeleportationModule.class);
        Location playerLocation = this.getPlayer().getLocation();
        AtomicInteger atomicInteger = new AtomicInteger(teleportationModule.getTeleportDelay(this.getPlayer()));
        if (teleportationModule.isTeleportDelayBypass() && this.hasPermission(Permission.ESSENTIALS_TELEPORT_BYPASS) || atomicInteger.get() <= 0) {
            this.teleport(teleportationModule, location, successMessage, args);
            return;
        }
        PlatformScheduler platformScheduler = this.plugin.getScheduler();
        platformScheduler.runAtLocationTimer(location, wrappedTask -> {
            if (!this.isOnline()) {
                wrappedTask.cancel();
                return;
            }
            if (!this.same(playerLocation, this.getPlayer().getLocation())) {
                this.message(this, Message.TELEPORT_MOVE, new Object[0]);
                wrappedTask.cancel();
                return;
            }
            int currentSecond = atomicInteger.getAndDecrement();
            if (currentSecond == 0) {
                wrappedTask.cancel();
                this.teleport(teleportationModule, location, successMessage, args);
            } else {
                ArrayList<Object> objects = new ArrayList<Object>(Arrays.asList(args));
                objects.add("%seconds%");
                objects.add(currentSecond);
                this.message(this, message, objects.toArray());
            }
        }, 1L, 20L);
    }

    private void teleport(TeleportationModule teleportationModule, Location toLocation, Message message, Object ... args) {
        Location location;
        Location location2 = this.getPlayer().isFlying() ? toLocation : (location = teleportationModule.isTeleportSafety() ? this.toSafeLocation(toLocation) : toLocation);
        if (teleportationModule.isTeleportToCenter()) {
            location = location.getBlock().getLocation().add(0.5, 0.0, 0.5);
            location.setYaw(toLocation.getYaw());
            location.setPitch(toLocation.getPitch());
        }
        this.teleportNow(location);
        if (message != null) {
            this.message(this, message, args);
        }
    }

    @Override
    public boolean hasPermission(Permission permission) {
        return this.getPlayer().hasPermission(permission.asPermission());
    }

    @Override
    public User getTargetUser() {
        return this.targetUser;
    }

    @Override
    public void setTargetUser(User targetUser) {
        this.targetUser = targetUser;
    }

    @Override
    public boolean getOption(Option option) {
        return this.options.getOrDefault((Object)option, false);
    }

    @Override
    public void setOption(Option option, boolean value) {
        this.options.put(option, value);
        this.getStorage().updateOption(this.uniqueId, option, value);
    }

    @Override
    public void setFakeOption(Option option, boolean value) {
        this.options.put(option, value);
    }

    @Override
    public Map<Option, Boolean> getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(List<OptionDTO> options) {
        options.forEach(optionDTO -> this.options.put(optionDTO.option_name(), optionDTO.option_value()));
    }

    @Override
    public Map<String, Long> getCooldowns() {
        long currentTime = System.currentTimeMillis();
        this.cooldowns.entrySet().removeIf(entry -> (Long)entry.getValue() <= currentTime);
        return this.cooldowns;
    }

    @Override
    public void setCooldowns(List<CooldownDTO> cooldowns) {
        long currentTime = System.currentTimeMillis();
        cooldowns.stream().filter(cooldownDTO -> cooldownDTO.cooldown_value() > currentTime).forEach(cooldownDTO -> this.cooldowns.put(cooldownDTO.cooldown_name(), cooldownDTO.cooldown_value()));
    }

    @Override
    public void setCooldown(String key, long expiredAt) {
        this.cooldowns.put(key, expiredAt);
        this.getStorage().updateCooldown(this.uniqueId, key, expiredAt);
    }

    @Override
    public void setCooldownSilent(String key, long expiredAt) {
        this.cooldowns.put(key, expiredAt);
    }

    @Override
    public boolean isCooldown(String key) {
        return this.cooldowns.containsKey(key) && this.cooldowns.get(key) >= System.currentTimeMillis();
    }

    @Override
    public long getCooldown(String key) {
        return this.cooldowns.getOrDefault(key, 0L);
    }

    @Override
    public long getCooldownSeconds(String key) {
        long cooldown = this.getCooldown(key);
        return cooldown == 0L ? 0L : (cooldown - System.currentTimeMillis()) / 1000L;
    }

    @Override
    public void addCooldown(String key, long seconds) {
        this.setCooldown(key, System.currentTimeMillis() + 1000L * seconds);
    }

    @Override
    public BigDecimal getBalance(Economy economy) {
        return this.balances.getOrDefault(economy.getName(), BigDecimal.ZERO);
    }

    @Override
    public boolean has(Economy economy, BigDecimal bigDecimal) {
        return this.getBalance(economy).compareTo(bigDecimal) > 0;
    }

    @Override
    public void set(UUID fromUuid, Economy economy, BigDecimal bigDecimal, String reason) {
        BigDecimal finalBigDecimal;
        Economy finalEconomy;
        if (this.isOnline() && this.plugin.getServer().isPrimaryThread()) {
            UserEconomyUpdateEvent event = new UserEconomyUpdateEvent(this, economy, bigDecimal);
            event.callEvent();
            if (event.isCancelled()) {
                return;
            }
            finalEconomy = event.getEconomy();
            finalBigDecimal = event.getAmount();
        } else {
            finalBigDecimal = bigDecimal;
            finalEconomy = economy;
        }
        BigDecimal fromAmount = this.balances.getOrDefault(finalEconomy.getName(), BigDecimal.ZERO);
        BigDecimal toAmount = finalBigDecimal.compareTo(finalEconomy.getMinValue()) < 0 ? finalEconomy.getMinValue() : (finalBigDecimal.compareTo(finalEconomy.getMaxValue()) > 0 ? finalEconomy.getMaxValue() : finalBigDecimal);
        this.balances.put(finalEconomy.getName(), toAmount);
        this.getStorage().updateEconomy(this.uniqueId, finalEconomy, finalBigDecimal);
        this.getStorage().storeTransactions(fromUuid, this.uniqueId, finalEconomy, fromAmount, toAmount, reason);
        if (this.isOnline() && this.plugin.getServer().isPrimaryThread()) {
            UserEconomyPostUpdateEvent postUpdateEvent = new UserEconomyPostUpdateEvent(this, finalEconomy, finalBigDecimal);
            postUpdateEvent.callEvent(this.plugin);
        }
    }

    @Override
    public void set(UUID fromUuid, Economy economy, BigDecimal bigDecimal) {
        this.set(fromUuid, economy, bigDecimal, "No reason");
    }

    @Override
    public void withdraw(UUID fromUuid, Economy economy, BigDecimal bigDecimal, String reason) {
        this.set(fromUuid, economy, this.getBalance(economy).subtract(bigDecimal), reason);
    }

    @Override
    public void withdraw(UUID fromUuid, Economy economy, BigDecimal bigDecimal) {
        this.set(fromUuid, economy, this.getBalance(economy).subtract(bigDecimal));
    }

    @Override
    public void deposit(UUID fromUuid, Economy economy, BigDecimal bigDecimal, String reason) {
        this.set(fromUuid, economy, this.getBalance(economy).add(bigDecimal), reason);
    }

    @Override
    public void deposit(UUID fromUuid, Economy economy, BigDecimal bigDecimal) {
        this.set(fromUuid, economy, this.getBalance(economy).add(bigDecimal));
    }

    @Override
    public void set(Economy economy, BigDecimal bigDecimal) {
        this.set(this.plugin.getConsoleUniqueId(), economy, bigDecimal);
    }

    @Override
    public void deposit(Economy economy, BigDecimal bigDecimal) {
        this.deposit(this.plugin.getConsoleUniqueId(), economy, bigDecimal);
    }

    @Override
    public void withdraw(Economy economy, BigDecimal bigDecimal) {
        this.withdraw(this.plugin.getConsoleUniqueId(), economy, bigDecimal);
    }

    @Override
    public void set(Economy economy, BigDecimal bigDecimal, String reason) {
        this.set(this.plugin.getConsoleUniqueId(), economy, bigDecimal, reason);
    }

    @Override
    public void deposit(Economy economy, BigDecimal bigDecimal, String reason) {
        this.deposit(this.plugin.getConsoleUniqueId(), economy, bigDecimal, reason);
    }

    @Override
    public void withdraw(Economy economy, BigDecimal bigDecimal, String reason) {
        this.withdraw(this.plugin.getConsoleUniqueId(), economy, bigDecimal, reason);
    }

    @Override
    public Map<String, BigDecimal> getBalances() {
        return this.balances;
    }

    @Override
    public void setBalance(String key, BigDecimal value) {
        this.balances.put(key, value);
    }

    @Override
    public void setEconomies(List<EconomyDTO> economyDTOS) {
        economyDTOS.forEach(economyDTO -> this.balances.put(economyDTO.economy_name(), economyDTO.amount()));
    }

    @Override
    public void setTargetPay(User user, Economy economy, BigDecimal bigDecimal) {
        this.targetUser = user;
        this.targetEconomy = economy;
        this.targetAmount = bigDecimal;
    }

    @Override
    @Nullable
    public Economy getTargetEconomy() {
        return this.targetEconomy;
    }

    @Override
    @Nullable
    public BigDecimal getTargetDecimal() {
        return this.targetAmount;
    }

    @Override
    public void setLastLocation() {
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        if (this.plugin.getConfiguration().getDisableBackWorld().contains(player.getWorld().getName())) {
            return;
        }
        this.lastLocation = new SafeLocation(player.getLocation().clone());
        this.getStorage().upsertUser(this);
    }

    @Override
    public Location getLastLocation() {
        return this.lastLocation.getLocation();
    }

    @Override
    public void setLastLocation(SafeLocation location) {
        this.lastLocation = location;
    }

    @Override
    public boolean isFirstJoin() {
        return this.firstJoin;
    }

    @Override
    public void setFirstJoin() {
        this.firstJoin = true;
    }

    @Override
    public boolean setHome(String name, Location location, boolean force) {
        if (!force && this.isHomeName(name)) {
            this.message(this, Message.COMMAND_SET_HOME_CREATE_CONFIRM, "%name%", name);
            return false;
        }
        AtomicReference<Object> material = new AtomicReference<Object>(null);
        this.getHome(name).ifPresent(home -> material.set(home.getMaterial()));
        this.homes.removeIf(home -> home.getName().equalsIgnoreCase(name));
        ZHome home2 = new ZHome(new SafeLocation(location), name, material.get());
        this.homes.add(home2);
        this.getStorage().upsertHome(this.uniqueId, home2);
        return true;
    }

    @Override
    public Optional<Home> getHome(String name) {
        return this.homes.stream().filter(home -> home.getName().equalsIgnoreCase(name)).findFirst();
    }

    @Override
    public List<Home> getHomes() {
        return this.homes;
    }

    @Override
    public void setHomes(List<HomeDTO> homeDTOS) {
        this.homes.addAll(homeDTOS.stream().map(homeDTO -> {
            try {
                return new ZHome(this.stringAsLocation(homeDTO.location()), homeDTO.name(), homeDTO.material() == null ? null : Material.valueOf((String)homeDTO.material()));
            }
            catch (Exception exception) {
                this.plugin.getLogger().severe("Impossible to load the home " + homeDTO.name() + " for " + this.name + " Debug: " + String.valueOf(homeDTO));
                exception.printStackTrace();
                return null;
            }
        }).filter(Objects::nonNull).toList());
    }

    @Override
    public int countHomes() {
        return this.homes.size();
    }

    @Override
    public void removeHome(String name) {
        this.homes.removeIf(home -> home.getName().equalsIgnoreCase(name));
        this.getStorage().deleteHome(this.uniqueId, name);
    }

    @Override
    public boolean isHomeName(String homeName) {
        return this.getHome(homeName).isPresent();
    }

    @Override
    public int getActiveBanId() {
        return this.banId;
    }

    @Override
    public int getActiveMuteId() {
        return this.muteId;
    }

    @Override
    public void setSanction(Integer banId, Integer muteId) {
        this.banId = banId == null ? 0 : banId;
        this.muteId = muteId == null ? 0 : muteId;
    }

    @Override
    public Sanction getMuteSanction() {
        return this.muteSanction;
    }

    @Override
    public void setMuteSanction(Sanction sanction) {
        this.muteId = sanction == null ? 0 : sanction.getId();
        this.muteSanction = sanction;
    }

    @Override
    public boolean isMute() {
        return this.muteSanction != null && this.muteSanction.isActive();
    }

    @Override
    public List<Sanction> getFakeSanctions() {
        return this.fakeSanctions;
    }

    @Override
    public void setFakeSanctions(List<SanctionDTO> sanctions) {
        this.fakeSanctions = sanctions.stream().map(Sanction::fromDTO).toList();
    }

    @Override
    public Sanction getBanSanction() {
        return this.banSanction;
    }

    @Override
    public void setBanSanction(Sanction banSanction) {
        this.banId = banSanction != null ? banSanction.getId() : 0;
        this.banSanction = banSanction;
    }

    @Override
    public String getLastMessage() {
        return this.lastMessage;
    }

    @Override
    public void setLastMessage(String lastMessage) {
        this.lastMessage = lastMessage;
    }

    @Override
    public PrivateMessage setPrivateMessage(UUID uuid, String userName) {
        this.privateMessage = new PrivateMessage(uuid, userName);
        return this.privateMessage;
    }

    @Override
    public PrivateMessage getPrivateMessage() {
        return this.privateMessage;
    }

    @Override
    public boolean hasPrivateMessage() {
        return this.privateMessage != null;
    }

    @Override
    public long getPlayTime() {
        return this.playTime + (System.currentTimeMillis() - this.currentSessionPlayTime) / 1000L;
    }

    @Override
    public void setPlayTime(long playtime) {
        this.playTime = playtime;
    }

    @Override
    public long getCurrentSessionPlayTime() {
        return this.currentSessionPlayTime;
    }

    @Override
    public void startCurrentSessionPlayTime() {
        this.currentSessionPlayTime = System.currentTimeMillis();
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(String address) {
        this.address = address;
    }

    @Override
    public long getKitCooldown(Kit kit) {
        return this.getCooldown("kit:" + kit.getName());
    }

    @Override
    public boolean isKitCooldown(Kit kit) {
        return this.isCooldown("kit:" + kit.getName());
    }

    @Override
    public void addKitCooldown(Kit kit, long cooldown) {
        this.addCooldown("kit:" + kit.getName(), cooldown);
    }

    @Override
    public void openKitPreview(Kit kit) {
        this.previewKit = kit;
        this.plugin.openInventory(this.getPlayer(), "kit_preview");
    }

    @Override
    public void removeCooldown(String cooldownName) {
        this.cooldowns.remove(cooldownName);
    }

    @Override
    public void setPowerTools(Material type, String command) {
        this.powerTools.put(type, command);
        this.getStorage().setPowerTools(this.uniqueId, type, command);
    }

    @Override
    public Map<Material, String> getPowerTools() {
        return this.powerTools;
    }

    @Override
    public void setPowerTools(Map<Material, String> powerTools) {
        this.powerTools = powerTools;
    }

    @Override
    public Optional<String> getPowerTool(Material material) {
        return Optional.ofNullable(this.powerTools.get(material));
    }

    @Override
    public Kit getKitPreview() {
        return this.previewKit;
    }

    @Override
    public void deletePowerTools(Material material) {
        this.powerTools.remove(material);
        this.getStorage().deletePowerTools(this.uniqueId, material);
    }

    @Override
    public List<MailBoxItem> getMailBoxItems() {
        return this.mailBoxItems;
    }

    @Override
    public void setMailBoxItems(List<MailBoxDTO> mailBoxItems) {
        this.mailBoxItems.clear();
        this.mailBoxItems.addAll(mailBoxItems.stream().map(MailBoxItem::new).toList());
    }

    @Override
    public void addMailBoxItem(MailBoxItem mailBoxItem) {
        this.mailBoxItems.add(mailBoxItem);
        this.getStorage().addMailBoxItem(mailBoxItem);
    }

    @Override
    public DynamicCooldown getDynamicCooldown() {
        return this.dynamicCooldown;
    }

    @Override
    public long getVote() {
        return this.vote;
    }

    @Override
    public void setVote(long amount) {
        this.vote = amount;
        this.getStorage().setVote(this.uniqueId, this.vote, 0L);
    }

    @Override
    public void addVote(long amount) {
        this.setVote(this.vote + amount);
    }

    @Override
    public void removeVote(long amount) {
        this.setVote(this.vote - amount);
    }

    @Override
    public void setWithDTO(UserDTO userDTO) {
        this.vote = userDTO.vote();
        this.offlineVote = userDTO.vote_offline();
        this.playTime = userDTO.play_time();
        this.lastLocation = this.stringAsLocation(userDTO.last_location());
        this.freeze = userDTO.frozen() != null && userDTO.frozen() != false;
        this.flySeconds = userDTO.fly_seconds();
    }

    @Override
    public void setVoteSite(String site) {
        long ms = System.currentTimeMillis();
        if (this.lastVotes.containsKey(site) && ms - this.lastVotes.get(site) < 500L) {
            return;
        }
        this.lastVotes.put(site, ms);
        this.getStorage().setLastVote(this.uniqueId, site);
    }

    @Override
    public long getLastVoteSite(String site) {
        return this.lastVotes.getOrDefault(site, 0L);
    }

    @Override
    public long getOfflineVotes() {
        return this.offlineVote;
    }

    @Override
    public void setVoteSites(List<VoteSiteDTO> select) {
        this.lastVotes = select.stream().collect(Collectors.toMap(VoteSiteDTO::site, value -> value.last_vote_at().getTime()));
    }

    @Override
    public void resetOfflineVote() {
        this.getStorage().setVote(this.uniqueId, -1L, 0L);
    }

    @Override
    public Selection getSelection() {
        return this.selection;
    }

    @Override
    public boolean hasWorldeditTask() {
        return this.worldEditTask != null && this.worldEditTask.getWorldeditStatus().isRunning();
    }

    @Override
    public WorldEditTask getWorldeditTask() {
        return this.worldEditTask;
    }

    @Override
    public void setWorldeditTask(WorldEditTask worldEditTask) {
        this.worldEditTask = worldEditTask;
    }

    @Override
    public ItemStack getItemInMainHand() {
        return this.getPlayer().getInventory().getItemInMainHand();
    }

    @Override
    public void setItemInMainHand(ItemStack itemStack) {
        this.getPlayer().getInventory().setItemInMainHand(itemStack);
    }

    @Override
    public void playSound(Sound sound, float volume, float pitch) {
        Player player = this.getPlayer();
        player.playSound(player.getLocation(), sound, volume, pitch);
    }

    @Override
    public boolean isFrozen() {
        return this.freeze;
    }

    @Override
    public void setFrozen(boolean isFrozen) {
        this.freeze = isFrozen;
    }

    @Override
    public Optional<Home> getCurrentDeleteHome() {
        return Optional.ofNullable(this.currentDeleteHome);
    }

    @Override
    public void setCurrentDeleteHome(Home currentDeleteHome) {
        this.currentDeleteHome = currentDeleteHome;
    }

    @Override
    public long getFlySeconds() {
        return this.flySeconds;
    }

    @Override
    public void setFlySeconds(long seconds) {
        this.flySeconds = seconds;
        this.getStorage().upsertFlySeconds(this.uniqueId, this.flySeconds);
    }

    @Override
    public void addFlySeconds(long seconds) {
        this.flySeconds += seconds;
        this.getStorage().upsertFlySeconds(this.uniqueId, this.flySeconds);
    }

    @Override
    public void removeFlySeconds(long seconds) {
        this.flySeconds -= seconds;
        this.getStorage().upsertFlySeconds(this.uniqueId, this.flySeconds);
    }

    @Override
    public DiscordAccount getDiscordAccount() {
        return this.discordAccount;
    }

    @Override
    public void setDiscordAccount(DiscordAccount discordAccount) {
        this.discordAccount = discordAccount;
    }

    @Override
    public boolean isDiscordLinked() {
        return this.discordAccount != null;
    }

    @Override
    public void removeDiscordAccount() {
        this.discordAccount = null;
    }

    @Override
    public long getLastActiveTime() {
        return this.lastActiveTime;
    }

    @Override
    public void setLastActiveTime() {
        this.lastActiveTime = System.currentTimeMillis();
    }

    @Override
    public boolean isAfk() {
        if (this.manualAfk) {
            return true;
        }
        Player player = this.getPlayer();
        if (player == null) {
            return false;
        }
        long difference = (System.currentTimeMillis() - this.lastActiveTime) / 1000L;
        Optional<AfkPermission> optional = this.plugin.getAfkManager().getPermission((Permissible)player);
        return optional.filter(afkPermission -> difference >= (long)afkPermission.startAfkTime()).isPresent();
    }

    @Override
    public void setAfk(boolean afk) {
        this.manualAfk = afk;
    }

    @Override
    public boolean isManualAfk() {
        return this.manualAfk;
    }

    @Override
    public long getProtectionDuration() {
        return this.protectionDuration;
    }

    @Override
    public void setProtectionDuration(long duration) {
        this.protectionDuration = duration;
    }
}

