/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.zutils.utils;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.messages.DefaultFontInfo;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.messages.MessageType;
import fr.maxlego08.essentials.api.messages.messages.BossBarMessage;
import fr.maxlego08.essentials.api.messages.messages.ClassicMessage;
import fr.maxlego08.essentials.api.messages.messages.TitleMessage;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.api.utils.component.ComponentMessage;
import fr.maxlego08.essentials.zutils.utils.ComponentMessageHelper;
import fr.maxlego08.essentials.zutils.utils.PlaceholderUtils;
import fr.maxlego08.menu.zcore.utils.nms.NMSUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class MessageUtils
extends PlaceholderUtils {
    protected final ComponentMessage componentMessage = ComponentMessageHelper.componentMessage;

    public static String getString(String message, Object[] newArgs) {
        if (newArgs.length % 2 != 0) {
            throw new IllegalArgumentException("Number of invalid arguments. Arguments must be in pairs.");
        }
        for (int i = 0; i < newArgs.length; i += 2) {
            if (newArgs[i] == null || newArgs[i + 1] == null) {
                throw new IllegalArgumentException("Keys and replacement values must not be null.");
            }
            message = message.replace(newArgs[i].toString(), newArgs[i + 1].toString());
        }
        return message;
    }

    protected void message(CommandSender sender, String message) {
        this.componentMessage.sendMessage(sender, message);
    }

    protected void message(User sender, Message message, Object ... args) {
        this.message((CommandSender)sender.getPlayer(), message, args);
    }

    protected void message(UUID uniqueId, Message message, Object ... args) {
        Player player = Bukkit.getPlayer((UUID)uniqueId);
        if (player == null) {
            return;
        }
        this.message((CommandSender)player, message, args);
    }

    protected void broadcast(Permission permission, Message message, Object ... args) {
        Bukkit.getOnlinePlayers().forEach(player -> {
            if (player.hasPermission(permission.asPermission())) {
                this.message((CommandSender)player, message, args);
            }
        });
        this.message((CommandSender)Bukkit.getConsoleSender(), message, args);
    }

    protected void broadcast(Message message, Object ... args) {
        Bukkit.getOnlinePlayers().forEach(player -> this.message((CommandSender)player, message, args));
        this.message((CommandSender)Bukkit.getConsoleSender(), message, args);
    }

    protected void message(CommandSender sender, Message message, Object ... args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            message.getMessages().forEach(essentialsMessage -> {
                if (essentialsMessage instanceof ClassicMessage) {
                    ClassicMessage classicMessage = (ClassicMessage)essentialsMessage;
                    switch (essentialsMessage.messageType()) {
                        case TCHAT: 
                        case WITHOUT_PREFIX: {
                            this.sendTchatMessage(sender, classicMessage, args);
                            break;
                        }
                        case ACTION: {
                            classicMessage.messages().forEach(currentMessage -> this.componentMessage.sendActionBar(player, this.getMessage((String)currentMessage, args)));
                            break;
                        }
                        case CENTER: {
                            classicMessage.messages().forEach(currentMessage -> this.componentMessage.sendMessage(sender, this.getCenteredMessage(this.getMessage((String)currentMessage, args))));
                        }
                    }
                } else if (essentialsMessage instanceof BossBarMessage) {
                    BossBarMessage bossBarMessage = (BossBarMessage)essentialsMessage;
                    EssentialsPlugin plugin = (EssentialsPlugin)Bukkit.getPluginManager().getPlugin("zEssentials");
                    this.componentMessage.sendBossBar(plugin, player, bossBarMessage);
                } else if (essentialsMessage instanceof TitleMessage) {
                    TitleMessage titleMessage = (TitleMessage)essentialsMessage;
                    this.componentMessage.sendTitle(player, titleMessage, new Object[0]);
                }
            });
        } else {
            message.getMessages().forEach(essentialsMessage -> {
                if (essentialsMessage instanceof ClassicMessage) {
                    ClassicMessage classicMessage = (ClassicMessage)essentialsMessage;
                    this.sendTchatMessage(sender, classicMessage, args);
                }
            });
        }
    }

    private void sendTchatMessage(CommandSender sender, ClassicMessage classicMessage, Object ... args) {
        boolean isWithoutPrefix = classicMessage.messageType() == MessageType.WITHOUT_PREFIX || classicMessage.messages().size() > 1;
        classicMessage.messages().forEach(message -> this.componentMessage.sendMessage(sender, (isWithoutPrefix ? "" : Message.PREFIX.getMessageAsString()) + this.getMessage((String)message, args)));
    }

    protected String getMessage(Message message, Object ... args) {
        return this.getMessage(String.join((CharSequence)"\n", message.getMessageAsStringList()), args);
    }

    protected String getMessage(String message, Object ... args) {
        ArrayList<Object> modifiedArgs = new ArrayList<Object>();
        for (Object arg : args) {
            this.handleArg(arg, modifiedArgs);
        }
        Object[] newArgs = modifiedArgs.toArray();
        return MessageUtils.getString(message, newArgs);
    }

    private void handleArg(Object arg, List<Object> modifiedArgs) {
        if (arg instanceof Player) {
            Player player = (Player)arg;
            this.addPlayerDetails(modifiedArgs, player.getName(), player.getDisplayName());
        } else if (arg instanceof User) {
            User user = (User)arg;
            this.addPlayerDetails(modifiedArgs, user.getName(), user.getPlayer().getDisplayName());
        } else {
            modifiedArgs.add(arg);
        }
    }

    private void addPlayerDetails(List<Object> modifiedArgs, String name, String displayName) {
        modifiedArgs.add("%player%");
        modifiedArgs.add(name);
        modifiedArgs.add("%displayName%");
        modifiedArgs.add(displayName);
    }

    protected String getCenteredMessage(String message) {
        if (message == null || message.equals("")) {
            return "";
        }
        int CENTER_PX = 154;
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        int messagePxSize = 0;
        boolean previousCode = false;
        boolean isBold = false;
        for (char c : message.toCharArray()) {
            if (c == '\u00a7') {
                previousCode = true;
                continue;
            }
            if (previousCode) {
                previousCode = false;
                isBold = c == 'l' || c == 'L';
                continue;
            }
            DefaultFontInfo dFI = DefaultFontInfo.getDefaultFontInfo(c);
            messagePxSize += isBold ? dFI.getBoldLength() : dFI.getLength();
            ++messagePxSize;
        }
        int halvedMessageSize = messagePxSize / 2;
        int toCompensate = CENTER_PX - halvedMessageSize;
        int spaceLength = DefaultFontInfo.SPACE.getLength() + 1;
        StringBuilder sb = new StringBuilder();
        for (int compensated = 0; compensated < toCompensate; compensated += spaceLength) {
            sb.append(" ");
        }
        return String.valueOf(sb) + message;
    }

    protected String color(String message) {
        if (message == null) {
            return null;
        }
        if (NMSUtils.isHexColor()) {
            Pattern pattern = Pattern.compile("#[a-fA-F0-9]{6}");
            Matcher matcher = pattern.matcher(message);
            while (matcher.find()) {
                String color = message.substring(matcher.start(), matcher.end());
                message = message.replace(color, String.valueOf(net.md_5.bungee.api.ChatColor.of((String)color)));
                matcher = pattern.matcher(message);
            }
        }
        return net.md_5.bungee.api.ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }
}

