/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search;

import java.util.ArrayList;
import java.util.List;
import redis.clients.jedis.Builder;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.search.Document;

public class SearchResult {
    private final long totalResults;
    private final List<Document> documents;

    private SearchResult(long totalResults, List<Document> documents) {
        this.totalResults = totalResults;
        this.documents = documents;
    }

    public long getTotalResults() {
        return this.totalResults;
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public static class SearchResultBuilder
    extends Builder<SearchResult> {
        private final boolean hasContent;
        private final boolean hasScores;
        private final boolean hasPayloads;
        private final boolean decode;

        public SearchResultBuilder(boolean hasContent, boolean hasScores, boolean hasPayloads, boolean decode) {
            this.hasContent = hasContent;
            this.hasScores = hasScores;
            this.hasPayloads = hasPayloads;
            this.decode = decode;
        }

        @Override
        public SearchResult build(Object data) {
            List resp = (List)data;
            int step = 1;
            int scoreOffset = 0;
            int contentOffset = 1;
            int payloadOffset = 0;
            if (this.hasScores) {
                ++step;
                scoreOffset = 1;
                ++contentOffset;
            }
            if (this.hasContent) {
                ++step;
                if (this.hasPayloads) {
                    payloadOffset = scoreOffset + 1;
                    ++step;
                    ++contentOffset;
                }
            }
            long totalResults = (Long)resp.get(0);
            ArrayList<Document> documents = new ArrayList<Document>(resp.size() - 1);
            for (int i = 1; i < resp.size(); i += step) {
                String id = BuilderFactory.STRING.build(resp.get(i));
                double score = this.hasScores ? BuilderFactory.DOUBLE.build(resp.get(i + scoreOffset)) : 1.0;
                byte[] payload = this.hasPayloads ? (byte[])resp.get(i + payloadOffset) : null;
                List fields = this.hasContent ? (List)resp.get(i + contentOffset) : null;
                documents.add(Document.load(id, score, payload, fields, this.decode));
            }
            return new SearchResult(totalResults, documents);
        }
    }
}

