/*
 * Decompiled with CFR 0.152.
 */
package com.mcwroofs.kikoz.objects.gutters;

import com.mcwroofs.kikoz.init.BlockInit;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GutterTall
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape[] SHAPES = new VoxelShape[12];
    public static final BooleanProperty ABOVE;
    public static final BooleanProperty BELOW;
    private static final BooleanProperty WATER;

    public GutterTall(BlockState state, BlockBehaviour.Properties prop) {
        super(prop);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATER, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ABOVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BELOW, (Comparable)Boolean.valueOf(false)));
    }

    private BlockState GutterState(BlockState state, LevelAccessor access, BlockPos pos) {
        boolean above = access.m_8055_(pos.m_7494_()).m_60734_() == this;
        boolean below = access.m_8055_(pos.m_7495_()).m_60734_() == this;
        return (BlockState)((BlockState)state.m_61124_((Property)ABOVE, (Comparable)Boolean.valueOf(above))).m_61124_((Property)BELOW, (Comparable)Boolean.valueOf(below));
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState statetwo, boolean bolean) {
        if (!statetwo.m_60713_(state.m_60734_())) {
            this.GutterState(state, (LevelAccessor)world, pos);
        }
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable Entity entity, ItemStack stack) {
        this.GutterState(state, (LevelAccessor)world, pos);
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState bstate, LevelAccessor world, BlockPos pos, BlockPos postwo) {
        return this.GutterState(state, world, pos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.GutterState(super.m_5573_(context), (LevelAccessor)context.m_43725_(), context.m_8083_()).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122427_());
    }

    public void placeAt(Level world, BlockPos pos, int into) {
        world.m_7731_(pos, this.m_49966_(), into);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        Direction facing;
        boolean isBelow;
        boolean isAbove = (Boolean)state.m_61143_((Property)ABOVE);
        int shapeIndex = this.getShapeIndex(isAbove, isBelow = ((Boolean)state.m_61143_((Property)BELOW)).booleanValue(), facing = (Direction)state.m_61143_((Property)FACING));
        if (shapeIndex >= 0 && shapeIndex < SHAPES.length) {
            return SHAPES[shapeIndex];
        }
        return Shapes.m_83040_();
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemstack = player.m_21120_(hand);
        Boolean i = (Boolean)state.m_61143_((Property)WATER);
        Item item = itemstack.m_41720_();
        ItemStack heldItem = player.m_21120_(hand);
        if (item == Items.f_42447_ && !i.booleanValue()) {
            state = (BlockState)state.m_61122_((Property)WATER);
            world.m_7731_(pos, state, 2);
            itemstack.m_41774_(1);
            player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
        }
        if (item == Items.f_42446_ && i.booleanValue()) {
            state = (BlockState)state.m_61122_((Property)WATER);
            world.m_7731_(pos, state, 2);
            itemstack.m_41774_(1);
            player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42447_));
        }
        if (item == Items.f_42590_ && i.booleanValue()) {
            state = (BlockState)state.m_61122_((Property)WATER);
            world.m_7731_(pos, state, 2);
            player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42589_));
        }
        if (item instanceof DyeItem) {
            DyeColor dyeColor = ((DyeItem)item).m_41089_();
            Block blockToPlace = null;
            switch (dyeColor) {
                case WHITE: {
                    blockToPlace = (Block)BlockInit.GUTTER_MIDDLE_WHITE.get();
                    break;
                }
                case LIGHT_GRAY: {
                    blockToPlace = (Block)BlockInit.GUTTER_MIDDLE_LIGHT_GRAY.get();
                    break;
                }
                case GRAY: {
                    blockToPlace = (Block)BlockInit.GUTTER_MIDDLE_GRAY.get();
                    break;
                }
                case BLACK: {
                    blockToPlace = (Block)BlockInit.GUTTER_MIDDLE_BLACK.get();
                    break;
                }
                case BROWN: {
                    blockToPlace = (Block)BlockInit.GUTTER_MIDDLE_BROWN.get();
                    break;
                }
                case RED: {
                    blockToPlace = (Block)BlockInit.GUTTER_MIDDLE_RED.get();
                    break;
                }
                case ORANGE: {
                    blockToPlace = (Block)BlockInit.GUTTER_MIDDLE_ORANGE.get();
                    break;
                }
                case YELLOW: {
                    blockToPlace = (Block)BlockInit.GUTTER_MIDDLE_YELLOW.get();
                    break;
                }
                case LIME: {
                    blockToPlace = (Block)BlockInit.GUTTER_MIDDLE_LIME.get();
                    break;
                }
                case GREEN: {
                    blockToPlace = (Block)BlockInit.GUTTER_MIDDLE_GREEN.get();
                    break;
                }
                case CYAN: {
                    blockToPlace = (Block)BlockInit.GUTTER_MIDDLE_CYAN.get();
                    break;
                }
                case LIGHT_BLUE: {
                    blockToPlace = (Block)BlockInit.GUTTER_MIDDLE_LIGHT_BLUE.get();
                    break;
                }
                case BLUE: {
                    blockToPlace = (Block)BlockInit.GUTTER_MIDDLE_BLUE.get();
                    break;
                }
                case PURPLE: {
                    blockToPlace = (Block)BlockInit.GUTTER_MIDDLE_PURPLE.get();
                    break;
                }
                case MAGENTA: {
                    blockToPlace = (Block)BlockInit.GUTTER_MIDDLE_MAGENTA.get();
                    break;
                }
                case PINK: {
                    blockToPlace = (Block)BlockInit.GUTTER_MIDDLE_PINK.get();
                    break;
                }
                default: {
                    return InteractionResult.PASS;
                }
            }
            Direction currentFacing = (Direction)state.m_61143_((Property)FACING);
            Boolean currentWater = (Boolean)state.m_61143_((Property)WATER);
            Boolean currentAbove = (Boolean)state.m_61143_((Property)ABOVE);
            Boolean currentBelow = (Boolean)state.m_61143_((Property)BELOW);
            BlockState newState = (BlockState)((BlockState)((BlockState)((BlockState)blockToPlace.m_49966_().m_61124_((Property)FACING, (Comparable)currentFacing)).m_61124_((Property)WATER, (Comparable)currentWater)).m_61124_((Property)ABOVE, (Comparable)currentAbove)).m_61124_((Property)BELOW, (Comparable)currentBelow);
            world.m_46597_(pos, newState);
            if (!player.m_150110_().f_35937_) {
                heldItem.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private int getShapeIndex(boolean isAbove, boolean isBelow, Direction facing) {
        if (!isAbove && !isBelow) {
            switch (facing) {
                case WEST: {
                    return 2;
                }
                case EAST: {
                    return 0;
                }
                case SOUTH: {
                    return 1;
                }
                case NORTH: {
                    return 3;
                }
            }
        } else if (isAbove && isBelow) {
            switch (facing) {
                case WEST: {
                    return 6;
                }
                case EAST: {
                    return 4;
                }
                case SOUTH: {
                    return 5;
                }
                case NORTH: {
                    return 7;
                }
            }
        } else if (isAbove && !isBelow) {
            switch (facing) {
                case WEST: {
                    return 2;
                }
                case EAST: {
                    return 0;
                }
                case SOUTH: {
                    return 1;
                }
                case NORTH: {
                    return 3;
                }
            }
        } else {
            switch (facing) {
                case WEST: {
                    return 10;
                }
                case EAST: {
                    return 8;
                }
                case SOUTH: {
                    return 9;
                }
                case NORTH: {
                    return 11;
                }
            }
        }
        return -1;
    }

    public void onBroken(Level worldIn, BlockPos pos) {
        worldIn.m_46796_(1029, pos, 0);
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        BlockPos blockpos = pos.m_6630_(30);
        if (state.m_61138_((Property)WATER)) {
            if (world.m_46758_(blockpos) && !((Boolean)state.m_61143_((Property)WATER)).booleanValue()) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)WATER, (Comparable)Boolean.valueOf(true)));
                this.scheduleSpread(world, pos);
            }
            if (!world.m_46758_(blockpos) && ((Boolean)state.m_61143_((Property)WATER)).booleanValue()) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)WATER, (Comparable)Boolean.valueOf(false)));
                this.scheduleClear(world, pos);
            }
        }
    }

    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        BlockPos blockpos = pos.m_6630_(30);
        if (world.m_46758_(blockpos)) {
            if (state.m_61138_((Property)WATER) && !((Boolean)state.m_61143_((Property)WATER)).booleanValue()) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)WATER, (Comparable)Boolean.valueOf(true)));
                this.scheduleSpread(world, pos);
            }
        } else if (state.m_61138_((Property)WATER) && ((Boolean)state.m_61143_((Property)WATER)).booleanValue()) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)WATER, (Comparable)Boolean.valueOf(false)));
            this.scheduleClear(world, pos);
        }
    }

    private void scheduleSpread(ServerLevel world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        for (BlockPos neighbor : this.getNeighborPositions(pos)) {
            BlockState neighborState = world.m_8055_(neighbor);
            if (neighborState.m_60734_() != state.m_60734_() || !neighborState.m_61138_((Property)WATER) || ((Boolean)neighborState.m_61143_((Property)WATER)).booleanValue()) continue;
            world.m_186460_(neighbor, (Block)this, 6);
        }
    }

    private void scheduleClear(ServerLevel world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        for (BlockPos neighbor : this.getNeighborPositions(pos)) {
            BlockState neighborState = world.m_8055_(neighbor);
            if (neighborState.m_60734_() != state.m_60734_() || !neighborState.m_61138_((Property)WATER) || !((Boolean)neighborState.m_61143_((Property)WATER)).booleanValue()) continue;
            world.m_186460_(neighbor, (Block)this, 6);
        }
    }

    private List<BlockPos> getNeighborPositions(BlockPos pos) {
        return List.of(pos.m_142127_(), pos.m_142128_(), pos.m_142126_(), pos.m_142125_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, ABOVE, BELOW, WATER});
    }

    static {
        GutterTall.SHAPES[0] = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)6.0, (double)5.6, (double)4.0, (double)10.0, (double)9.8, (double)7.4), (VoxelShape)Block.m_49796_((double)6.0, (double)5.6, (double)0.0, (double)10.0, (double)16.0, (double)4.0));
        GutterTall.SHAPES[1] = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)8.8, (double)5.6, (double)6.0, (double)12.1, (double)9.8, (double)10.0), (VoxelShape)Block.m_49796_((double)12.1, (double)5.6, (double)6.0, (double)16.1, (double)16.0, (double)10.0));
        GutterTall.SHAPES[2] = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)6.0, (double)5.6, (double)8.7, (double)10.0, (double)9.8, (double)12.0), (VoxelShape)Block.m_49796_((double)6.0, (double)5.6, (double)12.0, (double)10.0, (double)16.0, (double)16.0));
        GutterTall.SHAPES[3] = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)5.6, (double)6.0, (double)7.3, (double)9.8, (double)10.0), (VoxelShape)Block.m_49796_((double)0.0, (double)5.6, (double)6.0, (double)4.0, (double)16.0, (double)10.0));
        GutterTall.SHAPES[4] = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[0]);
        GutterTall.SHAPES[5] = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)12.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0), (VoxelShape[])new VoxelShape[0]);
        GutterTall.SHAPES[6] = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)12.0, (double)10.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
        GutterTall.SHAPES[7] = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)4.0, (double)16.0, (double)10.0), (VoxelShape[])new VoxelShape[0]);
        GutterTall.SHAPES[8] = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)6.0, (double)4.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)15.0, (double)5.0), Block.m_49796_((double)0.0, (double)11.0, (double)1.0, (double)16.0, (double)12.0, (double)4.0), Block.m_49796_((double)6.0, (double)6.0, (double)0.8, (double)10.0, (double)8.975, (double)5.0), Block.m_49796_((double)5.0, (double)9.0, (double)0.8, (double)11.0, (double)14.975, (double)7.0)});
        GutterTall.SHAPES[9] = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)12.0, (double)0.0, (double)6.0, (double)16.0, (double)6.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)11.0, (double)12.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), Block.m_49796_((double)12.0, (double)11.0, (double)0.0, (double)15.0, (double)12.0, (double)16.0), Block.m_49796_((double)11.0, (double)6.0, (double)6.0, (double)16.0, (double)9.0, (double)10.0), Block.m_49796_((double)9.0, (double)9.0, (double)5.0, (double)16.0, (double)15.0, (double)11.0)});
        GutterTall.SHAPES[10] = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)12.0, (double)10.0, (double)6.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)12.0, (double)11.0, (double)16.0, (double)15.0, (double)16.0), Block.m_49796_((double)0.0, (double)11.0, (double)12.0, (double)16.0, (double)12.0, (double)15.0), Block.m_49796_((double)6.0, (double)6.0, (double)11.0, (double)10.0, (double)9.0, (double)16.0), Block.m_49796_((double)5.0, (double)9.0, (double)9.0, (double)11.0, (double)15.0, (double)16.0)});
        GutterTall.SHAPES[11] = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)4.0, (double)6.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)5.0, (double)15.0, (double)16.0), Block.m_49796_((double)1.0, (double)11.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0), Block.m_49796_((double)1.0, (double)6.0, (double)6.0, (double)5.0, (double)9.0, (double)10.0), Block.m_49796_((double)1.0, (double)9.0, (double)5.0, (double)7.0, (double)15.0, (double)11.0)});
        ABOVE = BooleanProperty.m_61465_((String)"above");
        BELOW = BooleanProperty.m_61465_((String)"below");
        WATER = BooleanProperty.m_61465_((String)"water");
    }
}

