/*
 * Decompiled with CFR 0.152.
 */
package com.mcwroofs.kikoz.objects.gutters;

import com.mcwroofs.kikoz.init.BlockInit;
import com.mcwroofs.kikoz.init.ItemInit;
import com.mcwroofs.kikoz.objects.roofs.AwningBlock;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RainGutter
extends AwningBlock {
    private static final BooleanProperty WATER = BooleanProperty.m_61465_((String)"water");
    private static final VoxelShape[] SHAPES = new VoxelShape[12];

    private int getShapeIndex(StairsShape shape, Direction facing) {
        switch (shape) {
            case OUTER_RIGHT: {
                return switch (facing) {
                    case Direction.WEST -> 10;
                    case Direction.EAST -> 8;
                    case Direction.SOUTH -> 9;
                    case Direction.NORTH -> 11;
                    default -> -1;
                };
            }
            case INNER_RIGHT: {
                return switch (facing) {
                    case Direction.WEST -> 6;
                    case Direction.EAST -> 4;
                    case Direction.SOUTH -> 5;
                    case Direction.NORTH -> 7;
                    default -> -1;
                };
            }
            case OUTER_LEFT: {
                return switch (facing) {
                    case Direction.WEST -> 9;
                    case Direction.EAST -> 11;
                    case Direction.SOUTH -> 8;
                    case Direction.NORTH -> 10;
                    default -> -1;
                };
            }
            case INNER_LEFT: {
                return switch (facing) {
                    case Direction.WEST -> 5;
                    case Direction.EAST -> 7;
                    case Direction.SOUTH -> 4;
                    case Direction.NORTH -> 6;
                    default -> -1;
                };
            }
        }
        return switch (facing) {
            case Direction.WEST -> 2;
            case Direction.EAST -> 0;
            case Direction.SOUTH -> 1;
            case Direction.NORTH -> 3;
            default -> -1;
        };
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        Direction facing;
        StairsShape shape = (StairsShape)state.m_61143_((Property)SHAPE);
        int shapeIndex = this.getShapeIndex(shape, facing = (Direction)state.m_61143_((Property)FACING));
        return shapeIndex >= 0 && shapeIndex < SHAPES.length ? SHAPES[shapeIndex] : Shapes.m_83040_();
    }

    public RainGutter(BlockState state, BlockBehaviour.Properties prop) {
        super(state, prop);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATER, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)SHAPE, (Comparable)StairsShape.STRAIGHT));
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        Boolean i = (Boolean)state.m_61143_((Property)WATER);
        ItemStack heldItem = player.m_21120_(hand);
        if (item == ItemInit.ROOFING_HAMMER.get()) {
            state = (BlockState)state.m_61122_((Property)SHAPE);
            world.m_7731_(pos, state, 2);
        }
        if (item == Items.f_42447_ && !i.booleanValue()) {
            state = (BlockState)state.m_61122_((Property)WATER);
            world.m_7731_(pos, state, 2);
            player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
        }
        if (item == Items.f_42446_ && i.booleanValue()) {
            state = (BlockState)state.m_61122_((Property)WATER);
            world.m_7731_(pos, state, 2);
            itemstack.m_41774_(1);
            player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42447_));
        }
        if (item == Items.f_42590_ && i.booleanValue()) {
            state = (BlockState)state.m_61122_((Property)WATER);
            world.m_7731_(pos, state, 2);
            player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42589_));
        }
        if (item instanceof DyeItem) {
            DyeColor dyeColor = ((DyeItem)item).m_41089_();
            Block blockToPlace = null;
            switch (dyeColor) {
                case WHITE: {
                    blockToPlace = (Block)BlockInit.GUTTER_BASE_WHITE.get();
                    break;
                }
                case LIGHT_GRAY: {
                    blockToPlace = (Block)BlockInit.GUTTER_BASE_LIGHT_GRAY.get();
                    break;
                }
                case GRAY: {
                    blockToPlace = (Block)BlockInit.GUTTER_BASE_GRAY.get();
                    break;
                }
                case BLACK: {
                    blockToPlace = (Block)BlockInit.GUTTER_BASE_BLACK.get();
                    break;
                }
                case BROWN: {
                    blockToPlace = (Block)BlockInit.GUTTER_BASE_BROWN.get();
                    break;
                }
                case RED: {
                    blockToPlace = (Block)BlockInit.GUTTER_BASE_RED.get();
                    break;
                }
                case ORANGE: {
                    blockToPlace = (Block)BlockInit.GUTTER_BASE_ORANGE.get();
                    break;
                }
                case YELLOW: {
                    blockToPlace = (Block)BlockInit.GUTTER_BASE_YELLOW.get();
                    break;
                }
                case LIME: {
                    blockToPlace = (Block)BlockInit.GUTTER_BASE_LIME.get();
                    break;
                }
                case GREEN: {
                    blockToPlace = (Block)BlockInit.GUTTER_BASE_GREEN.get();
                    break;
                }
                case CYAN: {
                    blockToPlace = (Block)BlockInit.GUTTER_BASE_CYAN.get();
                    break;
                }
                case LIGHT_BLUE: {
                    blockToPlace = (Block)BlockInit.GUTTER_BASE_LIGHT_BLUE.get();
                    break;
                }
                case BLUE: {
                    blockToPlace = (Block)BlockInit.GUTTER_BASE_BLUE.get();
                    break;
                }
                case PURPLE: {
                    blockToPlace = (Block)BlockInit.GUTTER_BASE_PURPLE.get();
                    break;
                }
                case MAGENTA: {
                    blockToPlace = (Block)BlockInit.GUTTER_BASE_MAGENTA.get();
                    break;
                }
                case PINK: {
                    blockToPlace = (Block)BlockInit.GUTTER_BASE_PINK.get();
                    break;
                }
                default: {
                    return InteractionResult.PASS;
                }
            }
            Direction currentFacing = (Direction)state.m_61143_((Property)FACING);
            Boolean currentWater = (Boolean)state.m_61143_((Property)WATER);
            StairsShape currentAbove = (StairsShape)state.m_61143_((Property)SHAPE);
            BlockState newState = (BlockState)((BlockState)((BlockState)blockToPlace.m_49966_().m_61124_((Property)FACING, (Comparable)currentFacing)).m_61124_((Property)WATER, (Comparable)currentWater)).m_61124_((Property)SHAPE, (Comparable)currentAbove);
            world.m_46597_(pos, newState);
            if (!player.m_150110_().f_35937_) {
                heldItem.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static boolean isBlockStairs(BlockState state) {
        return state.m_60734_() instanceof RainGutter;
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        BlockPos blockpos = pos.m_6630_(30);
        if (state.m_61138_((Property)WATER)) {
            if (world.m_46758_(blockpos) && !((Boolean)state.m_61143_((Property)WATER)).booleanValue()) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)WATER, (Comparable)Boolean.valueOf(true)));
                this.scheduleSpread(world, pos);
            }
            if (!world.m_46758_(blockpos) && ((Boolean)state.m_61143_((Property)WATER)).booleanValue()) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)WATER, (Comparable)Boolean.valueOf(false)));
                this.scheduleClear(world, pos);
            }
        }
    }

    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        BlockPos blockpos = pos.m_6630_(30);
        if (world.m_46758_(blockpos)) {
            if (state.m_61138_((Property)WATER) && !((Boolean)state.m_61143_((Property)WATER)).booleanValue()) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)WATER, (Comparable)Boolean.valueOf(true)));
                this.scheduleSpread(world, pos);
            }
        } else if (state.m_61138_((Property)WATER) && ((Boolean)state.m_61143_((Property)WATER)).booleanValue()) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)WATER, (Comparable)Boolean.valueOf(false)));
            this.scheduleClear(world, pos);
        }
    }

    private void scheduleSpread(ServerLevel world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        for (BlockPos neighbor : this.getNeighborPositions(pos)) {
            BlockState neighborState = world.m_8055_(neighbor);
            if (neighborState.m_60734_() != state.m_60734_() || !neighborState.m_61138_((Property)WATER) || ((Boolean)neighborState.m_61143_((Property)WATER)).booleanValue()) continue;
            world.m_186460_(neighbor, (Block)this, 6);
        }
    }

    private void scheduleClear(ServerLevel world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        for (BlockPos neighbor : this.getNeighborPositions(pos)) {
            BlockState neighborState = world.m_8055_(neighbor);
            if (neighborState.m_60734_() != state.m_60734_() || !neighborState.m_61138_((Property)WATER) || !((Boolean)neighborState.m_61143_((Property)WATER)).booleanValue()) continue;
            world.m_186460_(neighbor, (Block)this, 6);
        }
    }

    private List<BlockPos> getNeighborPositions(BlockPos pos) {
        return List.of(pos.m_142127_(), pos.m_142128_(), pos.m_142126_(), pos.m_142125_());
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATER, FACING, SHAPE});
    }

    static {
        RainGutter.SHAPES[0] = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)15.0, (double)12.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)11.0, (double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)16.0), Block.m_49796_((double)12.0, (double)11.0, (double)0.0, (double)15.0, (double)12.0, (double)16.0)});
        RainGutter.SHAPES[1] = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)12.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)12.0, (double)11.0, (double)16.0, (double)15.0, (double)12.0), Block.m_49796_((double)0.0, (double)11.0, (double)12.0, (double)16.0, (double)12.0, (double)15.0)});
        RainGutter.SHAPES[2] = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)4.0, (double)12.0, (double)0.0, (double)5.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0), Block.m_49796_((double)1.0, (double)11.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0)});
        RainGutter.SHAPES[3] = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)12.0, (double)4.0, (double)16.0, (double)15.0, (double)5.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0), Block.m_49796_((double)0.0, (double)11.0, (double)1.0, (double)16.0, (double)12.0, (double)4.0)});
        RainGutter.SHAPES[4] = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)15.0, (double)12.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)11.0, (double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)12.0), Block.m_49796_((double)12.0, (double)11.0, (double)0.0, (double)15.0, (double)12.0, (double)15.0), Block.m_49796_((double)0.0, (double)12.0, (double)11.0, (double)11.0, (double)15.0, (double)12.0), Block.m_49796_((double)0.0, (double)12.0, (double)15.0, (double)15.0, (double)15.0, (double)16.0), Block.m_49796_((double)0.0, (double)11.0, (double)12.0, (double)12.0, (double)12.0, (double)15.0)});
        RainGutter.SHAPES[5] = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)12.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.0, (double)12.0, (double)11.0, (double)16.0, (double)15.0, (double)12.0), Block.m_49796_((double)1.0, (double)11.0, (double)12.0, (double)16.0, (double)12.0, (double)15.0), Block.m_49796_((double)4.0, (double)12.0, (double)0.0, (double)5.0, (double)15.0, (double)11.0), Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0), Block.m_49796_((double)1.0, (double)11.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0)});
        RainGutter.SHAPES[6] = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.0, (double)12.0, (double)4.0, (double)5.0, (double)15.0, (double)16.0), Block.m_49796_((double)1.0, (double)11.0, (double)1.0, (double)4.0, (double)12.0, (double)16.0), Block.m_49796_((double)5.0, (double)12.0, (double)4.0, (double)16.0, (double)15.0, (double)5.0), Block.m_49796_((double)1.0, (double)12.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0), Block.m_49796_((double)4.0, (double)11.0, (double)1.0, (double)16.0, (double)12.0, (double)4.0)});
        RainGutter.SHAPES[7] = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0, (double)5.0), Block.m_49796_((double)0.0, (double)11.0, (double)1.0, (double)15.0, (double)12.0, (double)4.0), Block.m_49796_((double)11.0, (double)12.0, (double)5.0, (double)12.0, (double)15.0, (double)16.0), Block.m_49796_((double)15.0, (double)12.0, (double)1.0, (double)16.0, (double)15.0, (double)16.0), Block.m_49796_((double)12.0, (double)11.0, (double)4.0, (double)15.0, (double)12.0, (double)16.0)});
        RainGutter.SHAPES[8] = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)11.0, (double)12.0, (double)11.0, (double)12.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)11.0, (double)12.0, (double)15.0, (double)12.0, (double)16.0), Block.m_49796_((double)15.0, (double)12.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0), Block.m_49796_((double)12.0, (double)12.0, (double)11.0, (double)16.0, (double)15.0, (double)12.0), Block.m_49796_((double)15.0, (double)11.0, (double)12.0, (double)16.0, (double)12.0, (double)15.0)});
        RainGutter.SHAPES[9] = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)12.0, (double)11.0, (double)5.0, (double)15.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)11.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0), Block.m_49796_((double)0.0, (double)12.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0), Block.m_49796_((double)4.0, (double)12.0, (double)12.0, (double)5.0, (double)15.0, (double)16.0), Block.m_49796_((double)1.0, (double)11.0, (double)15.0, (double)4.0, (double)12.0, (double)16.0)});
        RainGutter.SHAPES[10] = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)4.0, (double)12.0, (double)0.0, (double)5.0, (double)15.0, (double)5.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)11.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0), Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0), Block.m_49796_((double)0.0, (double)12.0, (double)4.0, (double)4.0, (double)15.0, (double)5.0), Block.m_49796_((double)0.0, (double)11.0, (double)1.0, (double)1.0, (double)12.0, (double)4.0)});
        RainGutter.SHAPES[11] = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)11.0, (double)12.0, (double)4.0, (double)16.0, (double)15.0, (double)5.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)11.0, (double)1.0, (double)16.0, (double)12.0, (double)4.0), Block.m_49796_((double)15.0, (double)12.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0), Block.m_49796_((double)11.0, (double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)4.0), Block.m_49796_((double)12.0, (double)11.0, (double)0.0, (double)15.0, (double)12.0, (double)1.0)});
    }
}

