/*
 * Decompiled with CFR 0.152.
 */
package com.mcwroofs.kikoz.objects.roofs;

import com.mcwroofs.kikoz.init.BlockInit;
import com.mcwroofs.kikoz.init.ItemInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AwningBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.f_61398_;
    protected static final VoxelShape BASE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);

    public AwningBlock(BlockState state, BlockBehaviour.Properties prop) {
        super(prop);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(SHAPE, (Comparable)StairsShape.STRAIGHT));
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter getter, BlockPos pos) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        return BASE;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing.m_122434_().m_122479_() ? (BlockState)stateIn.m_61124_(SHAPE, (Comparable)AwningBlock.getShapeProperty(stateIn, (BlockGetter)worldIn, currentPos)) : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        ItemStack heldItem = player.m_21120_(hand);
        if (item == ItemInit.ROOFING_HAMMER.get()) {
            state = (BlockState)state.m_61122_(SHAPE);
            world.m_7731_(pos, state, 2);
        }
        if (item instanceof DyeItem) {
            DyeColor dyeColor = ((DyeItem)item).m_41089_();
            Block blockToPlace = null;
            switch (dyeColor) {
                case WHITE: {
                    return InteractionResult.PASS;
                }
                case LIGHT_GRAY: {
                    blockToPlace = (Block)BlockInit.LIGHT_GRAY_STRIPED_AWNING.get();
                    break;
                }
                case GRAY: {
                    blockToPlace = (Block)BlockInit.GRAY_STRIPED_AWNING.get();
                    break;
                }
                case BLACK: {
                    blockToPlace = (Block)BlockInit.BLACK_STRIPED_AWNING.get();
                    break;
                }
                case BROWN: {
                    blockToPlace = (Block)BlockInit.BROWN_STRIPED_AWNING.get();
                    break;
                }
                case RED: {
                    blockToPlace = (Block)BlockInit.RED_STRIPED_AWNING.get();
                    break;
                }
                case ORANGE: {
                    blockToPlace = (Block)BlockInit.ORANGE_STRIPED_AWNING.get();
                    break;
                }
                case YELLOW: {
                    blockToPlace = (Block)BlockInit.YELLOW_STRIPED_AWNING.get();
                    break;
                }
                case LIME: {
                    blockToPlace = (Block)BlockInit.LIME_STRIPED_AWNING.get();
                    break;
                }
                case GREEN: {
                    blockToPlace = (Block)BlockInit.GREEN_STRIPED_AWNING.get();
                    break;
                }
                case CYAN: {
                    blockToPlace = (Block)BlockInit.CYAN_STRIPED_AWNING.get();
                    break;
                }
                case LIGHT_BLUE: {
                    blockToPlace = (Block)BlockInit.LIGHT_BLUE_STRIPED_AWNING.get();
                    break;
                }
                case BLUE: {
                    blockToPlace = (Block)BlockInit.BLUE_STRIPED_AWNING.get();
                    break;
                }
                case PURPLE: {
                    blockToPlace = (Block)BlockInit.PURPLE_STRIPED_AWNING.get();
                    break;
                }
                case MAGENTA: {
                    blockToPlace = (Block)BlockInit.MAGENTA_STRIPED_AWNING.get();
                    break;
                }
                case PINK: {
                    blockToPlace = (Block)BlockInit.PINK_STRIPED_AWNING.get();
                    break;
                }
                default: {
                    return InteractionResult.PASS;
                }
            }
            Direction currentFacing = (Direction)state.m_61143_((Property)FACING);
            StairsShape currentShape = (StairsShape)state.m_61143_(SHAPE);
            BlockState newState = (BlockState)((BlockState)blockToPlace.m_49966_().m_61124_((Property)FACING, (Comparable)currentFacing)).m_61124_(SHAPE, (Comparable)currentShape);
            world.m_46597_(pos, newState);
            if (!player.m_150110_().f_35937_) {
                heldItem.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        Direction horizontalDirection = context.m_8125_();
        BlockState blockstate = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)horizontalDirection);
        return (BlockState)blockstate.m_61124_(SHAPE, (Comparable)AwningBlock.getShapeProperty(blockstate, (BlockGetter)context.m_43725_(), blockpos));
    }

    private static StairsShape getShapeProperty(BlockState state, BlockGetter worldIn, BlockPos pos) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockState blockstate = worldIn.m_8055_(pos.m_142300_(direction));
        if (AwningBlock.isBlockStairs(blockstate) && (direction1 = (Direction)blockstate.m_61143_((Property)FACING)).m_122434_() != direction.m_122434_()) {
            return direction1 == direction.m_122428_() ? StairsShape.OUTER_LEFT : StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = worldIn.m_8055_(pos.m_142300_(direction.m_122424_()));
        if (AwningBlock.isBlockStairs(blockstate1) && (direction2 = (Direction)blockstate1.m_61143_((Property)FACING)).m_122434_() != direction.m_122434_()) {
            return direction2 == direction.m_122428_() ? StairsShape.INNER_LEFT : StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    public static boolean isBlockStairs(BlockState state) {
        return state.m_60734_() instanceof AwningBlock;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        StairsShape stairsshape = (StairsShape)state.m_61143_(SHAPE);
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                if (direction.m_122434_() != Direction.Axis.Z) break;
                return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)this.getMirroredShape(stairsshape));
            }
            case FRONT_BACK: {
                if (direction.m_122434_() != Direction.Axis.X) break;
                return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)this.getMirroredShape(stairsshape));
            }
        }
        return super.m_6943_(state, mirrorIn);
    }

    private StairsShape getMirroredShape(StairsShape shape) {
        switch (shape) {
            case INNER_LEFT: {
                return StairsShape.INNER_RIGHT;
            }
            case INNER_RIGHT: {
                return StairsShape.INNER_LEFT;
            }
            case OUTER_LEFT: {
                return StairsShape.OUTER_RIGHT;
            }
            case OUTER_RIGHT: {
                return StairsShape.OUTER_LEFT;
            }
        }
        return shape;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SHAPE});
    }
}

