/*
 * Decompiled with CFR 0.152.
 */
package com.mcwroofs.kikoz.objects.roofs;

import com.mcwroofs.kikoz.objects.roofs.RoofBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Steep
extends RoofBlock {
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0), Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0), Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0), Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0)};
    protected static final VoxelShape OCCLUSION = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    protected static final VoxelShape[] TOP_SHAPES = Steep.createStairShapes(SHAPES[0], SHAPES[2], SHAPES[6], SHAPES[3], SHAPES[7]);
    protected static final VoxelShape[] BOTTOM_SHAPES = Steep.createStairShapes(SHAPES[1], SHAPES[4], SHAPES[8], SHAPES[5], SHAPES[9]);
    private static final int[] SHAPE_BY_STATE = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};

    private static VoxelShape[] createStairShapes(VoxelShape baseShape, VoxelShape ... shapes) {
        VoxelShape[] stairShapes = new VoxelShape[16];
        for (int i = 0; i < 16; ++i) {
            stairShapes[i] = baseShape;
            for (int j = 0; j < shapes.length; ++j) {
                if ((i & 1 << j) == 0) continue;
                stairShapes[i] = Shapes.m_83110_((VoxelShape)stairShapes[i], (VoxelShape)shapes[j]);
            }
        }
        return stairShapes;
    }

    public Steep(BlockState state, BlockBehaviour.Properties prop) {
        super(prop);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext collision) {
        VoxelShape[] shapes = state.m_61143_((Property)HALF) == Half.TOP ? TOP_SHAPES : BOTTOM_SHAPES;
        int shapeIndex = this.getShapeIndex(state);
        return shapes[SHAPE_BY_STATE[shapeIndex]];
    }

    private int getShapeIndex(BlockState state) {
        return ((StairsShape)state.m_61143_((Property)SHAPE)).ordinal() * 4 + ((Direction)state.m_61143_((Property)FACING)).m_122416_();
    }

    @Override
    public VoxelShape m_7952_(BlockState state, BlockGetter getter, BlockPos pos) {
        return OCCLUSION;
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction dir, BlockState statetwo, LevelAccessor access, BlockPos pos, BlockPos postwo) {
        return dir.m_122434_().m_122479_() ? (BlockState)state.m_61124_((Property)SHAPE, (Comparable)Steep.getStairsShape((BlockGetter)access, pos, (Direction)state.m_61143_((Property)FACING), (Half)state.m_61143_((Property)HALF))) : super.m_7417_(state, dir, statetwo, access, pos, postwo);
    }

    private static StairsShape getStairsShape(BlockGetter reader, BlockPos pos, Direction facing, Half half) {
        Direction direction2;
        Direction direction1;
        Direction direction = facing;
        BlockState blockstate = reader.m_8055_(pos.m_142300_(direction));
        if (Steep.isSteep(blockstate) && half == blockstate.m_61143_((Property)HALF) && (direction1 = (Direction)blockstate.m_61143_((Property)FACING)).m_122434_() != facing.m_122434_() && Steep.canTakeShape(direction1.m_122424_(), blockstate, reader, pos)) {
            return direction1 == direction.m_122428_() ? StairsShape.OUTER_LEFT : StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = reader.m_8055_(pos.m_142300_(direction.m_122424_()));
        if (Steep.isSteep(blockstate1) && half == blockstate1.m_61143_((Property)HALF) && (direction2 = (Direction)blockstate1.m_61143_((Property)FACING)).m_122434_() != facing.m_122434_() && Steep.canTakeShape(direction2, blockstate1, reader, pos)) {
            return direction2 == direction.m_122428_() ? StairsShape.INNER_LEFT : StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean canTakeShape(Direction dir, BlockState state, BlockGetter reader, BlockPos pos) {
        BlockState blockstate = reader.m_8055_(pos.m_142300_(dir));
        return !Steep.isSteep(blockstate) || blockstate.m_61143_((Property)FACING) != state.m_61143_((Property)FACING) || blockstate.m_61143_((Property)HALF) != state.m_61143_((Property)HALF);
    }

    public static boolean isSteep(BlockState state) {
        return state.m_60734_() instanceof Steep;
    }
}

