data modify storage nitwit_trades:db / set value {\
	types: [\
		{ type: "minecraft:desert" },\
		{ type: "minecraft:jungle" },\
		{ type: "minecraft:plains" },\
		{ type: "minecraft:savanna" },\
		{ type: "minecraft:snow" },\
		{ type: "minecraft:swamp" },\
		{ type: "minecraft:taiga" }\
	],\
	"minecraft:desert": [\
		{ name: "Block of Coal", id: [I; -944114159, 1690717852, -1399353875, -122061289], texture: "ZjZjNWVjYWM5NDJjNzdiOTVhYjQ2MjBkZjViODVlMzgwNjRjOTc0ZjljNWM1NzZiODQzNjIyODA2YTQ1NTcifX19", sound: "stone" },\
		{ name: "Block of Copper", id: [I; 581584980, -1323413932, -2045364538, 536346058], texture: "YTk1ZDdjYjdlMTg3MzkyMTEwMmJkYmEzMDlhYTM4NTUzZjVmZDU4MGQxZWQ5ZDQ0Mzg5ZjUzZTA5ZWNkNWEwMiJ9fX0=", sound: "copper" },\
		{ name: "Block of Diamond", id: [I; 1026891468, 601702558, -2134294593, 201158332], texture: "OTYzMTU5N2RjZTRlNDA1MWU4ZDVhNTQzNjQxOTY2YWI1NGZiZjI1YTBlZDYwNDdmMTFlNjE0MGQ4OGJmNDhmIn19fQ==", sound: "metal" },\
		{ name: "Block of Emerald", id: [I; 2081467957, -1135262116, -1594052031, 1586498681], texture: "YWFiOGZhNzY1NTU1MTVlMmRjYmUzODMzNmM2OTE4NDFhOWMyM2Q5OWM4OGY2NWQ5NmY0NDQ3Nzc1YmNjMTZlYiJ9fX0=", sound: "metal" },\
		{ name: "Block of Gold", id: [I; -34962163, -1366602224, -1962710909, 1229644390], texture: "ZmRjZjVmNzhiZjFkOWFkZTEyNmIyYzdmNmI0OTgwZGNmZTg5YjRlNjVjZDUzMmZjNjVhZDhiNzU3MjUzMGM1YiJ9fX0=", sound: "metal" },\
		{ name: "Block of Iron", id: [I; -350240344, 1983792175, -1089458133, 1005501234], texture: "MTI2Yjc3MjMyOWNmMzJmODY0M2M0OTI4NjI2YjZhMzI1MjMzZmY2MWFhOWM3NzI1ODczYTRiZDY2ZGIzZDY5MiJ9fX0=", sound: "metal" },\
		{ name: "Block of Lapis Lazuli", id: [I; 1313416803, 1145390925, -1328945319, 213131654], texture: "ODZmNDc2ODcxZWQyM2Y3OWU3YjlkNDk1NDg5ODg3ZTI0NGM2MTljNWUxOWU0MWNmOTViMjcxYTJlYmU3NSJ9fX0=", sound: "stone" },\
		{ name: "Block of Raw Copper", id: [I; 1671646978, -686928275, -1302770116, -1204514428], texture: "OWExMjJiMzEyYzAzN2NjZmYxZTUyYTU5M2I2ZGIyNjRlMWI0Y2M5NjQ5YjRmNzYzYjY1OTYyZjFhMThjMzI4NCJ9fX0=", sound: "stone" },\
		{ name: "Block of Raw Gold", id: [I; 1598086221, -319797935, -1755972906, -895059839], texture: "ZWFkZGZmNjkxNmU2NDEwZGY2Yjg4MzE1OGFlYWRhY2U2YjM2NzMzMzc0YmU2YmVkMTgyMWUzZTc0Yzk1ZDkxYiJ9fX0=", sound: "stone" },\
		{ name: "Block of Raw Iron", id: [I; -964817346, 411584652, -1941791944, 1306847194], texture: "NDQ3ZjJlMzlkOTZlNWQwNDM4NjQ3M2RhZjBlYjBhZTAwYjE3ZmEwMTU1NTZjOWNhMzlmOGUyZGU4YTIzNjlmMiJ9fX0=", sound: "stone" },\
		{ name: "Block of Redstone", id: [I; 925628459, 1316703665, -1165924520, 368585445], texture: "YmI3OGZhNWRlZmU3MmRlYmNkOWM3NmFiOWY0ZTExNDI1MDQ3OWJiOWI0NGY0Mjg4N2JiZjZmNzM4NjEyYiJ9fX0=", sound: "metal" },\
		{ name: "Cactus", id: [I; -503001228, 937708965, -1388164958, 353455252], texture: "NjEyZGUzYzE5NTQyNDczYjdiMzQ0MWRmZTdkZDM2MGQyNDJlZDMwZGE3NmI0ODUzZDhhMjQxN2I4NTUyM2ZmYyJ9fX0=", sound: "wool" },\
		{ name: "Chiseled Red Sandstone", id: [I; 735161023, -1733344168, -1372096289, -1490311568], texture: "ZmM0NjFlYzBiMWIxMmViMzNhOTdkYWNiN2IxNzMzOTZjYjk3ODFlMjc3OGE2NWRhMzg5OGY5ZjE4NzkyNjdmMSJ9fX0=", sound: "stone" },\
		{ name: "Chiseled Sandstone", id: [I; 618085206, -1165341975, -1999024000, -1008347797], texture: "OTRlOGRjMDg2NWNlZDM4N2QxZjRlYzA5ZWUzMmFjZGZmNjk5ZmYyNjczMDZhNWViOWI3NDVkMTMxYzRiZWZlYSJ9fX0=", sound: "stone" },\
		{ name: "Coal Ore", id: [I; -1686056074, -1622061750, -1940556228, 292823853], texture: "NzExMTA3ZjcwZjhjYTA0NzRmMDIzMjQzYmQzODJiYmQ2YjQxNDlhZWY0ZjQyYjI1ZGRiYmNmZWM4Nzk4YjRkYyJ9fX0=", sound: "stone" },\
		{ name: "Copper Ore", id: [I; -372347713, 586760840, -1968518947, 1121631181], texture: "MWJjMmUzOGRiNjYxZGRiNzg0Y2VlM2ZkNzMwMDQ2ZWFiZDU2OGU1MzE5OTMxMmE2MGRjZGYwYWYxYTU1MzVjNyJ9fX0=", sound: "stone" },\
		{ name: "Deepslate Coal Ore", id: [I; -1821410259, 5783893, -1183620288, -280706641], texture: "YWNmOTQ3ODRkN2MxZGM2YTkzYjQxM2JlNTJiNTRmYTc3YjdhNzI1ODY3NWU4NzAyMWIzNGVkMmJmNzUxZGIyMSJ9fX0=", sound: "deepslate" },\
		{ name: "Deepslate Copper Ore", id: [I; 1215381569, 48252937, -1657401746, -63497721], texture: "OWQ2YzFkYjI5YTdmNzQ1YmQ3ODlhMmMyOTQ3NmJkMTNlNzUxNjM3NmNiN2Y2ODBiZjY2ZTE3YjJhNTRhMDgxNiJ9fX0=", sound: "deepslate" },\
		{ name: "Deepslate Diamond Ore", id: [I; 1312462147, -30325835, -1738620274, 1823097246], texture: "M2UwYWEzYTk1MjVkODY0NmYwNmIxMmE1NGExOTc3MGVhZjMyMDA1N2M5OGViZjYzZTY2M2ZkZTJkOWQ5YjEzMSJ9fX0=", sound: "deepslate" },\
		{ name: "Deepslate Emerald Ore", id: [I; -2132119329, -80328833, -2088259296, 1546906529], texture: "MTEzNTBlMGE2MDY5NjVmMmVmMDk0OTFiYTU0ZWUxMzc5MTVkZTU4YThhMjhhYjEzMGE1M2ZhOGY0MTZiMjhkNSJ9fX0=", sound: "deepslate" },\
		{ name: "Deepslate Gold Ore", id: [I; 1732718768, 1896500850, -1955924072, -1432993713], texture: "ODBjOWM1ZWIxYmZjZjk5YTBkOGM2ZTgyMmM1MDBjOTk3MTAzNjU3NWY0MDExNzVkNGEwNDAwZWMzMmEzYTFhYyJ9fX0=", sound: "deepslate" },\
		{ name: "Deepslate Iron Ore", id: [I; -254106580, -701282208, -1627783387, 1115790952], texture: "Y2FlY2Y4ZDVhMjFiM2M5ZmM4Y2U1YTU2NjAyMWYzYTJiMGQ5ODY1MmRiYzVkYWVlNDVmN2M2MzY0N2VkMTQxYSJ9fX0=", sound: "deepslate" },\
		{ name: "Deepslate Lapis Ore", id: [I; -426946462, -870298576, -1544164093, -282194126], texture: "YmM1YmY0OWZlYmVjOTU1ZWIzYjMyOGNlMTcwOWY3YmI5ZjQ2OWMyN2E3ZmY0MGQxMzA2OTQyYzA4Zjk2MjUwZSJ9fX0=", sound: "deepslate" },\
		{ name: "Deepslate Redstone Ore", id: [I; 742531174, 2125941547, -1627397434, -1923543202], texture: "NmMzNjFhZjk2YWMyYzk5Nzc0NTA4Mzg0NDY0NTI3OTk4N2FjYTY1Njc5MDQ2ZTVhZGJhNzdmYzVmNGYyODFkMCJ9fX0=", sound: "deepslate" },\
		{ name: "Diamond Ore", id: [I; -1444360275, 1966424910, -1579966069, 1810155982], texture: "NzMzYjZjOTA3ZjFjMmExYWU1NGY5MGFhZmJjOWU1NjFmMmY0ZGQ0ZWM0YjczZTU2ZDU0OTU1YmMxZGZjYzJhMCJ9fX0=", sound: "stone" },\
		{ name: "Emerald Ore", id: [I; -1793835845, 749421622, -1946003241, -64300437], texture: "YmE0MGJhZWI5NmZlYTFiZDZlZTA2NDY5NmNkYjc0ZmZkMDhhNmY3YzQwNjE3ZDQ2MmU0ZTJkYThmYWFmNzNlNSJ9fX0=", sound: "stone" },\
		{ name: "Exposed Copper", id: [I; 560709494, -36812274, -1729033851, 2003853440], texture: "NzFlMjE5OTQyNDRiMDI5YWYzODUyMGE3MTM4NDllZDcxZWYyOTU4NmJkMjg2Y2VkMmJhMTY3NWJhNWY0YTQ0ZSJ9fX0=", sound: "copper" },\
		{ name: "Gold Ore", id: [I; 766593177, -1216395606, -1904440042, 1869135056], texture: "ODViNGFiZDRmMDdiNjg5NDYwN2NiZDg3MDg2OGY2N2UwMjVjN2ZiNTUyYTFhNTdmNTZmNzdjMDQ0Y2NhNDFjZSJ9fX0=", sound: "stone" },\
		{ name: "Iron Ore", id: [I; -419392818, -2027404947, -1373762724, 484458229], texture: "ODM4NWFhZWRkNzg0ZmFlZjhlOGY2Zjc4MmZhNDhkMDdjMmZjMmJiY2Y2ZmVhMWZiYzliOTg2MmQwNWQyMjhjMSJ9fX0=", sound: "stone" },\
		{ name: "Lapis Ore", id: [I; -1779192045, 2146192115, -1320693840, 1915564124], texture: "NTEwMDFiNDI1MTExYmZlMGFjZmY3MTBhOGI0MWVhOTVlM2I5MzZhODVlNWJiNjUxNzE2MGJhYjU4N2U4ODcwZiJ9fX0=", sound: "stone" },\
		{ name: "Oxidized Copper", id: [I; 118302609, 160911090, -1860413146, -1120461794], texture: "NDhmZDk4NzlmODZlMjI5ZmU4MDNkNjFkOTNlYmVjYTk2M2IyMzIzZmM5YTU5NGIxMjFiMjI5YjVjOTI1NzBlIn19fQ==", sound: "copper" },\
		{ name: "Red Sand", id: [I; 1115752381, -1932768137, -1799524842, -1635272322], texture: "YTNjYjU0NjRhYjliODUxYjlkNGFjOGI4Y2RiYjg2NWU3NGM1ODliMzQ4NWFiZWNlNTg5ZDQyOWQ4OTlhZWQifX19", sound: "sand" },\
		{ name: "Red Sandstone", id: [I; -1508297484, -468238042, -1596031713, -489739702], texture: "YWUxMmIzNDQ5YTczNjRkNGEwNDczMDZmZWI5YTU3YWI3Nzg3YTc3NjBhYjE2NjA3ZjkwMzk2YmQxMDdmZjU2ZiJ9fX0=", sound: "stone" },\
		{ name: "Redstone Ore", id: [I; -1974499311, 611992878, -1939462076, -1347295362], texture: "NjMyY2NmNzgxNDUzOWE2MWY4YmZjMTViY2YxMTFhMzlhZDhhZTE2M2MzNmU0NGI2Mzc5NDE1NTU2NDc1ZDcyYSJ9fX0=", sound: "stone" },\
		{ name: "Sand", id: [I; 1381378554, 1711423830, -2009393088, 1937950700], texture: "NTMzOThhYjNjYjY5NmIzNDQzMGJlOTQ0YjE0YWZiZDIyN2ZkODdlOTkwMjZiY2ZjOGI3Mzg3YTg2MWJkZSJ9fX0=", sound: "sand" },\
		{ name: "Sandstone", id: [I; -1395060971, 1751270171, -1635329195, 411018119], texture: "NDhmODBlOWIyZDY1OTNhMzJkN2M0NGM4YmM4NjBmZWJhMzRiMzRmOGQ1NGQwY2RiNzIxMWUyM2U4ZGRjMzNhNCJ9fX0=", sound: "stone" },\
		{ name: "Weathered Copper", id: [I; -1762166422, -805352794, -1665951735, -1537236399], texture: "ZGE1N2U0NmViMWVhZDkwNzFjZDhkNjEzYTgxY2Q1NWM1OTMxY2I2ZGJhZTRkZmJmMTQ1OGYyOGY5OWVlN2Y0NCJ9fX0=", sound: "copper" }\
	],\
	"minecraft:jungle": [\
		{ name: "Bamboo Block", id: [I; 1000291252, -863286171, -1191117304, 412512577], texture: "M2FjMTZiMDdkMzAxN2QxNTliZTdhYjMxMTg1ZDg0OTBmODE2YWVkMDBmYWM0ODJmMTJlMzNhNGQ3Y2ZlOGY1MSJ9fX0=", sound: "bamboo_wood" },\
		{ name: "Bamboo Mosaic", id: [I; -136875004, 1465338448, -1263247978, -67931486], texture: "NWQ0YWJmNWFjZGM3ZjA3OWViYjk0ODc3YmMyNmE2ZDhkMGMzZjc2MjA2NGFjM2Y3NGYzNDNlNzg2NjkyZTRlZiJ9fX0=", sound: "bamboo_wood" },\
		{ name: "Bamboo Planks", id: [I; -1087111308, -1276294749, -1656894957, 636683883], texture: "NTYxNWViZWE3ODUwZTlkN2I1MGI5NjhlMDA5OWVmOTMyNTY2MjU3ODEyMTBmMDJhZTlkNTA4MWY4NmI3MDQ2MyJ9fX0=", sound: "bamboo_wood" },\
		{ name: "Barrel", id: [I; 373126497, 1756120048, -1581677378, 173970135], texture: "NjdjMmRkNmEzMTRjZDJkNDY0MWZjYmFiMzI1Njc0MTM0MDEwMTA5MTNjNTQwOTc1NDk2NWRmZDc0MTU4ZjMzNyJ9fX0=", sound: "wood" },\
		{ name: "Beacon", id: [I; 864932708, 1350713883, -1674230353, 674426537], texture: "MzUyNzIzYWEwNjM3ZWE1MjA0NDQ3YmU1MzYxNTFmNTI5ZmU0OTA2ODI2ZDhjMDY2YzRkY2M1MDA3OWE2NDQ2NSJ9fX0=", sound: "stone" },\
		{ name: "Bee Nest", id: [I; 1039465344, -1793769339, -1093485314, 281340308], texture: "ZTA0MGFiZTU4ZDhiZDczYWZmYzMwYTdkMDc1NDBhNjc0NWU5NmNjNGNjYWFiNWY3MTU0MGY0YzM2NmZkMDU1YiJ9fX0=", sound: "wood" },\
		{ name: "Blast Furnace", id: [I; -988923966, -1437318092, -1423605534, -212294757], texture: "ZTgzMDZiZjhlZTQwMzZhNmZkYjQ4NDE2NzBiMzE3Mjg5NDg1MDMxYjU2NTQ1ZDNkMWE1YzBlNTc0ZWNmZDFkNCJ9fX0=", sound: "stone" },\
		{ name: "Bookshelf", id: [I; -1596100575, -229880292, -1286242178, -325647466], texture: "N2Y2YmY5NThhYmQ3ODI5NWVlZDZmZmMyOTNiMWFhNTk1MjZlODBmNTQ5NzY4MjllYTA2ODMzN2MyZjVlOCJ9fX0=", sound: "wood" },\
		{ name: "Cartography Table", id: [I; -32685607, 424102266, -1493001987, -288935600], texture: "ZDkwOTdjYTU5MzM0MDIwZTRjMTZkNWJhMzZjYjI0NTgwZWU2NmM5YzJmNDI1YTNiNTY1NGZkYzQ3YjhkYjZmNiJ9fX0=", sound: "wood" },\
		{ name: "Chest", id: [I; 866667617, 641484425, -1507050624, 1155661645], texture: "ZDVjNmRjMmJiZjUxYzM2Y2ZjNzcxNDU4NWE2YTU2ODNlZjJiMTRkNDdkOGZmNzE0NjU0YTg5M2Y1ZGE2MjIifX19", sound: "wood" },\
		{ name: "Command Block", id: [I; -1553045868, -91797294, -1411685654, -222924515], texture: "NWY0YzIxZDE3YWQ2MzYzODdlYTNjNzM2YmZmNmFkZTg5NzMxN2UxMzc0Y2Q1ZDliMWMxNWU2ZTg5NTM0MzIifX19", sound: "metal" },\
		{ name: "Composter", id: [I; -1477925756, -683981452, -1613257316, 1561705494], texture: "NTNjYjhmNjFlN2Y2YmY5NTdhMjEzNGU5NmZhZWIwZmM5MjQxMzdkNGJmZjg4ZDk1MThiMmJmNjYyNTg2YzkyZSJ9fX0=", sound: "wood" },\
		{ name: "Crafting Table", id: [I; -462678395, -1186117755, -1865029521, -2104906282], texture: "Y2U3ZDhjMjQyZDJlNGY4MDI4ZjkzMGJlNzZmMzUwMTRiMjFiNTI1NTIwOGIxYzA0MTgxYjI1NzQxMzFiNzVhIn19fQ==", sound: "wood" },\
		{ name: "Dispenser", id: [I; 1909690910, -267500525, -1127489729, 295049151], texture: "M2MxMWEwZDkwYzM3ZWI2OTVjOGE1MjNkODYwMWFhMWM4NWZhZDA5YTRkMjIzMmQwNGVkMjNhYzkwZTQzMjVjMiJ9fX0=", sound: "stone" },\
		{ name: "Dried Kelp Block", id: [I; -886334666, -1620619815, -1798076778, -1005972196], texture: "YjgwNWNhZjNkMDJlMzVlNGFhZGMxOWFmMTVlODI3OTAxNzdmMWNkN2I3OWY0ZjViODhkOTQzYWM2YmUyMDNhMSJ9fX0=", sound: "grass" },\
		{ name: "Dropper", id: [I; 1342258687, -2050405689, -1939984080, 2095273293], texture: "MjVlOTE1MmVmZDg5MmY2MGQ3ZTBkN2U1MzM2OWUwNDc3OWVkMzExMWUyZmIyNzUyYjZmNGMyNmRmNTQwYWVkYyJ9fX0=", sound: "stone" },\
		{ name: "Enchanting Table", id: [I; 507409930, 1284720135, -1764460138, 978555378], texture: "YjJmNzkwMTZjYWQ4NGQxYWUyMTYwOWM0ODEzNzgyNTk4ZTM4Nzk2MWJlMTNjMTU2ODI3NTJmMTI2ZGNlN2EifX19", sound: "stone" },\
		{ name: "Ender Chest", id: [I; 1121675190, -1647227906, -1267169239, -1050533352], texture: "YTZjYzQ4NmMyYmUxY2I5ZGZjYjJlNTNkZDlhM2U5YTg4M2JmYWRiMjdjYjk1NmYxODk2ZDYwMmI0MDY3In19fQ==", sound: "stone" },\
		{ name: "Fletching Table", id: [I; 1864804746, 1282428451, -1937034466, -1821441201], texture: "Mjc2MDc3NjA3NGMyM2FlNDExZWQ0NmVmMzI0YTdhMDcyODJmYmZiYmJjNWE5OWZjYjNmNWE4YzlkNmIwMmE1MyJ9fX0=", sound: "wood" },\
		{ name: "Furnace", id: [I; -1654655835, 1990084936, -1611850011, 1004962910], texture: "OTk3MTNlMWNkYzIzZmRhZjM4NDA5NWMzYTNhZDY0YzY3MGQyOGFlOWVlZjkyZDEwZjFlYTA1NWE4NWQ5MGQ0OSJ9fX0=", sound: "stone" },\
		{ name: "Hay Bale", id: [I; 2121391639, 300761991, -1847234753, -2035943531], texture: "YmZlNTY3MjgyZTc4NjA3ZjJjYTJhZWY1ODNiOGVmZWJjOTE5NTlmODRjYWU0YTgzYmVkMTBkY2Q1YjBjZmNjZCJ9fX0=", sound: "grass" },\
		{ name: "Honey Block", id: [I; -778247695, 1837125602, -1780969265, 415697170], texture: "NWI3YjE0ZjNjNzg3ODVjMWZkMjQ0MjU1ZTA1ZDUzN2Q2YzU1MTIwNzI2MmE2MGMzODEyNWMwMWY2NjNhMDc1ZSJ9fX0=", sound: "honey_block" },\
		{ name: "Honeycomb Block", id: [I; -334428575, -678215008, -1273393869, -977753282], texture: "MmM2ODAxNDlhZDE3ZTQ2ZmJiZjc2MDZiMjg0Y2M4M2EwM2IxYTY3Y2Q4YTUyNzE3YjQ0YmZhM2FkNTkxNGYxNCJ9fX0=", sound: "coral_block" },\
		{ name: "Jukebox", id: [I; 886173614, 1449021017, -1415778700, -539820954], texture: "YTYyMGI4MmNmMTFlM2MxMzcxY2M1MWViOWUzMTJkZTcyYTZhNjI2NjQ0OTRlZDJjYjcxODFiMWJkZmJjOTI3OCJ9fX0=", sound: "stone" },\
		{ name: "Jungle Log", id: [I; -1564648924, 2043563170, -1450694614, 1662402020], texture: "MzAyMzUxNGIyODg1OTEzMjk0NmFjZmZmNTNjNTVkNjFjYjNlMWI0NzA2MDQ5YjI1YThmZmVhMzVkZjMzYjRhNCJ9fX0=", sound: "wood" },\
		{ name: "Jungle Planks", id: [I; -1253899014, 1510032467, -1727836853, 1476834528], texture: "ZmQ5ZGQ3ZTU1ZWNiMDI1ZjdmNmNhYTc5OWU0YjBhMGM1NDg2MDk3YTU3N2Q2M2ZmMjIyYmYzMzhmNWViMCJ9fX0=", sound: "wood" },\
		{ name: "Lodestone", id: [I; -1678143801, -903461454, -1477273745, 1985336161], texture: "ZjUwMjE2NTk3ZjE2YmNkYzIyZjEwYTNjYzIyOTljYTg4NGM1N2U0Njg1MGZiOGRlZjAxODk1NjYyZDM5MDQwNCJ9fX0=", sound: "lodestone" },\
		{ name: "Melon", id: [I; 206223347, -2113190707, -1179904260, 691120316], texture: "OTYzNmRlZTgwNmJhNDdhMmM0MGU5NWI1N2ExMmYzN2RlNmMyZTY3N2YyMTYwMTMyYTA3ZTI0ZWVmZmE2In19fQ==", sound: "wood" },\
		{ name: "Observer", id: [I; -547711844, 1039089685, -1124404881, -1339205488], texture: "NjkyZjRmMTU1ZGE5ZjE0MTc3NDY0MjkwODY1YTFiMjVhMjBhZTAyZTA4NzRiYmM5N2RhNTEzZGNmMzM3ZTY1YyJ9fX0=", sound: "stone" },\
		{ name: "Piston", id: [I; -137614125, 1212368822, -2066389118, 577365826], texture: "YWE4NjhjZTkxN2MwOWFmOGU0YzM1MGE1ODA3MDQxZjY1MDliZjJiODlhY2E0NWU1OTFmYmJkN2Q0YjExN2QifX19", sound: "stone" },\
		{ name: "Pumpkin", id: [I; -1375951056, 2015709048, -1419927684, 1532174315], texture: "NjM5NzllOTYzOWExNGMzZDQ2Y2U0NmQ3MTRkNDIzY2IxNTkwOTE4MzlhNzYyY2Y5Mzk3MTZmMTUxMWZkMTUifX19", sound: "wood" },\
		{ name: "Redstone Lamp", id: [I; -1768556495, 436030533, -1381399352, 1211582856], texture: "ZjNlNzFhZDkxOTUyM2VhY2U5Y2Q2MmEyNWIxOGU0ZTE3YWIzOGQxMjU2MjQxZjQyNjJkZmJhNzI5N2M0ZDkyIn19fQ==", sound: "glass" },\
		{ name: "Smithing Table", id: [I; -2000096328, -54505731, -1104823870, 732283982], texture: "MjcyZDFiZTQ4OGQyNjdlY2JlY2Y3ZmJjMzE0MzkwNjM2ZTk0MmI2NDYwNjI4YjAyMTA0YTgzODE4NGI3ZTczNyJ9fX0=", sound: "wood" },\
		{ name: "Smoker", id: [I; -445858831, 131156782, -1826498346, -1637708289], texture: "Yjk5MTA1MWE4M2NiM2M5MWJiYzRhNzY4NWE1ZWVkNWJmOTFlYjc5NzlmOTIxYTAxNDVmYzlmYWYxZWRlNjI2NSJ9fX0=", sound: "stone" },\
		{ name: "Sticky Piston", id: [I; -1419488047, 2133019403, -1833166775, -1157510076], texture: "YzNmYmVjZjNhMmZlMTQ4MGUyOWQ2NGIwNDZkYzAyNjMyODU2NjZlYjA1NzE5NDM0NDYzZDBmYjk2NjUxZDYzZiJ9fX0=", sound: "stone" },\
		{ name: "Stripped Bamboo Block", id: [I; 1100076226, -2129247296, -1210179130, -1133303532], texture: "MmVkNDU2ODRlMjQ2YTQzZDE5NzMzNGY2YjczYjZkODMxNjg3MDRmN2Q3NjM5YWI5ZmJiMzhiODA2MDc0ZmZmNSJ9fX0=", sound: "bamboo_wood" },\
		{ name: "Stripped Jungle Log", id: [I; 1204409710, 489900693, -1422848407, -2081823232], texture: "NmIxZDBjYjY0Y2MzOWNkMWM2MGM3M2NhODBkMDEwNWU1NTQzZGNlM2MyOTYzYTcyOTJmYmY2NzNkZmU3MGQxYyJ9fX0=", sound: "wood" },\
		{ name: "Target", id: [I; -1052173835, 482626680, -1304461617, 553994899], texture: "NzNjM2E5YmRjOGM0MGM0MmQ4NDFkYWViNzFlYTllN2QxYzU0YWIzMWEyM2EyZDkyNjU5MWQ1NTUxNDExN2U1ZCJ9fX0=", sound: "grass" },\
		{ name: "TNT", id: [I; 2108940611, 120472760, -1665635429, 1472141395], texture: "ZGVlYmI4YjAzY2QyN2QzNDM1ZTExNTYxNmI4ZWQzNWRjYjQyN2FmNWIwYjFjYzUyNmQzMjY1YTcyZDQ5M2UifX19", sound: "grass" }\
	],\
	"minecraft:plains": [\
		{ name: "Ancient Debris", id: [I; -314841336, -438940491, -1201343389, -1275161951], texture: "OWZhMjYxMDU0NWM1MTkzYjE3NzZmYWU2ZjVkNmYxNzU3OWQ2MDAyYWVhMDMyZjlmNTJiNTRiZDNiZmY1OWE1MSJ9fX0=", sound: "ancient_debris" },\
		{ name: "Basalt", id: [I; -331058636, -1576973325, -2127451942, -786676635], texture: "YWI4MDAwNDVhOWY1M2MxMjY5M2FiYzkwZDY1YmU1MTY3NGI3YjZiYTRjMDNjNmU3ZGI3NTI0OTg0ODQ0MmE4YyJ9fX0=", sound: "basalt" },\
		{ name: "Bedrock", id: [I; 369902713, -559397082, -1105705496, -509566672], texture: "MzZkMWZhYmRmM2UzNDI2NzFiZDlmOTVmNjg3ZmUyNjNmNDM5ZGRjMmYxYzllYThmZjE1YjEzZjFlN2U0OGI5In19fQ==", sound: "stone" },\
		{ name: "Blackstone Bricks", id: [I; -1057224514, 1348030189, -1299554137, -1629753669], texture: "NzUxYjk0ZjE4OTU3MmE2Njc5NTUzNDE2MzQ5MmQyYTdjMmE3Mjg5YWZjNjNhZGUwNTJmMTFkYWNjNzVhNzQzIn19fQ==", sound: "stone" },\
		{ name: "Blackstone", id: [I; -1194565936, 330711524, -1235409996, -1365090661], texture: "MThmODJjNTRjOTdlNzFlZGFkZTY5MmQ0NzUzZGY1NjAxMzI5Nzk0ZWM1MGFmMWRmNWZmYmMxMDM0ZWM5YmIyNyJ9fX0=", sound: "stone" },\
		{ name: "Block of Netherite", id: [I; 1193984953, 1059343239, -1289252226, 658651064], texture: "NjdlMjlhNThjMDYwNTExZmYwMzUwMjQxYzljODY0OTY5NDdkOGY4NGJmMzJmMmRmMzVlYmUzNzQyZjBlMjAyOSJ9fX0=", sound: "netherite_block" },\
		{ name: "Cherry Log", id: [I; -1023884692, -2141107959, -2111296169, 206907978], texture: "ZGZhODI4NTU1MWQxNmExOGQ2NzI2MGE4OWRiNjBkNTU0NGNjZDFkYzljOGVjZGQyOTdjMzFiNGY5NTQ2YmM0MyJ9fX0=", sound: "cherry_wood" },\
		{ name: "Cherry Planks", id: [I; -1214359766, 306859207, -1906062151, -201328285], texture: "ZWVhNzIwNTk2ZDhjODJlMDM0YzFkMjVmNDBmNjhjZTE4MTFiYWVlNjcxN2IyMWQ2MDA5NzY1ZmIyYmE1ZTlmZCJ9fX0=", sound: "cherry_wood" },\
		{ name: "Chiseled Nether Bricks", id: [I; 863188005, 1664371508, -1212136206, 625995523], texture: "OWViNDcwMTdkMmIzOGY0ZjVkMDVmNzE0NWU5NzIwYTMwMDJlZjdhMjliYjVlNzgyMDZlODFjODkyN2FjMDk2MSJ9fX0=", sound: "nether_bricks" },\
		{ name: "Chiseled Polished Blackstone", id: [I; -9813841, -1884992628, -1380835883, 1780721683], texture: "NmZkOWFlNmQ5YTAxZjAzOGZjYmE5ZGVkNzJjMWNmZDhjNzk0YTZiYTU4ZjllNjVhNDQ0OGNmZmViZWU2NTNlYiJ9fX0=", sound: "stone" },\
		{ name: "Crimson Nylium", id: [I; -1154380309, -1736358854, -1742941410, 984982443], texture: "ZTEwMjllYTQ3Y2EwZTk0NDBhMDc4Mjg3OGM4NGQ2MWQ5MjgxMjRjMTRkYWJkMzIzYzlmYzYwOWJhZDM2YTQ1NyJ9fX0=", sound: "nether_wood" },\
		{ name: "Crimson Planks", id: [I; -836485262, 852707521, -1308409806, 186692215], texture: "YTJjZDY5YTNlNDI1NjRjMGRhNGMyMjk3OTQzYmUyM2FhOWNlMWM3NTZkOGJhOWU2ZWVkZDhmNTIzMjE4ZmRlNCJ9fX0=", sound: "nether_wood" },\
		{ name: "Crimson Stem", id: [I; 1793782074, 1857439110, -1905542052, -743519303], texture: "ODQzYjRjODdmOTc4MThkNzFmMTNhZmE2ZGI5NDZmYjBhMjM1Y2Q3NzFhZTg2OTkyNGM5OGIzZDE3ZDc2NDk5YiJ9fX0=", sound: "nether_wood" },\
		{ name: "Crying Obsidian", id: [I; 590124071, 1680163456, -1377778235, 2063408198], texture: "ZGE1Yzg2ODY0MTFkNDQ2YzkwYzE5MWM5M2Y4MGI5ZmZiMWNkMjQ3YWExMmEyMjZmODk3OTk4MWFkNDM4OGJlZSJ9fX0=", sound: "stone" },\
		{ name: "Gilded Blackstone", id: [I; 1575730194, 775964324, -1610503867, 163413616], texture: "YzQ4MmQxYmE0YmRhYzk5MGY2ZWE5ODc3MDM1ODdmZDc5ZmU1NTU1NTM2MzI1MTk4NDY3OWQ0ZjI3OWNjMGMyYSJ9fX0=", sound: "gilded_blackstone" },\
		{ name: "Glowstone", id: [I; 122630389, -704033691, -1080455880, 726153390], texture: "YzQ2ZDM0OTU4Zjg3MDQxYjVlNGFmNjQxMjM4NjAwYTI3N2YwNjRmZjIyZGMxM2Y2YWY5YjZiZTU1NDdkZDc5MCJ9fX0=", sound: "glass" },\
		{ name: "Magma Block", id: [I; -1357428651, 465257393, -1967451220, -1240446995], texture: "YmI1MDhjNzc5ZjMxMmRhZmYzMzdkMTM3ZjM0ZGQzNjVhM2Y5YzEzMmJkOTJlYjBjNWZmYWI3YzViNGE1NWM1In19fQ==", sound: "stone" },\
		{ name: "Nether Bricks", id: [I; 2013966200, -2012590451, -2132560345, -1236082456], texture: "ZTEyNmRmYWUzMTc2ZjQ3YmFkM2ZhZTEzMWE2NmQ0M2EzYjRlYjdmNDZkZjYxMWNhZTBiZjVjMzgyYzJiNCJ9fX0=", sound: "nether_bricks" },\
		{ name: "Nether Gold Ore", id: [I; 1443083468, 1971472595, -2122128063, 274554715], texture: "YWNhOGMwZmNhOTc4MDg5OWM3MzQ5MmE1ZDJkZTQ0ZmRkZjhkMGZjOWI3NjJmZmU0NTE2NTk0N2RkYjc2MzJiYiJ9fX0=", sound: "nether_gold_ore" },\
		{ name: "Nether Quartz Ore", id: [I; 351783933, 1232489776, -1385409704, -1822148250], texture: "ZjRkNjljNGNkZGY5MDNmYmNjNWE4YzY3Y2MyMmU0ZDkzMjQyNzJkNTJhNDc5NmQ2NjcyNDM1ZDEwMTU5ODk4NSJ9fX0=", sound: "nether_ore" },\
		{ name: "Nether Wart Block", id: [I; 355335389, -1870774045, -1527444966, 1861544407], texture: "Zjg5MTJiYzFhZDNkZGJlMzlhMTliNzM0YTQyZDg1NDg5NjRiYjBhOWNlNThhNTJmMWE2YWUzNzEyMTUyNCJ9fX0=", sound: "wart_block" },\
		{ name: "Netherrack", id: [I; 73823501, 1215317040, -1786262062, -445943537], texture: "OWZjNDRmN2Y3NmVkMTI0NzJmNzA1ZTk5YmI1ZDc5YTQ0NjUzNGU5ZGMwNmQyMjhiYjYxOTQxYzNmYjg0OTQ3YiJ9fX0=", sound: "netherrack" },\
		{ name: "Oak Log", id: [I; 1671593870, -240760377, -1085542796, -2086627135], texture: "NWM0NDI2MjU2NGFjNWEwMDQ5YTk4MjU1OGQwODc3MzNiMGVlMmI1YTJiZjVmYzVmZGFmZTZlMDhmNDk2MTc0YyJ9fX0=", sound: "wood" },\
		{ name: "Oak Planks", id: [I; 633395295, -232963161, -1467812704, 563787538], texture: "MTBmOTZkOWI3MjMwM2YzNzI3OWZhOWMyY2MyM2VlNmY4ZGI2ODIzNjg1YjYyNmI1NmVkNTNiNjc0YjZiMCJ9fX0=", sound: "wood" },\
		{ name: "Obsidian", id: [I; -656341730, -677754867, -1227897108, -287653697], texture: "ODRjMzA4NTVmODliNDkwYzZmZjIzMmRmM2QzZWM3NDMzYWI2MzYxMGE5YTk1N2M4OGE2Y2Q0MzI3YjA2YTQ5ZSJ9fX0=", sound: "stone" },\
		{ name: "Polished Basalt", id: [I; 1303997919, -357350021, -1104006490, 420593090], texture: "NjEyMzUxNmVjMDY5YWUxMjUwMTM1NTQ3ZjU1MDM1ZDM4NDdmNTgxNzhhNWY0NzM5NDMzOTUzNzFhN2ZjM2QyNyJ9fX0=", sound: "basalt" },\
		{ name: "Polished Blackstone", id: [I; -1085736344, -398112775, -1267345573, 1643036065], texture: "NWM5ZWUxZDU1OGE4OWYxMWNkNTc3YTkwYjdiMWI5NmZkYTM0YzIxYzQwMDk2MDM5MDgxNWMyM2RiNTRiNjQ3MSJ9fX0=", sound: "stone" },\
		{ name: "Red Nether Bricks", id: [I; 431522009, 458574629, -1388245934, -172269387], texture: "Mjk1OWFjMjg0ZGZhY2NhNWE4ZTZjMTc5NjA5ODI1ODc1YTc2OGFmMzI5MWM3N2U4YTY4YmQ5MDM0ZGEzZWM2NCJ9fX0=", sound: "nether_bricks" },\
		{ name: "Respawn Anchor", id: [I; -64919969, -1779677883, -1264824476, -965074437], texture: "YjRlNjNlNDViNDRjOGQ4OWZmM2UzM2U1YjYwMTY2Yjc5MWM3MDYwNjY2NDg1NzBiZDViODY0ODBiYTcxZjRiMSJ9fX0=", sound: "stone" },\
		{ name: "Shroomlight", id: [I; -1813529705, -2037365538, -1698419242, -1124969478], texture: "ZDgwNjhhM2U5ZWQwZTY4ODc2OGNmZTAxN2VhZGZmZmM5MjEwNjhmYjRhOGExMGJhYmFkY2U3NWNmNTcyYWFhMyJ9fX0=", sound: "shroomlight" },\
		{ name: "Soul Sand", id: [I; -1538066674, -2048701192, -1339165068, -775416280], texture: "YTg3MDk1ZmFmMzMxNzgzMTJmNjEyOGI5Y2Q0YWZjNTIzMGRiNjA5Y2I2Mzk2M2ZmYmRlYmVmOTQ4MTdiMzM3MyJ9fX0=", sound: "soul_sand" },\
		{ name: "Soul Soil", id: [I; -527978126, -724613687, -1924003672, -1107981359], texture: "ODcwNmY2MmU2NWFhNWUzZGMyNDFlODM2OTIyMTExODE4ZjI4YzliZTJmYzRmNzJlOGY5OGRjY2RjMzE2OTJhYSJ9fX0=", sound: "soul_soil" },\
		{ name: "Stripped Cherry Log", id: [I; -1134756239, 1503086320, -1741805790, 313274031], texture: "YjU2YzA0ZTVjNzJkNGM1ZmJkNjMxNjgzNWE0NTJmMDAxYzIwZTg0ZDJkZGJlZTg0YzY0NDcwNTg0NGI0ZjQ3MSJ9fX0=", sound: "cherry_wood" },\
		{ name: "Stripped Crimson Stem", id: [I; 199086785, -906082067, -1563039494, -1020534999], texture: "NWI2NDMzOGIyNTk1ZjJjY2IyYzcyNzAyZWVhYTM4YjViMTI3YTllYzMyZTc1YWM3ZDFhZDNmZTBjODBjMGZlMCJ9fX0=", sound: "nether_wood" },\
		{ name: "Stripped Oak Log", id: [I; 1353341095, 1033913748, -1475989630, -1195146895], texture: "ZmI4MmNlZDE5NTI3YjZmZmM2MmZiNDA5YzZhZWFmODkzNTdjOWIzZWIzMzc2ZDE5OWE1MDFkYjkwYzI3MTcyOSJ9fX0=", sound: "wood" },\
		{ name: "Stripped Warped Stem", id: [I; -1530293960, -35239145, -1398253348, -377082103], texture: "MjM3NWE1Zjk5N2M2NDA4NzgxYmE1MzNjMmM1ODA0YTRiYTg3YjVjYTM4ZTQzMjk3YzNjODlhZjFiMWU0YWYwNSJ9fX0=", sound: "nether_wood" },\
		{ name: "Warped Nylium", id: [I; 1488690378, 1263879664, -1616710678, -1752882933], texture: "NjFmOTFlNzczODQ3MDQ1ODA3MDRhOWY0NTcwYWM1NGU0YjM2YzE3NTdjNWFkYWI2NWNjNDU0ZTZmZmYyZDNiMCJ9fX0=", sound: "nether_wood" },\
		{ name: "Warped Planks", id: [I; 1562247441, -684636907, -2066693595, 382371432], texture: "MWJmYzc5MTgyNDdkNGU1YjU2YjA1ZGJhMDk1OGRkZjQ2MmM1ZTM1ZDJmZGNiMDgzNjQ4NmZkYzZlODEwNDEyMiJ9fX0=", sound: "nether_wood" },\
		{ name: "Warped Stem", id: [I; 918256636, 690376638, -1595561728, 728587839], texture: "NGFhNGJiNGE3ODJhNjM2NzJhMzM5YTc0Y2QxNzMxMTlkYjA5YTA0NTY4NTA0MDVhMzRjN2MwZjRiZmRiOWQxNSJ9fX0=", sound: "nether_wood" },\
		{ name: "Warped Wart Block", id: [I; 375949507, -923645585, -1549175788, 339205334], texture: "MzIwNTIxMDQ2NTQxNTk4M2MzMmExMjc4Mzc5YWIwMGNkYzY0MDBhZmEzY2RiYzUxOGQ2MmY2NTU3MTUwNGEyMCJ9fX0=", sound: "wart_block" }\
	],\
	"minecraft:savanna": [\
		{ name: "Acacia Log", id: [I; 1499288444, -869709284, -1347003681, -999584136], texture: "NWMxMDBkZDJlMWUyZGMyOTM4NjVmODc0N2M5MDRjNzM3YmFhYjIzNmU2ZTU0Y2NjMmQzYmVkNmQxZmE0MmQzYSJ9fX0=", sound: "wood" },\
		{ name: "Acacia Planks", id: [I; 1903622148, 483610537, -1299850246, 764238268], texture: "NjI5OTY0ZGU4OGJjYWIzZjFiNzYzNTUyYjc5OTExZWYyNGU3NWIzMzUyZjY1ZGJkYThmNThmNjFkMWVhN2YifX19", sound: "wood" },\
		{ name: "Black Glazed Terracotta", id: [I; 1984233547, -846771542, -1220662756, 419687530], texture: "ZWQ0YTMyMWM0YzNiYzdjYzM5MWQ0NWMyZDMwNGE0ZjUyNmJjYWU1YjIzNTY1YTA0MTM1Y2VmODFjZTUxMThjYyJ9fX0=", sound: "stone" },\
		{ name: "Black Terracotta", id: [I; 1261787947, 40517845, -1949648576, 1019252398], texture: "ZTE3ZmY4YmFiYjkxYjRkYmFkNzUyNGU1OGVlZDRiMmY3MTU2NTc0NTk4OWFmOWEyY2NmY2YzMzI4ZjYxYmQyIn19fQ==", sound: "stone" },\
		{ name: "Blue Glazed Terracotta", id: [I; -505595449, 1604995829, -1605030962, 1918804912], texture: "NjgxZTM3NjMyMjE4OGIxZTk4ODMwOWY5OWEwMTVkOTQ5YjY4ZmZlOWM5ZDczY2I5NzgxMzUzOGQwODY0ODk3ZSJ9fX0=", sound: "stone" },\
		{ name: "Blue Terracotta", id: [I; -766369935, 1897024211, -1405092483, -448513465], texture: "N2MxMTY2OTQ3MzFmYmQyNzJjMWZmYTQzNTJhNTM1OWI2YzNhNGNiNTg2NGE3NGE1ZGJlMGY2NjVmODM4NWMifX19", sound: "stone" },\
		{ name: "Brown Glazed Terracotta", id: [I; -997974560, -552777251, -2054748348, 615873270], texture: "YWQ0ZWFhNTQzMDI3MmM0OGUwODFkMDEwYjRmNDRhYjZmNGFlODQxZTM4OTY3YmE2MDY2MDFkYmMzNTAyNmVjYSJ9fX0=", sound: "stone" },\
		{ name: "Brown Terracotta", id: [I; 1508990488, -340245294, -1495803309, 342922208], texture: "NTRiOTMyZjExN2M4N2UxMTE4OWYxYzRjNDBjZmQ5MmJlOTExOWIxMTM3Y2Q2MTBjNjhlZGQ0MWFjNThmMTQifX19", sound: "stone" },\
		{ name: "Cyan Glazed Terracotta", id: [I; -190579139, -1434959626, -1857958191, 302127872], texture: "MTdjNjdhZjgxMzdmZmRjZjg3MzU4ZjdhYjZkYTZkMGVhOThhMDk2MDk5NWMwMmU0ZTk4MTgwMTYzNDhlMWY4MSJ9fX0=", sound: "stone" },\
		{ name: "Cyan Terracotta", id: [I; -1486938408, -2081405037, -2064477303, 1993678789], texture: "NDQ2MzgxMWZkMGM0OGZjZDczYWJjYjdiYmU1YWE1ZWM2YmMyODA5ZmZjNTU3N2QzZjQ1NTlkZjMwNzY1ZiJ9fX0=", sound: "stone" },\
		{ name: "Gray Glazed Terracotta", id: [I; 613642786, 770984460, -1769021760, 531495374], texture: "Nzc3Mjk1NjJjNzQxZTliNzFhZWViZGIzNjQ1NzJmMDk5YzczYzAyNTZkN2Q4Yzg2MzMxZDc0MTdhODAzYzczNCJ9fX0=", sound: "stone" },\
		{ name: "Gray Terracotta", id: [I; 1015268143, 1117670864, -1349924238, 516205472], texture: "OWVmYTdiNWU1ZTYzZDQ2ZDE0NjE1YzYxYmVkMTU0MjdkOTBiMjYxYzdjYTVlODE1OWM0NjZmMDk1NjFkYSJ9fX0=", sound: "stone" },\
		{ name: "Green Glazed Terracotta", id: [I; 1716054884, 1494501442, -1483315573, -746542783], texture: "NmNlODA3ZjBhNmY0OTljZTljY2M2NTAxMGZhYTU0ZWQ0ZTBmZmE2N2NmYjg0OGNkYTE1OWQzZGNhMGEyZGNhNSJ9fX0=", sound: "stone" },\
		{ name: "Green Terracotta", id: [I; -1173745620, 362890300, -2109417545, -372991694], texture: "YjU1ZDUwMTljOGQ1NWJjYjlkYzM0OTRjY2MzNDE5NzU3Zjg5YzMzODRjZjNjOWFiZWMzZjE4ODMxZjM1YjAifX19", sound: "stone" },\
		{ name: "Light Blue Glazed Terracotta", id: [I; 125411748, 117722113, -1782177724, 930626271], texture: "MzFjODk1OTM1MTc0YWM1ZjY0ZWRhZDIxNWNlMGI2YjM4MDEzN2NjNGQxZjM5OWEzZGYxN2RjM2IyZGU0MGJkZSJ9fX0=", sound: "stone" },\
		{ name: "Light Blue Terracotta", id: [I; -135904712, -521515086, -1898779346, -120292784], texture: "ODdiYzhmNWFjMmJmMzM2OTc0MWE5NjJkZTJhZGRiYWExN2QxNWNjNGRhZGIxOWFlZjZlOTQ0ODE3ZTZjMjQifX19", sound: "stone" },\
		{ name: "Light Gray Glazed Terracotta", id: [I; -559616715, -1093973534, -1243771197, 665701758], texture: "NjRjMDRkNmViNWI2ODUyODQzNzBkMDMyY2RiNjljZjJkNGZkMWFlMDA0NTc0ZmI0NDIyZjJiNTU3N2RkMTkzMiJ9fX0=", sound: "stone" },\
		{ name: "Light Gray Terracotta", id: [I; -1622543530, 502222181, -1258818115, 2109815191], texture: "NWNkZTk5YjcyNzI4ZWY4ODE2NDBmYTUwNjhkMTIyZTYxZGQ5Y2Y3MThkYmIzNzA5ZmM1YjMyNmYxYWY1ZCJ9fX0=", sound: "stone" },\
		{ name: "Lime Glazed Terracotta", id: [I; 1625020657, -1529655894, -2116131103, 1006478073], texture: "M2UwYjk3Yzc4NWUzOTc2ZWZhNzhhY2M4MjhkYjY3ZTcxZGVhZDliNjY5NGZkZTYxM2QyZTJlN2NhZmJlMWQ1YiJ9fX0=", sound: "stone" },\
		{ name: "Lime Terracotta", id: [I; 20259118, 2108967181, -1398692454, -111198405], texture: "NTVhMTE3ZTE2MWY3YTI5MWQwYTNhMTY4ZTc3YTIxYjA5ZDM5ZmZkZjU3NzNkMjJhYzAyZjVmYTY2MTFkYjY3In19fQ==", sound: "stone" },\
		{ name: "Magenta Glazed Terracotta", id: [I; -2024602848, 2048806833, -2071373656, -1263728843], texture: "M2U2MTdiZWQ4ZTk3ZDQwODc5OTNlYzBjODk4Zjg3NzJjNDUyYjk5ZDhiNGI5YTQ1ZTNlYzQzNDkzMDQwOWVlOSJ9fX0=", sound: "stone" },\
		{ name: "Magenta Terracotta", id: [I; 413202930, 2009614116, -1372468583, -1835227695], texture: "MzQ0MTUyOGQyODhiMmI3OTczNmNiMjI0ODg3OGZiOTFlZmI0NDYyZDQzYmViZDcxMWY3MzI2YWZiYmY4NSJ9fX0=", sound: "stone" },\
		{ name: "Orange Glazed Terracotta", id: [I; 173953625, 1229013508, -1579041853, -1460332623], texture: "NGFlYjA0ZGU4MTljMTc3NjY4YzUxMzkyNjQzN2QwZWNjMTY4NGUwMjRkMWQ4NjdhZjQ1OTAxY2I0NjFiYjQ3NSJ9fX0=", sound: "stone" },\
		{ name: "Orange Terracotta", id: [I; -534938424, -2013511540, -1155227432, -1158435303], texture: "NzMxNmMxNmIxYWM0NzBkMmMxMTQ0MzRmZjg3MzBmMTgxNTcwOTM4M2RiNmYzY2Y3MjBjMzliNmRjZTIxMTYifX19", sound: "stone" },\
		{ name: "Pink Glazed Terracotta", id: [I; -1097544897, 918897676, -1633823539, 1281938189], texture: "MWMxMjBhYzJmZTJiZDdjZGMyZTg2YTUzNDA4NDQ5ZTM4OTkxNTk5NWQ0OTE3MDEzMWE5YzkyMGRlYjA1OTkyZSJ9fX0=", sound: "stone" },\
		{ name: "Pink Terracotta", id: [I; 1431986052, 719277551, -1301235779, -672556288], texture: "Zjc1ZGI4MWUxNTkyZjMyZDc3MWRkNWRiYzZjM2E1MWU3YTBkNjZiMjJkZmUyOTZiOTY4Njg1MDVjZWVjIn19fQ==", sound: "stone" },\
		{ name: "Purple Glazed Terracotta", id: [I; -445674621, -1233630011, -1242629824, -2048197777], texture: "NmI3NWU4N2Q1MGNiODk2NmEzYTU2ZjczZDBhMTY2NDI5NDhmZjdkMTQ3OWI3ZDU5MDU0MTU0YmY2YmUwM2NkNCJ9fX0=", sound: "stone" },\
		{ name: "Purple Terracotta", id: [I; 1519732176, 1451049770, -1298719179, 1950856516], texture: "ZTZmNTRmODI4MzZhNTU5MjRlZTg1ZGVjNTZiYmJkOGNhMTQ2MzNkYWE5YmZlMzU2NTU5MmVkZjM5YTZkZSJ9fX0=", sound: "stone" },\
		{ name: "Red Glazed Terracotta", id: [I; -1466271984, 825773393, -1540449106, 1241108675], texture: "MmQyMjI1YmZkNjRlN2Y3YmVjOTZiZDgzMGU1YzgxYmMzMGZkZTk2YmJkYTE2YTBjNWJjZTViNWVjMThiNmUxMiJ9fX0=", sound: "stone" },\
		{ name: "Red Terracotta", id: [I; -1995722303, 925909853, -1616145193, 720562595], texture: "OWU0MmY2ODJlNDMwYjU1YjYxMjA0YTZmOGI3NmQ1MjI3ZDI3OGVkOWVjNGQ5OGJkYTRhN2E0ODMwYTRiNiJ9fX0=", sound: "stone" },\
		{ name: "Stripped Acacia Log", id: [I; -1096699264, 94914416, -1879319608, -514112019], texture: "MmI0OGQ5MjM3NTcyNzdhMTIzY2M0OTI3NWI4ODVhNTI4YmQzN2Q2ZjczNGFlZGM5YWViMDYzNzlkNGIwODZjZiJ9fX0=", sound: "wood" },\
		{ name: "Terracotta", id: [I; 536928860, -923448669, -1266304442, -2001152902], texture: "ODJkNWZlZmUyMGRhZjMxYzIzOGVlMjI3ZGQxNDE4MjdhZGE1ZWY4NDgyZDhkMzU3YmJlNWE3Y2Y0MGFmODUifX19", sound: "stone" },\
		{ name: "White Glazed Terracotta", id: [I; 986853233, 572738078, -2073578896, 1590739091], texture: "ZDJkODk1Nzg5ZjM4OTQ3ODhhYWRmNjMxZDg4MDRiODRmOWUzZDdkMmI4N2YwNDhlOTM4ODhiNDhlNmVhMGM4YiJ9fX0=", sound: "stone" },\
		{ name: "White Terracotta", id: [I; -884443472, -1441576651, -1843427814, 1745223002], texture: "NzE1OTU5NDM4OGJmMDEzYTRlM2U2ODY5ZmFhYmNiOTVkMzFkZDNmNGEyNThhNTM1ZTdjYmQ5MmM5OTg2YjcifX19", sound: "stone" },\
		{ name: "Yellow Glazed Terracotta", id: [I; 356378472, 1115639745, -1387145396, 178853557], texture: "ODc4NzI4OTEyNDE0ODUzYTU2M2M5NWNkZjExOWFjNmIyZDQ4NmUzNzg0ZWNlNmJiMTc0NWZhNGI3ZDZjNDAwMiJ9fX0=", sound: "stone" },\
		{ name: "Yellow Terracotta", id: [I; 599596825, -774616473, -1814182099, -2032378612], texture: "NjM1MTdiYzNlYzMyODY5ZDkzOWM4OWQyOTYxZTMwYjcxNjFlYWNkOTI1NWJlYzMxM2JlMjM5NjAyMjFkNDFiNCJ9fX0=", sound: "stone" }\
	],\
	"minecraft:snow": [\
		{ name: "Birch Log", id: [I; 354545958, -1146139371, -1644253515, 82404730], texture: "YTk5MWYzYjczZWJiOWRlYzkxZWRkYzgzNjFjYTJmZWNmNTI4MGQyYzczM2VkYTllY2I2OTVmODNkMTU4MCJ9fX0=", sound: "wood" },\
		{ name: "Birch Planks", id: [I; 1047289262, -427670359, -2029437413, 1110480387], texture: "MjQyNzRhY2Y5NDYzNWE4NzNkZjA5Njg4MmEyNjYxZGNkNDQzMjgyZGIwODg4MGM3NjU1OTQ3YzRjYzY1ZCJ9fX0=", sound: "wood" },\
		{ name: "Black Wool", id: [I; 1018670404, -895662834, -1290313485, 2096360380], texture: "Y2ZhNGRkYTZkMTlhMWZlMmQ5ODhkNjVkZWM1MzQyOTUwNTMwODE2NmM5MDY3YjY4YTQ3NzBjYTVjNDM2Y2Y5NCJ9fX0=", sound: "wool" },\
		{ name: "Blue Ice", id: [I; 1145689685, -626700497, -1848058044, -1329113840], texture: "NTgxYjRmNWYzZDk5NjcyYWIxYTM5ZjVmNDEwYmQ0ZDRmZDkyNTQ4ZTA3ZDE3YmRmMGQ0ZjFmNTdkY2ViYjVjZiJ9fX0=", sound: "glass" },\
		{ name: "Blue Wool", id: [I; -104255801, -483504506, -1942391443, 968293579], texture: "ZWE4MWZjYjUxYmUyYTlmODliMWFkYzlkODcyMzliYTQyOWQ2MzVmYmUwMWIzN2VjMzI5MTY0ODg3YmY2NjViIn19fQ==", sound: "wool" },\
		{ name: "Brown Mushroom Block", id: [I; 433436639, -768390457, -1505795291, -1044176877], texture: "OTNhMWUwNTAxMjRmZTU1YmE3OThkYWUwYmIwM2E0ZWE5N2RkNTk5NWE0YjQwNWFhZGZlNzk2MDFmZjE3OTg4ZCJ9fX0=", sound: "wood" },\
		{ name: "Brown Wool", id: [I; -1220350653, 1286950307, -1723473863, -1467804931], texture: "MjJjYmQ5ZjQzNjE5YWI1Y2IxYjExZjkxY2IwM2U5NTVjNmZjNmM0NThhYmY4OWFiNjEwMzEzNDZhMDkwNjEyZSJ9fX0=", sound: "wool" },\
		{ name: "Calcite", id: [I; 1592369478, -73577914, -1653763014, 132391569], texture: "YTRhZDBkZGQ1M2ZlMmQzMDk1YmUyMDg1NWFhYTU1M2U5ZWViMGY5ODAxMzRjZjVlMDEyOGRjZjI5MDM3ZmY1NiJ9fX0=", sound: "calcite" },\
		{ name: "Cyan Wool", id: [I; -482363864, 138888315, -1742090844, -164276047], texture: "MWZhZGY3NDFhYjc2Y2QzNjIwYWQxNjEzMDAyMDJkN2I1OWEzMzA1MWU1OTY3ZTRiNjE5NGJhYzQwYmIyODBmZiJ9fX0=", sound: "wool" },\
		{ name: "Dark Oak Log", id: [I; 42535380, -1799797722, -1794119031, -1986955833], texture: "YjllOGE3YjM3ZjM0MmU4ZmI0NThhOWM5ODlmNTE5NmMyNjUxYjg3ODExZGU1NGZlMDVlNjFiZjRkMjg3Yjk5YiJ9fX0=", sound: "wood" },\
		{ name: "Dark Oak Planks", id: [I; 1344145446, 913263791, -1201211865, 981810529], texture: "NGZkOTE3ZmQ1OTNhN2FjNWJkZmUxZmM2NWQzMjBkZjQ2MTFkYTQzMWYzZWE0ZjM0YzdhMTkwMjBmNTEyIn19fQ==", sound: "wood" },\
		{ name: "Dripstone Block", id: [I; -44111765, -1260369525, -2099864530, -71592865], texture: "NDg0OWY2NjBkNGY3MzJjYjMyZDkzZmExMTQ5ODMwYzM5NWIzM2RmYjJkMGIwNjcwZDMzMjJkMDkxZTk4NzAxNSJ9fX0=", sound: "dripstone_block" },\
		{ name: "End Stone", id: [I; -612800989, -2065740771, -2037784296, -1339851573], texture: "NDI4MTNjZjhjNGZkMDEzYmFmNWJmNTVhOGM5MzEyMWM0ODJkYTFjZjZlMTA1NGMxODBmZjNlODE3MjdiNjVkZCJ9fX0=", sound: "stone" },\
		{ name: "End Stone Bricks", id: [I; -961744901, 573787723, -1628554524, 1857136053], texture: "NjZkZTY1ZDE4OTY4MTI2ODExMDViYjNjMDE3ZmIzYWNkM2Y0ZGQ2M2IxM2IxOGRhMTRkNTliZTk4NGE2M2Q3In19fQ==", sound: "stone" },\
		{ name: "End Portal Frame", id: [I; 1731735608, -1694282311, -1475170688, 1720316741], texture: "ZjQ2ODRlM2U3ODkwY2FmN2QxMzc2MmVhMTllYjE0YzU5NDBiODhmZDdmMDc3ZDgxZTZlZmZiNGY2ZGYxNmMyNiJ9fX0=", sound: "glass" },\
		{ name: "Gray Wool", id: [I; -879621827, -1921040260, -1774055548, 710689686], texture: "YWRmMjFmNTMyMTIyNTY2YWY4OTNkYTI3ODgwYTFiNjA5NWMzNTcxMmYyOWEzNzhjZmVjYzdmZTJiMTMyOGFiNCJ9fX0=", sound: "wool" },\
		{ name: "Green Wool", id: [I; -631053078, 1382041887, -1706625619, -269273812], texture: "NTM1ODFjMmY5Y2YzNThkN2VkYzc4ZGQ2ZmQ0YjYyNTc1MDFiYzRlNjQ1NWUzM2ZhMGNhYWUyMDdjZjAzMjFhMiJ9fX0=", sound: "wool" },\
		{ name: "Light Blue Wool", id: [I; 809380372, 1806977328, -2143381479, -104781022], texture: "MTYzZTY2NDZmMWMwZDQxZmQzYmY1NTg0YTFjZTA0NGY1YzQ2ZDU5ODI1OGRiNDYyMTYxMTc4NTlmNTdhZjE5NyJ9fX0=", sound: "wool" },\
		{ name: "Light Gray Wool", id: [I; 842498629, -1085977199, -2005401713, 1115910502], texture: "NTUyODhkZGM5MTFhNzVmNzdjM2E1ZDMzNjM2NWE4ZjhiMTM5ZmE1MzkzMGI0YjZlZTEzOTg3NWM4MGNlMzY2YyJ9fX0=", sound: "wool" },\
		{ name: "Lime Wool", id: [I; -1944765384, -1297332936, -1991965547, -542514178], texture: "Nzc0NzJkNjA4ODIxZjQ1YTg4MDUzNzZlYzBjNmZmY2I3ODExNzgyOWVhNWY5NjAwNDFjMmEwOWQxMGUwNGNiNCJ9fX0=", sound: "wool" },\
		{ name: "Magenta Wool", id: [I; -2333631, 714621959, -1769892339, -519658488], texture: "Zjk3MDEyZWQ2YTkyYjA1ZWEwZjE5NDk1MDc0ODU0NGUwNzViYWEyODc4MWNhMzczZDFiMjdlMjhjMjY5NTNjIn19fQ==", sound: "wool" },\
		{ name: "Moss Block", id: [I; -364280010, 2080001923, -1418624310, -860531239], texture: "YWE0Yjc4YThiYWYzOGFhOTdjMWI1ODcwNjgzMGVkOGRkYTRmNzc5MWQ4NmZiNTNhOGY2MWRhNTRhMjQzMWExIn19fQ==", sound: "moss" },\
		{ name: "Mushroom Stem", id: [I; 38683773, -1233042357, -1875708121, 1078220850], texture: "OWRhMzIzZWJiYzRiMWI1NjQ0ZmVlM2EwZjFlNWIxNTUwMWJlNmIxOWEwZmQzOGQzZTBiYTkwM2Y4NjBhM2MyZSJ9fX0=", sound: "wood" },\
		{ name: "Orange Wool", id: [I; 735581399, 682247452, -1943884902, 1828267747], texture: "YWRmMmViMjA1YTIzYzExOTZiM2VjZjIxZTY4YzA3NmI2OTZlNzYxNjNhYzhmYzRmYjlmNTMxOGMyYTVlNWIxYSJ9fX0=", sound: "wool" },\
		{ name: "Packed Ice", id: [I; 1016475138, -249999519, -1546230673, -2127191202], texture: "MjZlNDI5YzYwOTMyZWJjMzY2ZTc5MWE0MmUxODZhZjg4OGRlMDhlNWQ4ZWI4YWM2ZjViNmY0ZDQ0MGRiNDg2YyJ9fX0=", sound: "glass" },\
		{ name: "Pink Wool", id: [I; -158108335, 89342370, -1504859784, -427306912], texture: "ZDA4ODM2NTBlYTkyOWRiMGVhYmRmNWJjNzU1OTlkOGVmMDBkNzAzNDBjZDFjZTVlMDRhZDk1ZWY4ZWQ4M2I3MyJ9fX0=", sound: "wool" },\
		{ name: "Purple Wool", id: [I; 1381169159, 510608452, -1556402199, 1063459988], texture: "ODllYzVhMzAyMjJkMDY1OWIwZGJlZTg0NGI4ZjUzZWFlNjJmZTk1YjRhMzQ0OGE5ZWY3OTBhN2FlZGIyOTZkOSJ9fX0=", sound: "wool" },\
		{ name: "Purpur Block", id: [I; -218011833, -1971699139, -1840463572, 317867737], texture: "NzA4ZjM4MzJiYzE1ZmFjNDE1MjJjZTZlZDFkODhmOTU0M2RkNTcxZjkzNDA3Mzg3NGVmMGNiOWJmY2NlYSJ9fX0=", sound: "stone" },\
		{ name: "Purpur Pillar", id: [I; -636678544, -626441262, -1970267446, -1455894180], texture: "OWE4MmFmNmE2MTJkYTU3ZWMzYmRjZmVhZDhlMDIxODM5NWY2YmNmZjY5MzdmZDM2YjQwMDk0YjVmZGQzZGEwNSJ9fX0=", sound: "stone" },\
		{ name: "Red Mushroom Block", id: [I; -380025694, 1306019937, -1644762318, -1616573100], texture: "ZDVjNTI2NzFhOWRmYTVjZmM5ZDM2YWEzZWZiNWRkMmQwYmJkMWIzMjc5MzIwZjllYmMwODMxYzAzOTczOWVkNCJ9fX0=", sound: "wood" },\
		{ name: "Red Wool", id: [I; -15479960, 170606664, -1592045623, 2084103401], texture: "Njk1M2IxMmEwOTQ2YjYyOWI0YzA4ODlkNDFmZDI2ZWQyNmZiNzI5ZDRkNTE0YjU5NzI3MTI0YzM3YmI3MGQ4ZCJ9fX0=", sound: "wool" },\
		{ name: "Shulker Box", id: [I; -1752214274, 753814970, -1463896858, -1931978021], texture: "MjVjNGQyNGFmZmRkNDgxMDI2MjAzNjE1MjdkMjE1NmUxOGMyMjNiYWU1MTg5YWM0Mzk4MTU2NDNmM2NmZjlkIn19fQ==", sound: "stone" },\
		{ name: "Snow Block", id: [I; 768349495, -1087878101, -1190779486, 726914076], texture: "NDgyZWQ1M2Q5N2U2MjhjYjMwYzlhNDIyZDU3ODU4NTdiNWZjZmJlNjg5NjFlMDdmY2I1MGY0ZTZjMTA1MjAxYiJ9fX0=", sound: "snow" },\
		{ name: "Stripped Birch Log", id: [I; -1437400873, -155957654, -1219808003, -421611827], texture: "NGUyZjk0ZjlmYTUzMmQ4YTJjYTIwNTRhZDkwNDQ0Mzg5OTgxZTZiOGQxMzE5ODNjZTEyOWUyM2JkZDA2ZmZiNSJ9fX0=", sound: "wood" },\
		{ name: "Stripped Dark Oak Log", id: [I; -1555012652, -329823998, -2136856628, 1387766136], texture: "Mzg1ZTEyYTNlZDk3NzczNWI0MWVhMTk4ZTM2ZjFlY2ViMzFmNmIzODg3MzhhYjNkNGZhZGVlNmZiZDY0ZDlhZCJ9fX0=", sound: "wood" },\
		{ name: "White Wool", id: [I; 775398644, -1788787824, -1651766630, 152117032], texture: "ZDA4ZGY2MGM1MTA3NGVlZjI1NDRmZjM4Y2VhZDllMTY2NzVhZTQyNTE5MTYxMDUxODBlMWY4Y2UxOTdhYjNiYyJ9fX0=", sound: "wool" },\
		{ name: "Yellow Wool", id: [I; -1758440255, 2042121585, -1598739664, -369458067], texture: "NGQ5MDUyNjlhY2NhYjI0YjExOTI0ZWJhOGJkOTI5OTFiOGQ4NWNlNDI3NjAyN2ExNjM2YzkzMWI2ZDA2Yzg5ZSJ9fX0=", sound: "wool" }\
	],\
	"minecraft:swamp": [\
		{ name: "Andesite", id: [I; -1578330764, 1321946335, -1560972079, 325468090], texture: "YmM1ZTE2Yzc2MWUwYWFhMmRkNTI4OWU0M2Y1MmNjNDcxNTY3Y2Q4ZjhjOGE0NzVhNGIyOTBhZWU4Y2ZhNDUzOCJ9fX0=", sound: "stone" },\
		{ name: "Block of Amethyst", id: [I; 1642715083, -1150989963, -1404325767, 285862586], texture: "OGI1ZTNkZWNlNDI1YzhiNGNkNDY5MWY3NmEyMThjOGEwZDA0ODBiYTgwMmU2MTI4MmQwMmQwZDU2N2VkOGMzZSJ9fX0=", sound: "amethyst_block" },\
		{ name: "Block of Quartz", id: [I; -1117200372, 1499287091, -1382600217, -587298133], texture: "ZTVlMmIyZWQyOThiNTNjYzg0NzgzY2Q3ODVlYzU3ZGE0OWNlYWFiZGNmZjMxYjI1ZmU1MjU2YjM0MjliNDEyIn19fQ==", sound: "stone" },\
		{ name: "Bone Block", id: [I; -1181032313, 1254379211, -1167652892, -1869539049], texture: "ODZjZTliMThjYTIzOGVhZDY1MTViMDE3MzUzNGE3ZjM0ZDI4YmM1MWMwMTg4ZTJkYjA2ODQ1YzE3ZTYyZjEwYSJ9fX0=", sound: "bone_block" },\
		{ name: "Bricks", id: [I; 1632324956, 496518846, -1778592707, -1349729402], texture: "NGQ2YWJjY2RmZGI1MjMxZjc0NzEwZDc3OGMyMDg0ZjRjOGU0Y2Q2OTEzYTcwZThhNzIxM2FkYjYzOTE5MjUyNyJ9fX0=", sound: "stone" },\
		{ name: "Chiseled Deepslate", id: [I; -1440491201, 751847728, -1921836033, 845136078], texture: "NTM1MWRjMzJmZTBhNTI0ZGU2NjY5NmExYjI4Yzg5YjU5Yzc2YTdlZmRhNjljMmNhMWY4ODdmYWEzOGNhOWZiMyJ9fX0=", sound: "deepslate_bricks" },\
		{ name: "Chiseled Stone Bricks", id: [I; 4575818, -1786622138, -1880514351, -656070278], texture: "MmYyZWI4MjQ5ZTY3MTA0OGRmOTljMDM2ODExYjEyNjE1ZmNjYWVlNTZmNjY3YTUwMmFkYjQwN2NmOGZlMjYxYiJ9fX0=", sound: "stone" },\
		{ name: "Clay", id: [I; -781671474, 194596528, -1278393834, 413024264], texture: "Njc4MjY4MjllYWI1YWQ2MmYwYzExZDlmYWFmZGM5OTU0MzY0ODcxMTYwZGQ4MzllMWFiNWEzYjIxM2EzMyJ9fX0=", sound: "gravel" },\
		{ name: "Cobbled Deepslate", id: [I; -966595565, 1576486419, -1801077148, 1569658488], texture: "YWU0ZTFiYmRkNmUyNTc0YTIxNGNkNjE1YmUwNDE0NmUyODc2YzYzODI1YTY3YjlhMGU4MDcxODFjM2U1Y2JhYiJ9fX0=", sound: "deepslate" },\
		{ name: "Cobblestone", id: [I; 686627684, -1988148325, -2098939964, -950127968], texture: "MzNkNTFmNGQwNjA5OGJiMWY0Y2VmZjYxOWM2ZGRjYTk3NmZjNzBlOWY4ODcxZWJlZTRlZWY2NTgwY2Y3NmIwZiJ9fX0=", sound: "stone" },\
		{ name: "Deepslate", id: [I; -966595565, 1576478227, -1801077148, 1569674872], texture: "NWIyMWFlOTM2MTNiZjAwMWY5NDA3NTJjNTlkNTc4OGExZDgwZjRjNTI1NThhNDI1YzNiYjY2MzI4MzU4OWVkOCJ9fX0=", sound: "deepslate" },\
		{ name: "Deepslate Bricks", id: [I; -933041133, 1576486419, -1801077148, 1569674872], texture: "MjQyZDY0YjRhMTc2OTA1OWJhMTVkZDg4YTZjZjdjYjIxMTM1ZDZiY2U4ZDcyZWJlZjljOWEwZjU2MWI4N2QxZiJ9fX0=", sound: "deepslate" },\
		{ name: "Deepslate Tiles", id: [I; -22197901, 1897353017, -1444928391, 1229371153], texture: "MzUwODY0MGNkZmFlZjZmMTRhYWQ0OGFmZjQ3YWZiODZjMTUxZDIyMjdjNmI0MzBkMGQ1MTg0MDBkN2M0YTg5MSJ9fX0=", sound: "deepslate" },\
		{ name: "Diorite", id: [I; -1248682033, -917159854, -1791654945, 1580895416], texture: "NTVjMWVmMmQ0NDY1NzE1MDZiNTlmOTI5MTAzZDE5NTZmYzMxNTJmZDlkNDAwMjAyNmJjZTViMDI4YzkxN2ZlZiJ9fX0=", sound: "stone" },\
		{ name: "Granite", id: [I; -496161940, -957529972, -1147619051, -1844633414], texture: "OGQ4MzhiMmQwNDg0NzAwMTU1MmU0YmYyZTUzNzMzZWNlNzBmNTU1YzZmNGM2NmYxNzRjYzMxMWYzMDkxYzMyOSJ9fX0=", sound: "stone" },\
		{ name: "Gravel", id: [I; 1855084908, 1576747486, -1742812766, -1814063857], texture: "Yzc1NDMxOGEzMzc2ZjQ3MGU0ODFkZmNkNmM4M2E1OWFhNjkwYWQ0YjRkZDc1NzdmZGFkMWMyZWYwOGQ4YWVlNiJ9fX0=", sound: "gravel" },\
		{ name: "Mangrove Log", id: [I; -364919053, -47100724, -1703450226, 1906312713], texture: "M2Q5YTEwNzUxY2JlMmMzZTBkNjhjODg1YjcyNmMwODIzMjlmMWYyZTE3YTVjNTEyMWE3Y2ZjMTZiNTk1NjM4NCJ9fX0=", sound: "wood" },\
		{ name: "Mangrove Planks", id: [I; -820983196, 1778861998, -2023977136, -273473355], texture: "OTQ0MzMxYjEwN2YxOWI3NTBiMzdlNTNmZmQxNzQ5MDc5NGU4YTViZTQ2ZGJhY2E5YWIyNDFmZmNkYjY1OTU2OCJ9fX0=", sound: "wood" },\
		{ name: "Mossy Cobblestone", id: [I; 1684206543, -658486815, -2035398035, -67162188], texture: "Y2RlNjIwZTE4MDBiM2JlZDViNzcyODYwZDdmNWU0YzNmOGE3MTJhZTQ2MmJmOWE3OTdkNTA0YmUxMzBkYTNiOCJ9fX0=", sound: "stone" },\
		{ name: "Mud", id: [I; -2117054607, -270775264, -1709818464, -1252332469], texture: "ZWVkMjFmNDYzNjIyMTBjNzc2Y2MxNWM0YTkxOWNhNjgxODM3NThjZDZmMDkyM2Y1NzQwMDIxYTkxZWJmOGViNCJ9fX0=", sound: "mud" },\
		{ name: "Mud Bricks", id: [I; -482454474, -812889475, -1734154357, 973656286], texture: "Y2Y4NjExN2NhYjZhZDYxMmQ3ZWM5YWI2M2U2MDg4MDk5MDM4YmY3MTRkMzllYzhhNzFjMjY5ZTM5OWM2ZjU1ZSJ9fX0=", sound: "mud_bricks" },\
		{ name: "Ochre Froglight", id: [I; -844880836, 868108459, -1772569479, -1631224773], texture: "NTc2ODJmZDE3YWM0NGI4NmE3MDVjYTA0YzkyNjU0ZTFlZDkxYTI0Zjg4MGFmMmUwOTU0Y2E3NjYyZjQ3NTU1MiJ9fX0=", sound: "froglight" },\
		{ name: "Packed Mud", id: [I; 1631216381, 1253983808, -1265251806, 1939158585], texture: "OGRjYzlmZTgxODhkMjkyMGVkYjQxZjMxNmE1YzhlZDRiZDExZDc4NjA5OTJjNjNlYzIwNGE1NmE4NDBjODMzOSJ9fX0=", sound: "packed_mud" },\
		{ name: "Pearlescent Froglight", id: [I; 972121567, 1555253827, -1334370818, -2128831286], texture: "ZWY4NzY3MmQ5NzYwYmI1OWQ1MzlmYjVhYWE1ZmE1MDIwMTE4ZDhkM2I3N2ViNTgxNTcxNTNkYWViYWJjZTJhMCJ9fX0=", sound: "froglight" },\
		{ name: "Polished Andesite", id: [I; -1682237925, -1267776126, -1935222986, 1617805337], texture: "Y2E5NzlmNzY2MzNmNWRkYTg5NDk2NTExNzE2OTQ4ZTlkN2I4NTkyZjZlMWU0ODBjNWRlMWM4MzIzOGQzZTMyIn19fQ==", sound: "stone" },\
		{ name: "Polished Deepslate", id: [I; 102005996, -126006164, -1584587583, 1211938671], texture: "YzU5ODBiNTM0N2JiZDQ3NTQ3NmVlYWRkZWM0YmI4YjFkODc1OGY1ZTdhMWMyZDhiYWNhODhmMjY0NzI3YmNlOCJ9fX0=", sound: "deepslate" },\
		{ name: "Polished Diorite", id: [I; -649014898, -1548334898, -1746599682, -227022177], texture: "MzFhMjgxZjQ5NDUyODZjMzFmYTA3NzEyMWY5YjMyYzU4OGZiOTQwNjRkZTdmOTA4Y2YwZTk2NzdjZGRhOGIxIn19fQ==", sound: "stone" },\
		{ name: "Polished Granite", id: [I; 904243914, -1714142776, -1979112023, -210868464], texture: "OWFlNGNmMjJmNDViYjc3YWVmYTVhZmExZjg2NGRkM2M1ZjlkM2U5MmY0M2IzNTg4ZmQxNjJiMmFhOGMifX19", sound: "stone" },\
		{ name: "Reinforced Deepslate", id: [I; -694602394, 900026220, -1602526395, -664649334], texture: "NjlhODczZjI0OGMzOTExMjIxODg3OWNjOWMwMzM0N2VkMTZlN2Y2MDIzOTBhYzdhNjgwNmY4ZTg0OTI3OTRkNSJ9fX0=", sound: "deepslate" },\
		{ name: "Sculk", id: [I; 1657495772, 1139230325, -1643609522, 1780711833], texture: "ZDY3YjU1YzdmZWExMjVjZjkyMzJlODk1ZDk2YzIxMzIwMTE4ZmNmOGNkMjMzNzRiZmY2NmY3YWIwYzk3ZDljYSJ9fX0=", sound: "sculk" },\
		{ name: "Sculk Catalyst", id: [I; -1482790122, 695684307, -1158628516, -567019125], texture: "MzVjMjMxMmMzNzVlMWQzMzQ4MjM0YzcyZjcwMTc2OTJjOTgxNmIxZTU5NGFjZDlmZmMyOWUyNmI4M2MwYjM3ZiJ9fX0=", sound: "sculk_catalyst" },\
		{ name: "Sculk Shrieker", id: [I; -1826771982, 2032486645, -1489617490, 1150198639], texture: "YmIyZDkxYmJmM2NlNWY5MTQ4ZTczOWVlYjA5NjFmMmJhODRiYTQwNmFkMmNhNjcyNDlhNTUzYjhiODE0MzdhNSJ9fX0=", sound: "sculk_shrieker" },\
		{ name: "Smooth Basalt", id: [I; -267774613, 1627737727, -1609485072, -561037189], texture: "YTJlZjQxNjg2NmY0MjRjZDkwZjhhODkwYWJiMjA1NTYyOWU2YzMxYWU3YTc4NDZkYjViMjMxZmQ3YWYwNGI3In19fQ==", sound: "basalt" },\
		{ name: "Smooth Stone", id: [I; -1927610720, 216286942, -1114713063, 1676381676], texture: "OGRkMGNkMTU4YzJiYjY2MTg2NTBlMzk1NGIyZDI5MjM3ZjViNGMwZGRjN2QyNThlMTczODBhYjY5NzlmMDcxIn19fQ==", sound: "stone" },\
		{ name: "Stone", id: [I; 1574779933, -1714798066, -1987665384, 2114116260], texture: "MTU0ODE4MjMzYzgxMTg3M2U4NWY1YTRlYTQ0MjliNzVmMjNiNmFlMGVhNmY1ZmMwZjdiYjQyMGQ3YzQ3MSJ9fX0=", sound: "stone" },\
		{ name: "Stone Bricks", id: [I; -690738039, 1479102128, -1309511330, -152278075], texture: "ODNmYTBmYzA5OTZjZjc3MmQxZGJjMDUyYWEyNWIxMWRhYmFlOTc3ODIwYWY2NjNlZjAyMmQzY2UxZGI2MTEyMiJ9fX0=", sound: "stone" },\
		{ name: "Stripped Mangrove Log", id: [I; -1971450447, -173064017, -2002269743, 2135816623], texture: "OTk5MTE5ZTFkYmNjNGFlM2ZkMzE1ODk4ZjViZTc0MTRjMDUwYTFkNGZkMTM2ZTVjYTEyODQ1YjQxM2E0Njk4NCJ9fX0=", sound: "wood" },\
		{ name: "Tuff", id: [I; 1736968338, 617500086, -1500933999, -16870491], texture: "ZmY5YmY1MzgzZmNlNTQzZTRhYTg4MzVhZjhlY2FlZDY3MDI5ZmQwYWFiYjAzYWMwZmY1YTJlZGVjZWUyY2U0ZCJ9fX0=", sound: "tuff" },\
		{ name: "Verdant Froglight", id: [I; -1394201504, 665603296, -1930484664, -194888099], texture: "ZjI0YzdlNDMyYzk2YjQ4YzBiZWI3YjNiMGIxNTU5ZmMxYjdmOWUyZWJhNzg2OWExZmJlOGYyMjY5NjQ3YTY5NSJ9fX0=", sound: "froglight" }\
	],\
	"minecraft:taiga": [\
		{ name: "Black Concrete", id: [I; 2005968586, -372816795, -1606330677, -1266867476], texture: "NGZjMjM3MmI0NTc1NDJjNjU0ODNhZmExNDQyZTFjMzNhNWZmNzU4ZDM2MmVjZWM0MzQ4Nzk1MTcyODI0ZDg2OSJ9fX0=", sound: "stone" },\
		{ name: "Blue Concrete", id: [I; -517992799, -800635777, -1916863952, -456112211], texture: "NTdjN2EyOTcxMDNkYjA4NGFmNjI3M2I4Nzk4MDVhZmM4NTc3Y2M4MmM3NTJhYzI2NmNmOGQ3YTZlZWE2MCJ9fX0=", sound: "stone" },\
		{ name: "Brain Coral", id: [I; -1665893688, -64271270, -1237356966, 820830712], texture: "OTU3ZGQ0M2U4ZjFjZDEzNzI2YzBmOTlhYzQwNDcxNTA0N2QxMmViNDJhMjhmZmM2YWU5YmZiM2I3MGQ3NjQwYSJ9fX0=", sound: "coral_block" },\
		{ name: "Brown Concrete", id: [I; -1147216834, -474986328, -1425021264, 607657995], texture: "NjUzODEyMGY2MThmMmNjZDNiYmRjMThjZDU3ODJlNjM4MmFlOWVlNzJkMDVmNWY4NjI3NmFkYTU0ZWY3ZWQifX19", sound: "stone" },\
		{ name: "Bubble Coral", id: [I; 1908908961, 1090211476, -1625708862, 1359651145], texture: "MTNmMTgwNWVkY2QzMmI5N2FiMmYxOWEwM2JhYWIxZjhkNGRjNGRiOGVjN2EwMDRiMTRlYjY2NmQwOWZiODdmMiJ9fX0=", sound: "coral_block" },\
		{ name: "Cyan Concrete", id: [I; 1195875438, -1644802223, -2088516836, 1280871231], texture: "ZjMzYjUxZmVmMWQ3ZmRmMTkyNzRiYjc2ZmNlZGVjZWM3YTc3ZDAxMGNiMzRmZTAyOWZiNzk0Y2M1OWFiYSJ9fX0=", sound: "stone" },\
		{ name: "Dark Prismarine", id: [I; -1799842724, 546590149, -1149614187, 490826710], texture: "ZmQ5MTg1OTg5ODk1NDk1OTQ0NDZlODNmMzM4NzM4OTExNzhkYTlkYjQyZjkxMmU1MjcyZTFmYjI0MDMxMmEifX19", sound: "stone" },\
		{ name: "Dirt", id: [I; -905830593, 1342326450, -1087072169, 2030633423], texture: "MWFiNDNiOGMzZDM0ZjEyNWU1YTNmOGI5MmNkNDNkZmQxNGM2MjQwMmMzMzI5ODQ2MWQ0ZDRkN2NlMmQzYWVhIn19fQ==", sound: "gravel" },\
		{ name: "Dirt Path", id: [I; 2130153042, -239382607, -1506588201, -1827759659], texture: "MzVhOWNmZGI3OGFjMWJlYjc4MjNiY2M4N2I3ZTNhZjgyZGFlZTEwYTU3ODM1ZGM0Y2I2MzJiZjFjZWUyMTU4MCJ9fX0=", sound: "grass" },\
		{ name: "Fire Coral", id: [I; -1791347161, -1346943181, -1302204469, -2076365733], texture: "OWZlOGRlZDNjNzRlYWNkNzg0MTJhOTAzYjkwNGY1NTc3ODUwZDFlMjBkMzQ4NzhmZDc3NTk3YWQxNjMzYmY3NCJ9fX0=", sound: "coral_block" },\
		{ name: "Grass Block", id: [I; -33375620, 1874085261, -1350728281, 712933731], texture: "MzQ5YzYzYmM1MDg3MjMzMjhhMTllNTk3ZjQwODYyZDI3YWQ1YzFkNTQ1NjYzYWMyNDQ2NjU4MmY1NjhkOSJ9fX0=", sound: "grass" },\
		{ name: "Gray Concrete", id: [I; 798647880, 520504591, -1580045656, 835383144], texture: "YzA2ZDdiZWZjODJmMjAxZjgzZTE5Mzc2N2U2M2Y4MTAzNzIxNWFmZDQ4M2EzOGQzNjk2NTk4MmNhNmQwIn19fQ==", sound: "stone" },\
		{ name: "Green Concrete", id: [I; 682498106, -2029171087, -1661131006, 1046424684], texture: "ZGZhYjdkYWViOGYzMzNjNzg4NmE3MGVmMzBjYWY0ZGVjNGE4Y2QxMDQ5M2YyMzgwMmYxNTE2YmRkMjNmY2QifX19", sound: "stone" },\
		{ name: "Horn Coral", id: [I; -1764707184, -1929621645, -2140990707, 755500673], texture: "MzQ5MWI2ZTZhZTk0NTFjNDdlMDliZjFmZjIzZDUwZmZmODdiYTU5MjdhNTFmNDZmZmVkZjkyNmM1Y2JkZTc3ZiJ9fX0=", sound: "coral_block" },\
		{ name: "Light Blue Concrete", id: [I; 332011298, 531054921, -1468662549, 1923484379], texture: "ZjQ3N2Y0NDM4OTM2MmM0Yzc2NGM4NDdhOTczOWJjNzhjMzI0NjdlYWI0ZTM4MzBhZTRjOGJlYWMzNDQyZWY5In19fQ==", sound: "stone" },\
		{ name: "Light Gray Concrete", id: [I; -783846850, 1919646, -1941995194, -117665879], texture: "NmJhMGM0YTBmZGNlOTIzYTkwNDgzMjhkNjY0MTQ3YzViOTI0NDkxZjRlZTVmZWE3MWYzZTllYzMxNCJ9fX0=", sound: "stone" },\
		{ name: "Lime Concrete", id: [I; -302860700, 702106748, -1891744892, 781331959], texture: "NGI1OTljNjE4ZTkxNGMyNWEzN2Q2OWY1NDFhMjJiZWJiZjc1MTYxNTI2Mzc1NmYyNTYxZmFiNGNmYTM5ZSJ9fX0=", sound: "stone" },\
		{ name: "Magenta Concrete", id: [I; 1945506371, -386842046, -1107492490, 1899899850], texture: "NjVlZjJkODdmN2MxZGVmNzk1MjNlOTU2NzY3YjgyODRjYTM4OWIyNDI5OWY1ZTQ2NWQ0NTc5ODlkNjJkZjgifX19", sound: "stone" },\
		{ name: "Mycelium", id: [I; 899364665, 1642548533, -1177002133, 1715392746], texture: "N2ViNGM0MWY0ODFlODE2Y2Y0YjUwN2IwYTE3NTk1ZjJiYTFmMjQ2NjRkYzQzMmJlMzQ3ZDRlN2E0ZWIzIn19fQ==", sound: "grass" },\
		{ name: "Orange Concrete", id: [I; 1754405132, 781795802, -1075877496, 1191199993], texture: "NjNmMTNlMjNlYzIzNDY3YWM1ZTZmNjVhODNmMjY4NmViZWNkOTk4NmRmNWY4Y2JjZDZmYWZjNDJlNjYyYjM4In19fQ==", sound: "stone" },\
		{ name: "Pink Concrete", id: [I; 367714912, 438125528, -2041009374, 1198691286], texture: "MjI3NDlkMzdjM2Y5OGQ0NTdiZjU0MDIyYThiNjEzYTQzNTNlZDhkZDJlMTQ5NDI2ZmM0MmRiM2I3ZCJ9fX0=", sound: "stone" },\
		{ name: "Podzol", id: [I; 661929092, -973454540, -2071215363, 692003832], texture: "YTQxOTVmOWE0MzljNmQwZmZkMTk2MTY1N2Y2ZjBhYThlM2EyZjhhMjQ5M2FmYTY2MmFiNWU0MTkzZTAifX19", sound: "gravel" },\
		{ name: "Prismarine", id: [I; -980300118, -193314634, -1234871888, 956659805], texture: "OTdlNTYxNDA2ODZlNDc2YWVmNTUyMGFjYmFiYzIzOTUzNWZmOTdlMjRiMTRkODdmNDk4MmYxMzY3NWMifX19", sound: "stone" },\
		{ name: "Prismarine Bricks", id: [I; 765528172, -1794685228, -1860883561, -1599114995], texture: "MzdjYmEyMzNmZmM0NTdiMzMwNTIyOGIyNWYzNWMwMjMzNTYxMWM5ZWZiNzY2OThiNWU5NGMwZDU0MWI1ZjQifX19", sound: "stone" },\
		{ name: "Purple Concrete", id: [I; -1562366639, 523718562, -1088264808, -416099102], texture: "ZjBjMDVkNTYwZDhlMTNmMGNiMjVjMTVjODMxYmM1OTU0NTBjNWU1NGNlMzVmYTU0ZTE3ZTA0OTUyNjdjIn19fQ==", sound: "stone" },\
		{ name: "Red Concrete", id: [I; -142002610, 2093239173, -1299655714, -773940749], texture: "NjE4NTZjN2IzNzhkMzUwMjYyMTQzODQzZDFmOWZiYjIxOTExYTcxOTgzYmE3YjM5YTRkNGJhNWI2NmJlZGM2In19fQ==", sound: "stone" },\
		{ name: "Rooted Dirt", id: [I; 139604863, 1981236069, -2051264822, 2100814343], texture: "NzYwODk1ZjIzYTYxZGNmYWQzMzliOTJmMmQxNzI5ZDEzNTI4YTg2YjJjYTUyNjdjYTlkZmRmYWU4ZWRkZmZjZCJ9fX0=", sound: "rooted_dirt" },\
		{ name: "Sea Lantern", id: [I; -1893701261, -849854009, -1344276501, -1574668202], texture: "ODI0YzZmZjE3MTRlYjJjM2I4NDRkNDZkMmU1ZWEyZjI2ZDI3M2EzM2VhYWE3NDRhYmY2NDViMDYwYjQ3ZDcifX19", sound: "glass" },\
		{ name: "Sponge", id: [I; -1344168850, 439306773, -2088457258, 1201759056], texture: "MTJmMDk2ZWVmODdkOWYyMGNjYWFiYTJhMDJlZWQ2ZjQzZTY0MzJhNjkyOGZlMTY0NjdjYjRkZWI1ZTc0MTE4YyJ9fX0=", sound: "grass" },\
		{ name: "Spruce Log", id: [I; 2033205319, -547272101, -1113743018, -1306244628], texture: "OWY0YWYyODk4MjVlMTI3ZGFjMzIyMDhiMWUwMzg5YTkyN2VmNDA1NTk3YjZjOWE2NGNlZjAzZjIxZDkyNzNiNSJ9fX0=", sound: "wood" },\
		{ name: "Spruce Planks", id: [I; -603635550, -451850740, -1257033696, -1307669904], texture: "MTBlYjE5NjhmZjJkYTZiY2E2OGY1OWI2MTExNzEzZTA4ZDIyNDk5MjI5ZTEwODY0NDljYmE1MGY3ZGU2NGFlIn19fQ==", sound: "wood" },\
		{ name: "Stripped Spruce Log", id: [I; 1317871041, -1135983640, -1164639572, 53819734], texture: "MmM1NDY0MjViYTA5ZGE5YjQ3OGIzYWJlOWYzZDk5ZTAyNWNmZWViYTZhNTBjZjYyN2JkNTcxYzYzZDBhOWFhZSJ9fX0=", sound: "wood" },\
		{ name: "Tube Coral", id: [I; 813153985, -1087551804, -2115540584, -404321160], texture: "MzlmYzNjZjU1MDhkNDBjMTQ2OTlkNWJmN2YyNTI3NTllMTk1NmFmOWE2NmQxNWE2YzM4NTQzNzhjNjFmNmQ5YSJ9fX0=", sound: "coral_block" },\
		{ name: "White Concrete", id: [I; 874606536, 1073040081, -1396034593, -1410251262], texture: "ZDA5MjVjNDhiMDU2NjI4NDhlYzlmMDY4NWY4NThkODg5ZDNkYTExYjA3MTc4OGVhYTM2Y2NkOGYxZjMxZGUifX19", sound: "stone" },\
		{ name: "Yellow Concrete", id: [I; 225680432, -1102756806, -1374490912, -1133688672], texture: "ZmNhNWJmZjMyNWVkNzFkOTdhMmRkZmM4M2FjZjA1ZmU3ZmQ5Y2I3Y2JkYjE1ZWJiNGYwNTYyMTkwN2U5ZjJiIn19fQ==", sound: "stone" }\
	]\
}
