data modify storage nitwit_trades:db / set value {\
	types: [\
		{ type: "minecraft:desert" },\
		{ type: "minecraft:jungle" },\
		{ type: "minecraft:plains" },\
		{ type: "minecraft:savanna" },\
		{ type: "minecraft:snow" },\
		{ type: "minecraft:swamp" },\
		{ type: "minecraft:taiga" }\
	],\
	"minecraft:desert": [\
		{ name: "cactus",                 texture: "NjEyZGUzYzE5NTQyNDczYjdiMzQ0MWRmZTdkZDM2MGQyNDJlZDMwZGE3NmI0ODUzZDhhMjQxN2I4NTUyM2ZmYyJ9fX0=", sound: "wool" },\
		{ name: "chiseled_red_sandstone", texture: "ZmM0NjFlYzBiMWIxMmViMzNhOTdkYWNiN2IxNzMzOTZjYjk3ODFlMjc3OGE2NWRhMzg5OGY5ZjE4NzkyNjdmMSJ9fX0=", sound: "stone" },\
		{ name: "chiseled_sandstone",     texture: "OTRlOGRjMDg2NWNlZDM4N2QxZjRlYzA5ZWUzMmFjZGZmNjk5ZmYyNjczMDZhNWViOWI3NDVkMTMxYzRiZWZlYSJ9fX0=", sound: "stone" },\
		{ name: "coal_block",             texture: "ZjZjNWVjYWM5NDJjNzdiOTVhYjQ2MjBkZjViODVlMzgwNjRjOTc0ZjljNWM1NzZiODQzNjIyODA2YTQ1NTcifX19",     sound: "stone" },\
		{ name: "coal_ore",               texture: "NzExMTA3ZjcwZjhjYTA0NzRmMDIzMjQzYmQzODJiYmQ2YjQxNDlhZWY0ZjQyYjI1ZGRiYmNmZWM4Nzk4YjRkYyJ9fX0=", sound: "stone" },\
		{ name: "copper_block",           texture: "YTk1ZDdjYjdlMTg3MzkyMTEwMmJkYmEzMDlhYTM4NTUzZjVmZDU4MGQxZWQ5ZDQ0Mzg5ZjUzZTA5ZWNkNWEwMiJ9fX0=", sound: "copper" },\
		{ name: "copper_ore",             texture: "MWJjMmUzOGRiNjYxZGRiNzg0Y2VlM2ZkNzMwMDQ2ZWFiZDU2OGU1MzE5OTMxMmE2MGRjZGYwYWYxYTU1MzVjNyJ9fX0=", sound: "stone" },\
		{ name: "deepslate_coal_ore",     texture: "YWNmOTQ3ODRkN2MxZGM2YTkzYjQxM2JlNTJiNTRmYTc3YjdhNzI1ODY3NWU4NzAyMWIzNGVkMmJmNzUxZGIyMSJ9fX0=", sound: "deepslate" },\
		{ name: "deepslate_copper_ore",   texture: "OWQ2YzFkYjI5YTdmNzQ1YmQ3ODlhMmMyOTQ3NmJkMTNlNzUxNjM3NmNiN2Y2ODBiZjY2ZTE3YjJhNTRhMDgxNiJ9fX0=", sound: "deepslate" },\
		{ name: "deepslate_diamond_ore",  texture: "M2UwYWEzYTk1MjVkODY0NmYwNmIxMmE1NGExOTc3MGVhZjMyMDA1N2M5OGViZjYzZTY2M2ZkZTJkOWQ5YjEzMSJ9fX0=", sound: "deepslate" },\
		{ name: "deepslate_emerald_ore",  texture: "MTEzNTBlMGE2MDY5NjVmMmVmMDk0OTFiYTU0ZWUxMzc5MTVkZTU4YThhMjhhYjEzMGE1M2ZhOGY0MTZiMjhkNSJ9fX0=", sound: "deepslate" },\
		{ name: "deepslate_gold_ore",     texture: "ODBjOWM1ZWIxYmZjZjk5YTBkOGM2ZTgyMmM1MDBjOTk3MTAzNjU3NWY0MDExNzVkNGEwNDAwZWMzMmEzYTFhYyJ9fX0=", sound: "deepslate" },\
		{ name: "deepslate_iron_ore",     texture: "Y2FlY2Y4ZDVhMjFiM2M5ZmM4Y2U1YTU2NjAyMWYzYTJiMGQ5ODY1MmRiYzVkYWVlNDVmN2M2MzY0N2VkMTQxYSJ9fX0=", sound: "deepslate" },\
		{ name: "deepslate_lapis_ore",    texture: "YmM1YmY0OWZlYmVjOTU1ZWIzYjMyOGNlMTcwOWY3YmI5ZjQ2OWMyN2E3ZmY0MGQxMzA2OTQyYzA4Zjk2MjUwZSJ9fX0=", sound: "deepslate" },\
		{ name: "deepslate_redstone_ore", texture: "NmMzNjFhZjk2YWMyYzk5Nzc0NTA4Mzg0NDY0NTI3OTk4N2FjYTY1Njc5MDQ2ZTVhZGJhNzdmYzVmNGYyODFkMCJ9fX0=", sound: "deepslate" },\
		{ name: "diamond_block",          texture: "OTYzMTU5N2RjZTRlNDA1MWU4ZDVhNTQzNjQxOTY2YWI1NGZiZjI1YTBlZDYwNDdmMTFlNjE0MGQ4OGJmNDhmIn19fQ==", sound: "metal" },\
		{ name: "diamond_ore",            texture: "NzMzYjZjOTA3ZjFjMmExYWU1NGY5MGFhZmJjOWU1NjFmMmY0ZGQ0ZWM0YjczZTU2ZDU0OTU1YmMxZGZjYzJhMCJ9fX0=", sound: "stone" },\
		{ name: "emerald_block",          texture: "YWFiOGZhNzY1NTU1MTVlMmRjYmUzODMzNmM2OTE4NDFhOWMyM2Q5OWM4OGY2NWQ5NmY0NDQ3Nzc1YmNjMTZlYiJ9fX0=", sound: "metal" },\
		{ name: "emerald_ore",            texture: "YmE0MGJhZWI5NmZlYTFiZDZlZTA2NDY5NmNkYjc0ZmZkMDhhNmY3YzQwNjE3ZDQ2MmU0ZTJkYThmYWFmNzNlNSJ9fX0=", sound: "stone" },\
		{ name: "exposed_copper",         texture: "NzFlMjE5OTQyNDRiMDI5YWYzODUyMGE3MTM4NDllZDcxZWYyOTU4NmJkMjg2Y2VkMmJhMTY3NWJhNWY0YTQ0ZSJ9fX0=", sound: "copper" },\
		{ name: "gold_block",             texture: "ZmRjZjVmNzhiZjFkOWFkZTEyNmIyYzdmNmI0OTgwZGNmZTg5YjRlNjVjZDUzMmZjNjVhZDhiNzU3MjUzMGM1YiJ9fX0=", sound: "metal" },\
		{ name: "gold_ore",               texture: "ODViNGFiZDRmMDdiNjg5NDYwN2NiZDg3MDg2OGY2N2UwMjVjN2ZiNTUyYTFhNTdmNTZmNzdjMDQ0Y2NhNDFjZSJ9fX0=", sound: "stone" },\
		{ name: "iron_block",             texture: "MTI2Yjc3MjMyOWNmMzJmODY0M2M0OTI4NjI2YjZhMzI1MjMzZmY2MWFhOWM3NzI1ODczYTRiZDY2ZGIzZDY5MiJ9fX0=", sound: "metal" },\
		{ name: "iron_ore",               texture: "ODM4NWFhZWRkNzg0ZmFlZjhlOGY2Zjc4MmZhNDhkMDdjMmZjMmJiY2Y2ZmVhMWZiYzliOTg2MmQwNWQyMjhjMSJ9fX0=", sound: "stone" },\
		{ name: "lapis_block",            texture: "ODZmNDc2ODcxZWQyM2Y3OWU3YjlkNDk1NDg5ODg3ZTI0NGM2MTljNWUxOWU0MWNmOTViMjcxYTJlYmU3NSJ9fX0=",     sound: "stone" },\
		{ name: "lapis_ore",              texture: "NTEwMDFiNDI1MTExYmZlMGFjZmY3MTBhOGI0MWVhOTVlM2I5MzZhODVlNWJiNjUxNzE2MGJhYjU4N2U4ODcwZiJ9fX0=", sound: "stone" },\
		{ name: "oxidized_copper",        texture: "NDhmZDk4NzlmODZlMjI5ZmU4MDNkNjFkOTNlYmVjYTk2M2IyMzIzZmM5YTU5NGIxMjFiMjI5YjVjOTI1NzBlIn19fQ==", sound: "copper" },\
		{ name: "raw_copper_block",       texture: "OWExMjJiMzEyYzAzN2NjZmYxZTUyYTU5M2I2ZGIyNjRlMWI0Y2M5NjQ5YjRmNzYzYjY1OTYyZjFhMThjMzI4NCJ9fX0=", sound: "stone" },\
		{ name: "raw_gold_block",         texture: "ZWFkZGZmNjkxNmU2NDEwZGY2Yjg4MzE1OGFlYWRhY2U2YjM2NzMzMzc0YmU2YmVkMTgyMWUzZTc0Yzk1ZDkxYiJ9fX0=", sound: "stone" },\
		{ name: "raw_iron_block",         texture: "NDQ3ZjJlMzlkOTZlNWQwNDM4NjQ3M2RhZjBlYjBhZTAwYjE3ZmEwMTU1NTZjOWNhMzlmOGUyZGU4YTIzNjlmMiJ9fX0=", sound: "stone" },\
		{ name: "red_sand",               texture: "YTNjYjU0NjRhYjliODUxYjlkNGFjOGI4Y2RiYjg2NWU3NGM1ODliMzQ4NWFiZWNlNTg5ZDQyOWQ4OTlhZWQifX19",     sound: "sand" },\
		{ name: "red_sandstone",          texture: "YWUxMmIzNDQ5YTczNjRkNGEwNDczMDZmZWI5YTU3YWI3Nzg3YTc3NjBhYjE2NjA3ZjkwMzk2YmQxMDdmZjU2ZiJ9fX0=", sound: "stone" },\
		{ name: "redstone_block",         texture: "YmI3OGZhNWRlZmU3MmRlYmNkOWM3NmFiOWY0ZTExNDI1MDQ3OWJiOWI0NGY0Mjg4N2JiZjZmNzM4NjEyYiJ9fX0=",     sound: "metal" },\
		{ name: "redstone_ore",           texture: "NjMyY2NmNzgxNDUzOWE2MWY4YmZjMTViY2YxMTFhMzlhZDhhZTE2M2MzNmU0NGI2Mzc5NDE1NTU2NDc1ZDcyYSJ9fX0=", sound: "stone" },\
		{ name: "trial_spawner",          texture: "Y2ZlMmY1MTE2NzdkMzljNDNlYTM3NjUxMmI2OTIxMmU0NWU4MTBkYzljZjk2NmRiY2M4OTgwZDllMDE2NzY3NCJ9fX0=", sound: "trial_spawner" },\
		{ name: "sand",                   texture: "NTMzOThhYjNjYjY5NmIzNDQzMGJlOTQ0YjE0YWZiZDIyN2ZkODdlOTkwMjZiY2ZjOGI3Mzg3YTg2MWJkZSJ9fX0=",     sound: "sand" },\
		{ name: "sandstone",              texture: "NDhmODBlOWIyZDY1OTNhMzJkN2M0NGM4YmM4NjBmZWJhMzRiMzRmOGQ1NGQwY2RiNzIxMWUyM2U4ZGRjMzNhNCJ9fX0=", sound: "stone" },\
		{ name: "spawner",                texture: "OTdiMjE4OTMwMGYzMzliYTA1MGUwMWFlMmE1NDBiN2U4OWVmODk2YTU1Yzc5MTZkY2M5ZTU4NTFhZjg2NDExZSJ9fX0=", sound: "metal" },\
		{ name: "vault",                  texture: "YTBhZTI5NDU1NGI3NDJmZjk1MmY3ZTY2NTNmZjM3ZDQzZmQwYTM0OWI2ZjI0NGZiMjA1MWViNTYzYjEzYmRiOSJ9fX0=", sound: "vault" },\
		{ name: "vault",                  texture: "MmE5Zjk2NzUzMTIyMDhkY2UzNWY0M2U3ZmQ3YzUxMTQyZjQzOTU4OTNhMmQzYTE2OTM5YTAxODI1ZGM3MDdhOSJ9fX0=", sound: "vault" },\
		{ name: "weathered_copper",       texture: "ZGE1N2U0NmViMWVhZDkwNzFjZDhkNjEzYTgxY2Q1NWM1OTMxY2I2ZGJhZTRkZmJmMTQ1OGYyOGY5OWVlN2Y0NCJ9fX0=", sound: "copper" }\
	],\
	"minecraft:jungle": [\
		{ name: "bamboo_block",          texture: "M2FjMTZiMDdkMzAxN2QxNTliZTdhYjMxMTg1ZDg0OTBmODE2YWVkMDBmYWM0ODJmMTJlMzNhNGQ3Y2ZlOGY1MSJ9fX0=", sound: "bamboo_wood" },\
		{ name: "bamboo_mosaic",         texture: "NWQ0YWJmNWFjZGM3ZjA3OWViYjk0ODc3YmMyNmE2ZDhkMGMzZjc2MjA2NGFjM2Y3NGYzNDNlNzg2NjkyZTRlZiJ9fX0=", sound: "bamboo_wood" },\
		{ name: "bamboo_planks",         texture: "NTYxNWViZWE3ODUwZTlkN2I1MGI5NjhlMDA5OWVmOTMyNTY2MjU3ODEyMTBmMDJhZTlkNTA4MWY4NmI3MDQ2MyJ9fX0=", sound: "bamboo_wood" },\
		{ name: "barrel",                texture: "NjdjMmRkNmEzMTRjZDJkNDY0MWZjYmFiMzI1Njc0MTM0MDEwMTA5MTNjNTQwOTc1NDk2NWRmZDc0MTU4ZjMzNyJ9fX0=", sound: "wood" },\
		{ name: "beacon",                texture: "MzUyNzIzYWEwNjM3ZWE1MjA0NDQ3YmU1MzYxNTFmNTI5ZmU0OTA2ODI2ZDhjMDY2YzRkY2M1MDA3OWE2NDQ2NSJ9fX0=", sound: "stone" },\
		{ name: "bee_nest",              texture: "ZTA0MGFiZTU4ZDhiZDczYWZmYzMwYTdkMDc1NDBhNjc0NWU5NmNjNGNjYWFiNWY3MTU0MGY0YzM2NmZkMDU1YiJ9fX0=", sound: "wood" },\
		{ name: "beehive",               texture: "YjlkY2U1OWJhNzJmODQ3MzZlMWVhOWMzYjQzZWIxYWFkYzQ5N2IyOTA0YTFjZGEwODk3MjY5MmRjMWI0Y2E3NSJ9fX0=", sound: "wood" },\
		{ name: "blast_furnace",         texture: "ZTgzMDZiZjhlZTQwMzZhNmZkYjQ4NDE2NzBiMzE3Mjg5NDg1MDMxYjU2NTQ1ZDNkMWE1YzBlNTc0ZWNmZDFkNCJ9fX0=", sound: "stone" },\
		{ name: "bookshelf",             texture: "N2Y2YmY5NThhYmQ3ODI5NWVlZDZmZmMyOTNiMWFhNTk1MjZlODBmNTQ5NzY4MjllYTA2ODMzN2MyZjVlOCJ9fX0=",     sound: "wood" },\
		{ name: "cartography_table",     texture: "ZDkwOTdjYTU5MzM0MDIwZTRjMTZkNWJhMzZjYjI0NTgwZWU2NmM5YzJmNDI1YTNiNTY1NGZkYzQ3YjhkYjZmNiJ9fX0=", sound: "wood" },\
		{ name: "chest",                 texture: "ZDVjNmRjMmJiZjUxYzM2Y2ZjNzcxNDU4NWE2YTU2ODNlZjJiMTRkNDdkOGZmNzE0NjU0YTg5M2Y1ZGE2MjIifX19",     sound: "wood" },\
		{ name: "command_block",         texture: "NWY0YzIxZDE3YWQ2MzYzODdlYTNjNzM2YmZmNmFkZTg5NzMxN2UxMzc0Y2Q1ZDliMWMxNWU2ZTg5NTM0MzIifX19",     sound: "metal" },\
		{ name: "composter",             texture: "NTNjYjhmNjFlN2Y2YmY5NTdhMjEzNGU5NmZhZWIwZmM5MjQxMzdkNGJmZjg4ZDk1MThiMmJmNjYyNTg2YzkyZSJ9fX0=", sound: "wood" },\
		{ name: "crafter",               texture: "ZjU3YzdlOTZhODAyYzI3MDgwYzdmODA1MzgxNDM2OGVhOTRkZjg2NDQ1OTEyMGU1MTU1NzE4YjUwM2MzZWQ3In19fQ==", sound: "stone" },\
		{ name: "crafting_table",        texture: "Y2U3ZDhjMjQyZDJlNGY4MDI4ZjkzMGJlNzZmMzUwMTRiMjFiNTI1NTIwOGIxYzA0MTgxYjI1NzQxMzFiNzVhIn19fQ==", sound: "wood" },\
		{ name: "dispenser",             texture: "M2MxMWEwZDkwYzM3ZWI2OTVjOGE1MjNkODYwMWFhMWM4NWZhZDA5YTRkMjIzMmQwNGVkMjNhYzkwZTQzMjVjMiJ9fX0=", sound: "stone" },\
		{ name: "dried_kelp_block",      texture: "YjgwNWNhZjNkMDJlMzVlNGFhZGMxOWFmMTVlODI3OTAxNzdmMWNkN2I3OWY0ZjViODhkOTQzYWM2YmUyMDNhMSJ9fX0=", sound: "grass" },\
		{ name: "dropper",               texture: "MjVlOTE1MmVmZDg5MmY2MGQ3ZTBkN2U1MzM2OWUwNDc3OWVkMzExMWUyZmIyNzUyYjZmNGMyNmRmNTQwYWVkYyJ9fX0=", sound: "stone" },\
		{ name: "enchanting_table",      texture: "YjJmNzkwMTZjYWQ4NGQxYWUyMTYwOWM0ODEzNzgyNTk4ZTM4Nzk2MWJlMTNjMTU2ODI3NTJmMTI2ZGNlN2EifX19",     sound: "stone" },\
		{ name: "ender_chest",           texture: "YTZjYzQ4NmMyYmUxY2I5ZGZjYjJlNTNkZDlhM2U5YTg4M2JmYWRiMjdjYjk1NmYxODk2ZDYwMmI0MDY3In19fQ==",     sound: "stone" },\
		{ name: "fletching_table",       texture: "Mjc2MDc3NjA3NGMyM2FlNDExZWQ0NmVmMzI0YTdhMDcyODJmYmZiYmJjNWE5OWZjYjNmNWE4YzlkNmIwMmE1MyJ9fX0=", sound: "wood" },\
		{ name: "furnace",               texture: "OTk3MTNlMWNkYzIzZmRhZjM4NDA5NWMzYTNhZDY0YzY3MGQyOGFlOWVlZjkyZDEwZjFlYTA1NWE4NWQ5MGQ0OSJ9fX0=", sound: "stone" },\
		{ name: "hay_block",             texture: "YmZlNTY3MjgyZTc4NjA3ZjJjYTJhZWY1ODNiOGVmZWJjOTE5NTlmODRjYWU0YTgzYmVkMTBkY2Q1YjBjZmNjZCJ9fX0=", sound: "grass" },\
		{ name: "honey_block",           texture: "NWI3YjE0ZjNjNzg3ODVjMWZkMjQ0MjU1ZTA1ZDUzN2Q2YzU1MTIwNzI2MmE2MGMzODEyNWMwMWY2NjNhMDc1ZSJ9fX0=", sound: "honey_block" },\
		{ name: "honeycomb_block",       texture: "MmM2ODAxNDlhZDE3ZTQ2ZmJiZjc2MDZiMjg0Y2M4M2EwM2IxYTY3Y2Q4YTUyNzE3YjQ0YmZhM2FkNTkxNGYxNCJ9fX0=", sound: "coral_block" },\
		{ name: "jukebox",               texture: "YTYyMGI4MmNmMTFlM2MxMzcxY2M1MWViOWUzMTJkZTcyYTZhNjI2NjQ0OTRlZDJjYjcxODFiMWJkZmJjOTI3OCJ9fX0=", sound: "stone" },\
		{ name: "jungle_log",            texture: "MzAyMzUxNGIyODg1OTEzMjk0NmFjZmZmNTNjNTVkNjFjYjNlMWI0NzA2MDQ5YjI1YThmZmVhMzVkZjMzYjRhNCJ9fX0=", sound: "wood" },\
		{ name: "jungle_planks",         texture: "ZmQ5ZGQ3ZTU1ZWNiMDI1ZjdmNmNhYTc5OWU0YjBhMGM1NDg2MDk3YTU3N2Q2M2ZmMjIyYmYzMzhmNWViMCJ9fX0=",     sound: "wood" },\
		{ name: "lodestone",             texture: "ZjUwMjE2NTk3ZjE2YmNkYzIyZjEwYTNjYzIyOTljYTg4NGM1N2U0Njg1MGZiOGRlZjAxODk1NjYyZDM5MDQwNCJ9fX0=", sound: "lodestone" },\
		{ name: "melon",                 texture: "OTYzNmRlZTgwNmJhNDdhMmM0MGU5NWI1N2ExMmYzN2RlNmMyZTY3N2YyMTYwMTMyYTA3ZTI0ZWVmZmE2In19fQ==",     sound: "wood" },\
		{ name: "observer",              texture: "NjkyZjRmMTU1ZGE5ZjE0MTc3NDY0MjkwODY1YTFiMjVhMjBhZTAyZTA4NzRiYmM5N2RhNTEzZGNmMzM3ZTY1YyJ9fX0=", sound: "stone" },\
		{ name: "piston",                texture: "YWE4NjhjZTkxN2MwOWFmOGU0YzM1MGE1ODA3MDQxZjY1MDliZjJiODlhY2E0NWU1OTFmYmJkN2Q0YjExN2QifX19",     sound: "stone" },\
		{ name: "pumpkin",               texture: "NjM5NzllOTYzOWExNGMzZDQ2Y2U0NmQ3MTRkNDIzY2IxNTkwOTE4MzlhNzYyY2Y5Mzk3MTZmMTUxMWZkMTUifX19",     sound: "wood" },\
		{ name: "redstone_lamp",         texture: "ZjNlNzFhZDkxOTUyM2VhY2U5Y2Q2MmEyNWIxOGU0ZTE3YWIzOGQxMjU2MjQxZjQyNjJkZmJhNzI5N2M0ZDkyIn19fQ==", sound: "glass" },\
		{ name: "smithing_table",        texture: "MjcyZDFiZTQ4OGQyNjdlY2JlY2Y3ZmJjMzE0MzkwNjM2ZTk0MmI2NDYwNjI4YjAyMTA0YTgzODE4NGI3ZTczNyJ9fX0=", sound: "wood" },\
		{ name: "smoker",                texture: "Yjk5MTA1MWE4M2NiM2M5MWJiYzRhNzY4NWE1ZWVkNWJmOTFlYjc5NzlmOTIxYTAxNDVmYzlmYWYxZWRlNjI2NSJ9fX0=", sound: "stone" },\
		{ name: "sticky_piston",         texture: "YzNmYmVjZjNhMmZlMTQ4MGUyOWQ2NGIwNDZkYzAyNjMyODU2NjZlYjA1NzE5NDM0NDYzZDBmYjk2NjUxZDYzZiJ9fX0=", sound: "stone" },\
		{ name: "stripped_bamboo_block", texture: "MmVkNDU2ODRlMjQ2YTQzZDE5NzMzNGY2YjczYjZkODMxNjg3MDRmN2Q3NjM5YWI5ZmJiMzhiODA2MDc0ZmZmNSJ9fX0=", sound: "bamboo_wood" },\
		{ name: "stripped_jungle_log",   texture: "NmIxZDBjYjY0Y2MzOWNkMWM2MGM3M2NhODBkMDEwNWU1NTQzZGNlM2MyOTYzYTcyOTJmYmY2NzNkZmU3MGQxYyJ9fX0=", sound: "wood" },\
		{ name: "target",                texture: "NzNjM2E5YmRjOGM0MGM0MmQ4NDFkYWViNzFlYTllN2QxYzU0YWIzMWEyM2EyZDkyNjU5MWQ1NTUxNDExN2U1ZCJ9fX0=", sound: "grass" },\
		{ name: "tnt",                   texture: "ZGVlYmI4YjAzY2QyN2QzNDM1ZTExNTYxNmI4ZWQzNWRjYjQyN2FmNWIwYjFjYzUyNmQzMjY1YTcyZDQ5M2UifX19",     sound: "grass" }\
	],\
	"minecraft:plains": [\
		{ name: "ancient_debris",               texture: "OWZhMjYxMDU0NWM1MTkzYjE3NzZmYWU2ZjVkNmYxNzU3OWQ2MDAyYWVhMDMyZjlmNTJiNTRiZDNiZmY1OWE1MSJ9fX0=", sound: "ancient_debris" },\
		{ name: "basalt",                       texture: "YWI4MDAwNDVhOWY1M2MxMjY5M2FiYzkwZDY1YmU1MTY3NGI3YjZiYTRjMDNjNmU3ZGI3NTI0OTg0ODQ0MmE4YyJ9fX0=", sound: "basalt" },\
		{ name: "bedrock",                      texture: "MzZkMWZhYmRmM2UzNDI2NzFiZDlmOTVmNjg3ZmUyNjNmNDM5ZGRjMmYxYzllYThmZjE1YjEzZjFlN2U0OGI5In19fQ==", sound: "stone" },\
		{ name: "blackstone",                   texture: "MThmODJjNTRjOTdlNzFlZGFkZTY5MmQ0NzUzZGY1NjAxMzI5Nzk0ZWM1MGFmMWRmNWZmYmMxMDM0ZWM5YmIyNyJ9fX0=", sound: "stone" },\
		{ name: "cherry_log",                   texture: "ZGZhODI4NTU1MWQxNmExOGQ2NzI2MGE4OWRiNjBkNTU0NGNjZDFkYzljOGVjZGQyOTdjMzFiNGY5NTQ2YmM0MyJ9fX0=", sound: "cherry_wood" },\
		{ name: "cherry_planks",                texture: "ZWVhNzIwNTk2ZDhjODJlMDM0YzFkMjVmNDBmNjhjZTE4MTFiYWVlNjcxN2IyMWQ2MDA5NzY1ZmIyYmE1ZTlmZCJ9fX0=", sound: "cherry_wood" },\
		{ name: "chiseled_nether_bricks",       texture: "OWViNDcwMTdkMmIzOGY0ZjVkMDVmNzE0NWU5NzIwYTMwMDJlZjdhMjliYjVlNzgyMDZlODFjODkyN2FjMDk2MSJ9fX0=", sound: "nether_bricks" },\
		{ name: "chiseled_polished_blackstone", texture: "NmZkOWFlNmQ5YTAxZjAzOGZjYmE5ZGVkNzJjMWNmZDhjNzk0YTZiYTU4ZjllNjVhNDQ0OGNmZmViZWU2NTNlYiJ9fX0=", sound: "stone" },\
		{ name: "crimson_nylium",               texture: "ZTEwMjllYTQ3Y2EwZTk0NDBhMDc4Mjg3OGM4NGQ2MWQ5MjgxMjRjMTRkYWJkMzIzYzlmYzYwOWJhZDM2YTQ1NyJ9fX0=", sound: "nether_wood" },\
		{ name: "crimson_planks",               texture: "YTJjZDY5YTNlNDI1NjRjMGRhNGMyMjk3OTQzYmUyM2FhOWNlMWM3NTZkOGJhOWU2ZWVkZDhmNTIzMjE4ZmRlNCJ9fX0=", sound: "nether_wood" },\
		{ name: "crimson_stem",                 texture: "ODQzYjRjODdmOTc4MThkNzFmMTNhZmE2ZGI5NDZmYjBhMjM1Y2Q3NzFhZTg2OTkyNGM5OGIzZDE3ZDc2NDk5YiJ9fX0=", sound: "nether_wood" },\
		{ name: "crying_obsidian",              texture: "ZGE1Yzg2ODY0MTFkNDQ2YzkwYzE5MWM5M2Y4MGI5ZmZiMWNkMjQ3YWExMmEyMjZmODk3OTk4MWFkNDM4OGJlZSJ9fX0=", sound: "stone" },\
		{ name: "gilded_blackstone",            texture: "YzQ4MmQxYmE0YmRhYzk5MGY2ZWE5ODc3MDM1ODdmZDc5ZmU1NTU1NTM2MzI1MTk4NDY3OWQ0ZjI3OWNjMGMyYSJ9fX0=", sound: "gilded_blackstone" },\
		{ name: "glowstone",                    texture: "YzQ2ZDM0OTU4Zjg3MDQxYjVlNGFmNjQxMjM4NjAwYTI3N2YwNjRmZjIyZGMxM2Y2YWY5YjZiZTU1NDdkZDc5MCJ9fX0=", sound: "glass" },\
		{ name: "magma_block",                  texture: "YmI1MDhjNzc5ZjMxMmRhZmYzMzdkMTM3ZjM0ZGQzNjVhM2Y5YzEzMmJkOTJlYjBjNWZmYWI3YzViNGE1NWM1In19fQ==", sound: "stone" },\
		{ name: "nether_bricks",                texture: "ZTEyNmRmYWUzMTc2ZjQ3YmFkM2ZhZTEzMWE2NmQ0M2EzYjRlYjdmNDZkZjYxMWNhZTBiZjVjMzgyYzJiNCJ9fX0=",     sound: "nether_bricks" },\
		{ name: "nether_gold_ore",              texture: "YWNhOGMwZmNhOTc4MDg5OWM3MzQ5MmE1ZDJkZTQ0ZmRkZjhkMGZjOWI3NjJmZmU0NTE2NTk0N2RkYjc2MzJiYiJ9fX0=", sound: "nether_gold_ore" },\
		{ name: "nether_quartz_ore",            texture: "ZjRkNjljNGNkZGY5MDNmYmNjNWE4YzY3Y2MyMmU0ZDkzMjQyNzJkNTJhNDc5NmQ2NjcyNDM1ZDEwMTU5ODk4NSJ9fX0=", sound: "nether_ore" },\
		{ name: "nether_wart_block",            texture: "Zjg5MTJiYzFhZDNkZGJlMzlhMTliNzM0YTQyZDg1NDg5NjRiYjBhOWNlNThhNTJmMWE2YWUzNzEyMTUyNCJ9fX0=",     sound: "wart_block" },\
		{ name: "netherite_block",              texture: "NjdlMjlhNThjMDYwNTExZmYwMzUwMjQxYzljODY0OTY5NDdkOGY4NGJmMzJmMmRmMzVlYmUzNzQyZjBlMjAyOSJ9fX0=", sound: "netherite_block" },\
		{ name: "netherrack",                   texture: "OWZjNDRmN2Y3NmVkMTI0NzJmNzA1ZTk5YmI1ZDc5YTQ0NjUzNGU5ZGMwNmQyMjhiYjYxOTQxYzNmYjg0OTQ3YiJ9fX0=", sound: "netherrack" },\
		{ name: "oak_log",                      texture: "NWM0NDI2MjU2NGFjNWEwMDQ5YTk4MjU1OGQwODc3MzNiMGVlMmI1YTJiZjVmYzVmZGFmZTZlMDhmNDk2MTc0YyJ9fX0=", sound: "wood" },\
		{ name: "oak_planks",                   texture: "MTBmOTZkOWI3MjMwM2YzNzI3OWZhOWMyY2MyM2VlNmY4ZGI2ODIzNjg1YjYyNmI1NmVkNTNiNjc0YjZiMCJ9fX0=",     sound: "wood" },\
		{ name: "obsidian",                     texture: "ODRjMzA4NTVmODliNDkwYzZmZjIzMmRmM2QzZWM3NDMzYWI2MzYxMGE5YTk1N2M4OGE2Y2Q0MzI3YjA2YTQ5ZSJ9fX0=", sound: "stone" },\
		{ name: "polished_basalt",              texture: "NjEyMzUxNmVjMDY5YWUxMjUwMTM1NTQ3ZjU1MDM1ZDM4NDdmNTgxNzhhNWY0NzM5NDMzOTUzNzFhN2ZjM2QyNyJ9fX0=", sound: "basalt" },\
		{ name: "polished_blackstone",          texture: "NWM5ZWUxZDU1OGE4OWYxMWNkNTc3YTkwYjdiMWI5NmZkYTM0YzIxYzQwMDk2MDM5MDgxNWMyM2RiNTRiNjQ3MSJ9fX0=", sound: "stone" },\
		{ name: "polished_blackstone_bricks",   texture: "NzUxYjk0ZjE4OTU3MmE2Njc5NTUzNDE2MzQ5MmQyYTdjMmE3Mjg5YWZjNjNhZGUwNTJmMTFkYWNjNzVhNzQzIn19fQ==", sound: "stone" },\
		{ name: "red_nether_bricks",            texture: "Mjk1OWFjMjg0ZGZhY2NhNWE4ZTZjMTc5NjA5ODI1ODc1YTc2OGFmMzI5MWM3N2U4YTY4YmQ5MDM0ZGEzZWM2NCJ9fX0=", sound: "nether_bricks" },\
		{ name: "respawn_anchor",               texture: "YjRlNjNlNDViNDRjOGQ4OWZmM2UzM2U1YjYwMTY2Yjc5MWM3MDYwNjY2NDg1NzBiZDViODY0ODBiYTcxZjRiMSJ9fX0=", sound: "stone" },\
		{ name: "shroomlight",                  texture: "ZDgwNjhhM2U5ZWQwZTY4ODc2OGNmZTAxN2VhZGZmZmM5MjEwNjhmYjRhOGExMGJhYmFkY2U3NWNmNTcyYWFhMyJ9fX0=", sound: "shroomlight" },\
		{ name: "soul_sand",                    texture: "YTg3MDk1ZmFmMzMxNzgzMTJmNjEyOGI5Y2Q0YWZjNTIzMGRiNjA5Y2I2Mzk2M2ZmYmRlYmVmOTQ4MTdiMzM3MyJ9fX0=", sound: "soul_sand" },\
		{ name: "soul_soil",                    texture: "ODcwNmY2MmU2NWFhNWUzZGMyNDFlODM2OTIyMTExODE4ZjI4YzliZTJmYzRmNzJlOGY5OGRjY2RjMzE2OTJhYSJ9fX0=", sound: "soul_soil" },\
		{ name: "stripped_cherry_log",          texture: "YjU2YzA0ZTVjNzJkNGM1ZmJkNjMxNjgzNWE0NTJmMDAxYzIwZTg0ZDJkZGJlZTg0YzY0NDcwNTg0NGI0ZjQ3MSJ9fX0=", sound: "cherry_wood" },\
		{ name: "stripped_crimson_stem",        texture: "NWI2NDMzOGIyNTk1ZjJjY2IyYzcyNzAyZWVhYTM4YjViMTI3YTllYzMyZTc1YWM3ZDFhZDNmZTBjODBjMGZlMCJ9fX0=", sound: "nether_wood" },\
		{ name: "stripped_oak_log",             texture: "ZmI4MmNlZDE5NTI3YjZmZmM2MmZiNDA5YzZhZWFmODkzNTdjOWIzZWIzMzc2ZDE5OWE1MDFkYjkwYzI3MTcyOSJ9fX0=", sound: "wood" },\
		{ name: "stripped_warped_stem",         texture: "MjM3NWE1Zjk5N2M2NDA4NzgxYmE1MzNjMmM1ODA0YTRiYTg3YjVjYTM4ZTQzMjk3YzNjODlhZjFiMWU0YWYwNSJ9fX0=", sound: "nether_wood" },\
		{ name: "warped_nylium",                texture: "NjFmOTFlNzczODQ3MDQ1ODA3MDRhOWY0NTcwYWM1NGU0YjM2YzE3NTdjNWFkYWI2NWNjNDU0ZTZmZmYyZDNiMCJ9fX0=", sound: "nether_wood" },\
		{ name: "warped_planks",                texture: "MWJmYzc5MTgyNDdkNGU1YjU2YjA1ZGJhMDk1OGRkZjQ2MmM1ZTM1ZDJmZGNiMDgzNjQ4NmZkYzZlODEwNDEyMiJ9fX0=", sound: "nether_wood" },\
		{ name: "warped_stem",                  texture: "NGFhNGJiNGE3ODJhNjM2NzJhMzM5YTc0Y2QxNzMxMTlkYjA5YTA0NTY4NTA0MDVhMzRjN2MwZjRiZmRiOWQxNSJ9fX0=", sound: "nether_wood" },\
		{ name: "warped_wart_block",            texture: "MzIwNTIxMDQ2NTQxNTk4M2MzMmExMjc4Mzc5YWIwMGNkYzY0MDBhZmEzY2RiYzUxOGQ2MmY2NTU3MTUwNGEyMCJ9fX0=", sound: "wart_block" }\
	],\
	"minecraft:savanna": [\
		{ name: "acacia_log",                   texture: "NWMxMDBkZDJlMWUyZGMyOTM4NjVmODc0N2M5MDRjNzM3YmFhYjIzNmU2ZTU0Y2NjMmQzYmVkNmQxZmE0MmQzYSJ9fX0=", sound: "wood" },\
		{ name: "acacia_planks",                texture: "NjI5OTY0ZGU4OGJjYWIzZjFiNzYzNTUyYjc5OTExZWYyNGU3NWIzMzUyZjY1ZGJkYThmNThmNjFkMWVhN2YifX19",     sound: "wood" },\
		{ name: "black_glazed_terracotta",      texture: "ZWQ0YTMyMWM0YzNiYzdjYzM5MWQ0NWMyZDMwNGE0ZjUyNmJjYWU1YjIzNTY1YTA0MTM1Y2VmODFjZTUxMThjYyJ9fX0=", sound: "stone" },\
		{ name: "black_terracotta",             texture: "ZTE3ZmY4YmFiYjkxYjRkYmFkNzUyNGU1OGVlZDRiMmY3MTU2NTc0NTk4OWFmOWEyY2NmY2YzMzI4ZjYxYmQyIn19fQ==", sound: "stone" },\
		{ name: "blue_glazed_terracotta",       texture: "NjgxZTM3NjMyMjE4OGIxZTk4ODMwOWY5OWEwMTVkOTQ5YjY4ZmZlOWM5ZDczY2I5NzgxMzUzOGQwODY0ODk3ZSJ9fX0=", sound: "stone" },\
		{ name: "blue_terracotta",              texture: "N2MxMTY2OTQ3MzFmYmQyNzJjMWZmYTQzNTJhNTM1OWI2YzNhNGNiNTg2NGE3NGE1ZGJlMGY2NjVmODM4NWMifX19",     sound: "stone" },\
		{ name: "brown_glazed_terracotta",      texture: "YWQ0ZWFhNTQzMDI3MmM0OGUwODFkMDEwYjRmNDRhYjZmNGFlODQxZTM4OTY3YmE2MDY2MDFkYmMzNTAyNmVjYSJ9fX0=", sound: "stone" },\
		{ name: "brown_terracotta",             texture: "NTRiOTMyZjExN2M4N2UxMTE4OWYxYzRjNDBjZmQ5MmJlOTExOWIxMTM3Y2Q2MTBjNjhlZGQ0MWFjNThmMTQifX19",     sound: "stone" },\
		{ name: "copper_bulb",                  texture: "N2E5YTAyMzkyMTNmZmRjZjJjOTAzNGZiM2I2OWQxYjgwODUwM2NkMzk5Y2I2YThmN2QzZWMxOTQ5YWQwNDFmNyJ9fX0=", sound: "copper_bulb" },\
		{ name: "cyan_glazed_terracotta",       texture: "MTdjNjdhZjgxMzdmZmRjZjg3MzU4ZjdhYjZkYTZkMGVhOThhMDk2MDk5NWMwMmU0ZTk4MTgwMTYzNDhlMWY4MSJ9fX0=", sound: "stone" },\
		{ name: "cyan_terracotta",              texture: "NDQ2MzgxMWZkMGM0OGZjZDczYWJjYjdiYmU1YWE1ZWM2YmMyODA5ZmZjNTU3N2QzZjQ1NTlkZjMwNzY1ZiJ9fX0=",     sound: "stone" },\
		{ name: "exposed_copper_bulb",          texture: "OTc0M2Y4ZjRiNDhkYjc3NzAxZDNjNGU5ZWYxNjEyZGFmYzljMDdmOGMzZWU5NWNkNmI1ZmQwYzJiNTJjYjU5MiJ9fX0=", sound: "copper_bulb" },\
		{ name: "gray_glazed_terracotta",       texture: "Nzc3Mjk1NjJjNzQxZTliNzFhZWViZGIzNjQ1NzJmMDk5YzczYzAyNTZkN2Q4Yzg2MzMxZDc0MTdhODAzYzczNCJ9fX0=", sound: "stone" },\
		{ name: "gray_terracotta",              texture: "OWVmYTdiNWU1ZTYzZDQ2ZDE0NjE1YzYxYmVkMTU0MjdkOTBiMjYxYzdjYTVlODE1OWM0NjZmMDk1NjFkYSJ9fX0=",     sound: "stone" },\
		{ name: "green_glazed_terracotta",      texture: "NmNlODA3ZjBhNmY0OTljZTljY2M2NTAxMGZhYTU0ZWQ0ZTBmZmE2N2NmYjg0OGNkYTE1OWQzZGNhMGEyZGNhNSJ9fX0=", sound: "stone" },\
		{ name: "green_terracotta",             texture: "YjU1ZDUwMTljOGQ1NWJjYjlkYzM0OTRjY2MzNDE5NzU3Zjg5YzMzODRjZjNjOWFiZWMzZjE4ODMxZjM1YjAifX19",     sound: "stone" },\
		{ name: "light_blue_glazed_terracotta", texture: "MzFjODk1OTM1MTc0YWM1ZjY0ZWRhZDIxNWNlMGI2YjM4MDEzN2NjNGQxZjM5OWEzZGYxN2RjM2IyZGU0MGJkZSJ9fX0=", sound: "stone" },\
		{ name: "light_blue_terracotta",        texture: "ODdiYzhmNWFjMmJmMzM2OTc0MWE5NjJkZTJhZGRiYWExN2QxNWNjNGRhZGIxOWFlZjZlOTQ0ODE3ZTZjMjQifX19",     sound: "stone" },\
		{ name: "light_gray_glazed_terracotta", texture: "NjRjMDRkNmViNWI2ODUyODQzNzBkMDMyY2RiNjljZjJkNGZkMWFlMDA0NTc0ZmI0NDIyZjJiNTU3N2RkMTkzMiJ9fX0=", sound: "stone" },\
		{ name: "light_gray_terracotta",        texture: "NWNkZTk5YjcyNzI4ZWY4ODE2NDBmYTUwNjhkMTIyZTYxZGQ5Y2Y3MThkYmIzNzA5ZmM1YjMyNmYxYWY1ZCJ9fX0=",     sound: "stone" },\
		{ name: "lime_glazed_terracotta",       texture: "M2UwYjk3Yzc4NWUzOTc2ZWZhNzhhY2M4MjhkYjY3ZTcxZGVhZDliNjY5NGZkZTYxM2QyZTJlN2NhZmJlMWQ1YiJ9fX0=", sound: "stone" },\
		{ name: "lime_terracotta",              texture: "NTVhMTE3ZTE2MWY3YTI5MWQwYTNhMTY4ZTc3YTIxYjA5ZDM5ZmZkZjU3NzNkMjJhYzAyZjVmYTY2MTFkYjY3In19fQ==", sound: "stone" },\
		{ name: "magenta_glazed_terracotta",    texture: "M2U2MTdiZWQ4ZTk3ZDQwODc5OTNlYzBjODk4Zjg3NzJjNDUyYjk5ZDhiNGI5YTQ1ZTNlYzQzNDkzMDQwOWVlOSJ9fX0=", sound: "stone" },\
		{ name: "magenta_terracotta",           texture: "MzQ0MTUyOGQyODhiMmI3OTczNmNiMjI0ODg3OGZiOTFlZmI0NDYyZDQzYmViZDcxMWY3MzI2YWZiYmY4NSJ9fX0=",     sound: "stone" },\
		{ name: "orange_glazed_terracotta",     texture: "NGFlYjA0ZGU4MTljMTc3NjY4YzUxMzkyNjQzN2QwZWNjMTY4NGUwMjRkMWQ4NjdhZjQ1OTAxY2I0NjFiYjQ3NSJ9fX0=", sound: "stone" },\
		{ name: "orange_terracotta",            texture: "NzMxNmMxNmIxYWM0NzBkMmMxMTQ0MzRmZjg3MzBmMTgxNTcwOTM4M2RiNmYzY2Y3MjBjMzliNmRjZTIxMTYifX19",     sound: "stone" },\
		{ name: "oxidized_copper_bulb",         texture: "ZTBkYjE1ZGQ3ZmRhMTJiYTIyZjVmYTllNzMxYTZiOTFmYjk1MTNlMmI0NzAyMmE2MDA4YThmOGVjOGM3N2NmYSJ9fX0=", sound: "copper_bulb" },\
		{ name: "pink_glazed_terracotta",       texture: "MWMxMjBhYzJmZTJiZDdjZGMyZTg2YTUzNDA4NDQ5ZTM4OTkxNTk5NWQ0OTE3MDEzMWE5YzkyMGRlYjA1OTkyZSJ9fX0=", sound: "stone" },\
		{ name: "pink_terracotta",              texture: "Zjc1ZGI4MWUxNTkyZjMyZDc3MWRkNWRiYzZjM2E1MWU3YTBkNjZiMjJkZmUyOTZiOTY4Njg1MDVjZWVjIn19fQ==",     sound: "stone" },\
		{ name: "purple_glazed_terracotta",     texture: "NmI3NWU4N2Q1MGNiODk2NmEzYTU2ZjczZDBhMTY2NDI5NDhmZjdkMTQ3OWI3ZDU5MDU0MTU0YmY2YmUwM2NkNCJ9fX0=", sound: "stone" },\
		{ name: "purple_terracotta",            texture: "ZTZmNTRmODI4MzZhNTU5MjRlZTg1ZGVjNTZiYmJkOGNhMTQ2MzNkYWE5YmZlMzU2NTU5MmVkZjM5YTZkZSJ9fX0=",     sound: "stone" },\
		{ name: "red_glazed_terracotta",        texture: "MmQyMjI1YmZkNjRlN2Y3YmVjOTZiZDgzMGU1YzgxYmMzMGZkZTk2YmJkYTE2YTBjNWJjZTViNWVjMThiNmUxMiJ9fX0=", sound: "stone" },\
		{ name: "red_terracotta",               texture: "OWU0MmY2ODJlNDMwYjU1YjYxMjA0YTZmOGI3NmQ1MjI3ZDI3OGVkOWVjNGQ5OGJkYTRhN2E0ODMwYTRiNiJ9fX0=",     sound: "stone" },\
		{ name: "stripped_acacia_log",          texture: "MmI0OGQ5MjM3NTcyNzdhMTIzY2M0OTI3NWI4ODVhNTI4YmQzN2Q2ZjczNGFlZGM5YWViMDYzNzlkNGIwODZjZiJ9fX0=", sound: "wood" },\
		{ name: "terracotta",                   texture: "ODJkNWZlZmUyMGRhZjMxYzIzOGVlMjI3ZGQxNDE4MjdhZGE1ZWY4NDgyZDhkMzU3YmJlNWE3Y2Y0MGFmODUifX19",     sound: "stone" },\
		{ name: "weathered_copper_bulb",        texture: "NTIxNmY4MTBjNzNmMTMxZjAyNzQ3ZjU1NmYwZDRjMGE2ZDc4YTY2N2Q4NzdhNWQ3YzE2NzBmMjQxODNlOWZlOCJ9fX0=", sound: "copper_bulb" },\
		{ name: "white_glazed_terracotta",      texture: "ZDJkODk1Nzg5ZjM4OTQ3ODhhYWRmNjMxZDg4MDRiODRmOWUzZDdkMmI4N2YwNDhlOTM4ODhiNDhlNmVhMGM4YiJ9fX0=", sound: "stone" },\
		{ name: "white_terracotta",             texture: "NzE1OTU5NDM4OGJmMDEzYTRlM2U2ODY5ZmFhYmNiOTVkMzFkZDNmNGEyNThhNTM1ZTdjYmQ5MmM5OTg2YjcifX19",     sound: "stone" },\
		{ name: "yellow_glazed_terracotta",     texture: "ODc4NzI4OTEyNDE0ODUzYTU2M2M5NWNkZjExOWFjNmIyZDQ4NmUzNzg0ZWNlNmJiMTc0NWZhNGI3ZDZjNDAwMiJ9fX0=", sound: "stone" },\
		{ name: "yellow_terracotta",            texture: "NjM1MTdiYzNlYzMyODY5ZDkzOWM4OWQyOTYxZTMwYjcxNjFlYWNkOTI1NWJlYzMxM2JlMjM5NjAyMjFkNDFiNCJ9fX0=", sound: "stone" }\
	],\
	"minecraft:snow": [\
		{ name: "birch_log",             texture: "YTk5MWYzYjczZWJiOWRlYzkxZWRkYzgzNjFjYTJmZWNmNTI4MGQyYzczM2VkYTllY2I2OTVmODNkMTU4MCJ9fX0=",     sound: "wood" },\
		{ name: "birch_planks",          texture: "MjQyNzRhY2Y5NDYzNWE4NzNkZjA5Njg4MmEyNjYxZGNkNDQzMjgyZGIwODg4MGM3NjU1OTQ3YzRjYzY1ZCJ9fX0=",     sound: "wood" },\
		{ name: "black_wool",            texture: "Y2ZhNGRkYTZkMTlhMWZlMmQ5ODhkNjVkZWM1MzQyOTUwNTMwODE2NmM5MDY3YjY4YTQ3NzBjYTVjNDM2Y2Y5NCJ9fX0=", sound: "wool" },\
		{ name: "blue_ice",              texture: "NTgxYjRmNWYzZDk5NjcyYWIxYTM5ZjVmNDEwYmQ0ZDRmZDkyNTQ4ZTA3ZDE3YmRmMGQ0ZjFmNTdkY2ViYjVjZiJ9fX0=", sound: "glass" },\
		{ name: "blue_wool",             texture: "ZWE4MWZjYjUxYmUyYTlmODliMWFkYzlkODcyMzliYTQyOWQ2MzVmYmUwMWIzN2VjMzI5MTY0ODg3YmY2NjViIn19fQ==", sound: "wool" },\
		{ name: "brown_mushroom_block",  texture: "OTNhMWUwNTAxMjRmZTU1YmE3OThkYWUwYmIwM2E0ZWE5N2RkNTk5NWE0YjQwNWFhZGZlNzk2MDFmZjE3OTg4ZCJ9fX0=", sound: "wood" },\
		{ name: "brown_wool",            texture: "MjJjYmQ5ZjQzNjE5YWI1Y2IxYjExZjkxY2IwM2U5NTVjNmZjNmM0NThhYmY4OWFiNjEwMzEzNDZhMDkwNjEyZSJ9fX0=", sound: "wool" },\
		{ name: "calcite",               texture: "YTRhZDBkZGQ1M2ZlMmQzMDk1YmUyMDg1NWFhYTU1M2U5ZWViMGY5ODAxMzRjZjVlMDEyOGRjZjI5MDM3ZmY1NiJ9fX0=", sound: "calcite" },\
		{ name: "chiseled_resin_bricks", texture: "MTVjZTkzODliZjU0ZDgwY2FiMjRhZTljNzhlNmMyZTlmOWNlNzc3YzNiNzYwZGZlZWRjMWJlODc4ZmZlMDAyNiJ9fX0=", sound: "resin_bricks" },\
		{ name: "creaking_heart",        texture: "ZGJjZGE1M2U2OTYyNGMwOTkyOWI2OTJkMGM5MGRhN2I3NmFlMzllMzViZGZkNmY2N2IzMTI3YjE3Yjk3MDVkNyJ9fX0=", sound: "creaking_heart" },\
		{ name: "cyan_wool",             texture: "MWZhZGY3NDFhYjc2Y2QzNjIwYWQxNjEzMDAyMDJkN2I1OWEzMzA1MWU1OTY3ZTRiNjE5NGJhYzQwYmIyODBmZiJ9fX0=", sound: "wool" },\
		{ name: "dark_oak_log",          texture: "YjllOGE3YjM3ZjM0MmU4ZmI0NThhOWM5ODlmNTE5NmMyNjUxYjg3ODExZGU1NGZlMDVlNjFiZjRkMjg3Yjk5YiJ9fX0=", sound: "wood" },\
		{ name: "dark_oak_planks",       texture: "NGZkOTE3ZmQ1OTNhN2FjNWJkZmUxZmM2NWQzMjBkZjQ2MTFkYTQzMWYzZWE0ZjM0YzdhMTkwMjBmNTEyIn19fQ==",     sound: "wood" },\
		{ name: "dripstone_block",       texture: "NDg0OWY2NjBkNGY3MzJjYjMyZDkzZmExMTQ5ODMwYzM5NWIzM2RmYjJkMGIwNjcwZDMzMjJkMDkxZTk4NzAxNSJ9fX0=", sound: "dripstone_block" },\
		{ name: "end_stone",             texture: "NDI4MTNjZjhjNGZkMDEzYmFmNWJmNTVhOGM5MzEyMWM0ODJkYTFjZjZlMTA1NGMxODBmZjNlODE3MjdiNjVkZCJ9fX0=", sound: "stone" },\
		{ name: "end_stone_bricks",      texture: "NjZkZTY1ZDE4OTY4MTI2ODExMDViYjNjMDE3ZmIzYWNkM2Y0ZGQ2M2IxM2IxOGRhMTRkNTliZTk4NGE2M2Q3In19fQ==", sound: "stone" },\
		{ name: "end_portal_frame",      texture: "ZjQ2ODRlM2U3ODkwY2FmN2QxMzc2MmVhMTllYjE0YzU5NDBiODhmZDdmMDc3ZDgxZTZlZmZiNGY2ZGYxNmMyNiJ9fX0=", sound: "glass" },\
		{ name: "gray_wool",             texture: "YWRmMjFmNTMyMTIyNTY2YWY4OTNkYTI3ODgwYTFiNjA5NWMzNTcxMmYyOWEzNzhjZmVjYzdmZTJiMTMyOGFiNCJ9fX0=", sound: "wool" },\
		{ name: "green_wool",            texture: "NTM1ODFjMmY5Y2YzNThkN2VkYzc4ZGQ2ZmQ0YjYyNTc1MDFiYzRlNjQ1NWUzM2ZhMGNhYWUyMDdjZjAzMjFhMiJ9fX0=", sound: "wool" },\
		{ name: "light_blue_wool",       texture: "MTYzZTY2NDZmMWMwZDQxZmQzYmY1NTg0YTFjZTA0NGY1YzQ2ZDU5ODI1OGRiNDYyMTYxMTc4NTlmNTdhZjE5NyJ9fX0=", sound: "wool" },\
		{ name: "light_gray_wool",       texture: "NTUyODhkZGM5MTFhNzVmNzdjM2E1ZDMzNjM2NWE4ZjhiMTM5ZmE1MzkzMGI0YjZlZTEzOTg3NWM4MGNlMzY2YyJ9fX0=", sound: "wool" },\
		{ name: "lime_wool",             texture: "Nzc0NzJkNjA4ODIxZjQ1YTg4MDUzNzZlYzBjNmZmY2I3ODExNzgyOWVhNWY5NjAwNDFjMmEwOWQxMGUwNGNiNCJ9fX0=", sound: "wool" },\
		{ name: "magenta_wool",          texture: "Zjk3MDEyZWQ2YTkyYjA1ZWEwZjE5NDk1MDc0ODU0NGUwNzViYWEyODc4MWNhMzczZDFiMjdlMjhjMjY5NTNjIn19fQ==", sound: "wool" },\
		{ name: "moss_block",            texture: "YWE0Yjc4YThiYWYzOGFhOTdjMWI1ODcwNjgzMGVkOGRkYTRmNzc5MWQ4NmZiNTNhOGY2MWRhNTRhMjQzMWExIn19fQ==", sound: "moss" },\
		{ name: "mushroom_stem",         texture: "OWRhMzIzZWJiYzRiMWI1NjQ0ZmVlM2EwZjFlNWIxNTUwMWJlNmIxOWEwZmQzOGQzZTBiYTkwM2Y4NjBhM2MyZSJ9fX0=", sound: "wood" },\
		{ name: "orange_wool",           texture: "YWRmMmViMjA1YTIzYzExOTZiM2VjZjIxZTY4YzA3NmI2OTZlNzYxNjNhYzhmYzRmYjlmNTMxOGMyYTVlNWIxYSJ9fX0=", sound: "wool" },\
		{ name: "packed_ice",            texture: "MjZlNDI5YzYwOTMyZWJjMzY2ZTc5MWE0MmUxODZhZjg4OGRlMDhlNWQ4ZWI4YWM2ZjViNmY0ZDQ0MGRiNDg2YyJ9fX0=", sound: "glass" },\
		{ name: "pale_moss_block",       texture: "MWQwNTg5YzhhOGNhZGYwZTU3NTJmNzZhYWVhNzI0OWQ0NWQzNGU4MjI4ZGM5ZDNkMjAxMDBkYWE1MzgzOGVmZSJ9fX0=", sound: "moss" },\
		{ name: "pale_oak_log",          texture: "MzAwNDdmYTRhMWY0OWYxOTRjYmYwMDdmODhlNWZlNDQxN2Y5MjllZDdhOTBlZjZkZDgwN2E3ZDU4MjQxOWZjIn19fQ==", sound: "wood" },\
		{ name: "pale_oak_planks",       texture: "OGRmNjZjYmViZmQ4MDAwNDkwOWRiYzk2YTY4MmU0MGFjYWYwMzNlNGEwMWE0NjM4MzVmMzcyNTU5M2MzMTY3MyJ9fX0=", sound: "wood" },\
		{ name: "pink_wool",             texture: "ZDA4ODM2NTBlYTkyOWRiMGVhYmRmNWJjNzU1OTlkOGVmMDBkNzAzNDBjZDFjZTVlMDRhZDk1ZWY4ZWQ4M2I3MyJ9fX0=", sound: "wool" },\
		{ name: "purple_wool",           texture: "ODllYzVhMzAyMjJkMDY1OWIwZGJlZTg0NGI4ZjUzZWFlNjJmZTk1YjRhMzQ0OGE5ZWY3OTBhN2FlZGIyOTZkOSJ9fX0=", sound: "wool" },\
		{ name: "purpur_block",          texture: "NzA4ZjM4MzJiYzE1ZmFjNDE1MjJjZTZlZDFkODhmOTU0M2RkNTcxZjkzNDA3Mzg3NGVmMGNiOWJmY2NlYSJ9fX0=",     sound: "stone" },\
		{ name: "purpur_pillar",         texture: "OWE4MmFmNmE2MTJkYTU3ZWMzYmRjZmVhZDhlMDIxODM5NWY2YmNmZjY5MzdmZDM2YjQwMDk0YjVmZGQzZGEwNSJ9fX0=", sound: "stone" },\
		{ name: "red_mushroom_block",    texture: "ZDVjNTI2NzFhOWRmYTVjZmM5ZDM2YWEzZWZiNWRkMmQwYmJkMWIzMjc5MzIwZjllYmMwODMxYzAzOTczOWVkNCJ9fX0=", sound: "wood" },\
		{ name: "red_wool",              texture: "Njk1M2IxMmEwOTQ2YjYyOWI0YzA4ODlkNDFmZDI2ZWQyNmZiNzI5ZDRkNTE0YjU5NzI3MTI0YzM3YmI3MGQ4ZCJ9fX0=", sound: "wool" },\
		{ name: "resin_block",           texture: "NGZlY2MzMWUxNmE2ZTY5NjE5YWY0ODM0MmI1Njg2Y2JjN2ExMDE5NTU0Yzg5MGI2MmViZTlhYjA3MmFiNjFiOSJ9fX0=", sound: "resin" },\
		{ name: "resin_bricks",          texture: "Mjc2ZGZmOWM3ZDA2ZDBhMzkwNzljNDNlYmQ0NjAzZjEyNWFmZjZmNzMyODYyNzIyOWQyMTk5N2MyOGU5MTgxNyJ9fX0=", sound: "resin_bricks" },\
		{ name: "shulker_box",           texture: "MjVjNGQyNGFmZmRkNDgxMDI2MjAzNjE1MjdkMjE1NmUxOGMyMjNiYWU1MTg5YWM0Mzk4MTU2NDNmM2NmZjlkIn19fQ==", sound: "stone" },\
		{ name: "snow_block",            texture: "NDgyZWQ1M2Q5N2U2MjhjYjMwYzlhNDIyZDU3ODU4NTdiNWZjZmJlNjg5NjFlMDdmY2I1MGY0ZTZjMTA1MjAxYiJ9fX0=", sound: "snow" },\
		{ name: "stripped_birch_log",    texture: "NGUyZjk0ZjlmYTUzMmQ4YTJjYTIwNTRhZDkwNDQ0Mzg5OTgxZTZiOGQxMzE5ODNjZTEyOWUyM2JkZDA2ZmZiNSJ9fX0=", sound: "wood" },\
		{ name: "stripped_dark_oak_log", texture: "Mzg1ZTEyYTNlZDk3NzczNWI0MWVhMTk4ZTM2ZjFlY2ViMzFmNmIzODg3MzhhYjNkNGZhZGVlNmZiZDY0ZDlhZCJ9fX0=", sound: "wood" },\
		{ name: "stripped_pale_oak_log", texture: "NzE0ODFkMGEyNDU4OTAzMDg0OTVhMDk0NjczZGNkN2E1NTIyNzFhNmY1NjViMmRjNjM0NjY5M2E4OTE5YTZiNyJ9fX0=", sound: "wood" },\
		{ name: "white_wool",            texture: "ZDA4ZGY2MGM1MTA3NGVlZjI1NDRmZjM4Y2VhZDllMTY2NzVhZTQyNTE5MTYxMDUxODBlMWY4Y2UxOTdhYjNiYyJ9fX0=", sound: "wool" },\
		{ name: "yellow_wool",           texture: "NGQ5MDUyNjlhY2NhYjI0YjExOTI0ZWJhOGJkOTI5OTFiOGQ4NWNlNDI3NjAyN2ExNjM2YzkzMWI2ZDA2Yzg5ZSJ9fX0=", sound: "wool" }\
	],\
	"minecraft:swamp": [\
		{ name: "amethyst_block",        texture: "OGI1ZTNkZWNlNDI1YzhiNGNkNDY5MWY3NmEyMThjOGEwZDA0ODBiYTgwMmU2MTI4MmQwMmQwZDU2N2VkOGMzZSJ9fX0=", sound: "amethyst_block" },\
		{ name: "andesite",              texture: "YmM1ZTE2Yzc2MWUwYWFhMmRkNTI4OWU0M2Y1MmNjNDcxNTY3Y2Q4ZjhjOGE0NzVhNGIyOTBhZWU4Y2ZhNDUzOCJ9fX0=", sound: "stone" },\
		{ name: "bone_block",            texture: "ODZjZTliMThjYTIzOGVhZDY1MTViMDE3MzUzNGE3ZjM0ZDI4YmM1MWMwMTg4ZTJkYjA2ODQ1YzE3ZTYyZjEwYSJ9fX0=", sound: "bone_block" },\
		{ name: "bricks",                texture: "NGQ2YWJjY2RmZGI1MjMxZjc0NzEwZDc3OGMyMDg0ZjRjOGU0Y2Q2OTEzYTcwZThhNzIxM2FkYjYzOTE5MjUyNyJ9fX0=", sound: "stone" },\
		{ name: "chiseled_deepslate",    texture: "NTM1MWRjMzJmZTBhNTI0ZGU2NjY5NmExYjI4Yzg5YjU5Yzc2YTdlZmRhNjljMmNhMWY4ODdmYWEzOGNhOWZiMyJ9fX0=", sound: "deepslate_bricks" },\
		{ name: "chiseled_stone_bricks", texture: "MmYyZWI4MjQ5ZTY3MTA0OGRmOTljMDM2ODExYjEyNjE1ZmNjYWVlNTZmNjY3YTUwMmFkYjQwN2NmOGZlMjYxYiJ9fX0=", sound: "stone" },\
		{ name: "chiseled_tuff",         texture: "MzM2MGJlMGNlMjUzYjljODQxNDU3NThlMWI2MWRlODZkYzQ3ZjQ4NmIzYjc3OTNjNGFlNDU0ZWZlM2NkYWMyMiJ9fX0=", sound: "tuff" },\
		{ name: "chiseled_tuff_bricks",  texture: "MWJmNGRhNzY1M2U0ZmRlOTUxZTk1OGI4NDY0ZTM2YjczODM0M2JlOWYwMDQxNmYzMWVlMTEzZWFiZGZjMTM4NSJ9fX0=", sound: "polished_tuff" },\
		{ name: "clay",                  texture: "Njc4MjY4MjllYWI1YWQ2MmYwYzExZDlmYWFmZGM5OTU0MzY0ODcxMTYwZGQ4MzllMWFiNWEzYjIxM2EzMyJ9fX0=",     sound: "gravel" },\
		{ name: "cobbled_deepslate",     texture: "YWU0ZTFiYmRkNmUyNTc0YTIxNGNkNjE1YmUwNDE0NmUyODc2YzYzODI1YTY3YjlhMGU4MDcxODFjM2U1Y2JhYiJ9fX0=", sound: "deepslate" },\
		{ name: "cobblestone",           texture: "MzNkNTFmNGQwNjA5OGJiMWY0Y2VmZjYxOWM2ZGRjYTk3NmZjNzBlOWY4ODcxZWJlZTRlZWY2NTgwY2Y3NmIwZiJ9fX0=", sound: "stone" },\
		{ name: "deepslate",             texture: "NWIyMWFlOTM2MTNiZjAwMWY5NDA3NTJjNTlkNTc4OGExZDgwZjRjNTI1NThhNDI1YzNiYjY2MzI4MzU4OWVkOCJ9fX0=", sound: "deepslate" },\
		{ name: "deepslate_bricks",      texture: "MjQyZDY0YjRhMTc2OTA1OWJhMTVkZDg4YTZjZjdjYjIxMTM1ZDZiY2U4ZDcyZWJlZjljOWEwZjU2MWI4N2QxZiJ9fX0=", sound: "deepslate" },\
		{ name: "deepslate_tiles",       texture: "MzUwODY0MGNkZmFlZjZmMTRhYWQ0OGFmZjQ3YWZiODZjMTUxZDIyMjdjNmI0MzBkMGQ1MTg0MDBkN2M0YTg5MSJ9fX0=", sound: "deepslate" },\
		{ name: "diorite",               texture: "NTVjMWVmMmQ0NDY1NzE1MDZiNTlmOTI5MTAzZDE5NTZmYzMxNTJmZDlkNDAwMjAyNmJjZTViMDI4YzkxN2ZlZiJ9fX0=", sound: "stone" },\
		{ name: "granite",               texture: "OGQ4MzhiMmQwNDg0NzAwMTU1MmU0YmYyZTUzNzMzZWNlNzBmNTU1YzZmNGM2NmYxNzRjYzMxMWYzMDkxYzMyOSJ9fX0=", sound: "stone" },\
		{ name: "gravel",                texture: "Yzc1NDMxOGEzMzc2ZjQ3MGU0ODFkZmNkNmM4M2E1OWFhNjkwYWQ0YjRkZDc1NzdmZGFkMWMyZWYwOGQ4YWVlNiJ9fX0=", sound: "gravel" },\
		{ name: "mangrove_log",          texture: "M2Q5YTEwNzUxY2JlMmMzZTBkNjhjODg1YjcyNmMwODIzMjlmMWYyZTE3YTVjNTEyMWE3Y2ZjMTZiNTk1NjM4NCJ9fX0=", sound: "wood" },\
		{ name: "mangrove_planks",       texture: "OTQ0MzMxYjEwN2YxOWI3NTBiMzdlNTNmZmQxNzQ5MDc5NGU4YTViZTQ2ZGJhY2E5YWIyNDFmZmNkYjY1OTU2OCJ9fX0=", sound: "wood" },\
		{ name: "mossy_cobblestone",     texture: "Y2RlNjIwZTE4MDBiM2JlZDViNzcyODYwZDdmNWU0YzNmOGE3MTJhZTQ2MmJmOWE3OTdkNTA0YmUxMzBkYTNiOCJ9fX0=", sound: "stone" },\
		{ name: "mud",                   texture: "ZWVkMjFmNDYzNjIyMTBjNzc2Y2MxNWM0YTkxOWNhNjgxODM3NThjZDZmMDkyM2Y1NzQwMDIxYTkxZWJmOGViNCJ9fX0=", sound: "mud" },\
		{ name: "mud_bricks",            texture: "Y2Y4NjExN2NhYjZhZDYxMmQ3ZWM5YWI2M2U2MDg4MDk5MDM4YmY3MTRkMzllYzhhNzFjMjY5ZTM5OWM2ZjU1ZSJ9fX0=", sound: "mud_bricks" },\
		{ name: "ochre_froglight",       texture: "NTc2ODJmZDE3YWM0NGI4NmE3MDVjYTA0YzkyNjU0ZTFlZDkxYTI0Zjg4MGFmMmUwOTU0Y2E3NjYyZjQ3NTU1MiJ9fX0=", sound: "froglight" },\
		{ name: "packed_mud",            texture: "OGRjYzlmZTgxODhkMjkyMGVkYjQxZjMxNmE1YzhlZDRiZDExZDc4NjA5OTJjNjNlYzIwNGE1NmE4NDBjODMzOSJ9fX0=", sound: "packed_mud" },\
		{ name: "pearlescent_froglight", texture: "ZWY4NzY3MmQ5NzYwYmI1OWQ1MzlmYjVhYWE1ZmE1MDIwMTE4ZDhkM2I3N2ViNTgxNTcxNTNkYWViYWJjZTJhMCJ9fX0=", sound: "froglight" },\
		{ name: "polished_andesite",     texture: "Y2E5NzlmNzY2MzNmNWRkYTg5NDk2NTExNzE2OTQ4ZTlkN2I4NTkyZjZlMWU0ODBjNWRlMWM4MzIzOGQzZTMyIn19fQ==", sound: "stone" },\
		{ name: "polished_deepslate",    texture: "YzU5ODBiNTM0N2JiZDQ3NTQ3NmVlYWRkZWM0YmI4YjFkODc1OGY1ZTdhMWMyZDhiYWNhODhmMjY0NzI3YmNlOCJ9fX0=", sound: "deepslate" },\
		{ name: "polished_diorite",      texture: "MzFhMjgxZjQ5NDUyODZjMzFmYTA3NzEyMWY5YjMyYzU4OGZiOTQwNjRkZTdmOTA4Y2YwZTk2NzdjZGRhOGIxIn19fQ==", sound: "stone" },\
		{ name: "polished_granite",      texture: "OWFlNGNmMjJmNDViYjc3YWVmYTVhZmExZjg2NGRkM2M1ZjlkM2U5MmY0M2IzNTg4ZmQxNjJiMmFhOGMifX19",         sound: "stone" },\
		{ name: "polished_tuff",         texture: "MjIzM2ExNzQ4OTllYjRjNDVjZDcyNjdmMGE5NWM0Yzk2MDI0N2QyODM0MzI1ODY3MzJhMzkzNGRmZDNjYjVjYyJ9fX0=", sound: "tuff" },\
		{ name: "quartz_block",          texture: "ZTVlMmIyZWQyOThiNTNjYzg0NzgzY2Q3ODVlYzU3ZGE0OWNlYWFiZGNmZjMxYjI1ZmU1MjU2YjM0MjliNDEyIn19fQ==", sound: "stone" },\
		{ name: "reinforced_deepslate",  texture: "NjlhODczZjI0OGMzOTExMjIxODg3OWNjOWMwMzM0N2VkMTZlN2Y2MDIzOTBhYzdhNjgwNmY4ZTg0OTI3OTRkNSJ9fX0=", sound: "deepslate" },\
		{ name: "sculk",                 texture: "ZDY3YjU1YzdmZWExMjVjZjkyMzJlODk1ZDk2YzIxMzIwMTE4ZmNmOGNkMjMzNzRiZmY2NmY3YWIwYzk3ZDljYSJ9fX0=", sound: "sculk" },\
		{ name: "sculk_catalyst",        texture: "MzVjMjMxMmMzNzVlMWQzMzQ4MjM0YzcyZjcwMTc2OTJjOTgxNmIxZTU5NGFjZDlmZmMyOWUyNmI4M2MwYjM3ZiJ9fX0=", sound: "sculk_catalyst" },\
		{ name: "sculk_shrieker",        texture: "YmIyZDkxYmJmM2NlNWY5MTQ4ZTczOWVlYjA5NjFmMmJhODRiYTQwNmFkMmNhNjcyNDlhNTUzYjhiODE0MzdhNSJ9fX0=", sound: "sculk_shrieker" },\
		{ name: "smooth_basalt",         texture: "YTJlZjQxNjg2NmY0MjRjZDkwZjhhODkwYWJiMjA1NTYyOWU2YzMxYWU3YTc4NDZkYjViMjMxZmQ3YWYwNGI3In19fQ==", sound: "basalt" },\
		{ name: "smooth_stone",          texture: "OGRkMGNkMTU4YzJiYjY2MTg2NTBlMzk1NGIyZDI5MjM3ZjViNGMwZGRjN2QyNThlMTczODBhYjY5NzlmMDcxIn19fQ==", sound: "stone" },\
		{ name: "stone",                 texture: "MTU0ODE4MjMzYzgxMTg3M2U4NWY1YTRlYTQ0MjliNzVmMjNiNmFlMGVhNmY1ZmMwZjdiYjQyMGQ3YzQ3MSJ9fX0=",     sound: "stone" },\
		{ name: "stone_bricks",          texture: "ODNmYTBmYzA5OTZjZjc3MmQxZGJjMDUyYWEyNWIxMWRhYmFlOTc3ODIwYWY2NjNlZjAyMmQzY2UxZGI2MTEyMiJ9fX0=", sound: "stone" },\
		{ name: "stripped_mangrove_log", texture: "OTk5MTE5ZTFkYmNjNGFlM2ZkMzE1ODk4ZjViZTc0MTRjMDUwYTFkNGZkMTM2ZTVjYTEyODQ1YjQxM2E0Njk4NCJ9fX0=", sound: "wood" },\
		{ name: "tuff",                  texture: "ZmY5YmY1MzgzZmNlNTQzZTRhYTg4MzVhZjhlY2FlZDY3MDI5ZmQwYWFiYjAzYWMwZmY1YTJlZGVjZWUyY2U0ZCJ9fX0=", sound: "tuff" },\
		{ name: "tuff_bricks",           texture: "YjY2NDgxMTlhMmNjMmFmNzVmYjRiNjNkMTZlODUwYjE1NGI2Mjk0MjlkMTIxMTNiNTU5YmNhY2M3YzJjZDMwZiJ9fX0=", sound: "polished_tuff" },\
		{ name: "verdant_froglight",     texture: "ZjI0YzdlNDMyYzk2YjQ4YzBiZWI3YjNiMGIxNTU5ZmMxYjdmOWUyZWJhNzg2OWExZmJlOGYyMjY5NjQ3YTY5NSJ9fX0=", sound: "froglight" }\
	],\
	"minecraft:taiga": [\
		{ name: "black_concrete",            texture: "NGZjMjM3MmI0NTc1NDJjNjU0ODNhZmExNDQyZTFjMzNhNWZmNzU4ZDM2MmVjZWM0MzQ4Nzk1MTcyODI0ZDg2OSJ9fX0=", sound: "stone" },\
		{ name: "blue_concrete",             texture: "NTdjN2EyOTcxMDNkYjA4NGFmNjI3M2I4Nzk4MDVhZmM4NTc3Y2M4MmM3NTJhYzI2NmNmOGQ3YTZlZWE2MCJ9fX0=",     sound: "stone" },\
		{ name: "brain_coral",               texture: "OTU3ZGQ0M2U4ZjFjZDEzNzI2YzBmOTlhYzQwNDcxNTA0N2QxMmViNDJhMjhmZmM2YWU5YmZiM2I3MGQ3NjQwYSJ9fX0=", sound: "coral_block" },\
		{ name: "brown_concrete",            texture: "NjUzODEyMGY2MThmMmNjZDNiYmRjMThjZDU3ODJlNjM4MmFlOWVlNzJkMDVmNWY4NjI3NmFkYTU0ZWY3ZWQifX19",     sound: "stone" },\
		{ name: "bubble_coral",              texture: "MTNmMTgwNWVkY2QzMmI5N2FiMmYxOWEwM2JhYWIxZjhkNGRjNGRiOGVjN2EwMDRiMTRlYjY2NmQwOWZiODdmMiJ9fX0=", sound: "coral_block" },\
		{ name: "chiseled_copper",           texture: "MmVkZDI0ODI1YzIxNzMwM2YyNmFmNTUyNjU3MGEyMTRhZWMyOWI5Mjk3YTY4NzcxNTFiYTUwZmNlZGZmN2ZmMSJ9fX0=", sound: "copper" },\
		{ name: "cyan_concrete",             texture: "ZjMzYjUxZmVmMWQ3ZmRmMTkyNzRiYjc2ZmNlZGVjZWM3YTc3ZDAxMGNiMzRmZTAyOWZiNzk0Y2M1OWFiYSJ9fX0=",     sound: "stone" },\
		{ name: "dark_prismarine",           texture: "ZmQ5MTg1OTg5ODk1NDk1OTQ0NDZlODNmMzM4NzM4OTExNzhkYTlkYjQyZjkxMmU1MjcyZTFmYjI0MDMxMmEifX19",     sound: "stone" },\
		{ name: "dirt",                      texture: "MWFiNDNiOGMzZDM0ZjEyNWU1YTNmOGI5MmNkNDNkZmQxNGM2MjQwMmMzMzI5ODQ2MWQ0ZDRkN2NlMmQzYWVhIn19fQ==", sound: "gravel" },\
		{ name: "dirt_path",                 texture: "MzVhOWNmZGI3OGFjMWJlYjc4MjNiY2M4N2I3ZTNhZjgyZGFlZTEwYTU3ODM1ZGM0Y2I2MzJiZjFjZWUyMTU4MCJ9fX0=", sound: "grass" },\
		{ name: "exposed_chiseled_copper",   texture: "NGYwNTY4YzQ4Mzg4NGNjZTM2MGY1YzA2YjYxY2JlOWMxNjdiM2RjYzBlNjMxNTY2YzA4MDk4MDRjMzIxNmMzNSJ9fX0=", sound: "copper" },\
		{ name: "fire_coral",                texture: "OWZlOGRlZDNjNzRlYWNkNzg0MTJhOTAzYjkwNGY1NTc3ODUwZDFlMjBkMzQ4NzhmZDc3NTk3YWQxNjMzYmY3NCJ9fX0=", sound: "coral_block" },\
		{ name: "grass_block",               texture: "ZWQzMzlkNTIzOTNkNTE4M2EzNjY0MDE1YzBiMmM2YzEwMTJlYTFiNTI1ZWQ5NTIwNzMzMTFjYTE4MGEwZTYifX19",     sound: "grass" },\
		{ name: "gray_concrete",             texture: "YzA2ZDdiZWZjODJmMjAxZjgzZTE5Mzc2N2U2M2Y4MTAzNzIxNWFmZDQ4M2EzOGQzNjk2NTk4MmNhNmQwIn19fQ==",     sound: "stone" },\
		{ name: "green_concrete",            texture: "ZGZhYjdkYWViOGYzMzNjNzg4NmE3MGVmMzBjYWY0ZGVjNGE4Y2QxMDQ5M2YyMzgwMmYxNTE2YmRkMjNmY2QifX19",     sound: "stone" },\
		{ name: "horn_coral",                texture: "MzQ5MWI2ZTZhZTk0NTFjNDdlMDliZjFmZjIzZDUwZmZmODdiYTU5MjdhNTFmNDZmZmVkZjkyNmM1Y2JkZTc3ZiJ9fX0=", sound: "coral_block" },\
		{ name: "light_blue_concrete",       texture: "ZjQ3N2Y0NDM4OTM2MmM0Yzc2NGM4NDdhOTczOWJjNzhjMzI0NjdlYWI0ZTM4MzBhZTRjOGJlYWMzNDQyZWY5In19fQ==", sound: "stone" },\
		{ name: "light_gray_concrete",       texture: "NmJhMGM0YTBmZGNlOTIzYTkwNDgzMjhkNjY0MTQ3YzViOTI0NDkxZjRlZTVmZWE3MWYzZTllYzMxNCJ9fX0=",         sound: "stone" },\
		{ name: "lime_concrete",             texture: "NGI1OTljNjE4ZTkxNGMyNWEzN2Q2OWY1NDFhMjJiZWJiZjc1MTYxNTI2Mzc1NmYyNTYxZmFiNGNmYTM5ZSJ9fX0=",     sound: "stone" },\
		{ name: "magenta_concrete",          texture: "NjVlZjJkODdmN2MxZGVmNzk1MjNlOTU2NzY3YjgyODRjYTM4OWIyNDI5OWY1ZTQ2NWQ0NTc5ODlkNjJkZjgifX19",     sound: "stone" },\
		{ name: "mycelium",                  texture: "N2ViNGM0MWY0ODFlODE2Y2Y0YjUwN2IwYTE3NTk1ZjJiYTFmMjQ2NjRkYzQzMmJlMzQ3ZDRlN2E0ZWIzIn19fQ==",     sound: "grass" },\
		{ name: "orange_concrete",           texture: "NjNmMTNlMjNlYzIzNDY3YWM1ZTZmNjVhODNmMjY4NmViZWNkOTk4NmRmNWY4Y2JjZDZmYWZjNDJlNjYyYjM4In19fQ==", sound: "stone" },\
		{ name: "oxidized_chiseled_copper",  texture: "ZTg5YmM5OWU5N2MzNjE3YzQ0ZTU5MmJhZDY0MTg2MGJmNmYzNDBjZGVhYzFiYWU1Njc1YmEyMGI3YmY2N2I4ZSJ9fX0=", sound: "copper" },\
		{ name: "pink_concrete",             texture: "MjI3NDlkMzdjM2Y5OGQ0NTdiZjU0MDIyYThiNjEzYTQzNTNlZDhkZDJlMTQ5NDI2ZmM0MmRiM2I3ZCJ9fX0=",         sound: "stone" },\
		{ name: "podzol",                    texture: "YTQxOTVmOWE0MzljNmQwZmZkMTk2MTY1N2Y2ZjBhYThlM2EyZjhhMjQ5M2FmYTY2MmFiNWU0MTkzZTAifX19",         sound: "gravel" },\
		{ name: "prismarine",                texture: "OTdlNTYxNDA2ODZlNDc2YWVmNTUyMGFjYmFiYzIzOTUzNWZmOTdlMjRiMTRkODdmNDk4MmYxMzY3NWMifX19",         sound: "stone" },\
		{ name: "prismarine_bricks",         texture: "MzdjYmEyMzNmZmM0NTdiMzMwNTIyOGIyNWYzNWMwMjMzNTYxMWM5ZWZiNzY2OThiNWU5NGMwZDU0MWI1ZjQifX19",     sound: "stone" },\
		{ name: "purple_concrete",           texture: "ZjBjMDVkNTYwZDhlMTNmMGNiMjVjMTVjODMxYmM1OTU0NTBjNWU1NGNlMzVmYTU0ZTE3ZTA0OTUyNjdjIn19fQ==",     sound: "stone" },\
		{ name: "red_concrete",              texture: "NjE4NTZjN2IzNzhkMzUwMjYyMTQzODQzZDFmOWZiYjIxOTExYTcxOTgzYmE3YjM5YTRkNGJhNWI2NmJlZGM2In19fQ==", sound: "stone" },\
		{ name: "rooted_dirt",               texture: "NzYwODk1ZjIzYTYxZGNmYWQzMzliOTJmMmQxNzI5ZDEzNTI4YTg2YjJjYTUyNjdjYTlkZmRmYWU4ZWRkZmZjZCJ9fX0=", sound: "rooted_dirt" },\
		{ name: "sea_lantern",               texture: "ODI0YzZmZjE3MTRlYjJjM2I4NDRkNDZkMmU1ZWEyZjI2ZDI3M2EzM2VhYWE3NDRhYmY2NDViMDYwYjQ3ZDcifX19",     sound: "glass" },\
		{ name: "sponge",                    texture: "MTJmMDk2ZWVmODdkOWYyMGNjYWFiYTJhMDJlZWQ2ZjQzZTY0MzJhNjkyOGZlMTY0NjdjYjRkZWI1ZTc0MTE4YyJ9fX0=", sound: "grass" },\
		{ name: "spruce_log",                texture: "OWY0YWYyODk4MjVlMTI3ZGFjMzIyMDhiMWUwMzg5YTkyN2VmNDA1NTk3YjZjOWE2NGNlZjAzZjIxZDkyNzNiNSJ9fX0=", sound: "wood" },\
		{ name: "spruce_planks",             texture: "MTBlYjE5NjhmZjJkYTZiY2E2OGY1OWI2MTExNzEzZTA4ZDIyNDk5MjI5ZTEwODY0NDljYmE1MGY3ZGU2NGFlIn19fQ==", sound: "wood" },\
		{ name: "stripped_spruce_log",       texture: "MmM1NDY0MjViYTA5ZGE5YjQ3OGIzYWJlOWYzZDk5ZTAyNWNmZWViYTZhNTBjZjYyN2JkNTcxYzYzZDBhOWFhZSJ9fX0=", sound: "wood" },\
		{ name: "tube_coral",                texture: "MzlmYzNjZjU1MDhkNDBjMTQ2OTlkNWJmN2YyNTI3NTllMTk1NmFmOWE2NmQxNWE2YzM4NTQzNzhjNjFmNmQ5YSJ9fX0=", sound: "coral_block" },\
		{ name: "weathered_chiseled_copper", texture: "MjJhZjk1OWExOWY3YTdiNjQ0NDA5OGNhMWUwYTM0MWMxMjBmMGQ5MGFjOWMyOWMzZGE5MzA2ZWQ2MWU3ZGFlMyJ9fX0=", sound: "copper" },\
		{ name: "white_concrete",            texture: "ZDA5MjVjNDhiMDU2NjI4NDhlYzlmMDY4NWY4NThkODg5ZDNkYTExYjA3MTc4OGVhYTM2Y2NkOGYxZjMxZGUifX19",     sound: "stone" },\
		{ name: "yellow_concrete",           texture: "ZmNhNWJmZjMyNWVkNzFkOTdhMmRkZmM4M2FjZjA1ZmU3ZmQ5Y2I3Y2JkYjE1ZWJiNGYwNTYyMTkwN2U5ZjJiIn19fQ==", sound: "stone" }\
	]\
}
