#version 330

#include "/settings.glsl"

uniform sampler2D gtexture;
uniform sampler2D lightmap;
uniform sampler2D shadowtex0;
uniform sampler2D shadowtex1;
uniform sampler2D shadowtex2;
uniform sampler2D shadowtex3;
uniform sampler2D normals;

uniform vec3 sunPosition;

uniform vec3 shadowLightPosition;
uniform vec3 skyColor;
uniform vec3 cameraPosition;

uniform mat4 shadowModelView;
uniform mat4 shadowProjection;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 modelViewMatrix;
uniform mat4 modelViewMatrixInverse;
uniform mat3 normalMatrix;

uniform float alphaTestRef;

/* DRAWBUFFERS:0 */
layout(location = 0) out vec4 outColor;

in vec2 UV0;
in vec2 UV2;

in vec3 position;
in vec3 viewSpacePosition;
in vec3 geoNormal;

in vec4 fColor;

in vec4 tangent;

vec3 projectAndDivide(mat4 projectionMatrix, vec3 position) {
    vec4 homogeneousPos = projectionMatrix * vec4(position, 1.0);
    return homogeneousPos.xyz / homogeneousPos.w;
}

mat3 tbnNormalTangent(vec3 normal, vec3 tangent) {
    vec3 bitangent = cross(normal, tangent);
    return mat3(tangent, bitangent, normal);
} 

void main() {

    vec4 normalInfo = texture(normals, UV0) * 2 - 1;
    vec3 normalNormalSpace = vec3(normalInfo.xy, sqrt(1 - dot(normalInfo.xy, normalInfo.xy)))*2-1;

    vec3 worldGeoNormal = (vec4(geoNormal * normalMatrix, 1) * gbufferModelViewInverse).xyz;

    vec3 worldTangent = (vec4(tangent.xyz * normalMatrix, 1) * gbufferModelViewInverse).xyz;

    mat3 TBN = tbnNormalTangent(worldGeoNormal, tangent.rgb);

    vec3 normalWorldSpace = TBN * normalNormalSpace;


    vec4 lightLevel = texture(lightmap, UV2);
    vec4 blockColor = texture(gtexture, UV0) * fColor;

    float directLight = dot((vec4(shadowLightPosition, 1) * gbufferModelView).xyz, normalWorldSpace);

    // Shadows
    vec3 shadowNdcPosition = projectAndDivide(shadowProjection, (shadowModelView * vec4((gbufferModelViewInverse * vec4(viewSpacePosition, 1.0)).xyz, 1.0)).xyz);
    float distancefPlayerShadowNDC = length(shadowNdcPosition.xy);
    vec3 fragShadowScreenSpace = vec3(shadowNdcPosition.xy / (.1+distancefPlayerShadowNDC * shadowNearPlaneBulge), shadowNdcPosition.z) * 0.5 + 0.5;
    float shadow = -0.1;
    // If in light
    if ((fragShadowScreenSpace.z - shadePlaneOffset) <= texture(shadowtex1, fragShadowScreenSpace.xy).r) {
        // Shadow equals 1.4
        shadow = .2;
    }

    if (directLight <= 0){
        shadow = -.1 ;
    }
    shadow = clamp(shadow, -1, .2);

    if (directLight <= 10 && directLight >= -10){
        shadow = -0.2;
    }


    // Direct

    outColor = blockColor * 0.7 * (lightLevel) + vec4(clamp((shadow * clamp(directLight, 0, 1)), 0, 1)) + vec4(((skyColor * (abs((geoNormal * normalMatrix).x + (geoNormal * normalMatrix).y)* lightLevel.xyz )) / 10), 0);

    outColor = vec4(outColor.xyz, blockColor.a);

    if (outColor.a < alphaTestRef) {
        discard;
    }
}
