#version 330

#include "/settings.glsl"

in vec2 mc_Entity;
in vec2 vaUV0;
in ivec2 vaUV2;
in vec4 vaColor;
in vec3 vaPosition;
in vec3 vaNormal;
in vec4 at_tangent;

uniform vec3 chunkOffset;
uniform mat4 modelViewMatrix;
uniform mat4 projectionMatrix;
uniform vec3 cameraPosition;

out vec2 UV0;
out vec2 UV2;
out vec4 fColor;
out vec3 viewSpacePosition;
out vec3 geoNormal;
out vec4 tangent;

uniform float frameTimeCounter;

void main() {
    UV0 = vaUV0;
    UV2 = vec2(vaUV2) * (1.0 / 256.0) + (1.0 / 32.0);
    fColor = vaColor;
    viewSpacePosition = (modelViewMatrix * vec4(vaPosition + chunkOffset, 1.0)).xyz;
    geoNormal = vaNormal;
    tangent = at_tangent;

    vec4 wobble = vec4(0);    

    if (mc_Entity.x < 13 && mc_Entity.x > 1) {
        wobble = vec4(0, sin(frameTimeCounter + vaPosition.z + vaPosition.x), 0, 0);
    }
    if (mc_Entity.x < 15 && mc_Entity.x > 12) {
        wobble = vec4(cos(frameTimeCounter + vaPosition.y + vaPosition.z), 0, 0, 0);
    }

    gl_Position = projectionMatrix * modelViewMatrix * vec4(vaPosition + chunkOffset, 1) + (wobble * 0.1);
}