#version 330 compatibility

#include "/settings.glsl"

uniform sampler2D gtexture;
uniform sampler2D lightmap;

const int shadowMapResolution = 2048;

uniform float alphaTestRef;

/* DRAWBUFFERS:0 */
layout(location = 0) out vec4 outColor;

in vec2 UV0;
in vec2 UV2;
in vec3 position;
in vec4 fColor;

void main() {


    vec4 lightLevel = texture(lightmap, UV2);
    vec4 blockColor = texture(gtexture, UV0) * fColor;

    outColor = blockColor * lightLevel;

    if (outColor.a < alphaTestRef) {
        discard;
    }
}