/*
 * Decompiled with CFR 0.152.
 */
package com.chestprotect;

import com.chestprotect.commands.AdminCommand;
import com.chestprotect.commands.ClaimChestCommand;
import com.chestprotect.commands.OpenRequestCommand;
import com.chestprotect.commands.RequestResponseCommand;
import com.chestprotect.commands.UnlockChestCommand;
import com.chestprotect.listeners.ChestListener;
import com.chestprotect.listeners.SignListener;
import com.chestprotect.managers.ChestManager;
import com.chestprotect.managers.RequestManager;
import com.chestprotect.utils.MessageUtils;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ChestProtectPlugin
extends JavaPlugin {
    private ChestManager chestManager;
    private RequestManager requestManager;
    private MessageUtils messageUtils;

    public void onEnable() {
        boolean geyserPresent;
        this.saveDefaultConfig();
        this.getLogger().info("Starting ChestProtect " + this.getDescription().getVersion());
        this.getLogger().info("Checking for Geyser/Floodgate compatibility...");
        boolean bl = geyserPresent = this.getServer().getPluginManager().getPlugin("Geyser-Spigot") != null || this.getServer().getPluginManager().getPlugin("floodgate") != null;
        if (geyserPresent) {
            this.getLogger().info("Geyser/Floodgate detected! Enabling Bedrock compatibility features.");
            if (!this.getConfig().contains("geyser")) {
                this.getLogger().info("Adding Geyser compatibility settings to config.yml");
                this.getConfig().set("geyser.enhanced_support", (Object)true);
                this.getConfig().set("geyser.use_titles", (Object)true);
                this.getConfig().set("geyser.increased_detection_range", (Object)5);
                this.getConfig().set("geyser.relaxed_chest_targeting", (Object)true);
                this.saveConfig();
            }
        } else {
            this.getLogger().info("Geyser/Floodgate not detected. Bedrock compatibility features disabled.");
            if (!this.getConfig().contains("geyser.enhanced_support")) {
                this.getConfig().set("geyser.enhanced_support", (Object)false);
                this.saveConfig();
            }
        }
        this.chestManager = new ChestManager(this);
        this.requestManager = new RequestManager(this);
        this.messageUtils = new MessageUtils(this);
        this.getServer().getPluginManager().registerEvents((Listener)new SignListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChestListener(this), (Plugin)this);
        this.getCommand("openrequest").setExecutor((CommandExecutor)new OpenRequestCommand(this));
        this.getCommand("acceptrequest").setExecutor((CommandExecutor)new RequestResponseCommand(this, true));
        this.getCommand("denyrequest").setExecutor((CommandExecutor)new RequestResponseCommand(this, false));
        this.getCommand("unlockchest").setExecutor((CommandExecutor)new UnlockChestCommand(this));
        this.getCommand("claimchest").setExecutor((CommandExecutor)new ClaimChestCommand(this));
        String adminCommand = this.getConfig().getString("commands.admin_command", "chestadmin");
        AdminCommand adminCommandExecutor = new AdminCommand(this);
        try {
            this.getCommand(adminCommand).setExecutor((CommandExecutor)adminCommandExecutor);
            this.getCommand(adminCommand).setTabCompleter((TabCompleter)adminCommandExecutor);
            this.getLogger().info("Registered admin command: /" + adminCommand);
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to register admin command: " + adminCommand);
            this.getLogger().warning("Make sure it's properly defined in plugin.yml");
        }
        this.getLogger().info("==================================================");
        this.getLogger().info("           ChestProtect v1.0.0 Enabled            ");
        this.getLogger().info("==================================================");
        this.getLogger().info("  Made by juicyyfruittsnackss dsc.gg/fruitsnacks  ");
        this.getLogger().info("==================================================");
        this.getLogger().info("  Commands: /openrequest, /acceptrequest, /denyrequest");
        this.getLogger().info("           /unlockchest, /claimchest, /" + adminCommand);
        this.getLogger().info("==================================================");
    }

    public void reloadConfig() {
        super.reloadConfig();
        if (this.requestManager != null) {
            this.requestManager = new RequestManager(this);
        }
        if (this.messageUtils != null) {
            this.messageUtils.loadMessages();
        }
    }

    public void onDisable() {
        this.chestManager.saveData();
        this.getLogger().info("==================================================");
        this.getLogger().info("           ChestProtect v1.0.0 Disabled           ");
        this.getLogger().info("==================================================");
        this.getLogger().info("  Made by juicyyfruittsnackss dsc.gg/fruitsnacks  ");
        this.getLogger().info("==================================================");
    }

    public ChestManager getChestManager() {
        return this.chestManager;
    }

    public RequestManager getRequestManager() {
        return this.requestManager;
    }

    public MessageUtils getMessageUtils() {
        return this.messageUtils;
    }
}

