/*
 * Decompiled with CFR 0.152.
 */
package com.chestprotect.commands;

import com.chestprotect.ChestProtectPlugin;
import com.chestprotect.utils.MessageUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class AdminCommand
implements CommandExecutor,
TabCompleter {
    private final ChestProtectPlugin plugin;
    private final MessageUtils messageUtils;
    private final List<String> subcommands = Arrays.asList("help", "reload", "list", "info");

    public AdminCommand(ChestProtectPlugin plugin) {
        this.plugin = plugin;
        this.messageUtils = plugin.getMessageUtils();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!sender.hasPermission("chestprotect.admin")) {
            this.messageUtils.sendMessage(sender, "error.no_permission", new Object[0]);
            return true;
        }
        if (args.length == 0) {
            this.showHelp(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "help": {
                this.showHelp(sender);
                break;
            }
            case "reload": {
                this.plugin.reloadConfig();
                this.messageUtils.loadMessages();
                this.messageUtils.sendMessage(sender, "success.config_reloaded", new Object[0]);
                break;
            }
            case "info": {
                this.showInfo(sender);
                break;
            }
            case "list": {
                this.listProtectedChests(sender, args.length > 1 ? args[1] : null);
                break;
            }
            default: {
                this.messageUtils.sendMessage(sender, "error.unknown_command", new Object[0]);
            }
        }
        return true;
    }

    private void showInfo(CommandSender sender) {
        this.messageUtils.sendMessage(sender, "success.admin_info", new Object[0]);
        int chestCount = this.plugin.getChestManager().getProtectedChestCount();
        sender.sendMessage("\u00a7eProtected chests: \u00a7f" + chestCount);
        int requestCount = this.plugin.getRequestManager().getActiveRequestCount();
        sender.sendMessage("\u00a7eActive requests: \u00a7f" + requestCount);
    }

    private void listProtectedChests(CommandSender sender, String playerName) {
        if (playerName != null) {
            List<String> chestLocations = this.plugin.getChestManager().getPlayerProtectedChests(playerName);
            if (chestLocations.isEmpty()) {
                sender.sendMessage("\u00a7ePlayer \u00a7f" + playerName + "\u00a7e has no protected chests.");
                return;
            }
            sender.sendMessage("\u00a7eProtected chests for \u00a7f" + playerName + "\u00a7e:");
            for (String location : chestLocations) {
                sender.sendMessage("\u00a7f- " + location);
            }
        } else {
            List<String> owners = this.plugin.getChestManager().getAllChestOwners();
            if (owners.isEmpty()) {
                sender.sendMessage("\u00a7eThere are no protected chests.");
                return;
            }
            sender.sendMessage("\u00a7eChest owners:");
            for (String owner : owners) {
                int count = this.plugin.getChestManager().getPlayerChestCount(owner);
                sender.sendMessage("\u00a7f- " + owner + " (" + count + " chests)");
            }
            sender.sendMessage("\u00a7eUse \u00a7f/chestadmin list <player> \u00a7eto see their chest locations.");
        }
    }

    private void showHelp(CommandSender sender) {
        sender.sendMessage(this.messageUtils.formatMessage("help.admin.header", new Object[0]));
        sender.sendMessage(this.messageUtils.formatMessage("help.admin.reload", new Object[0]));
        sender.sendMessage(this.messageUtils.formatMessage("help.admin.list", new Object[0]));
        sender.sendMessage(this.messageUtils.formatMessage("help.admin.info", new Object[0]));
        sender.sendMessage(this.messageUtils.formatMessage("help.admin.help", new Object[0]));
        sender.sendMessage(this.messageUtils.formatMessage("help.admin.footer", new Object[0]));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            String input = args[0].toLowerCase();
            return this.subcommands.stream().filter(subcommand -> subcommand.startsWith(input)).collect(Collectors.toList());
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("list")) {
            String input = args[1].toLowerCase();
            return this.plugin.getServer().getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(input)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

