/*
 * Decompiled with CFR 0.152.
 */
package com.chestprotect.commands;

import com.chestprotect.ChestProtectPlugin;
import com.chestprotect.managers.ChestManager;
import com.chestprotect.utils.ChestUtils;
import com.chestprotect.utils.MessageUtils;
import java.util.HashSet;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.util.BlockIterator;

public class ClaimChestCommand
implements CommandExecutor {
    private final ChestProtectPlugin plugin;
    private final ChestManager chestManager;
    private final MessageUtils messageUtils;

    public ClaimChestCommand(ChestProtectPlugin plugin) {
        this.plugin = plugin;
        this.chestManager = plugin.getChestManager();
        this.messageUtils = plugin.getMessageUtils();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        boolean isBedrockPlayer;
        if (!(sender instanceof Player)) {
            this.messageUtils.sendMessage(sender, "error.player_only", new Object[0]);
            return true;
        }
        Player player = (Player)sender;
        boolean bl = isBedrockPlayer = player.hasMetadata("floodgate-player-edition") || player.hasMetadata("Geyser-Player");
        if (!player.hasPermission("chestprotect.protect")) {
            this.messageUtils.sendMessage((CommandSender)player, "error.no_permission", new Object[0]);
            return true;
        }
        Block targetBlock = this.getTargetChest(player);
        if (targetBlock == null) {
            this.messageUtils.sendMessage((CommandSender)player, "error.no_chest_found", new Object[0]);
            return true;
        }
        if (this.chestManager.isChestProtected(targetBlock.getLocation())) {
            String ownerName = this.chestManager.getChestOwner(targetBlock.getLocation());
            if (isBedrockPlayer) {
                this.messageUtils.sendMessage((CommandSender)player, "error.already_protected_by", "\u00a7c\u00a7l" + ownerName + "\u00a7r");
            } else {
                this.messageUtils.sendMessage((CommandSender)player, "error.already_protected_by", ownerName);
            }
            return true;
        }
        if (!this.hasSignInInventory(player)) {
            this.messageUtils.sendMessage((CommandSender)player, "error.no_sign_inventory", new Object[0]);
            return true;
        }
        this.chestManager.protectChest(targetBlock.getLocation(), player.getName());
        this.removeSignFromInventory(player);
        if (isBedrockPlayer) {
            this.messageUtils.sendMessage((CommandSender)player, "success.chest_claimed", new Object[0]);
            player.sendTitle("\u00a7a\u00a7lChest Protected", "\u00a7fYou now own this chest", 10, 70, 20);
        } else {
            this.messageUtils.sendMessage((CommandSender)player, "success.chest_claimed", new Object[0]);
        }
        return true;
    }

    private boolean hasSignInInventory(Player player) {
        PlayerInventory inventory = player.getInventory();
        for (ItemStack item : inventory.getContents()) {
            if (item == null || !item.getType().name().contains("SIGN")) continue;
            return true;
        }
        return false;
    }

    private void removeSignFromInventory(Player player) {
        PlayerInventory inventory = player.getInventory();
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (item == null || !item.getType().name().contains("SIGN")) continue;
            if (item.getAmount() > 1) {
                item.setAmount(item.getAmount() - 1);
            } else {
                inventory.setItem(i, null);
            }
            player.updateInventory();
            return;
        }
    }

    private Block getTargetChest(Player player) {
        boolean isBedrockPlayer = player.hasMetadata("floodgate-player-edition") || player.hasMetadata("Geyser-Player");
        boolean enhancedGeyserSupport = this.plugin.getConfig().getBoolean("geyser.enhanced_support", true);
        int maxDistance = this.plugin.getConfig().getInt("detection.max_distance", 20);
        boolean anyLevel = this.plugin.getConfig().getBoolean("detection.detect_any_level", true);
        double verticalSensitivity = this.plugin.getConfig().getDouble("detection.vertical_sensitivity", 0.8);
        if (isBedrockPlayer && enhancedGeyserSupport) {
            int bedrockBonus = this.plugin.getConfig().getInt("geyser.increased_detection_range", 5);
            maxDistance += bedrockBonus;
            verticalSensitivity *= 1.2;
        }
        BlockIterator blockIterator = new BlockIterator((LivingEntity)player, maxDistance);
        HashSet<Block> checkedBlocks = new HashSet<Block>(maxDistance);
        double playerX = player.getLocation().getX();
        double playerY = player.getLocation().getY();
        double playerZ = player.getLocation().getZ();
        while (blockIterator.hasNext()) {
            double zDiff;
            double xDiff;
            double horizontalDistSq;
            double yDiff;
            Block block = blockIterator.next();
            if (!checkedBlocks.add(block)) continue;
            Material type = block.getType();
            if ((type == Material.CHEST || type == Material.TRAPPED_CHEST) && ChestUtils.isChest(block)) {
                return block;
            }
            if (!type.isOccluding() || !type.isSolid() || anyLevel && (yDiff = Math.abs(playerY - (double)block.getY())) > Math.sqrt(horizontalDistSq = (xDiff = playerX - (double)block.getX()) * xDiff + (zDiff = playerZ - (double)block.getZ()) * zDiff) * verticalSensitivity) continue;
            return null;
        }
        return null;
    }
}

