/*
 * Decompiled with CFR 0.152.
 */
package com.chestprotect.commands;

import com.chestprotect.ChestProtectPlugin;
import com.chestprotect.models.AccessRequest;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class OpenRequestCommand
implements CommandExecutor,
TabCompleter {
    private final ChestProtectPlugin plugin;

    public OpenRequestCommand(ChestProtectPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.getMessageUtils().sendMessage(sender, "error.player_only", new Object[0]);
            return true;
        }
        Player player = (Player)sender;
        if (this.plugin.getRequestManager().hasPendingOutgoingRequest(player.getUniqueId())) {
            this.plugin.getMessageUtils().sendMessage((CommandSender)player, "error.request_pending", new Object[0]);
            return true;
        }
        if (args.length == 0) {
            this.plugin.getMessageUtils().sendMessage((CommandSender)player, "help.openrequest", new Object[0]);
            return true;
        }
        String targetName = args[0];
        Player targetPlayer = Bukkit.getPlayerExact((String)targetName);
        if (targetPlayer == null) {
            this.plugin.getMessageUtils().sendMessage((CommandSender)player, "error.player_offline", targetName);
            return true;
        }
        if (player.getUniqueId().equals(targetPlayer.getUniqueId())) {
            this.plugin.getMessageUtils().sendMessage((CommandSender)player, "error.request_self", new Object[0]);
            return true;
        }
        if (!this.plugin.getChestManager().hasProtectedChests(targetName)) {
            this.plugin.getMessageUtils().sendMessage((CommandSender)player, "error.no_protected_chests", targetName);
            return true;
        }
        AccessRequest request = this.plugin.getRequestManager().createRequest(player.getUniqueId(), targetName);
        if (request == null) {
            this.plugin.getMessageUtils().sendMessage((CommandSender)player, "error.request_failed", new Object[0]);
            return true;
        }
        this.plugin.getMessageUtils().sendMessage((CommandSender)player, "success.request_sent", targetName);
        if (targetPlayer.isOnline()) {
            this.plugin.getMessageUtils().sendRequestNotification(targetPlayer, player.getName());
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.getName().toLowerCase().startsWith(args[0].toLowerCase())) continue;
                completions.add(player.getName());
            }
        }
        return completions;
    }
}

