/*
 * Decompiled with CFR 0.152.
 */
package com.chestprotect.commands;

import com.chestprotect.ChestProtectPlugin;
import com.chestprotect.models.AccessRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class RequestResponseCommand
implements CommandExecutor,
TabCompleter {
    private final ChestProtectPlugin plugin;
    private final boolean isAccept;

    public RequestResponseCommand(ChestProtectPlugin plugin, boolean isAccept) {
        this.plugin = plugin;
        this.isAccept = isAccept;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.getMessageUtils().sendMessage(sender, "error.player_only", new Object[0]);
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.plugin.getMessageUtils().sendMessage((CommandSender)player, this.isAccept ? "help.acceptrequest" : "help.denyrequest", new Object[0]);
            return true;
        }
        String requesterName = args[0];
        Player requester = Bukkit.getPlayerExact((String)requesterName);
        UUID requesterId = null;
        if (requester != null) {
            requesterId = requester.getUniqueId();
        } else {
            requesterId = this.plugin.getRequestManager().getRequesterUUID(requesterName);
            if (requesterId == null) {
                this.plugin.getMessageUtils().sendMessage((CommandSender)player, "error.no_pending_request", requesterName);
                return true;
            }
        }
        AccessRequest request = this.plugin.getRequestManager().getPendingRequest(requesterId, player.getName());
        if (request == null) {
            this.plugin.getMessageUtils().sendMessage((CommandSender)player, "error.no_pending_request", requesterName);
            return true;
        }
        if (this.isAccept) {
            this.plugin.getChestManager().grantTemporaryAccess(player.getName(), requesterId);
            this.plugin.getRequestManager().resolveRequest(request, true);
            this.plugin.getMessageUtils().sendMessage((CommandSender)player, "success.request_accepted", requesterName);
            if (requester != null && requester.isOnline()) {
                this.plugin.getMessageUtils().sendMessage((CommandSender)requester, "success.access_granted", player.getName());
            }
        } else {
            this.plugin.getRequestManager().resolveRequest(request, false);
            this.plugin.getMessageUtils().sendMessage((CommandSender)player, "success.request_denied", requesterName);
            if (requester != null && requester.isOnline()) {
                this.plugin.getMessageUtils().sendMessage((CommandSender)requester, "error.access_denied", player.getName());
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (!(sender instanceof Player)) {
            return completions;
        }
        Player player = (Player)sender;
        if (args.length == 1) {
            List<String> requesters = this.plugin.getRequestManager().getPendingRequesters(player.getName());
            for (String requester : requesters) {
                if (!requester.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                completions.add(requester);
            }
        }
        return completions;
    }
}

