/*
 * Decompiled with CFR 0.152.
 */
package com.chestprotect.commands;

import com.chestprotect.ChestProtectPlugin;
import com.chestprotect.managers.ChestManager;
import com.chestprotect.utils.ChestUtils;
import com.chestprotect.utils.MessageUtils;
import java.util.HashSet;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.BlockIterator;

public class UnlockChestCommand
implements CommandExecutor {
    private final ChestProtectPlugin plugin;
    private final ChestManager chestManager;
    private final MessageUtils messageUtils;

    public UnlockChestCommand(ChestProtectPlugin plugin) {
        this.plugin = plugin;
        this.chestManager = plugin.getChestManager();
        this.messageUtils = plugin.getMessageUtils();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.messageUtils.sendMessage(sender, "error.player_only", new Object[0]);
            return true;
        }
        Player player = (Player)sender;
        Block targetBlock = this.getTargetChest(player);
        if (targetBlock == null) {
            this.messageUtils.sendMessage((CommandSender)player, "error.no_chest_found", new Object[0]);
            return true;
        }
        if (!this.chestManager.isChestProtected(targetBlock.getLocation())) {
            this.messageUtils.sendMessage((CommandSender)player, "error.chest_not_protected", new Object[0]);
            return true;
        }
        String ownerName = this.chestManager.getChestOwner(targetBlock.getLocation());
        if (!player.getName().equalsIgnoreCase(ownerName) && !player.hasPermission("chestprotect.admin.unlock")) {
            this.messageUtils.sendMessage((CommandSender)player, "error.not_chest_owner", ownerName);
            return true;
        }
        if (this.chestManager.removeChestProtection(targetBlock.getLocation())) {
            this.messageUtils.sendMessage((CommandSender)player, "success.chest_unlocked", new Object[0]);
        } else {
            this.messageUtils.sendMessage((CommandSender)player, "error.unlock_failed", new Object[0]);
        }
        return true;
    }

    private Block getTargetChest(Player player) {
        int maxDistance = this.plugin.getConfig().getInt("detection.max_distance", 20);
        boolean anyLevel = this.plugin.getConfig().getBoolean("detection.detect_any_level", true);
        double verticalSensitivity = this.plugin.getConfig().getDouble("detection.vertical_sensitivity", 0.8);
        BlockIterator blockIterator = new BlockIterator((LivingEntity)player, maxDistance);
        HashSet<Block> checkedBlocks = new HashSet<Block>(maxDistance);
        double playerX = player.getLocation().getX();
        double playerY = player.getLocation().getY();
        double playerZ = player.getLocation().getZ();
        while (blockIterator.hasNext()) {
            double zDiff;
            double xDiff;
            double horizontalDistSq;
            double yDiff;
            Block block = blockIterator.next();
            if (!checkedBlocks.add(block)) continue;
            Material type = block.getType();
            if ((type == Material.CHEST || type == Material.TRAPPED_CHEST) && ChestUtils.isChest(block)) {
                return block;
            }
            if (!type.isOccluding() || !type.isSolid() || anyLevel && (yDiff = Math.abs(playerY - (double)block.getY())) > Math.sqrt(horizontalDistSq = (xDiff = playerX - (double)block.getX()) * xDiff + (zDiff = playerZ - (double)block.getZ()) * zDiff) * verticalSensitivity) continue;
            return null;
        }
        return null;
    }
}

