/*
 * Decompiled with CFR 0.152.
 */
package com.chestprotect.listeners;

import com.chestprotect.ChestProtectPlugin;
import com.chestprotect.models.ChestAccess;
import com.chestprotect.utils.ChestUtils;
import java.util.HashSet;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Chest;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockIterator;

public class ChestListener
implements Listener {
    private final ChestProtectPlugin plugin;
    private final int MAX_DISTANCE = 20;

    public ChestListener(ChestProtectPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onChestInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null || !(block.getState() instanceof org.bukkit.block.Chest)) {
            return;
        }
        Player player = event.getPlayer();
        boolean isBedrockPlayer = player.hasMetadata("floodgate-player-edition") || player.hasMetadata("Geyser-Player");
        boolean relaxedTargeting = isBedrockPlayer && this.plugin.getConfig().getBoolean("geyser.enhanced_support", true) && this.plugin.getConfig().getBoolean("geyser.relaxed_chest_targeting", true);
        String owner = this.plugin.getChestManager().getChestOwner(block.getLocation());
        if (owner == null && relaxedTargeting) {
            try {
                org.bukkit.block.Chest chest = (org.bukkit.block.Chest)block.getState();
                Chest chestData = (Chest)block.getBlockData();
                if (chestData.getType() != Chest.Type.SINGLE) {
                    String otherOwner;
                    Block otherHalf;
                    BlockFace otherHalfFace = null;
                    switch (chestData.getFacing()) {
                        case NORTH: 
                        case SOUTH: {
                            otherHalfFace = chestData.getType() == Chest.Type.LEFT ? BlockFace.EAST : BlockFace.WEST;
                            break;
                        }
                        case EAST: 
                        case WEST: {
                            otherHalfFace = chestData.getType() == Chest.Type.LEFT ? BlockFace.SOUTH : BlockFace.NORTH;
                            break;
                        }
                    }
                    if (otherHalfFace != null && (otherHalf = block.getRelative(otherHalfFace)).getState() instanceof org.bukkit.block.Chest && (otherOwner = this.plugin.getChestManager().getChestOwner(otherHalf.getLocation())) != null) {
                        owner = otherOwner;
                        block = otherHalf;
                    }
                }
            }
            catch (Exception chest) {
                // empty catch block
            }
        }
        if (owner == null) {
            long currentTime = System.currentTimeMillis();
            boolean shouldShowHint = true;
            if (player.hasMetadata("chestprotect.hintshown")) {
                long lastShown = ((MetadataValue)player.getMetadata("chestprotect.hintshown").get(0)).asLong();
                boolean bl = shouldShowHint = currentTime - lastShown > 300000L;
                if (shouldShowHint) {
                    player.removeMetadata("chestprotect.hintshown", (Plugin)this.plugin);
                }
            }
            if (shouldShowHint && Math.random() < 0.2 && this.hasSignInInventory(player) && event.getHand() == EquipmentSlot.HAND) {
                player.setMetadata("chestprotect.hintshown", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)currentTime));
                this.plugin.getMessageUtils().sendMessage((CommandSender)player, "info.use_claimchest", new Object[0]);
            }
            return;
        }
        if (player.getName().equalsIgnoreCase(owner)) {
            return;
        }
        ChestAccess access = this.plugin.getChestManager().getAccess(block.getLocation(), player.getUniqueId());
        if (access != null && access.isValid()) {
            this.plugin.getChestManager().removeAccess(block.getLocation(), player.getUniqueId());
            return;
        }
        event.setCancelled(true);
        this.plugin.getMessageUtils().sendRequestAccessMessage(player, owner, block.getLocation());
    }

    private Block getTargetChest(Player player) {
        int maxDistance = this.plugin.getConfig().getInt("detection.max_distance", 20);
        boolean anyLevel = this.plugin.getConfig().getBoolean("detection.detect_any_level", true);
        double verticalSensitivity = this.plugin.getConfig().getDouble("detection.vertical_sensitivity", 0.8);
        BlockIterator blockIterator = new BlockIterator((LivingEntity)player, maxDistance);
        HashSet<Block> checkedBlocks = new HashSet<Block>(maxDistance);
        double playerX = player.getLocation().getX();
        double playerY = player.getLocation().getY();
        double playerZ = player.getLocation().getZ();
        while (blockIterator.hasNext()) {
            double zDiff;
            double xDiff;
            double horizontalDistSq;
            double yDiff;
            Block block = blockIterator.next();
            if (!checkedBlocks.add(block)) continue;
            Material type = block.getType();
            if ((type == Material.CHEST || type == Material.TRAPPED_CHEST) && ChestUtils.isChest(block)) {
                return block;
            }
            if (!type.isOccluding() || !type.isSolid() || anyLevel && (yDiff = Math.abs(playerY - (double)block.getY())) > Math.sqrt(horizontalDistSq = (xDiff = playerX - (double)block.getX()) * xDiff + (zDiff = playerZ - (double)block.getZ()) * zDiff) * verticalSensitivity) continue;
            return null;
        }
        return null;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Block attachedChest;
        Block block = event.getBlock();
        Player player = event.getPlayer();
        if (block.getState() instanceof org.bukkit.block.Chest) {
            String owner = this.plugin.getChestManager().getChestOwner(block.getLocation());
            boolean isBedrockPlayer = player.hasMetadata("floodgate-player-edition") || player.hasMetadata("Geyser-Player");
            boolean enhancedGeyserSupport = this.plugin.getConfig().getBoolean("geyser.enhanced_support", true);
            boolean useTitles = this.plugin.getConfig().getBoolean("geyser.use_titles", true);
            if (owner != null && !player.getName().equalsIgnoreCase(owner) && !player.hasPermission("chestprotect.admin")) {
                event.setCancelled(true);
                if (isBedrockPlayer && enhancedGeyserSupport && useTitles) {
                    this.plugin.getMessageUtils().sendMessage((CommandSender)player, "error.break_protected_chest", "\u00a7c\u00a7l" + owner + "\u00a7r");
                    player.sendTitle("\u00a7c\u00a7lProtected Chest", "\u00a7fOwned by \u00a7e" + owner, 10, 70, 20);
                } else {
                    this.plugin.getMessageUtils().sendMessage((CommandSender)player, "error.break_protected_chest", owner);
                }
                return;
            }
            if (owner != null) {
                this.plugin.getChestManager().removeChestProtection(block.getLocation());
                if (isBedrockPlayer && enhancedGeyserSupport && useTitles) {
                    player.sendTitle("\u00a7a\u00a7lChest Unlocked", "\u00a7fProtection removed", 10, 40, 20);
                }
            }
        }
        if (ChestUtils.isSign(block) && (attachedChest = this.plugin.getChestManager().getAttachedChest(block)) != null) {
            String owner = this.plugin.getChestManager().getChestOwner(attachedChest.getLocation());
            boolean isBedrockPlayer = player.hasMetadata("floodgate-player-edition") || player.hasMetadata("Geyser-Player");
            boolean enhancedGeyserSupport = this.plugin.getConfig().getBoolean("geyser.enhanced_support", true);
            boolean useTitles = this.plugin.getConfig().getBoolean("geyser.use_titles", true);
            boolean autoRestore = this.plugin.getConfig().getBoolean("signs.auto_restore", true);
            Block signBlock = block;
            String chestOwner = owner;
            Material signType = block.getType();
            BlockData signData = block.getBlockData().clone();
            BlockState signState = block.getState();
            if (owner != null && !player.getName().equalsIgnoreCase(owner) && !player.hasPermission("chestprotect.admin")) {
                event.setCancelled(true);
                if (isBedrockPlayer && enhancedGeyserSupport && useTitles) {
                    this.plugin.getMessageUtils().sendMessage((CommandSender)player, "error.break_protection_sign", "\u00a7c\u00a7l" + owner + "\u00a7r");
                    player.sendTitle("\u00a7c\u00a7lProtected Sign", "\u00a7fOwned by \u00a7e" + owner, 10, 70, 20);
                } else {
                    this.plugin.getMessageUtils().sendMessage((CommandSender)player, "error.break_protection_sign", owner);
                }
                return;
            }
            if (autoRestore && owner != null) {
                Player ownerPlayer;
                int restoreDelay = this.plugin.getConfig().getInt("signs.restore_delay", 5);
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    if (this.plugin.getChestManager().isChestProtected(attachedChest.getLocation())) {
                        signBlock.setType(signType);
                        signBlock.setBlockData(signData);
                        try {
                            Sign sign = (Sign)signBlock.getState();
                            sign.setLine(0, "\u00a71[Protected]");
                            sign.setLine(1, "\u00a72Chest");
                            sign.setLine(2, "\u00a70Owner:");
                            sign.setLine(3, "\u00a79" + chestOwner);
                            sign.update(true);
                            this.plugin.getLogger().info("Restored protection sign for chest owned by " + chestOwner);
                        }
                        catch (Exception e) {
                            this.plugin.getLogger().warning("Failed to restore protection sign: " + e.getMessage());
                        }
                    }
                }, (long)restoreDelay);
                if (!player.getName().equalsIgnoreCase(owner) && (ownerPlayer = this.plugin.getServer().getPlayer(owner)) != null && ownerPlayer.isOnline()) {
                    this.plugin.getMessageUtils().sendMessage((CommandSender)ownerPlayer, "info.sign_restored", player.getName());
                }
                return;
            }
            if (owner != null && !autoRestore) {
                this.plugin.getChestManager().removeChestProtection(attachedChest.getLocation());
                if (isBedrockPlayer && enhancedGeyserSupport && useTitles) {
                    player.sendTitle("\u00a7a\u00a7lSign Removed", "\u00a7fChest protection removed", 10, 40, 20);
                }
            }
        }
    }

    private boolean hasSignInInventory(Player player) {
        PlayerInventory inventory = player.getInventory();
        for (ItemStack item : inventory.getContents()) {
            if (item == null || !item.getType().name().contains("SIGN")) continue;
            return true;
        }
        return false;
    }
}

