/*
 * Decompiled with CFR 0.152.
 */
package com.chestprotect.listeners;

import com.chestprotect.ChestProtectPlugin;
import com.chestprotect.utils.ChestUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class SignListener
implements Listener {
    private final ChestProtectPlugin plugin;
    private static final String LINE_1 = "\u00a71[Protected]";
    private static final String LINE_2 = "\u00a72Chest";
    private static final String LINE_3 = "\u00a70Owner:";
    private final Pattern usernamePattern = Pattern.compile(":(\\w+):");

    public SignListener(ChestProtectPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onProtectionSignEdit(SignChangeEvent event) {
        String owner;
        Block block = event.getBlock();
        if (!ChestUtils.isSign(block)) {
            return;
        }
        Block attachedBlock = ChestUtils.getAttachedBlock(block);
        if (attachedBlock != null && ChestUtils.isChest(attachedBlock) && (owner = this.plugin.getChestManager().getChestOwner(attachedBlock.getLocation())) != null) {
            event.setCancelled(true);
            this.updateProtectionSign(block, owner);
            Player player = event.getPlayer();
            this.plugin.getMessageUtils().sendMessage((CommandSender)player, "error.cant_edit_protection_sign", owner);
            return;
        }
    }

    private void updateProtectionSign(Block signBlock, String owner) {
        if (!ChestUtils.isSign(signBlock)) {
            return;
        }
        try {
            Sign sign = (Sign)signBlock.getState();
            sign.setLine(0, LINE_1);
            sign.setLine(1, LINE_2);
            sign.setLine(2, LINE_3);
            sign.setLine(3, "\u00a79" + owner);
            sign.update(true);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to update protection sign: " + e.getMessage());
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onSignChange(SignChangeEvent event) {
        Player player = event.getPlayer();
        String username = null;
        for (String line : event.getLines()) {
            Matcher matcher;
            if (line == null || !(matcher = this.usernamePattern.matcher(line)).find()) continue;
            username = matcher.group(1);
            break;
        }
        if (username == null) {
            return;
        }
        if (!username.equalsIgnoreCase(player.getName()) && !player.hasPermission("chestprotect.protect.others")) {
            this.plugin.getMessageUtils().sendMessage((CommandSender)player, "error.cant_protect_others", new Object[0]);
            return;
        }
        Block attachedBlock = ChestUtils.getAttachedBlock(event.getBlock());
        if (attachedBlock == null || !(attachedBlock.getState() instanceof Chest)) {
            this.plugin.getMessageUtils().sendMessage((CommandSender)player, "error.no_chest_found", new Object[0]);
            return;
        }
        if (this.plugin.getChestManager().isChestProtected(attachedBlock.getLocation())) {
            this.plugin.getMessageUtils().sendMessage((CommandSender)player, "error.already_protected", new Object[0]);
            return;
        }
        this.plugin.getChestManager().protectChest(attachedBlock.getLocation(), username);
        event.setLine(0, LINE_1);
        event.setLine(1, "\u00a72Owner:");
        event.setLine(2, "\u00a79" + username);
        this.plugin.getMessageUtils().sendMessage((CommandSender)player, "success.chest_protected", new Object[0]);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onSignInteract(PlayerInteractEvent event) {
        String owner;
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK && event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null || !ChestUtils.isSign(block)) {
            return;
        }
        Player player = event.getPlayer();
        boolean isBedrockPlayer = player.hasMetadata("floodgate-player-edition") || player.hasMetadata("Geyser-Player");
        Block attachedBlock = ChestUtils.getAttachedBlock(block);
        if (attachedBlock != null && ChestUtils.isChest(attachedBlock) && (owner = this.plugin.getChestManager().getChestOwner(attachedBlock.getLocation())) != null) {
            event.setCancelled(true);
            this.plugin.getMessageUtils().sendMessage((CommandSender)player, "info.chest_owner", owner);
            if (!owner.equalsIgnoreCase(player.getName())) {
                this.plugin.getMessageUtils().sendRequestAccessMessage(player, owner, attachedBlock.getLocation());
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onSignItemInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK && event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null || !item.getType().name().contains("SIGN")) {
            return;
        }
        Player player = event.getPlayer();
        boolean isBedrockPlayer = player.hasMetadata("floodgate-player-edition") || player.hasMetadata("Geyser-Player");
        Block block = event.getClickedBlock();
        if (block != null && ChestUtils.isChest(block)) {
            if (this.plugin.getChestManager().isChestProtected(block.getLocation())) {
                String owner = this.plugin.getChestManager().getChestOwner(block.getLocation());
                this.plugin.getMessageUtils().sendMessage((CommandSender)player, "error.already_protected_by", owner);
                return;
            }
            this.plugin.getMessageUtils().sendMessage((CommandSender)player, "info.use_claimchest", new Object[0]);
        }
    }
}

