/*
 * Decompiled with CFR 0.152.
 */
package com.chestprotect.managers;

import com.chestprotect.ChestProtectPlugin;
import com.chestprotect.models.ChestAccess;
import com.chestprotect.utils.ChestUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ChestManager {
    private final ChestProtectPlugin plugin;
    private final Map<String, String> protectedChests = new ConcurrentHashMap<String, String>();
    private final Map<String, Map<UUID, ChestAccess>> tempAccess = new ConcurrentHashMap<String, Map<UUID, ChestAccess>>();
    private File dataFile;
    private boolean dataChanged = false;

    public ChestManager(ChestProtectPlugin plugin) {
        this.plugin = plugin;
        this.dataFile = new File(plugin.getDataFolder(), "chests.yml");
        this.loadData();
    }

    public void loadData() {
        if (!this.dataFile.exists()) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.dataFile);
        if (config.contains("chests")) {
            for (String locString : config.getConfigurationSection("chests").getKeys(false)) {
                String owner = config.getString("chests." + locString);
                if (owner == null) continue;
                this.protectedChests.put(locString, owner);
            }
        }
        this.plugin.getLogger().info("Loaded " + this.protectedChests.size() + " protected chests.");
    }

    public void saveData() {
        if (!this.dataChanged) {
            return;
        }
        YamlConfiguration config = new YamlConfiguration();
        for (Map.Entry<String, String> entry : this.protectedChests.entrySet()) {
            config.set("chests." + entry.getKey(), (Object)entry.getValue());
        }
        try {
            config.save(this.dataFile);
            this.dataChanged = false;
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save chest data: " + e.getMessage());
        }
    }

    public boolean protectChest(Location location, String owner) {
        String locString = this.locationToString(location);
        String currentOwner = this.protectedChests.get(locString);
        if (currentOwner == null || !currentOwner.equals(owner)) {
            this.protectedChests.put(locString, owner);
            this.dataChanged = true;
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, this::saveData);
        }
        return true;
    }

    public boolean removeChestProtection(Location location) {
        String locString = this.locationToString(location);
        if (this.protectedChests.remove(locString) != null) {
            this.tempAccess.remove(locString);
            this.dataChanged = true;
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, this::saveData);
            return true;
        }
        return false;
    }

    public boolean isChestProtected(Location location) {
        return this.getChestOwner(location) != null;
    }

    public String getChestOwner(Location location) {
        String locString = this.locationToString(location);
        return this.protectedChests.get(locString);
    }

    public boolean grantTemporaryAccess(String ownerName, UUID playerId) {
        String ownerNameLower = ownerName.toLowerCase();
        long expiry = System.currentTimeMillis() + 60000L;
        boolean accessGranted = false;
        for (Map.Entry<String, String> entry : this.protectedChests.entrySet()) {
            if (!entry.getValue().toLowerCase().equals(ownerNameLower)) continue;
            String locString = entry.getKey();
            Map accessMap = this.tempAccess.computeIfAbsent(locString, k -> new HashMap(4, 0.9f));
            accessMap.put(playerId, new ChestAccess(playerId, expiry));
            accessGranted = true;
        }
        return accessGranted;
    }

    public ChestAccess getAccess(Location location, UUID playerId) {
        String locString = this.locationToString(location);
        Map<UUID, ChestAccess> accessMap = this.tempAccess.get(locString);
        if (accessMap == null) {
            return null;
        }
        ChestAccess access = accessMap.get(playerId);
        if (access == null || !access.isValid()) {
            return null;
        }
        return access;
    }

    public void removeAccess(Location location, UUID playerId) {
        String locString = this.locationToString(location);
        Map<UUID, ChestAccess> accessMap = this.tempAccess.get(locString);
        if (accessMap != null) {
            accessMap.remove(playerId);
            if (accessMap.isEmpty()) {
                this.tempAccess.remove(locString);
            }
        }
    }

    public Block getAttachedChest(Block signBlock) {
        return ChestUtils.getAttachedBlock(signBlock);
    }

    public boolean hasProtectedChests(String playerName) {
        String playerNameLower = playerName.toLowerCase();
        return this.protectedChests.values().stream().anyMatch(owner -> owner.toLowerCase().equals(playerNameLower));
    }

    private String locationToString(Location location) {
        return location.getWorld().getName() + "," + location.getBlockX() + "," + location.getBlockY() + "," + location.getBlockZ();
    }

    private Location stringToLocation(String locString) {
        String[] parts = locString.split(",");
        if (parts.length != 4) {
            return null;
        }
        try {
            return new Location(Bukkit.getWorld((String)parts[0]), (double)Integer.parseInt(parts[1]), (double)Integer.parseInt(parts[2]), (double)Integer.parseInt(parts[3]));
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getProtectedChestCount() {
        return this.protectedChests.size();
    }

    public List<String> getAllChestOwners() {
        return this.protectedChests.values().stream().distinct().collect(Collectors.toList());
    }

    public int getPlayerChestCount(String playerName) {
        String playerNameLower = playerName.toLowerCase();
        return (int)this.protectedChests.values().stream().filter(owner -> owner.toLowerCase().equals(playerNameLower)).count();
    }

    public List<String> getPlayerProtectedChests(String playerName) {
        String playerNameLower = playerName.toLowerCase();
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.protectedChests.entrySet()) {
            if (!entry.getValue().toLowerCase().equals(playerNameLower)) continue;
            result.add(entry.getKey());
        }
        return result;
    }
}

