/*
 * Decompiled with CFR 0.152.
 */
package com.chestprotect.managers;

import com.chestprotect.ChestProtectPlugin;
import com.chestprotect.models.AccessRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class RequestManager {
    private final ChestProtectPlugin plugin;
    private final Map<UUID, Map<String, AccessRequest>> pendingRequests = new ConcurrentHashMap<UUID, Map<String, AccessRequest>>();
    private final long requestTimeout;

    public RequestManager(ChestProtectPlugin plugin) {
        this.plugin = plugin;
        this.requestTimeout = plugin.getConfig().getLong("request_timeout", 60L) * 1000L;
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)plugin, this::cleanupExpiredRequests, 600L, 600L);
    }

    public AccessRequest createRequest(UUID requesterId, String ownerName) {
        this.cancelExistingRequests(requesterId, ownerName);
        long now = System.currentTimeMillis();
        AccessRequest request = new AccessRequest(requesterId, ownerName, now, now + this.requestTimeout);
        Player requester = Bukkit.getPlayer((UUID)requesterId);
        if (requester != null) {
            request.setRequesterName(requester.getName());
        }
        this.pendingRequests.computeIfAbsent(requesterId, k -> new HashMap(4, 0.9f)).put(ownerName.toLowerCase(), request);
        return request;
    }

    private void cancelExistingRequests(UUID requesterId, String ownerName) {
        Map<String, AccessRequest> requests = this.pendingRequests.get(requesterId);
        if (requests != null) {
            requests.remove(ownerName.toLowerCase());
            if (requests.isEmpty()) {
                this.pendingRequests.remove(requesterId);
            }
        }
    }

    public AccessRequest getPendingRequest(UUID requesterId, String ownerName) {
        Map<String, AccessRequest> requests = this.pendingRequests.get(requesterId);
        if (requests == null) {
            return null;
        }
        AccessRequest request = requests.get(ownerName.toLowerCase());
        if (request != null && request.isExpired()) {
            requests.remove(ownerName.toLowerCase());
            if (requests.isEmpty()) {
                this.pendingRequests.remove(requesterId);
            }
            return null;
        }
        return request;
    }

    public void resolveRequest(AccessRequest request, boolean accepted) {
        UUID requesterId = request.getRequesterId();
        String ownerName = request.getOwnerName();
        this.cancelExistingRequests(requesterId, ownerName);
    }

    public boolean hasPendingOutgoingRequest(UUID playerId) {
        Map<String, AccessRequest> requests = this.pendingRequests.get(playerId);
        if (requests == null || requests.isEmpty()) {
            return false;
        }
        long now = System.currentTimeMillis();
        return requests.values().stream().anyMatch(request -> request.getExpiry() > now);
    }

    public List<String> getPendingRequesters(String ownerName) {
        ArrayList<String> requesters = new ArrayList<String>(4);
        String ownerLower = ownerName.toLowerCase();
        long now = System.currentTimeMillis();
        this.pendingRequests.forEach((requesterId, requests) -> {
            AccessRequest request = (AccessRequest)requests.get(ownerLower);
            if (request != null && request.getExpiry() > now) {
                String requesterName = null;
                if (request.getRequesterName() != null && !request.getRequesterName().isEmpty()) {
                    requesterName = request.getRequesterName();
                } else {
                    Player requester = Bukkit.getPlayer((UUID)requesterId);
                    if (requester != null) {
                        requesterName = requester.getName();
                        request.setRequesterName(requesterName);
                    }
                }
                if (requesterName != null) {
                    requesters.add(requesterName);
                }
            }
        });
        return requesters;
    }

    public UUID getRequesterUUID(String requesterName) {
        String requesterNameLower = requesterName.toLowerCase();
        Player player = Bukkit.getPlayerExact((String)requesterName);
        if (player != null) {
            return player.getUniqueId();
        }
        return this.pendingRequests.entrySet().stream().filter(entry -> ((Map)entry.getValue()).values().stream().anyMatch(request -> {
            String cachedName = request.getRequesterName();
            return cachedName != null && cachedName.toLowerCase().equals(requesterNameLower);
        })).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    private void cleanupExpiredRequests() {
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<UUID, Map<String, AccessRequest>>> it = this.pendingRequests.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<UUID, Map<String, AccessRequest>> entry = it.next();
            Map<String, AccessRequest> requests = entry.getValue();
            requests.entrySet().removeIf(requestEntry -> ((AccessRequest)requestEntry.getValue()).getExpiry() < now);
            if (!requests.isEmpty()) continue;
            it.remove();
        }
    }

    public int getActiveRequestCount() {
        long now = System.currentTimeMillis();
        int count = 0;
        for (Map<String, AccessRequest> requestMap : this.pendingRequests.values()) {
            for (AccessRequest request : requestMap.values()) {
                if (request.getExpiry() <= now) continue;
                ++count;
            }
        }
        return count;
    }
}

