/*
 * Decompiled with CFR 0.152.
 */
package com.chestprotect.utils;

import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;

public class ChestUtils {
    private static final BlockFace[] FACES = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.UP};

    public static Block getAttachedBlock(Block signBlock) {
        if (signBlock == null) {
            return null;
        }
        if (signBlock.getBlockData() instanceof Directional) {
            Directional directional = (Directional)signBlock.getBlockData();
            return signBlock.getRelative(directional.getFacing().getOppositeFace());
        }
        return signBlock.getRelative(BlockFace.DOWN);
    }

    public static boolean isChest(Block block) {
        if (block == null) {
            return false;
        }
        try {
            return block.getState() instanceof Chest;
        }
        catch (Exception e) {
            Material type = block.getType();
            return type == Material.CHEST || type == Material.TRAPPED_CHEST;
        }
    }

    public static boolean isSign(Block block) {
        if (block == null) {
            return false;
        }
        String materialName = block.getType().name();
        if (!materialName.contains("SIGN") || materialName.contains("DESIGN")) {
            return false;
        }
        try {
            return block.getState() instanceof Sign;
        }
        catch (Throwable e1) {
            try {
                return materialName.endsWith("_SIGN") || materialName.endsWith("_WALL_SIGN") || materialName.equals("SIGN") || materialName.equals("WALL_SIGN") || materialName.equals("ACACIA_SIGN") || materialName.equals("BAMBOO_SIGN") || materialName.equals("BIRCH_SIGN") || materialName.equals("CHERRY_SIGN") || materialName.equals("CRIMSON_SIGN") || materialName.equals("DARK_OAK_SIGN") || materialName.equals("JUNGLE_SIGN") || materialName.equals("MANGROVE_SIGN") || materialName.equals("OAK_SIGN") || materialName.equals("SPRUCE_SIGN") || materialName.equals("WARPED_SIGN");
            }
            catch (Throwable e2) {
                return materialName.contains("SIGN") && !materialName.contains("DESIGN");
            }
        }
    }

    public static Block findAttachedSign(Block chestBlock) {
        if (!ChestUtils.isChest(chestBlock)) {
            return null;
        }
        for (BlockFace face : FACES) {
            Block adjacent = chestBlock.getRelative(face);
            if (adjacent == null || adjacent.getType() == Material.AIR || !ChestUtils.isSign(adjacent)) continue;
            try {
                Directional directional;
                BlockFace attachedFace;
                if (!(adjacent.getBlockData() instanceof Directional ? (attachedFace = (directional = (Directional)adjacent.getBlockData()).getFacing().getOppositeFace()) == face || face == BlockFace.UP && (attachedFace == BlockFace.DOWN || attachedFace == BlockFace.SELF) : face == BlockFace.UP)) continue;
                return adjacent;
            }
            catch (Exception e) {
                if (face == BlockFace.UP) {
                    return adjacent;
                }
                String typeName = adjacent.getType().name();
                if (!typeName.contains("WALL")) continue;
                try {
                    BlockData blockData = adjacent.getBlockData();
                    BlockFace signFace = null;
                    try {
                        if (blockData instanceof Directional) {
                            signFace = ((Directional)blockData).getFacing();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (signFace == null || signFace.getOppositeFace() != face) continue;
                    return adjacent;
                }
                catch (Throwable ignored) {
                    return adjacent;
                }
            }
        }
        return null;
    }
}

